/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cql3.statements;

import com.google.common.base.Objects;
import org.apache.cassandra.cql3.ColumnIdentifier;

public interface Selector {
    public ColumnIdentifier id();

    public boolean hasFunction();

    public Function function();

    public static class WithFunction
    implements Selector {
        private final Function function;
        private final ColumnIdentifier id;

        public WithFunction(ColumnIdentifier id, Function function) {
            this.id = id;
            this.function = function;
        }

        @Override
        public ColumnIdentifier id() {
            return this.id;
        }

        @Override
        public boolean hasFunction() {
            return true;
        }

        @Override
        public Function function() {
            return this.function;
        }

        public final int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.function, this.id});
        }

        public final boolean equals(Object o) {
            if (!(o instanceof WithFunction)) {
                return false;
            }
            WithFunction that = (WithFunction)o;
            return this.id().equals(that.id()) && this.function() == that.function();
        }

        public String toString() {
            return (Object)((Object)this.function) + "(" + this.id + ")";
        }
    }

    public static enum Function {
        WRITE_TIME,
        TTL;


        public String toString() {
            switch (this) {
                case WRITE_TIME: {
                    return "writetime";
                }
                case TTL: {
                    return "ttl";
                }
            }
            throw new AssertionError();
        }
    }
}

