/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cache;

import com.googlecode.concurrentlinkedhashmap.Weigher;
import com.googlecode.concurrentlinkedhashmap.Weighers;
import org.apache.cassandra.cache.ConcurrentLinkedHashCache;
import org.apache.cassandra.cache.ICache;
import org.apache.cassandra.cache.IRowCacheEntry;
import org.apache.cassandra.cache.IRowCacheProvider;
import org.apache.cassandra.cache.RowCacheKey;
import org.github.jamm.MemoryMeter;

public class ConcurrentLinkedHashCacheProvider
implements IRowCacheProvider {
    @Override
    public ICache<RowCacheKey, IRowCacheEntry> create(long capacity, boolean useMemoryWeigher) {
        return ConcurrentLinkedHashCache.create(capacity, useMemoryWeigher ? ConcurrentLinkedHashCacheProvider.createMemoryWeigher() : Weighers.singleton());
    }

    private static Weigher<IRowCacheEntry> createMemoryWeigher() {
        return new Weigher<IRowCacheEntry>(){
            final MemoryMeter meter = new MemoryMeter();

            public int weightOf(IRowCacheEntry value) {
                return (int)Math.min(this.meter.measure((Object)value), Integer.MAX_VALUE);
            }
        };
    }
}

