/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.dht.IPartitioner;
import org.apache.cassandra.dht.RingPosition;
import org.apache.cassandra.dht.Token;
import org.apache.cassandra.io.ISerializer;
import org.apache.cassandra.service.StorageService;
import org.apache.cassandra.utils.ByteBufferUtil;

public abstract class RowPosition
implements RingPosition<RowPosition> {
    private static final RowPositionSerializer serializer = new RowPositionSerializer();

    public static RowPositionSerializer serializer() {
        return serializer;
    }

    public static RowPosition forKey(ByteBuffer key, IPartitioner p) {
        return key == null || key.remaining() == 0 ? ((Token)p.getMinimumToken()).minKeyBound() : p.decorateKey(key);
    }

    @Override
    public abstract Token getToken();

    public abstract Kind kind();

    public boolean isMinimum() {
        return this.isMinimum(StorageService.getPartitioner());
    }

    public static class RowPositionSerializer
    implements ISerializer<RowPosition> {
        @Override
        public void serialize(RowPosition pos, DataOutput dos) throws IOException {
            Kind kind = pos.kind();
            dos.writeByte(kind.ordinal());
            if (kind == Kind.ROW_KEY) {
                ByteBufferUtil.writeWithShortLength(((DecoratedKey)pos).key, dos);
            } else {
                Token.serializer().serialize(pos.getToken(), dos);
            }
        }

        @Override
        public RowPosition deserialize(DataInput dis) throws IOException {
            Kind kind = Kind.fromOrdinal(dis.readByte());
            if (kind == Kind.ROW_KEY) {
                ByteBuffer k = ByteBufferUtil.readWithShortLength(dis);
                return StorageService.getPartitioner().decorateKey(k);
            }
            Token t = Token.serializer().deserialize(dis);
            return kind == Kind.MIN_BOUND ? t.minKeyBound() : t.maxKeyBound();
        }

        @Override
        public long serializedSize(RowPosition pos) {
            Kind kind = pos.kind();
            return 1L + (kind == Kind.ROW_KEY ? (long)(2 + ((DecoratedKey)pos).key.remaining()) : Token.serializer().serializedSize(pos.getToken()));
        }
    }

    public static enum Kind {
        ROW_KEY,
        MIN_BOUND,
        MAX_BOUND;

        private static final Kind[] allKinds;

        static Kind fromOrdinal(int ordinal) {
            return allKinds[ordinal];
        }

        static {
            allKinds = Kind.values();
        }
    }
}

