/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cql3.statements;

import com.google.common.collect.AbstractIterator;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.concurrent.TimeoutException;
import org.apache.cassandra.auth.Permission;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.cql3.CFDefinition;
import org.apache.cassandra.cql3.CFName;
import org.apache.cassandra.cql3.CQLStatement;
import org.apache.cassandra.cql3.ColumnIdentifier;
import org.apache.cassandra.cql3.ColumnNameBuilder;
import org.apache.cassandra.cql3.QueryProcessor;
import org.apache.cassandra.cql3.Relation;
import org.apache.cassandra.cql3.Term;
import org.apache.cassandra.cql3.statements.CFStatement;
import org.apache.cassandra.cql3.statements.ParsedStatement;
import org.apache.cassandra.cql3.statements.Selector;
import org.apache.cassandra.db.ColumnFamily;
import org.apache.cassandra.db.CounterColumn;
import org.apache.cassandra.db.ExpiringColumn;
import org.apache.cassandra.db.IColumn;
import org.apache.cassandra.db.RangeSliceCommand;
import org.apache.cassandra.db.ReadCommand;
import org.apache.cassandra.db.Row;
import org.apache.cassandra.db.RowPosition;
import org.apache.cassandra.db.SliceByNamesReadCommand;
import org.apache.cassandra.db.SliceFromReadCommand;
import org.apache.cassandra.db.Table;
import org.apache.cassandra.db.context.CounterContext;
import org.apache.cassandra.db.filter.QueryPath;
import org.apache.cassandra.db.marshal.CompositeType;
import org.apache.cassandra.db.marshal.Int32Type;
import org.apache.cassandra.db.marshal.LongType;
import org.apache.cassandra.db.marshal.ReversedType;
import org.apache.cassandra.db.marshal.TypeParser;
import org.apache.cassandra.dht.AbstractBounds;
import org.apache.cassandra.dht.Bounds;
import org.apache.cassandra.dht.ExcludingBounds;
import org.apache.cassandra.dht.IPartitioner;
import org.apache.cassandra.dht.IncludingExcludingBounds;
import org.apache.cassandra.dht.RandomPartitioner;
import org.apache.cassandra.dht.Range;
import org.apache.cassandra.dht.Token;
import org.apache.cassandra.service.ClientState;
import org.apache.cassandra.service.StorageProxy;
import org.apache.cassandra.service.StorageService;
import org.apache.cassandra.thrift.Column;
import org.apache.cassandra.thrift.ConsistencyLevel;
import org.apache.cassandra.thrift.CqlMetadata;
import org.apache.cassandra.thrift.CqlResult;
import org.apache.cassandra.thrift.CqlResultType;
import org.apache.cassandra.thrift.CqlRow;
import org.apache.cassandra.thrift.IndexExpression;
import org.apache.cassandra.thrift.IndexOperator;
import org.apache.cassandra.thrift.InvalidRequestException;
import org.apache.cassandra.thrift.RequestType;
import org.apache.cassandra.thrift.SlicePredicate;
import org.apache.cassandra.thrift.SliceRange;
import org.apache.cassandra.thrift.ThriftValidation;
import org.apache.cassandra.thrift.TimedOutException;
import org.apache.cassandra.thrift.UnavailableException;
import org.apache.cassandra.utils.ByteBufferUtil;
import org.apache.cassandra.utils.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SelectStatement
implements CQLStatement {
    private static final Logger logger = LoggerFactory.getLogger(SelectStatement.class);
    private static final ByteBuffer countColumn = ByteBufferUtil.bytes("count");
    private final int boundTerms;
    public final CFDefinition cfDef;
    public final Parameters parameters;
    private final List<Pair<CFDefinition.Name, Selector>> selectedNames = new ArrayList<Pair<CFDefinition.Name, Selector>>();
    private Restriction keyRestriction;
    private final Restriction[] columnRestrictions;
    private final Map<CFDefinition.Name, Restriction> metadataRestrictions = new HashMap<CFDefinition.Name, Restriction>();
    private Restriction sliceRestriction;
    private boolean isReversed;

    public SelectStatement(CFDefinition cfDef, int boundTerms, Parameters parameters) {
        this.cfDef = cfDef;
        this.boundTerms = boundTerms;
        this.columnRestrictions = new Restriction[cfDef.columns.size()];
        this.parameters = parameters;
    }

    @Override
    public int getBoundsTerms() {
        return this.boundTerms;
    }

    @Override
    public void checkAccess(ClientState state) throws InvalidRequestException {
        state.hasColumnFamilyAccess(this.keyspace(), this.columnFamily(), Permission.READ);
    }

    @Override
    public void validate(ClientState state) throws InvalidRequestException {
    }

    @Override
    public CqlResult execute(ClientState state, List<ByteBuffer> variables) throws InvalidRequestException, UnavailableException, TimedOutException {
        List<Row> rows = this.isKeyRange() ? this.multiRangeSlice(variables) : this.getSlice(variables);
        CqlResult result = new CqlResult();
        result.type = CqlResultType.ROWS;
        CqlMetadata schema = this.createSchema();
        List<CqlRow> cqlRows = this.process(rows, schema, variables);
        if (this.parameters.isCount) {
            result.schema = new CqlMetadata(Collections.emptyMap(), Collections.emptyMap(), "AsciiType", "LongType");
            List<Column> columns = Collections.singletonList(new Column(countColumn).setValue(ByteBufferUtil.bytes((long)cqlRows.size())));
            result.rows = Collections.singletonList(new CqlRow(countColumn, columns));
            return result;
        }
        result.schema = schema;
        result.rows = cqlRows;
        return result;
    }

    public List<CqlRow> process(List<Row> rows) throws InvalidRequestException {
        assert (!this.parameters.isCount);
        return this.process(rows, this.createSchema(), Collections.<ByteBuffer>emptyList());
    }

    private CqlMetadata createSchema() {
        return new CqlMetadata(new HashMap(), new HashMap(), TypeParser.getShortName(this.cfDef.cfm.comparator), TypeParser.getShortName(this.cfDef.cfm.getDefaultValidator()));
    }

    public String keyspace() {
        return this.cfDef.cfm.ksName;
    }

    public String columnFamily() {
        return this.cfDef.cfm.cfName;
    }

    private List<Row> getSlice(List<ByteBuffer> variables) throws InvalidRequestException, TimedOutException, UnavailableException {
        QueryPath queryPath = new QueryPath(this.columnFamily());
        Collection<ByteBuffer> keys = this.getKeys(variables);
        ArrayList<ReadCommand> commands = new ArrayList<ReadCommand>(keys.size());
        if (this.isColumnRange()) {
            ByteBuffer start = this.getRequestedBound(this.isReversed ? Bound.END : Bound.START, variables);
            ByteBuffer finish = this.getRequestedBound(this.isReversed ? Bound.START : Bound.END, variables);
            for (ByteBuffer key : keys) {
                QueryProcessor.validateKey(key);
                QueryProcessor.validateSliceRange(this.cfDef.cfm, start, finish, this.isReversed);
                commands.add(new SliceFromReadCommand(this.keyspace(), key, queryPath, start, finish, this.isReversed, this.getLimit()));
            }
        } else {
            List<ByteBuffer> columnNames = this.getRequestedColumns(variables);
            QueryProcessor.validateColumnNames(columnNames);
            for (ByteBuffer key : keys) {
                QueryProcessor.validateKey(key);
                commands.add(new SliceByNamesReadCommand(this.keyspace(), key, queryPath, columnNames));
            }
        }
        try {
            return StorageProxy.read(commands, this.parameters.consistencyLevel);
        }
        catch (TimeoutException e) {
            throw new TimedOutException();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private List<Row> multiRangeSlice(List<ByteBuffer> variables) throws InvalidRequestException, TimedOutException, UnavailableException {
        List<Row> rows;
        SlicePredicate thriftSlicePredicate = this.makeSlicePredicate(variables);
        QueryProcessor.validateSlicePredicate(this.cfDef.cfm, thriftSlicePredicate);
        List<IndexExpression> expressions = this.getIndexExpressions(variables);
        try {
            rows = StorageProxy.getRangeSlice(new RangeSliceCommand(this.keyspace(), this.columnFamily(), null, thriftSlicePredicate, this.getKeyBounds(variables), expressions, this.getLimit(), true, false), this.parameters.consistencyLevel);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        catch (TimeoutException e) {
            throw new TimedOutException();
        }
        return rows;
    }

    private AbstractBounds<RowPosition> getKeyBounds(List<ByteBuffer> variables) throws InvalidRequestException {
        AbstractBounds bounds;
        IPartitioner p = StorageService.getPartitioner();
        if (this.keyRestriction != null && this.keyRestriction.onToken) {
            Token startToken = this.getTokenBound(Bound.START, variables, p);
            Token endToken = this.getTokenBound(Bound.END, variables, p);
            Token.KeyBound start = this.includeKeyBound(Bound.START) ? startToken.minKeyBound() : startToken.maxKeyBound();
            Token.KeyBound end = this.includeKeyBound(Bound.END) ? endToken.maxKeyBound() : endToken.minKeyBound();
            bounds = new Range<Token.KeyBound>(start, end);
        } else {
            RowPosition finishKey;
            ByteBuffer startKeyBytes = this.getKeyBound(Bound.START, variables);
            ByteBuffer finishKeyBytes = this.getKeyBound(Bound.END, variables);
            RowPosition startKey = RowPosition.forKey(startKeyBytes, p);
            if (startKey.compareTo(finishKey = RowPosition.forKey(finishKeyBytes, p)) > 0 && !finishKey.isMinimum(p)) {
                if (p instanceof RandomPartitioner) {
                    throw new InvalidRequestException("Start key sorts after end key. This is not allowed; you probably should not specify end key at all, under RandomPartitioner");
                }
                throw new InvalidRequestException("Start key must sort before (or equal to) finish key in your partitioner!");
            }
            bounds = this.includeKeyBound(Bound.START) ? (this.includeKeyBound(Bound.END) ? new Bounds<RowPosition>(startKey, finishKey) : new IncludingExcludingBounds<RowPosition>(startKey, finishKey)) : (this.includeKeyBound(Bound.END) ? new Range<RowPosition>(startKey, finishKey) : new ExcludingBounds<RowPosition>(startKey, finishKey));
        }
        return bounds;
    }

    private SlicePredicate makeSlicePredicate(List<ByteBuffer> variables) throws InvalidRequestException {
        SlicePredicate thriftSlicePredicate = new SlicePredicate();
        if (this.isColumnRange()) {
            SliceRange sliceRange = new SliceRange();
            sliceRange.start = this.getRequestedBound(this.isReversed ? Bound.END : Bound.START, variables);
            sliceRange.finish = this.getRequestedBound(this.isReversed ? Bound.START : Bound.END, variables);
            sliceRange.reversed = this.isReversed;
            sliceRange.count = -1;
            thriftSlicePredicate.slice_range = sliceRange;
        } else {
            thriftSlicePredicate.column_names = this.getRequestedColumns(variables);
        }
        return thriftSlicePredicate;
    }

    private int getLimit() {
        int limit = this.sliceRestriction != null && !this.sliceRestriction.isInclusive(Bound.START) ? this.parameters.limit + 1 : this.parameters.limit;
        return this.cfDef.isCompact ? limit : this.cfDef.metadata.size() * limit;
    }

    private boolean isKeyRange() {
        if (!this.metadataRestrictions.isEmpty()) {
            return true;
        }
        return this.keyRestriction == null || !this.keyRestriction.isEquality() || this.keyRestriction.onToken;
    }

    private Collection<ByteBuffer> getKeys(List<ByteBuffer> variables) throws InvalidRequestException {
        assert (this.keyRestriction != null && this.keyRestriction.isEquality());
        ArrayList<ByteBuffer> keys = new ArrayList<ByteBuffer>(this.keyRestriction.eqValues.size());
        for (Term t : this.keyRestriction.eqValues) {
            keys.add(t.getByteBuffer(this.cfDef.key.type, variables));
        }
        return keys;
    }

    private ByteBuffer getKeyBound(Bound b, List<ByteBuffer> variables) throws InvalidRequestException {
        if (this.keyRestriction == null) {
            return ByteBufferUtil.EMPTY_BYTE_BUFFER;
        }
        if (this.keyRestriction.isEquality()) {
            assert (this.keyRestriction.eqValues.size() == 1);
            return this.keyRestriction.eqValues.get(0).getByteBuffer(this.cfDef.key.type, variables);
        }
        Term bound = this.keyRestriction.bound(b);
        return bound == null ? ByteBufferUtil.EMPTY_BYTE_BUFFER : bound.getByteBuffer(this.cfDef.key.type, variables);
    }

    private Token getTokenBound(Bound b, List<ByteBuffer> variables, IPartitioner<?> p) throws InvalidRequestException {
        assert (this.keyRestriction != null);
        if (this.keyRestriction.isEquality()) {
            assert (this.keyRestriction.eqValues.size() == 1);
            return this.keyRestriction.eqValues.get(0).getAsToken(this.cfDef.key.type, variables, p);
        }
        Term bound = this.keyRestriction.bound(b);
        return bound == null ? p.getMinimumToken() : bound.getAsToken(this.cfDef.key.type, variables, p);
    }

    private boolean includeKeyBound(Bound b) {
        if (this.keyRestriction == null || this.keyRestriction.isEquality()) {
            return true;
        }
        return this.keyRestriction.isInclusive(b);
    }

    private boolean isColumnRange() {
        if (!this.cfDef.isCompact && !this.cfDef.isComposite) {
            return false;
        }
        for (Restriction r : this.columnRestrictions) {
            if (r != null && r.isEquality()) continue;
            return true;
        }
        return false;
    }

    private boolean isWildcard() {
        return this.selectedNames.isEmpty();
    }

    private List<ByteBuffer> getRequestedColumns(List<ByteBuffer> variables) throws InvalidRequestException {
        assert (!this.isColumnRange());
        ColumnNameBuilder builder = this.cfDef.getColumnNameBuilder();
        for (Restriction r : this.columnRestrictions) {
            assert (r != null && r.isEquality());
            if (r.eqValues.size() > 1) {
                ArrayList<ByteBuffer> columns = new ArrayList<ByteBuffer>(r.eqValues.size());
                Iterator<Term> iter = r.eqValues.iterator();
                while (iter.hasNext()) {
                    Term v = iter.next();
                    ColumnNameBuilder b = iter.hasNext() ? builder.copy() : builder;
                    ByteBuffer cname = b.add(v, Relation.Type.EQ, variables).build();
                    columns.add(cname);
                }
                return columns;
            }
            builder.add(r.eqValues.get(0), Relation.Type.EQ, variables);
        }
        if (this.cfDef.isCompact) {
            return Collections.singletonList(builder.build());
        }
        ArrayList<ByteBuffer> columns = new ArrayList<ByteBuffer>(this.cfDef.columns.size());
        Iterator<ColumnIdentifier> iter = this.cfDef.metadata.keySet().iterator();
        while (iter.hasNext()) {
            ColumnIdentifier name = iter.next();
            ColumnNameBuilder b = iter.hasNext() ? builder.copy() : builder;
            ByteBuffer cname = b.add(name.key).build();
            columns.add(cname);
        }
        return columns;
    }

    private ByteBuffer getRequestedBound(Bound b, List<ByteBuffer> variables) throws InvalidRequestException {
        assert (this.isColumnRange());
        ColumnNameBuilder builder = this.cfDef.getColumnNameBuilder();
        for (Restriction r : this.columnRestrictions) {
            if (r == null || !r.isEquality() && r.bound(b) == null) {
                if (builder.componentCount() > 0 && b == Bound.END) {
                    return builder.buildAsEndOfRange();
                }
                return builder.build();
            }
            if (r.isEquality()) {
                assert (r.eqValues.size() == 1);
            } else {
                Term t = r.bound(b);
                assert (t != null);
                return builder.add(t, r.getRelation(b), variables).build();
            }
            builder.add(r.eqValues.get(0), Relation.Type.EQ, variables);
        }
        return builder.build();
    }

    private List<IndexExpression> getIndexExpressions(List<ByteBuffer> variables) throws InvalidRequestException {
        if (this.metadataRestrictions.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<IndexExpression> expressions = new ArrayList<IndexExpression>();
        for (Map.Entry<CFDefinition.Name, Restriction> entry : this.metadataRestrictions.entrySet()) {
            CFDefinition.Name name = entry.getKey();
            Restriction restriction = entry.getValue();
            if (restriction.isEquality()) {
                for (Term t : restriction.eqValues) {
                    ByteBuffer value = t.getByteBuffer(name.type, variables);
                    expressions.add(new IndexExpression(name.name.key, IndexOperator.EQ, value));
                }
                continue;
            }
            for (Bound b : Bound.values()) {
                if (restriction.bound(b) == null) continue;
                ByteBuffer value = restriction.bound(b).getByteBuffer(name.type, variables);
                expressions.add(new IndexExpression(name.name.key, restriction.getIndexOperator(b), value));
            }
        }
        return expressions;
    }

    private List<Pair<CFDefinition.Name, Selector>> getExpandedSelection() {
        if (this.selectedNames.isEmpty()) {
            ArrayList<Pair<CFDefinition.Name, Selector>> selection = new ArrayList<Pair<CFDefinition.Name, Selector>>();
            for (CFDefinition.Name name : this.cfDef) {
                selection.add(Pair.create(name, name.name));
            }
            return selection;
        }
        return this.selectedNames;
    }

    private ByteBuffer value(IColumn c) {
        return c instanceof CounterColumn ? ByteBufferUtil.bytes(CounterContext.instance().total(c.value())) : c.value();
    }

    private Column makeReturnColumn(Selector s, IColumn c) {
        Column cqlCol;
        if (s.hasFunction()) {
            cqlCol = new Column(ByteBufferUtil.bytes(s.toString()));
            if (c == null || c.isMarkedForDelete()) {
                return cqlCol;
            }
            switch (s.function()) {
                case WRITE_TIME: {
                    cqlCol.setValue(ByteBufferUtil.bytes(c.timestamp()));
                    break;
                }
                case TTL: {
                    if (!(c instanceof ExpiringColumn)) break;
                    int ttl = ((ExpiringColumn)c).getLocalDeletionTime() - (int)(System.currentTimeMillis() / 1000L);
                    cqlCol.setValue(ByteBufferUtil.bytes(ttl));
                }
            }
        } else {
            cqlCol = new Column(s.id().key);
            if (c == null || c.isMarkedForDelete()) {
                return cqlCol;
            }
            cqlCol.setValue(this.value(c)).setTimestamp(c.timestamp());
        }
        return cqlCol;
    }

    private void addToSchema(CqlMetadata schema, Pair<CFDefinition.Name, Selector> p) {
        if (((Selector)p.right).hasFunction()) {
            ByteBuffer nameAsRequested = ByteBufferUtil.bytes(((Selector)p.right).toString());
            schema.name_types.put(nameAsRequested, TypeParser.getShortName(CFDefinition.definitionType));
            switch (((Selector)p.right).function()) {
                case WRITE_TIME: {
                    schema.value_types.put(nameAsRequested, TypeParser.getShortName(LongType.instance));
                    break;
                }
                case TTL: {
                    schema.value_types.put(nameAsRequested, TypeParser.getShortName(Int32Type.instance));
                }
            }
        } else {
            ByteBuffer nameAsRequested = ((Selector)p.right).id().key;
            schema.name_types.put(nameAsRequested, TypeParser.getShortName(this.cfDef.getNameComparatorForResultSet((CFDefinition.Name)p.left)));
            schema.value_types.put(nameAsRequested, TypeParser.getShortName(((CFDefinition.Name)p.left).type));
        }
    }

    private Iterable<IColumn> columnsInOrder(final ColumnFamily cf, List<ByteBuffer> variables) throws InvalidRequestException {
        Restriction last = this.columnRestrictions[this.columnRestrictions.length - 1];
        if (last == null || !last.isEquality()) {
            return cf.getSortedColumns();
        }
        ColumnNameBuilder builder = this.cfDef.getColumnNameBuilder();
        for (int i = 0; i < this.columnRestrictions.length - 1; ++i) {
            builder.add(this.columnRestrictions[i].eqValues.get(0), Relation.Type.EQ, variables);
        }
        final ArrayList<ByteBuffer> requested = new ArrayList<ByteBuffer>(last.eqValues.size());
        Iterator<Term> iter = last.eqValues.iterator();
        while (iter.hasNext()) {
            Term t = iter.next();
            ColumnNameBuilder b = iter.hasNext() ? builder.copy() : builder;
            requested.add(b.add(t, Relation.Type.EQ, variables).build());
        }
        return new Iterable<IColumn>(){

            @Override
            public Iterator<IColumn> iterator() {
                return new AbstractIterator<IColumn>(){
                    Iterator<ByteBuffer> iter;
                    {
                        this.iter = requested.iterator();
                    }

                    public IColumn computeNext() {
                        if (!this.iter.hasNext()) {
                            return (IColumn)this.endOfData();
                        }
                        IColumn column = cf.getColumn(this.iter.next());
                        return column == null ? this.computeNext() : column;
                    }
                };
            }
        };
    }

    private List<CqlRow> process(List<Row> rows, CqlMetadata schema, List<ByteBuffer> variables) throws InvalidRequestException {
        ArrayList<CqlRow> cqlRows = new ArrayList<CqlRow>();
        List<Pair<CFDefinition.Name, Selector>> selection = this.getExpandedSelection();
        ArrayList<Column> thriftColumns = null;
        for (Pair<CFDefinition.Name, Selector> p : selection) {
            this.addToSchema(schema, p);
        }
        for (Row row : rows) {
            if (row.cf == null) continue;
            if (this.cfDef.isCompact) {
                for (IColumn iColumn : this.columnsInOrder(row.cf, variables)) {
                    if (iColumn.isMarkedForDelete()) continue;
                    thriftColumns = new ArrayList(selection.size());
                    ByteBuffer[] components = null;
                    if (this.cfDef.isComposite) {
                        components = ((CompositeType)this.cfDef.cfm.comparator).split(iColumn.name());
                    } else if (this.sliceRestriction != null && (!this.sliceRestriction.isInclusive(Bound.START) && iColumn.name().equals(this.sliceRestriction.bound(Bound.START).getByteBuffer(this.cfDef.cfm.comparator, variables)) || !this.sliceRestriction.isInclusive(Bound.END) && iColumn.name().equals(this.sliceRestriction.bound(Bound.END).getByteBuffer(this.cfDef.cfm.comparator, variables)))) continue;
                    for (Pair<CFDefinition.Name, Selector> p : selection) {
                        Column col;
                        CFDefinition.Name name = (CFDefinition.Name)p.left;
                        Selector selector = (Selector)p.right;
                        this.addToSchema(schema, p);
                        switch (name.kind) {
                            case KEY_ALIAS: {
                                col = new Column(selector.id().key);
                                col.setValue(row.key.key).setTimestamp(-1L);
                                break;
                            }
                            case COLUMN_ALIAS: {
                                col = new Column(selector.id().key);
                                col.setTimestamp(iColumn.timestamp());
                                if (this.cfDef.isComposite) {
                                    if (name.position < components.length) {
                                        col.setValue(components[name.position]);
                                        break;
                                    }
                                    col.setValue(ByteBufferUtil.EMPTY_BYTE_BUFFER);
                                    break;
                                }
                                col.setValue(iColumn.name());
                                break;
                            }
                            case VALUE_ALIAS: {
                                col = this.makeReturnColumn(selector, iColumn);
                                break;
                            }
                            case COLUMN_METADATA: {
                                throw new AssertionError();
                            }
                            default: {
                                throw new AssertionError();
                            }
                        }
                        thriftColumns.add(col);
                    }
                    cqlRows.add(new CqlRow(row.key.key, thriftColumns));
                }
                continue;
            }
            if (this.cfDef.isComposite) {
                CompositeType composite = (CompositeType)this.cfDef.cfm.comparator;
                int n = composite.types.size() - 1;
                ByteBuffer[] previous = null;
                HashMap<ByteBuffer, IColumn> group = new HashMap<ByteBuffer, IColumn>();
                for (IColumn c : row.cf) {
                    if (c.isMarkedForDelete()) continue;
                    ByteBuffer[] current = composite.split(c.name());
                    if (previous != null && !SelectStatement.isSameRow(previous, current)) {
                        cqlRows.add(this.handleGroup(selection, row.key.key, previous, group, schema));
                        group = new HashMap();
                    }
                    group.put(current[n], c);
                    previous = current;
                }
                if (previous == null) continue;
                cqlRows.add(this.handleGroup(selection, row.key.key, previous, group, schema));
                continue;
            }
            if (row.cf.getLiveColumnCount() == 0) continue;
            thriftColumns = new ArrayList<Column>(selection.size());
            for (Pair pair : selection) {
                CFDefinition.Name name = (CFDefinition.Name)pair.left;
                Selector selector = (Selector)pair.right;
                if (name.kind == CFDefinition.Name.Kind.KEY_ALIAS) {
                    thriftColumns.add(new Column(selector.id().key).setValue(row.key.key).setTimestamp(-1L));
                    continue;
                }
                IColumn c = row.cf.getColumn(name.name.key);
                thriftColumns.add(this.makeReturnColumn(selector, c));
            }
            cqlRows.add(new CqlRow(row.key.key, thriftColumns));
        }
        if (this.isReversed) {
            Collections.reverse(cqlRows);
        }
        cqlRows = cqlRows.size() > this.parameters.limit ? cqlRows.subList(0, this.parameters.limit) : cqlRows;
        return cqlRows;
    }

    private static boolean isSameRow(ByteBuffer[] c1, ByteBuffer[] c2) {
        assert (c1.length == c2.length) : "Sparse composite should not have partial column names";
        for (int i = 0; i < c1.length - 1; ++i) {
            if (c1[i].equals(c2[i])) continue;
            return false;
        }
        return true;
    }

    private CqlRow handleGroup(List<Pair<CFDefinition.Name, Selector>> selection, ByteBuffer key, ByteBuffer[] components, Map<ByteBuffer, IColumn> columns, CqlMetadata schema) {
        ArrayList<Column> thriftColumns = new ArrayList<Column>(selection.size());
        for (Pair<CFDefinition.Name, Selector> p : selection) {
            Column col;
            CFDefinition.Name name = (CFDefinition.Name)p.left;
            Selector selector = (Selector)p.right;
            switch (name.kind) {
                case KEY_ALIAS: {
                    col = new Column(selector.id().key);
                    col.setValue(key).setTimestamp(-1L);
                    break;
                }
                case COLUMN_ALIAS: {
                    col = new Column(selector.id().key);
                    col.setValue(components[name.position]);
                    col.setTimestamp(-1L);
                    break;
                }
                case VALUE_ALIAS: {
                    throw new AssertionError();
                }
                case COLUMN_METADATA: {
                    IColumn c = columns.get(name.name.key);
                    col = this.makeReturnColumn(selector, c);
                    break;
                }
                default: {
                    throw new AssertionError();
                }
            }
            thriftColumns.add(col);
        }
        return new CqlRow(key, thriftColumns);
    }

    public static class Parameters {
        private final int limit;
        private final ConsistencyLevel consistencyLevel;
        private final Map<ColumnIdentifier, Boolean> orderings;
        private final boolean isCount;

        public Parameters(ConsistencyLevel consistency, int limit, Map<ColumnIdentifier, Boolean> orderings, boolean isCount) {
            this.consistencyLevel = consistency;
            this.limit = limit;
            this.orderings = orderings;
            this.isCount = isCount;
        }
    }

    private static class Restriction {
        List<Term> eqValues;
        private final Term[] bounds;
        private final boolean[] boundInclusive;
        final boolean onToken;

        Restriction(List<Term> values) {
            this.eqValues = values;
            this.bounds = null;
            this.boundInclusive = null;
            this.onToken = false;
        }

        Restriction(Term value, boolean onToken) {
            this(Collections.singletonList(value));
        }

        Restriction(boolean onToken) {
            this.eqValues = null;
            this.bounds = new Term[2];
            this.boundInclusive = new boolean[2];
            this.onToken = onToken;
        }

        boolean isEquality() {
            return this.eqValues != null;
        }

        public void setBound(Bound b, Term t) {
            this.bounds[b.idx] = t;
        }

        public void setInclusive(Bound b) {
            this.boundInclusive[b.idx] = true;
        }

        public Term bound(Bound b) {
            return this.bounds[b.idx];
        }

        public boolean isInclusive(Bound b) {
            return this.bounds[b.idx] == null || this.boundInclusive[b.idx];
        }

        public Relation.Type getRelation(Bound b) {
            switch (b) {
                case START: {
                    return this.boundInclusive[b.idx] ? Relation.Type.GTE : Relation.Type.GT;
                }
                case END: {
                    return this.boundInclusive[b.idx] ? Relation.Type.LTE : Relation.Type.LT;
                }
            }
            throw new AssertionError();
        }

        public IndexOperator getIndexOperator(Bound b) {
            switch (b) {
                case START: {
                    return this.boundInclusive[b.idx] ? IndexOperator.GTE : IndexOperator.GT;
                }
                case END: {
                    return this.boundInclusive[b.idx] ? IndexOperator.LTE : IndexOperator.LT;
                }
            }
            throw new AssertionError();
        }

        public void setBound(ColumnIdentifier name, Relation.Type type, Term t) throws InvalidRequestException {
            Bound b = null;
            boolean inclusive = false;
            switch (type) {
                case GT: {
                    b = Bound.START;
                    inclusive = false;
                    break;
                }
                case GTE: {
                    b = Bound.START;
                    inclusive = true;
                    break;
                }
                case LT: {
                    b = Bound.END;
                    inclusive = false;
                    break;
                }
                case LTE: {
                    b = Bound.END;
                    inclusive = true;
                }
            }
            if (this.bounds[b.idx] != null) {
                throw new InvalidRequestException(String.format("Invalid restrictions found on %s", name));
            }
            this.bounds[b.idx] = t;
            this.boundInclusive[b.idx] = inclusive;
        }

        public String toString() {
            String s = this.eqValues == null ? String.format("SLICE(%s %s, %s %s)", this.boundInclusive[0] ? ">=" : ">", this.bounds[0], this.boundInclusive[1] ? "<=" : "<", this.bounds[1]) : String.format("EQ(%s)", this.eqValues);
            return this.onToken ? s + "*" : s;
        }
    }

    public static class RawStatement
    extends CFStatement {
        private final Parameters parameters;
        private final List<Selector> selectClause;
        private final List<Relation> whereClause;

        public RawStatement(CFName cfName, Parameters parameters, List<Selector> selectClause, List<Relation> whereClause) {
            super(cfName);
            this.parameters = parameters;
            this.selectClause = selectClause;
            this.whereClause = whereClause == null ? Collections.emptyList() : whereClause;
        }

        @Override
        public ParsedStatement.Prepared prepare() throws InvalidRequestException {
            CFDefinition.Name name;
            CFMetaData cfm = ThriftValidation.validateColumnFamily(this.keyspace(), this.columnFamily());
            ThriftValidation.validateConsistencyLevel(this.keyspace(), this.parameters.consistencyLevel, RequestType.READ);
            if (this.parameters.limit <= 0) {
                throw new InvalidRequestException("LIMIT must be strictly positive");
            }
            CFDefinition cfDef = cfm.getCfDef();
            SelectStatement stmt = new SelectStatement(cfDef, this.getBoundsTerms(), this.parameters);
            CFDefinition.Name[] names = new CFDefinition.Name[this.getBoundsTerms()];
            if (this.parameters.isCount) {
                if (!this.selectClause.isEmpty()) {
                    throw new InvalidRequestException("Only COUNT(*) and COUNT(1) operations are currently supported.");
                }
            } else {
                for (Selector t : this.selectClause) {
                    name = cfDef.get(t.id());
                    if (name == null) {
                        throw new InvalidRequestException(String.format("Undefined name %s in selection clause", t.id()));
                    }
                    if (t.hasFunction() && name.kind != CFDefinition.Name.Kind.COLUMN_METADATA && name.kind != CFDefinition.Name.Kind.VALUE_ALIAS) {
                        throw new InvalidRequestException(String.format("Cannot use function %s on PRIMARY KEY part %s", new Object[]{t.function(), name}));
                    }
                    stmt.selectedNames.add(Pair.create(name, t));
                }
            }
            for (Relation rel : this.whereClause) {
                name = cfDef.get(rel.getEntity());
                if (name == null) {
                    throw new InvalidRequestException(String.format("Undefined name %s in where clause ('%s')", rel.getEntity(), rel));
                }
                if (rel.operator() == Relation.Type.IN) {
                    for (Term value : rel.getInValues()) {
                        if (!value.isBindMarker()) continue;
                        names[value.bindIndex] = name;
                    }
                } else {
                    Term value = rel.getValue();
                    if (value.isBindMarker()) {
                        names[value.bindIndex] = name;
                    }
                }
                switch (name.kind) {
                    case KEY_ALIAS: {
                        if (rel.operator() != Relation.Type.EQ && rel.operator() != Relation.Type.IN && !rel.onToken && !StorageService.getPartitioner().preservesOrder()) {
                            throw new InvalidRequestException("Only EQ and IN relation are supported on first component of the PRIMARY KEY for RandomPartitioner (unless you use the token() function)");
                        }
                        stmt.keyRestriction = this.updateRestriction(name, stmt.keyRestriction, rel);
                        break;
                    }
                    case COLUMN_ALIAS: {
                        ((SelectStatement)stmt).columnRestrictions[name.position] = this.updateRestriction(name, stmt.columnRestrictions[name.position], rel);
                        break;
                    }
                    case VALUE_ALIAS: {
                        throw new InvalidRequestException(String.format("Restricting the value of a compact CF (%s) is not supported", name.name));
                    }
                    case COLUMN_METADATA: {
                        stmt.metadataRestrictions.put(name, this.updateRestriction(name, (Restriction)stmt.metadataRestrictions.get(name), rel));
                    }
                }
            }
            boolean shouldBeDone = false;
            CFDefinition.Name previous = null;
            Iterator<CFDefinition.Name> iter = cfDef.columns.values().iterator();
            for (int i = 0; i < stmt.columnRestrictions.length; ++i) {
                CFDefinition.Name cname = iter.next();
                Restriction restriction = stmt.columnRestrictions[i];
                if (restriction == null) {
                    shouldBeDone = true;
                } else {
                    if (shouldBeDone) {
                        throw new InvalidRequestException(String.format("PRIMARY KEY part %s cannot be restricted (preceding part %s is either not restricted or by a non-EQ relation)", cname, previous));
                    }
                    if (!restriction.isEquality()) {
                        shouldBeDone = true;
                        if (!(cfDef.isComposite || restriction.isInclusive(Bound.START) && restriction.isInclusive(Bound.END))) {
                            stmt.sliceRestriction = restriction;
                        }
                    } else if (restriction.eqValues.size() > 1 && i != stmt.columnRestrictions.length - 1) {
                        throw new InvalidRequestException(String.format("PRIMARY KEY part %s cannot be restricted by IN relation (only the first and last parts can)", cname));
                    }
                }
                previous = cname;
            }
            if (!stmt.metadataRestrictions.isEmpty()) {
                boolean hasEq = false;
                SortedSet<ByteBuffer> indexed = Table.open((String)this.keyspace()).getColumnFamilyStore((String)this.columnFamily()).indexManager.getIndexedColumns();
                for (Map.Entry entry : stmt.metadataRestrictions.entrySet()) {
                    if (!((Restriction)entry.getValue()).isEquality() || !indexed.contains(((CFDefinition.Name)entry.getKey()).name.key)) continue;
                    hasEq = true;
                    break;
                }
                if (!hasEq) {
                    throw new InvalidRequestException("No indexed columns present in by-columns clause with Equal operator");
                }
                if (stmt.keyRestriction != null && stmt.keyRestriction.isEquality() && ((SelectStatement)stmt).keyRestriction.eqValues.size() > 1) {
                    throw new InvalidRequestException("Select on indexed columns and with IN clause for the PRIMARY KEY are not supported");
                }
            }
            if (!stmt.parameters.orderings.isEmpty()) {
                Boolean[] reversedMap = new Boolean[cfDef.columns.size()];
                int i = 0;
                for (Map.Entry entry : stmt.parameters.orderings.entrySet()) {
                    ColumnIdentifier column = (ColumnIdentifier)entry.getKey();
                    boolean reversed = (Boolean)entry.getValue();
                    CFDefinition.Name name2 = cfDef.get(column);
                    if (name2 == null) {
                        throw new InvalidRequestException(String.format("Order by on unknown column %s", column));
                    }
                    if (name2.kind != CFDefinition.Name.Kind.COLUMN_ALIAS) {
                        throw new InvalidRequestException(String.format("Order by is currently only supported on the clustered columns of the PRIMARY KEY, got %s", column));
                    }
                    if (i++ != name2.position) {
                        throw new InvalidRequestException(String.format("Order by currently only support the ordering of columns following their declared order in the PRIMARY KEY", new Object[0]));
                    }
                    reversedMap[name2.position] = reversed != RawStatement.isReversedType(name2);
                }
                Boolean isReversed = null;
                for (Boolean b : reversedMap) {
                    if (b == null) continue;
                    if (isReversed == null) {
                        isReversed = b;
                        continue;
                    }
                    if (isReversed == b) continue;
                    throw new InvalidRequestException(String.format("Unsupported order by relation", new Object[0]));
                }
                assert (isReversed != null);
                stmt.isReversed = isReversed;
                if (stmt.keyRestriction == null || !stmt.keyRestriction.isEquality() || ((SelectStatement)stmt).keyRestriction.eqValues.size() != 1) {
                    throw new InvalidRequestException("Ordering is only supported if the first part of the PRIMARY KEY is restricted by an Equal");
                }
            }
            if (stmt.keyRestriction != null && ((SelectStatement)stmt).keyRestriction.onToken && stmt.keyRestriction.isEquality() && ((SelectStatement)stmt).keyRestriction.eqValues.size() > 1) {
                throw new InvalidRequestException("Select using the token() function don't support IN clause");
            }
            return new ParsedStatement.Prepared(stmt, Arrays.asList(names));
        }

        private static boolean isReversedType(CFDefinition.Name name) {
            return name.type instanceof ReversedType;
        }

        Restriction updateRestriction(CFDefinition.Name name, Restriction restriction, Relation newRel) throws InvalidRequestException {
            if (newRel.onToken && name.kind != CFDefinition.Name.Kind.KEY_ALIAS) {
                throw new InvalidRequestException(String.format("The token() function is only supported on the partition key, found on %s", name));
            }
            switch (newRel.operator()) {
                case EQ: {
                    if (restriction != null) {
                        throw new InvalidRequestException(String.format("%s cannot be restricted by more than one relation if it includes an Equal", name));
                    }
                    restriction = new Restriction(newRel.getValue(), newRel.onToken);
                    break;
                }
                case IN: {
                    if (restriction != null) {
                        throw new InvalidRequestException(String.format("%s cannot be restricted by more than one reation if it includes a IN", name));
                    }
                    restriction = new Restriction(newRel.getInValues());
                    break;
                }
                case GT: 
                case GTE: 
                case LT: 
                case LTE: {
                    if (restriction == null) {
                        restriction = new Restriction(newRel.onToken);
                    }
                    restriction.setBound(name.name, newRel.operator(), newRel.getValue());
                }
            }
            return restriction;
        }

        public String toString() {
            return String.format("SelectRawStatement[name=%s, selectClause=%s, whereClause=%s, isCount=%s, cLevel=%s, limit=%s]", this.cfName, this.selectClause, this.whereClause, this.parameters.isCount, this.parameters.consistencyLevel, this.parameters.limit);
        }
    }

    private static enum Bound {
        START(0),
        END(1);

        public final int idx;

        private Bound(int idx) {
            this.idx = idx;
        }
    }
}

