/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.streaming;

import java.io.IOException;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.gms.ApplicationState;
import org.apache.cassandra.gms.EndpointState;
import org.apache.cassandra.gms.FailureDetector;
import org.apache.cassandra.gms.Gossiper;
import org.apache.cassandra.gms.IEndpointStateChangeSubscriber;
import org.apache.cassandra.gms.IFailureDetectionEventListener;
import org.apache.cassandra.gms.VersionedValue;
import org.apache.cassandra.net.MessagingService;
import org.apache.cassandra.streaming.PendingFile;
import org.apache.cassandra.streaming.StreamHeader;
import org.apache.cassandra.utils.Pair;
import org.apache.commons.lang.StringUtils;
import org.cliffc.high_scale_lib.NonBlockingHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StreamOutSession
implements IEndpointStateChangeSubscriber,
IFailureDetectionEventListener {
    private static final Logger logger = LoggerFactory.getLogger(StreamOutSession.class);
    private static final ConcurrentMap<Pair<InetAddress, Long>, StreamOutSession> streams = new NonBlockingHashMap();
    private final Map<String, PendingFile> files = new NonBlockingHashMap();
    public final String table;
    private final Pair<InetAddress, Long> context;
    private final Runnable callback;
    private volatile String currentFile;
    private final AtomicBoolean isClosed = new AtomicBoolean(false);

    public static StreamOutSession create(String table, InetAddress host, Runnable callback) {
        return StreamOutSession.create(table, host, System.nanoTime(), callback);
    }

    public static StreamOutSession create(String table, InetAddress host, long sessionId) {
        return StreamOutSession.create(table, host, sessionId, null);
    }

    public static StreamOutSession create(String table, InetAddress host, long sessionId, Runnable callback) {
        Pair<InetAddress, Long> context = new Pair<InetAddress, Long>(host, sessionId);
        StreamOutSession session = new StreamOutSession(table, context, callback);
        streams.put(context, session);
        return session;
    }

    public static StreamOutSession get(InetAddress host, long sessionId) {
        return (StreamOutSession)streams.get(new Pair<InetAddress, Long>(host, sessionId));
    }

    private StreamOutSession(String table, Pair<InetAddress, Long> context, Runnable callback) {
        this.table = table;
        this.context = context;
        this.callback = callback;
        Gossiper.instance.register(this);
        FailureDetector.instance.registerFailureDetectionEventListener(this);
    }

    public InetAddress getHost() {
        return (InetAddress)this.context.left;
    }

    public long getSessionId() {
        return (Long)this.context.right;
    }

    public void addFilesToStream(List<PendingFile> pendingFiles) {
        for (PendingFile pendingFile : pendingFiles) {
            if (logger.isDebugEnabled()) {
                logger.debug("Adding file {} to be streamed.", (Object)pendingFile.getFilename());
            }
            this.files.put(pendingFile.getFilename(), pendingFile);
        }
    }

    public void retry() {
        this.streamFile(this.files.get(this.currentFile));
    }

    private void streamFile(PendingFile pf) {
        if (logger.isDebugEnabled()) {
            logger.debug("Streaming {} ...", (Object)pf);
        }
        this.currentFile = pf.getFilename();
        MessagingService.instance().stream(new StreamHeader(this.table, this.getSessionId(), pf), this.getHost());
    }

    public void startNext() throws IOException {
        assert (this.files.containsKey(this.currentFile));
        this.files.get((Object)this.currentFile).sstable.releaseReference();
        this.files.remove(this.currentFile);
        Iterator<PendingFile> iter = this.files.values().iterator();
        if (iter.hasNext()) {
            this.streamFile(iter.next());
        }
    }

    public void close() {
        this.close(true);
    }

    private void close(boolean success) {
        if (!this.isClosed.compareAndSet(false, true)) {
            logger.debug("StreamOutSession {} already closed", (Object)this.getSessionId());
            return;
        }
        Gossiper.instance.unregister(this);
        FailureDetector.instance.unregisterFailureDetectionEventListener(this);
        for (PendingFile file : this.files.values()) {
            file.sstable.releaseReference();
        }
        streams.remove(this.context);
        if (this.callback != null && success) {
            this.callback.run();
        }
    }

    void await() throws InterruptedException {
        while (streams.containsKey(this.context)) {
            Thread.sleep(10L);
        }
    }

    public Collection<PendingFile> getFiles() {
        return this.files.values();
    }

    public static Set<InetAddress> getDestinations() {
        HashSet<InetAddress> hosts = new HashSet<InetAddress>();
        for (StreamOutSession session : streams.values()) {
            hosts.add(session.getHost());
        }
        return hosts;
    }

    public static List<PendingFile> getOutgoingFiles(InetAddress host) {
        ArrayList<PendingFile> list = new ArrayList<PendingFile>();
        for (Map.Entry entry : streams.entrySet()) {
            if (!((InetAddress)((Pair)entry.getKey()).left).equals(host)) continue;
            list.addAll(((StreamOutSession)entry.getValue()).getFiles());
        }
        return list;
    }

    public void validateCurrentFile(String file) {
        if (!file.equals(this.currentFile)) {
            throw new IllegalStateException(String.format("target reports current file is %s but is %s", file, this.currentFile));
        }
    }

    public void begin() {
        PendingFile first = this.files.isEmpty() ? null : this.files.values().iterator().next();
        this.currentFile = first == null ? null : first.getFilename();
        StreamHeader header = new StreamHeader(this.table, this.getSessionId(), first, this.files.values());
        logger.info("Streaming to {}", (Object)this.getHost());
        logger.debug("Files are {}", (Object)StringUtils.join(this.files.values(), (String)","));
        MessagingService.instance().stream(header, this.getHost());
    }

    @Override
    public void onJoin(InetAddress endpoint, EndpointState epState) {
    }

    @Override
    public void onChange(InetAddress endpoint, ApplicationState state, VersionedValue value) {
    }

    @Override
    public void onAlive(InetAddress endpoint, EndpointState state) {
    }

    @Override
    public void onDead(InetAddress endpoint, EndpointState state) {
    }

    @Override
    public void onRemove(InetAddress endpoint) {
        this.convict(endpoint, Double.MAX_VALUE);
    }

    @Override
    public void onRestart(InetAddress endpoint, EndpointState epState) {
        this.convict(endpoint, Double.MAX_VALUE);
    }

    @Override
    public void convict(InetAddress endpoint, double phi) {
        if (!endpoint.equals(this.getHost())) {
            return;
        }
        if (phi < (double)(2 * DatabaseDescriptor.getPhiConvictThreshold())) {
            return;
        }
        logger.error("StreamOutSession {} failed because {} died or was restarted/removed (streams may still be active in background, but further streams won't be started)", (Object)endpoint);
        this.close(false);
    }
}

