/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.service;

import java.util.List;
import java.util.concurrent.ExecutionException;
import org.apache.cassandra.db.ColumnFamilyStore;
import org.apache.cassandra.db.RangeSliceCommand;
import org.apache.cassandra.db.RangeSliceReply;
import org.apache.cassandra.db.Row;
import org.apache.cassandra.db.Table;
import org.apache.cassandra.db.filter.IFilter;
import org.apache.cassandra.db.filter.QueryFilter;
import org.apache.cassandra.net.IVerbHandler;
import org.apache.cassandra.net.Message;
import org.apache.cassandra.net.MessagingService;
import org.apache.cassandra.service.StorageService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RangeSliceVerbHandler
implements IVerbHandler {
    private static final Logger logger = LoggerFactory.getLogger(RangeSliceVerbHandler.class);

    static List<Row> executeLocally(RangeSliceCommand command) throws ExecutionException, InterruptedException {
        ColumnFamilyStore cfs = Table.open(command.keyspace).getColumnFamilyStore(command.column_family);
        IFilter columnFilter = QueryFilter.getFilter(command.predicate, cfs.getComparator());
        if (cfs.indexManager.hasIndexFor(command.row_filter)) {
            return cfs.search(command.row_filter, command.range, command.maxResults, columnFilter, command.maxIsColumns);
        }
        return cfs.getRangeSlice(command.super_column, command.range, command.maxResults, columnFilter, command.row_filter, command.maxIsColumns);
    }

    @Override
    public void doVerb(Message message, String id) {
        try {
            if (StorageService.instance.isBootstrapMode()) {
                throw new RuntimeException("Cannot service reads while bootstrapping!");
            }
            RangeSliceCommand command = RangeSliceCommand.read(message);
            ColumnFamilyStore cfs = Table.open(command.keyspace).getColumnFamilyStore(command.column_family);
            RangeSliceReply reply = new RangeSliceReply(RangeSliceVerbHandler.executeLocally(command));
            Message response = reply.getReply(message);
            if (logger.isDebugEnabled()) {
                logger.debug("Sending " + reply + " to " + id + "@" + message.getFrom());
            }
            MessagingService.instance().sendReply(response, id, message.getFrom());
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }
}

