/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db;

import com.google.common.base.Function;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.Iterator;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import org.apache.cassandra.db.AbstractThreadUnsafeSortedColumns;
import org.apache.cassandra.db.IColumn;
import org.apache.cassandra.db.ISortedColumns;
import org.apache.cassandra.db.SuperColumn;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.utils.Allocator;

public class TreeMapBackedSortedColumns
extends AbstractThreadUnsafeSortedColumns
implements ISortedColumns {
    private final TreeMap<ByteBuffer, IColumn> map;
    public static final ISortedColumns.Factory factory = new ISortedColumns.Factory(){

        @Override
        public ISortedColumns create(AbstractType<?> comparator, boolean insertReversed) {
            return new TreeMapBackedSortedColumns(comparator);
        }

        @Override
        public ISortedColumns fromSorted(SortedMap<ByteBuffer, IColumn> sortedMap, boolean insertReversed) {
            return new TreeMapBackedSortedColumns(sortedMap);
        }
    };

    public static ISortedColumns.Factory factory() {
        return factory;
    }

    @Override
    public AbstractType<?> getComparator() {
        return (AbstractType)this.map.comparator();
    }

    private TreeMapBackedSortedColumns(AbstractType<?> comparator) {
        this.map = new TreeMap(comparator);
    }

    private TreeMapBackedSortedColumns(SortedMap<ByteBuffer, IColumn> columns) {
        this.map = new TreeMap<ByteBuffer, IColumn>(columns);
    }

    @Override
    public ISortedColumns.Factory getFactory() {
        return TreeMapBackedSortedColumns.factory();
    }

    @Override
    public ISortedColumns cloneMe() {
        return new TreeMapBackedSortedColumns(this.map);
    }

    @Override
    public boolean isInsertReversed() {
        return false;
    }

    @Override
    public void addColumn(IColumn column, Allocator allocator) {
        ByteBuffer name = column.name();
        IColumn oldColumn = this.map.put(name, column);
        if (oldColumn != null) {
            if (oldColumn instanceof SuperColumn) {
                assert (column instanceof SuperColumn);
                ((SuperColumn)oldColumn).putColumn((SuperColumn)column, allocator);
                this.map.put(name, oldColumn);
            } else {
                IColumn reconciledColumn = column.reconcile(oldColumn, allocator);
                this.map.put(name, reconciledColumn);
            }
        }
    }

    @Override
    protected void addAllColumns(ISortedColumns cm, Allocator allocator, Function<IColumn, IColumn> transformation) {
        for (IColumn column : cm.getSortedColumns()) {
            this.addColumn((IColumn)transformation.apply((Object)column), allocator);
        }
    }

    @Override
    public boolean replace(IColumn oldColumn, IColumn newColumn) {
        if (!oldColumn.name().equals(newColumn.name())) {
            throw new IllegalArgumentException();
        }
        IColumn previous = this.map.put(oldColumn.name(), newColumn);
        if (previous == null) {
            this.map.remove(oldColumn.name());
            return false;
        }
        if (!previous.equals(oldColumn)) {
            this.map.put(oldColumn.name(), previous);
            return false;
        }
        return true;
    }

    @Override
    public IColumn getColumn(ByteBuffer name) {
        return this.map.get(name);
    }

    @Override
    public void removeColumn(ByteBuffer name) {
        this.map.remove(name);
    }

    @Override
    public void clear() {
        this.map.clear();
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public Collection<IColumn> getSortedColumns() {
        return this.map.values();
    }

    @Override
    public Collection<IColumn> getReverseSortedColumns() {
        return this.map.descendingMap().values();
    }

    @Override
    public SortedSet<ByteBuffer> getColumnNames() {
        return this.map.navigableKeySet();
    }

    @Override
    public Iterator<IColumn> iterator() {
        return this.map.values().iterator();
    }

    @Override
    public Iterator<IColumn> reverseIterator() {
        return this.getReverseSortedColumns().iterator();
    }

    @Override
    public Iterator<IColumn> iterator(ByteBuffer start) {
        return this.map.tailMap(start).values().iterator();
    }

    @Override
    public Iterator<IColumn> reverseIterator(ByteBuffer start) {
        return this.map.descendingMap().tailMap(start).values().iterator();
    }
}

