/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cql3.statements;

import com.google.common.collect.AbstractIterator;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.concurrent.TimeoutException;
import org.apache.cassandra.auth.Permission;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.cql3.CFDefinition;
import org.apache.cassandra.cql3.CFName;
import org.apache.cassandra.cql3.CQLStatement;
import org.apache.cassandra.cql3.ColumnIdentifier;
import org.apache.cassandra.cql3.ColumnNameBuilder;
import org.apache.cassandra.cql3.QueryProcessor;
import org.apache.cassandra.cql3.Relation;
import org.apache.cassandra.cql3.Term;
import org.apache.cassandra.cql3.statements.CFStatement;
import org.apache.cassandra.cql3.statements.ParsedStatement;
import org.apache.cassandra.db.ColumnFamily;
import org.apache.cassandra.db.CounterColumn;
import org.apache.cassandra.db.IColumn;
import org.apache.cassandra.db.RangeSliceCommand;
import org.apache.cassandra.db.ReadCommand;
import org.apache.cassandra.db.Row;
import org.apache.cassandra.db.RowPosition;
import org.apache.cassandra.db.SliceByNamesReadCommand;
import org.apache.cassandra.db.SliceFromReadCommand;
import org.apache.cassandra.db.Table;
import org.apache.cassandra.db.context.CounterContext;
import org.apache.cassandra.db.filter.QueryPath;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.db.marshal.CompositeType;
import org.apache.cassandra.db.marshal.TypeParser;
import org.apache.cassandra.dht.AbstractBounds;
import org.apache.cassandra.dht.Bounds;
import org.apache.cassandra.dht.ExcludingBounds;
import org.apache.cassandra.dht.IPartitioner;
import org.apache.cassandra.dht.IncludingExcludingBounds;
import org.apache.cassandra.dht.RandomPartitioner;
import org.apache.cassandra.dht.Range;
import org.apache.cassandra.service.ClientState;
import org.apache.cassandra.service.StorageProxy;
import org.apache.cassandra.service.StorageService;
import org.apache.cassandra.thrift.Column;
import org.apache.cassandra.thrift.ConsistencyLevel;
import org.apache.cassandra.thrift.CqlMetadata;
import org.apache.cassandra.thrift.CqlResult;
import org.apache.cassandra.thrift.CqlResultType;
import org.apache.cassandra.thrift.CqlRow;
import org.apache.cassandra.thrift.IndexExpression;
import org.apache.cassandra.thrift.IndexOperator;
import org.apache.cassandra.thrift.InvalidRequestException;
import org.apache.cassandra.thrift.RequestType;
import org.apache.cassandra.thrift.SlicePredicate;
import org.apache.cassandra.thrift.SliceRange;
import org.apache.cassandra.thrift.ThriftValidation;
import org.apache.cassandra.thrift.TimedOutException;
import org.apache.cassandra.thrift.UnavailableException;
import org.apache.cassandra.utils.ByteBufferUtil;
import org.apache.cassandra.utils.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SelectStatement
implements CQLStatement {
    private static final Logger logger = LoggerFactory.getLogger(SelectStatement.class);
    private static final ByteBuffer countColumn = ByteBufferUtil.bytes("count");
    private final int boundTerms;
    public final CFDefinition cfDef;
    public final Parameters parameters;
    private final List<Pair<CFDefinition.Name, ColumnIdentifier>> selectedNames = new ArrayList<Pair<CFDefinition.Name, ColumnIdentifier>>();
    private Restriction keyRestriction;
    private final Restriction[] columnRestrictions;
    private final Map<CFDefinition.Name, Restriction> metadataRestrictions = new HashMap<CFDefinition.Name, Restriction>();

    public SelectStatement(CFDefinition cfDef, int boundTerms, Parameters parameters) {
        this.cfDef = cfDef;
        this.boundTerms = boundTerms;
        this.columnRestrictions = new Restriction[cfDef.columns.size()];
        this.parameters = parameters;
    }

    @Override
    public int getBoundsTerms() {
        return this.boundTerms;
    }

    @Override
    public void checkAccess(ClientState state) throws InvalidRequestException {
        state.hasColumnFamilyAccess(this.keyspace(), this.columnFamily(), Permission.READ);
    }

    @Override
    public void validate(ClientState state) throws InvalidRequestException {
    }

    @Override
    public CqlResult execute(ClientState state, List<ByteBuffer> variables) throws InvalidRequestException, UnavailableException, TimedOutException {
        List<Row> rows = this.isKeyRange() ? this.multiRangeSlice(variables) : this.getSlice(variables);
        CqlResult result = new CqlResult();
        result.type = CqlResultType.ROWS;
        if (this.parameters.isCount) {
            result.schema = new CqlMetadata(Collections.emptyMap(), Collections.emptyMap(), "AsciiType", "LongType");
            List<Column> columns = Collections.singletonList(new Column(countColumn).setValue(ByteBufferUtil.bytes((long)rows.size())));
            result.rows = Collections.singletonList(new CqlRow(countColumn, columns));
            return result;
        }
        result.schema = this.createSchema();
        result.rows = this.process(rows, result.schema, variables);
        return result;
    }

    public List<CqlRow> process(List<Row> rows) throws InvalidRequestException {
        assert (!this.parameters.isCount);
        return this.process(rows, this.createSchema(), Collections.<ByteBuffer>emptyList());
    }

    private CqlMetadata createSchema() {
        return new CqlMetadata(new HashMap(), new HashMap(), TypeParser.getShortName(this.cfDef.cfm.comparator), TypeParser.getShortName(this.cfDef.cfm.getDefaultValidator()));
    }

    public String keyspace() {
        return this.cfDef.cfm.ksName;
    }

    public String columnFamily() {
        return this.cfDef.cfm.cfName;
    }

    private List<Row> getSlice(List<ByteBuffer> variables) throws InvalidRequestException, TimedOutException, UnavailableException {
        QueryPath queryPath = new QueryPath(this.columnFamily());
        ArrayList<ReadCommand> commands = new ArrayList<ReadCommand>();
        if (this.isColumnRange()) {
            ByteBuffer start = this.getRequestedBound(Bound.START, variables);
            ByteBuffer finish = this.getRequestedBound(Bound.END, variables);
            for (ByteBuffer key : this.getKeys(variables)) {
                QueryProcessor.validateKey(key);
                QueryProcessor.validateSliceRange(this.cfDef.cfm, start, finish, this.parameters.isColumnsReversed);
                commands.add(new SliceFromReadCommand(this.keyspace(), key, queryPath, start, finish, this.parameters.isColumnsReversed, this.getLimit()));
            }
        } else {
            List<ByteBuffer> columnNames = this.getRequestedColumns(variables);
            QueryProcessor.validateColumnNames(columnNames);
            for (ByteBuffer key : this.getKeys(variables)) {
                QueryProcessor.validateKey(key);
                commands.add(new SliceByNamesReadCommand(this.keyspace(), key, queryPath, columnNames));
            }
        }
        try {
            return StorageProxy.read(commands, this.parameters.consistencyLevel);
        }
        catch (TimeoutException e) {
            throw new TimedOutException();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private List<Row> multiRangeSlice(List<ByteBuffer> variables) throws InvalidRequestException, TimedOutException, UnavailableException {
        List<Row> rows;
        RowPosition finishKey;
        IPartitioner p = StorageService.getPartitioner();
        ByteBuffer startKeyBytes = this.getKeyBound(Bound.START, variables);
        ByteBuffer finishKeyBytes = this.getKeyBound(Bound.END, variables);
        RowPosition startKey = RowPosition.forKey(startKeyBytes, p);
        if (startKey.compareTo(finishKey = RowPosition.forKey(finishKeyBytes, p)) > 0 && !finishKey.isMinimum(p)) {
            if (p instanceof RandomPartitioner) {
                throw new InvalidRequestException("Start key sorts after end key. This is not allowed; you probably should not specify end key at all, under RandomPartitioner");
            }
            throw new InvalidRequestException("Start key must sort before (or equal to) finish key in your partitioner!");
        }
        AbstractBounds bounds = this.includeKeyBound(Bound.START) ? (this.includeKeyBound(Bound.END) ? new Bounds<RowPosition>(startKey, finishKey) : new IncludingExcludingBounds<RowPosition>(startKey, finishKey)) : (this.includeKeyBound(Bound.END) ? new Range<RowPosition>(startKey, finishKey) : new ExcludingBounds<RowPosition>(startKey, finishKey));
        SlicePredicate thriftSlicePredicate = this.makeSlicePredicate(variables);
        QueryProcessor.validateSlicePredicate(this.cfDef.cfm, thriftSlicePredicate);
        List<IndexExpression> expressions = this.getIndexExpressions(variables);
        try {
            rows = StorageProxy.getRangeSlice(new RangeSliceCommand(this.keyspace(), this.columnFamily(), null, thriftSlicePredicate, bounds, expressions, this.getLimit(), true), this.parameters.consistencyLevel);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        catch (TimeoutException e) {
            throw new TimedOutException();
        }
        return rows;
    }

    private SlicePredicate makeSlicePredicate(List<ByteBuffer> variables) throws InvalidRequestException {
        SlicePredicate thriftSlicePredicate = new SlicePredicate();
        if (this.isColumnRange()) {
            SliceRange sliceRange = new SliceRange();
            sliceRange.start = this.getRequestedBound(Bound.START, variables);
            sliceRange.finish = this.getRequestedBound(Bound.END, variables);
            sliceRange.reversed = this.parameters.isColumnsReversed;
            sliceRange.count = -1;
            thriftSlicePredicate.slice_range = sliceRange;
        } else {
            thriftSlicePredicate.column_names = this.getRequestedColumns(variables);
        }
        return thriftSlicePredicate;
    }

    private int getLimit() {
        return this.cfDef.isCompact ? this.parameters.limit : this.cfDef.metadata.size() * this.parameters.limit;
    }

    private boolean isKeyRange() {
        if (!this.metadataRestrictions.isEmpty()) {
            return true;
        }
        return this.keyRestriction == null || !this.keyRestriction.isEquality();
    }

    private Collection<ByteBuffer> getKeys(List<ByteBuffer> variables) throws InvalidRequestException {
        assert (this.keyRestriction != null && this.keyRestriction.isEquality());
        ArrayList<ByteBuffer> keys = new ArrayList<ByteBuffer>(this.keyRestriction.eqValues.size());
        for (Term t : this.keyRestriction.eqValues) {
            keys.add(t.getByteBuffer(this.cfDef.key.type, variables));
        }
        return keys;
    }

    private ByteBuffer getKeyBound(Bound b, List<ByteBuffer> variables) throws InvalidRequestException {
        if (this.keyRestriction == null) {
            return ByteBufferUtil.EMPTY_BYTE_BUFFER;
        }
        if (this.keyRestriction.isEquality()) {
            assert (this.keyRestriction.eqValues.size() == 1);
            return this.keyRestriction.eqValues.get(0).getByteBuffer(this.cfDef.key.type, variables);
        }
        Term bound = this.keyRestriction.bound(b);
        return bound == null ? ByteBufferUtil.EMPTY_BYTE_BUFFER : bound.getByteBuffer(this.cfDef.key.type, variables);
    }

    private boolean includeKeyBound(Bound b) {
        if (this.keyRestriction == null || this.keyRestriction.isEquality()) {
            return true;
        }
        return this.keyRestriction.isInclusive(b);
    }

    private boolean isColumnRange() {
        if (!this.cfDef.isCompact && !this.cfDef.isComposite) {
            return false;
        }
        for (Restriction r : this.columnRestrictions) {
            if (r != null && r.isEquality()) continue;
            return true;
        }
        return false;
    }

    private boolean isWildcard() {
        return this.selectedNames.isEmpty();
    }

    private List<ByteBuffer> getRequestedColumns(List<ByteBuffer> variables) throws InvalidRequestException {
        assert (!this.isColumnRange());
        ColumnNameBuilder builder = this.cfDef.getColumnNameBuilder();
        for (Restriction r : this.columnRestrictions) {
            assert (r != null && r.isEquality());
            if (r.eqValues.size() > 1) {
                ArrayList<ByteBuffer> columns = new ArrayList<ByteBuffer>(r.eqValues.size());
                Iterator<Term> iter = r.eqValues.iterator();
                while (iter.hasNext()) {
                    Term v = iter.next();
                    ColumnNameBuilder b = iter.hasNext() ? builder.copy() : builder;
                    ByteBuffer cname = b.add(v, Relation.Type.EQ, variables).build();
                    columns.add(cname);
                }
                return columns;
            }
            builder.add(r.eqValues.get(0), Relation.Type.EQ, variables);
        }
        if (this.cfDef.isCompact) {
            return Collections.singletonList(builder.build());
        }
        ArrayList<ByteBuffer> columns = new ArrayList<ByteBuffer>();
        Iterator<Pair<CFDefinition.Name, ColumnIdentifier>> iter = this.getExpandedSelection().iterator();
        while (iter.hasNext()) {
            CFDefinition.Name name = (CFDefinition.Name)iter.next().left;
            if (name.kind != CFDefinition.Name.Kind.COLUMN_METADATA) continue;
            ColumnNameBuilder b = iter.hasNext() ? builder.copy() : builder;
            ByteBuffer cname = b.add(name.name.key).build();
            columns.add(cname);
        }
        return columns;
    }

    private ByteBuffer getRequestedBound(Bound b, List<ByteBuffer> variables) throws InvalidRequestException {
        assert (this.isColumnRange());
        ColumnNameBuilder builder = this.cfDef.getColumnNameBuilder();
        for (Restriction r : this.columnRestrictions) {
            if (r == null) {
                if (builder.componentCount() > 0 && b == Bound.END) {
                    return builder.buildAsEndOfRange();
                }
                return builder.build();
            }
            if (r.isEquality()) {
                assert (r.eqValues.size() == 1);
            } else {
                Term t = r.bound(b);
                if (t == null) {
                    return ByteBufferUtil.EMPTY_BYTE_BUFFER;
                }
                return builder.add(t, r.getRelation(b), variables).build();
            }
            builder.add(r.eqValues.get(0), Relation.Type.EQ, variables);
        }
        return builder.build();
    }

    private List<IndexExpression> getIndexExpressions(List<ByteBuffer> variables) throws InvalidRequestException {
        if (this.metadataRestrictions.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<IndexExpression> expressions = new ArrayList<IndexExpression>();
        for (Map.Entry<CFDefinition.Name, Restriction> entry : this.metadataRestrictions.entrySet()) {
            CFDefinition.Name name = entry.getKey();
            Restriction restriction = entry.getValue();
            if (restriction.isEquality()) {
                for (Term t : restriction.eqValues) {
                    ByteBuffer value = t.getByteBuffer(name.type, variables);
                    expressions.add(new IndexExpression(name.name.key, IndexOperator.EQ, value));
                }
                continue;
            }
            for (Bound b : Bound.values()) {
                ByteBuffer value = restriction.bound(b).getByteBuffer(name.type, variables);
                expressions.add(new IndexExpression(name.name.key, restriction.getIndexOperator(b), value));
            }
        }
        return expressions;
    }

    private List<Pair<CFDefinition.Name, ColumnIdentifier>> getExpandedSelection() {
        if (this.selectedNames.isEmpty()) {
            ArrayList<Pair<CFDefinition.Name, ColumnIdentifier>> selection = new ArrayList<Pair<CFDefinition.Name, ColumnIdentifier>>();
            for (CFDefinition.Name name : this.cfDef) {
                selection.add(Pair.create(name, name.name));
            }
            return selection;
        }
        return this.selectedNames;
    }

    private ByteBuffer value(IColumn c) {
        return c instanceof CounterColumn ? ByteBufferUtil.bytes(CounterContext.instance().total(c.value())) : c.value();
    }

    private void addToSchema(CqlMetadata schema, Pair<CFDefinition.Name, ColumnIdentifier> p) {
        ByteBuffer nameAsRequested = ((ColumnIdentifier)p.right).key;
        schema.name_types.put(nameAsRequested, TypeParser.getShortName(this.cfDef.getNameComparatorForResultSet((CFDefinition.Name)p.left)));
        schema.value_types.put(nameAsRequested, TypeParser.getShortName(((CFDefinition.Name)p.left).type));
    }

    private Iterable<IColumn> columnsInOrder(final ColumnFamily cf, List<ByteBuffer> variables) throws InvalidRequestException {
        Restriction last = this.columnRestrictions[this.columnRestrictions.length - 1];
        if (last == null || !last.isEquality()) {
            return cf.getSortedColumns();
        }
        ColumnNameBuilder builder = this.cfDef.getColumnNameBuilder();
        for (int i = 0; i < this.columnRestrictions.length - 1; ++i) {
            builder.add(this.columnRestrictions[i].eqValues.get(0), Relation.Type.EQ, variables);
        }
        final ArrayList<ByteBuffer> requested = new ArrayList<ByteBuffer>(last.eqValues.size());
        Iterator<Term> iter = last.eqValues.iterator();
        while (iter.hasNext()) {
            Term t = iter.next();
            ColumnNameBuilder b = iter.hasNext() ? builder.copy() : builder;
            requested.add(b.add(t, Relation.Type.EQ, variables).build());
        }
        return new Iterable<IColumn>(){

            @Override
            public Iterator<IColumn> iterator() {
                return new AbstractIterator<IColumn>(){
                    Iterator<ByteBuffer> iter;
                    {
                        this.iter = requested.iterator();
                    }

                    public IColumn computeNext() {
                        if (!this.iter.hasNext()) {
                            return (IColumn)this.endOfData();
                        }
                        IColumn column = cf.getColumn(this.iter.next());
                        return column == null ? this.computeNext() : column;
                    }
                };
            }
        };
    }

    private List<CqlRow> process(List<Row> rows, CqlMetadata schema, List<ByteBuffer> variables) throws InvalidRequestException {
        ArrayList<CqlRow> cqlRows = new ArrayList<CqlRow>();
        List<Pair<CFDefinition.Name, ColumnIdentifier>> selection = this.getExpandedSelection();
        ArrayList<Column> thriftColumns = null;
        for (Row row : rows) {
            if (this.cfDef.isCompact) {
                if (row.cf == null) continue;
                for (IColumn iColumn : this.columnsInOrder(row.cf, variables)) {
                    if (iColumn.isMarkedForDelete()) continue;
                    thriftColumns = new ArrayList();
                    ByteBuffer[] components = this.cfDef.isComposite ? ((CompositeType)this.cfDef.cfm.comparator).split(iColumn.name()) : null;
                    for (Pair<CFDefinition.Name, ColumnIdentifier> p : selection) {
                        CFDefinition.Name name = (CFDefinition.Name)p.left;
                        ByteBuffer nameAsRequested = ((ColumnIdentifier)p.right).key;
                        this.addToSchema(schema, p);
                        Column col = new Column(nameAsRequested);
                        switch (name.kind) {
                            case KEY_ALIAS: {
                                col.setValue(row.key.key).setTimestamp(-1L);
                                break;
                            }
                            case COLUMN_ALIAS: {
                                col.setTimestamp(iColumn.timestamp());
                                if (this.cfDef.isComposite) {
                                    if (name.position < components.length) {
                                        col.setValue(components[name.position]);
                                        break;
                                    }
                                    col.setValue(ByteBufferUtil.EMPTY_BYTE_BUFFER);
                                    break;
                                }
                                col.setValue(iColumn.name());
                                break;
                            }
                            case VALUE_ALIAS: {
                                col.setValue(this.value(iColumn)).setTimestamp(iColumn.timestamp());
                                break;
                            }
                            case COLUMN_METADATA: {
                                throw new AssertionError();
                            }
                        }
                        thriftColumns.add(col);
                    }
                    cqlRows.add(new CqlRow(row.key.key, thriftColumns));
                }
                continue;
            }
            if (this.cfDef.isComposite) {
                if (row.cf == null) continue;
                CompositeType composite = (CompositeType)this.cfDef.cfm.comparator;
                int n = composite.types.size() - 1;
                ByteBuffer[] previous = null;
                HashMap<ByteBuffer, IColumn> group = new HashMap<ByteBuffer, IColumn>();
                for (IColumn c : row.cf) {
                    if (c.isMarkedForDelete()) continue;
                    ByteBuffer[] current = composite.split(c.name());
                    if (previous != null && !SelectStatement.isSameRow(previous, current)) {
                        cqlRows.add(this.handleGroup(selection, row.key.key, previous, group, schema));
                        group = new HashMap();
                    }
                    group.put(current[n], c);
                    previous = current;
                }
                if (previous == null) continue;
                cqlRows.add(this.handleGroup(selection, row.key.key, previous, group, schema));
                continue;
            }
            thriftColumns = new ArrayList<Column>();
            for (Pair pair : selection) {
                CFDefinition.Name name = (CFDefinition.Name)pair.left;
                ByteBuffer nameAsRequested = ((ColumnIdentifier)pair.right).key;
                if (name.kind == CFDefinition.Name.Kind.KEY_ALIAS) {
                    this.addToSchema(schema, pair);
                    thriftColumns.add(new Column(nameAsRequested).setValue(row.key.key).setTimestamp(-1L));
                    continue;
                }
                if (row.cf == null) continue;
                this.addToSchema(schema, pair);
                IColumn c = row.cf.getColumn(name.name.key);
                Column col = new Column(name.name.key);
                if (c != null && !c.isMarkedForDelete()) {
                    col.setValue(this.value(c)).setTimestamp(c.timestamp());
                }
                thriftColumns.add(col);
            }
            cqlRows.add(new CqlRow(row.key.key, thriftColumns));
        }
        if (this.parameters.isColumnsReversed) {
            Collections.reverse(cqlRows);
        }
        cqlRows = cqlRows.size() > this.parameters.limit ? cqlRows.subList(0, this.parameters.limit) : cqlRows;
        return cqlRows;
    }

    private static boolean isSameRow(ByteBuffer[] c1, ByteBuffer[] c2) {
        assert (c1.length == c2.length) : "Sparse composite should not have partial column names";
        for (int i = 0; i < c1.length - 1; ++i) {
            if (c1[i].equals(c2[i])) continue;
            return false;
        }
        return true;
    }

    private CqlRow handleGroup(List<Pair<CFDefinition.Name, ColumnIdentifier>> selection, ByteBuffer key, ByteBuffer[] components, Map<ByteBuffer, IColumn> columns, CqlMetadata schema) {
        ArrayList<Column> thriftColumns = new ArrayList<Column>();
        for (Pair<CFDefinition.Name, ColumnIdentifier> p : selection) {
            CFDefinition.Name name = (CFDefinition.Name)p.left;
            ByteBuffer nameAsRequested = ((ColumnIdentifier)p.right).key;
            this.addToSchema(schema, p);
            Column col = new Column(nameAsRequested);
            switch (name.kind) {
                case KEY_ALIAS: {
                    col.setValue(key).setTimestamp(-1L);
                    break;
                }
                case COLUMN_ALIAS: {
                    col.setValue(components[name.position]);
                    col.setTimestamp(-1L);
                    break;
                }
                case VALUE_ALIAS: {
                    throw new AssertionError();
                }
                case COLUMN_METADATA: {
                    IColumn c = columns.get(name.name.key);
                    if (c == null || c.isMarkedForDelete()) break;
                    col.setValue(this.value(c)).setTimestamp(c.timestamp());
                }
            }
            thriftColumns.add(col);
        }
        return new CqlRow(key, thriftColumns);
    }

    public static class Parameters {
        private final int limit;
        private final ConsistencyLevel consistencyLevel;
        private final ColumnIdentifier orderBy;
        private final boolean isColumnsReversed;
        private final boolean isCount;

        public Parameters(ConsistencyLevel consistency, int limit, ColumnIdentifier orderBy, boolean reversed, boolean isCount) {
            this.consistencyLevel = consistency;
            this.limit = limit;
            this.orderBy = orderBy;
            this.isColumnsReversed = reversed;
            this.isCount = isCount;
        }
    }

    private static class Restriction {
        List<Term> eqValues;
        private final Term[] bounds;
        private final boolean[] boundInclusive;

        Restriction(List<Term> values) {
            this.eqValues = values;
            this.bounds = null;
            this.boundInclusive = null;
        }

        Restriction(Term value) {
            this(Collections.singletonList(value));
        }

        Restriction() {
            this.eqValues = null;
            this.bounds = new Term[2];
            this.boundInclusive = new boolean[2];
        }

        boolean isEquality() {
            return this.eqValues != null;
        }

        public void setBound(Bound b, Term t) {
            this.bounds[b.idx] = t;
        }

        public void setInclusive(Bound b) {
            this.boundInclusive[b.idx] = true;
        }

        public Term bound(Bound b) {
            return this.bounds[b.idx];
        }

        public boolean isInclusive(Bound b) {
            return this.boundInclusive[b.idx];
        }

        public Relation.Type getRelation(Bound b) {
            switch (b) {
                case START: {
                    return this.boundInclusive[b.idx] ? Relation.Type.GTE : Relation.Type.GT;
                }
                case END: {
                    return this.boundInclusive[b.idx] ? Relation.Type.LTE : Relation.Type.LT;
                }
            }
            throw new AssertionError();
        }

        public IndexOperator getIndexOperator(Bound b) {
            switch (b) {
                case START: {
                    return this.boundInclusive[b.idx] ? IndexOperator.GTE : IndexOperator.GT;
                }
                case END: {
                    return this.boundInclusive[b.idx] ? IndexOperator.LTE : IndexOperator.LT;
                }
            }
            throw new AssertionError();
        }

        public void setBound(ColumnIdentifier name, Relation.Type type, Term t) throws InvalidRequestException {
            Bound b = null;
            boolean inclusive = false;
            switch (type) {
                case GT: {
                    b = Bound.START;
                    inclusive = false;
                    break;
                }
                case GTE: {
                    b = Bound.START;
                    inclusive = true;
                    break;
                }
                case LTE: {
                    b = Bound.END;
                    inclusive = true;
                    break;
                }
                case LT: {
                    b = Bound.END;
                    inclusive = true;
                }
            }
            if (this.bounds[b.idx] != null) {
                throw new InvalidRequestException(String.format("Invalid restrictions found on %s", name));
            }
            this.bounds[b.idx] = t;
            this.boundInclusive[b.idx] = inclusive;
        }
    }

    public static class RawStatement
    extends CFStatement {
        private final Parameters parameters;
        private final List<ColumnIdentifier> selectClause;
        private final List<Relation> whereClause;

        public RawStatement(CFName cfName, Parameters parameters, List<ColumnIdentifier> selectClause, List<Relation> whereClause) {
            super(cfName);
            this.parameters = parameters;
            this.selectClause = selectClause;
            this.whereClause = whereClause == null ? Collections.emptyList() : whereClause;
        }

        @Override
        public ParsedStatement.Prepared prepare() throws InvalidRequestException {
            CFDefinition.Name name;
            CFMetaData cfm = ThriftValidation.validateColumnFamily(this.keyspace(), this.columnFamily());
            ThriftValidation.validateConsistencyLevel(this.keyspace(), this.parameters.consistencyLevel, RequestType.READ);
            if (this.parameters.limit <= 0) {
                throw new InvalidRequestException("LIMIT must be strictly positive");
            }
            CFDefinition cfDef = cfm.getCfDef();
            SelectStatement stmt = new SelectStatement(cfDef, this.getBoundsTerms(), this.parameters);
            AbstractType[] types = new AbstractType[this.getBoundsTerms()];
            if (this.parameters.isCount) {
                if (this.selectClause.size() != 1) {
                    throw new InvalidRequestException("Only COUNT(*) and COUNT(1) operations are currently supported.");
                }
                String columnName = this.selectClause.get(0).toString();
                if (!columnName.equals("*") && !columnName.equals("1")) {
                    throw new InvalidRequestException("Only COUNT(*) and COUNT(1) operations are currently supported.");
                }
            } else {
                for (ColumnIdentifier t : this.selectClause) {
                    name = cfDef.get(t);
                    if (name == null) {
                        throw new InvalidRequestException(String.format("Undefined name %s in selection clause", t));
                    }
                    stmt.selectedNames.add(Pair.create(name, t));
                }
            }
            for (Relation rel : this.whereClause) {
                name = cfDef.get(rel.getEntity());
                if (name == null) {
                    throw new InvalidRequestException(String.format("Undefined name %s in where clause ('%s')", rel.getEntity(), rel));
                }
                if (rel.operator() == Relation.Type.IN) {
                    for (Term value : rel.getInValues()) {
                        if (!value.isBindMarker()) continue;
                        types[value.bindIndex] = name.type;
                    }
                } else {
                    Term value = rel.getValue();
                    if (value.isBindMarker()) {
                        types[value.bindIndex] = name.type;
                    }
                }
                switch (name.kind) {
                    case KEY_ALIAS: {
                        if (rel.operator() != Relation.Type.EQ && rel.operator() != Relation.Type.IN && !StorageService.getPartitioner().preservesOrder()) {
                            throw new InvalidRequestException("Only EQ and IN relation are supported on first component of the PRIMARY KEY for RandomPartitioner");
                        }
                        stmt.keyRestriction = this.updateRestriction(name.name, stmt.keyRestriction, rel);
                        break;
                    }
                    case COLUMN_ALIAS: {
                        ((SelectStatement)stmt).columnRestrictions[name.position] = this.updateRestriction(name.name, stmt.columnRestrictions[name.position], rel);
                        break;
                    }
                    case VALUE_ALIAS: {
                        throw new InvalidRequestException(String.format("Restricting the value of a compact CF (%s) is not supported", name.name));
                    }
                    case COLUMN_METADATA: {
                        stmt.metadataRestrictions.put(name, this.updateRestriction(name.name, (Restriction)stmt.metadataRestrictions.get(name), rel));
                    }
                }
            }
            boolean shouldBeDone = false;
            CFDefinition.Name previous = null;
            Iterator<CFDefinition.Name> iter = cfDef.columns.values().iterator();
            for (int i = 0; i < stmt.columnRestrictions.length; ++i) {
                CFDefinition.Name cname = iter.next();
                Restriction restriction = stmt.columnRestrictions[i];
                if (restriction == null) {
                    shouldBeDone = true;
                } else {
                    if (shouldBeDone) {
                        throw new InvalidRequestException(String.format("PRIMARY KEY part %s cannot be restricted (preceding part %s is either not restricted or by a non-EQ relation)", cname, previous));
                    }
                    if (!restriction.isEquality()) {
                        shouldBeDone = true;
                    } else if (restriction.eqValues.size() > 1 && i != stmt.columnRestrictions.length - 1) {
                        throw new InvalidRequestException(String.format("PRIMARY KEY part %s cannot be restricted by IN relation (only the first and last parts can)", cname));
                    }
                }
                previous = cname;
            }
            if (!stmt.metadataRestrictions.isEmpty()) {
                boolean hasEq = false;
                SortedSet<ByteBuffer> indexed = Table.open((String)this.keyspace()).getColumnFamilyStore((String)this.columnFamily()).indexManager.getIndexedColumns();
                for (Map.Entry entry : stmt.metadataRestrictions.entrySet()) {
                    if (!((Restriction)entry.getValue()).isEquality() || !indexed.contains(((CFDefinition.Name)entry.getKey()).name.key)) continue;
                    hasEq = true;
                    break;
                }
                if (!hasEq) {
                    throw new InvalidRequestException("No indexed columns present in by-columns clause with Equal operator");
                }
                if (stmt.keyRestriction != null && stmt.keyRestriction.isEquality()) {
                    if (((SelectStatement)stmt).keyRestriction.eqValues.size() > 1) {
                        throw new InvalidRequestException("Select on indexed columns and with IN clause for the PRIMARY KEY are not supported");
                    }
                    Restriction newRestriction = new Restriction();
                    for (Bound b : Bound.values()) {
                        newRestriction.setBound(b, ((SelectStatement)stmt).keyRestriction.eqValues.get(0));
                        newRestriction.setInclusive(b);
                    }
                    stmt.keyRestriction = newRestriction;
                }
            }
            if (stmt.parameters.orderBy != null) {
                CFDefinition.Name name2 = cfDef.get(stmt.parameters.orderBy);
                if (name2 == null) {
                    throw new InvalidRequestException(String.format("Order by on unknown column %s", stmt.parameters.orderBy));
                }
                if (name2.kind != CFDefinition.Name.Kind.COLUMN_ALIAS || name2.position != 0) {
                    throw new InvalidRequestException(String.format("Order by is currently only supported on the second column of the PRIMARY KEY (if any), got %s", stmt.parameters.orderBy));
                }
            }
            if (stmt.parameters.isColumnsReversed && (stmt.keyRestriction == null || !stmt.keyRestriction.isEquality())) {
                throw new InvalidRequestException("Descending order is only supported is the first part of the PRIMARY KEY is restricted by an Equal or a IN");
            }
            return new ParsedStatement.Prepared(stmt, Arrays.asList(types));
        }

        Restriction updateRestriction(ColumnIdentifier name, Restriction restriction, Relation newRel) throws InvalidRequestException {
            switch (newRel.operator()) {
                case EQ: {
                    if (restriction != null) {
                        throw new InvalidRequestException(String.format("%s cannot be restricted by more than one relation if it includes an Equal", name));
                    }
                    restriction = new Restriction(newRel.getValue());
                    break;
                }
                case IN: {
                    if (restriction != null) {
                        throw new InvalidRequestException(String.format("%s cannot be restricted by more than one reation if it includes a IN", name));
                    }
                    restriction = new Restriction(newRel.getInValues());
                    break;
                }
                case GT: 
                case GTE: 
                case LT: 
                case LTE: {
                    if (restriction == null) {
                        restriction = new Restriction();
                    }
                    restriction.setBound(name, newRel.operator(), newRel.getValue());
                }
            }
            return restriction;
        }

        public String toString() {
            return String.format("SelectRawStatement[name=%s, selectClause=%s, whereClause=%s, isCount=%s, cLevel=%s, limit=%s]", this.cfName, this.selectClause, this.whereClause, this.parameters.isCount, this.parameters.consistencyLevel, this.parameters.limit);
        }
    }

    private static enum Bound {
        START(0),
        END(1);

        public final int idx;

        private Bound(int idx) {
            this.idx = idx;
        }
    }
}

