/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.config;

import com.google.common.collect.MapDifference;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.cassandra.config.ColumnDefinition;
import org.apache.cassandra.config.ConfigurationException;
import org.apache.cassandra.config.Schema;
import org.apache.cassandra.cql3.CFDefinition;
import org.apache.cassandra.cql3.QueryProcessor;
import org.apache.cassandra.cql3.UntypedResultSet;
import org.apache.cassandra.db.Column;
import org.apache.cassandra.db.ColumnFamily;
import org.apache.cassandra.db.ColumnFamilyStore;
import org.apache.cassandra.db.ColumnFamilyType;
import org.apache.cassandra.db.DeletedColumn;
import org.apache.cassandra.db.Row;
import org.apache.cassandra.db.RowMutation;
import org.apache.cassandra.db.SuperColumn;
import org.apache.cassandra.db.SystemTable;
import org.apache.cassandra.db.compaction.AbstractCompactionStrategy;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.db.marshal.AsciiType;
import org.apache.cassandra.db.marshal.BytesType;
import org.apache.cassandra.db.marshal.CompositeType;
import org.apache.cassandra.db.marshal.CounterColumnType;
import org.apache.cassandra.db.marshal.TimeUUIDType;
import org.apache.cassandra.db.marshal.TypeParser;
import org.apache.cassandra.db.marshal.UTF8Type;
import org.apache.cassandra.io.IColumnSerializer;
import org.apache.cassandra.io.compress.CompressionParameters;
import org.apache.cassandra.io.compress.SnappyCompressor;
import org.apache.cassandra.thrift.CfDef;
import org.apache.cassandra.thrift.ColumnDef;
import org.apache.cassandra.thrift.InvalidRequestException;
import org.apache.cassandra.utils.ByteBufferUtil;
import org.apache.cassandra.utils.FBUtilities;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CFMetaData {
    private static Logger logger = LoggerFactory.getLogger(CFMetaData.class);
    public static final double DEFAULT_READ_REPAIR_CHANCE = 0.1;
    public static final double DEFAULT_DCLOCAL_READ_REPAIR_CHANCE = 0.0;
    public static final boolean DEFAULT_REPLICATE_ON_WRITE = true;
    public static final int DEFAULT_GC_GRACE_SECONDS = 864000;
    public static final int DEFAULT_MIN_COMPACTION_THRESHOLD = 4;
    public static final int DEFAULT_MAX_COMPACTION_THRESHOLD = 32;
    public static final String DEFAULT_COMPACTION_STRATEGY_CLASS = "SizeTieredCompactionStrategy";
    public static final ByteBuffer DEFAULT_KEY_NAME = ByteBufferUtil.bytes("KEY");
    public static final CFMetaData StatusCf = CFMetaData.newSystemMetadata("LocationInfo", 0, "persistent metadata for the local node", BytesType.instance, null);
    public static final CFMetaData HintsCf = CFMetaData.newSystemMetadata("HintsColumnFamily", 1, "hinted handoff data", BytesType.instance, BytesType.instance);
    @Deprecated
    public static final CFMetaData MigrationsCf = CFMetaData.newSystemMetadata("Migrations", 2, "individual schema mutations", TimeUUIDType.instance, null);
    @Deprecated
    public static final CFMetaData SchemaCf = CFMetaData.newSystemMetadata("Schema", 3, "current state of the schema", UTF8Type.instance, null);
    public static final CFMetaData IndexCf = CFMetaData.newSystemMetadata("IndexInfo", 5, "indexes that have been completed", UTF8Type.instance, null);
    public static final CFMetaData NodeIdCf = CFMetaData.newSystemMetadata("NodeIdInfo", 6, "nodeId and their metadata", TimeUUIDType.instance, null);
    public static final CFMetaData VersionCf = CFMetaData.newSystemMetadata("Versions", 7, "server version information", UTF8Type.instance, null).keyAlias(ByteBufferUtil.bytes("component")).keyValidator(UTF8Type.instance).columnMetadata(Collections.singletonMap(ByteBufferUtil.bytes("version"), new ColumnDefinition(ByteBufferUtil.bytes("version"), UTF8Type.instance, null, null, null)));
    public static final CFMetaData SchemaKeyspacesCf = CFMetaData.newSchemaMetadata("schema_keyspaces", 8, "Keyspace definitions", AsciiType.instance, null).keyValidator(AsciiType.instance).keyAlias("keyspace");
    public static final CFMetaData SchemaColumnFamiliesCf;
    public static final CFMetaData SchemaColumnsCf;
    public final Integer cfId;
    public final String ksName;
    public final String cfName;
    public final ColumnFamilyType cfType;
    public AbstractType<?> comparator;
    public AbstractType<?> subcolumnComparator;
    private String comment;
    private double readRepairChance;
    private double dcLocalReadRepairChance;
    private boolean replicateOnWrite;
    private int gcGraceSeconds;
    private AbstractType<?> defaultValidator;
    private AbstractType<?> keyValidator;
    private int minCompactionThreshold;
    private int maxCompactionThreshold;
    private ByteBuffer keyAlias;
    private List<ByteBuffer> columnAliases = new ArrayList<ByteBuffer>();
    private ByteBuffer valueAlias;
    private Double bloomFilterFpChance;
    private Caching caching;
    Map<ByteBuffer, ColumnDefinition> column_metadata;
    public Class<? extends AbstractCompactionStrategy> compactionStrategyClass;
    public Map<String, String> compactionStrategyOptions;
    public CompressionParameters compressionParameters;
    private CFDefinition cqlCfDef;

    public CFMetaData comment(String prop) {
        this.comment = CFMetaData.enforceCommentNotNull(prop);
        return this;
    }

    public CFMetaData readRepairChance(double prop) {
        this.readRepairChance = prop;
        return this;
    }

    public CFMetaData dcLocalReadRepairChance(double prop) {
        this.dcLocalReadRepairChance = prop;
        return this;
    }

    public CFMetaData replicateOnWrite(boolean prop) {
        this.replicateOnWrite = prop;
        return this;
    }

    public CFMetaData gcGraceSeconds(int prop) {
        this.gcGraceSeconds = prop;
        return this;
    }

    public CFMetaData defaultValidator(AbstractType<?> prop) {
        this.defaultValidator = prop;
        this.updateCfDef();
        return this;
    }

    public CFMetaData keyValidator(AbstractType<?> prop) {
        this.keyValidator = prop;
        this.updateCfDef();
        return this;
    }

    public CFMetaData minCompactionThreshold(int prop) {
        this.minCompactionThreshold = prop;
        return this;
    }

    public CFMetaData maxCompactionThreshold(int prop) {
        this.maxCompactionThreshold = prop;
        return this;
    }

    public CFMetaData keyAlias(ByteBuffer prop) {
        this.keyAlias = prop;
        this.updateCfDef();
        return this;
    }

    public CFMetaData keyAlias(String alias) {
        return this.keyAlias(ByteBufferUtil.bytes(alias));
    }

    public CFMetaData columnAliases(List<ByteBuffer> prop) {
        this.columnAliases = prop;
        this.updateCfDef();
        return this;
    }

    public CFMetaData valueAlias(ByteBuffer prop) {
        this.valueAlias = prop;
        this.updateCfDef();
        return this;
    }

    public CFMetaData columnMetadata(Map<ByteBuffer, ColumnDefinition> prop) {
        this.column_metadata = prop;
        this.updateCfDef();
        return this;
    }

    private CFMetaData columnMetadata(ColumnDefinition ... cds) {
        HashMap<ByteBuffer, ColumnDefinition> map = new HashMap<ByteBuffer, ColumnDefinition>();
        for (ColumnDefinition cd : cds) {
            map.put(cd.name, cd);
        }
        return this.columnMetadata(map);
    }

    public CFMetaData compactionStrategyClass(Class<? extends AbstractCompactionStrategy> prop) {
        this.compactionStrategyClass = prop;
        return this;
    }

    public CFMetaData compactionStrategyOptions(Map<String, String> prop) {
        this.compactionStrategyOptions = prop;
        return this;
    }

    public CFMetaData compressionParameters(CompressionParameters prop) {
        this.compressionParameters = prop;
        return this;
    }

    public CFMetaData bloomFilterFpChance(Double prop) {
        this.bloomFilterFpChance = prop;
        return this;
    }

    public CFMetaData caching(Caching prop) {
        this.caching = prop;
        return this;
    }

    public CFMetaData(String keyspace, String name, ColumnFamilyType type, AbstractType<?> comp, AbstractType<?> subcc) {
        this(keyspace, name, type, comp, subcc, Schema.instance.nextCFId());
    }

    CFMetaData(String keyspace, String name, ColumnFamilyType type, AbstractType<?> comp, AbstractType<?> subcc, int id) {
        this.ksName = keyspace;
        this.cfName = name;
        this.cfType = type;
        this.comparator = comp;
        this.subcolumnComparator = this.enforceSubccDefault(type, subcc);
        this.cfId = id;
        this.caching = Caching.KEYS_ONLY;
        this.init();
    }

    private AbstractType<?> enforceSubccDefault(ColumnFamilyType cftype, AbstractType<?> subcc) {
        return subcc == null && cftype == ColumnFamilyType.Super ? BytesType.instance : subcc;
    }

    private static String enforceCommentNotNull(CharSequence comment) {
        return comment == null ? "" : ((Object)comment).toString();
    }

    private void init() {
        this.readRepairChance = 0.1;
        this.dcLocalReadRepairChance = 0.0;
        this.replicateOnWrite = true;
        this.gcGraceSeconds = 864000;
        this.minCompactionThreshold = 4;
        this.maxCompactionThreshold = 32;
        this.defaultValidator = BytesType.instance;
        this.keyValidator = BytesType.instance;
        this.comment = "";
        this.keyAlias = null;
        this.valueAlias = null;
        this.column_metadata = new HashMap<ByteBuffer, ColumnDefinition>();
        try {
            this.compactionStrategyClass = CFMetaData.createCompactionStrategy(DEFAULT_COMPACTION_STRATEGY_CLASS);
        }
        catch (ConfigurationException e) {
            throw new AssertionError((Object)e);
        }
        this.compactionStrategyOptions = new HashMap<String, String>();
        this.compressionParameters = new CompressionParameters(null);
        this.updateCfDef();
    }

    private static CFMetaData newSystemMetadata(String cfName, int cfId, String comment, AbstractType<?> comparator, AbstractType<?> subcc) {
        ColumnFamilyType type = subcc == null ? ColumnFamilyType.Standard : ColumnFamilyType.Super;
        CFMetaData newCFMD = new CFMetaData("system", cfName, type, comparator, subcc, cfId);
        return newCFMD.comment(comment).readRepairChance(0.0).dcLocalReadRepairChance(0.0).gcGraceSeconds(0);
    }

    private static CFMetaData newSchemaMetadata(String cfName, int cfId, String comment, AbstractType<?> comparator, AbstractType<?> subcc) {
        int gcGrace = 10368000;
        return CFMetaData.newSystemMetadata(cfName, cfId, comment, comparator, subcc).gcGraceSeconds(gcGrace);
    }

    public static CFMetaData newIndexMetadata(CFMetaData parent, ColumnDefinition info, AbstractType<?> columnComparator) {
        return new CFMetaData(parent.ksName, parent.indexColumnFamilyName(info), ColumnFamilyType.Standard, columnComparator, null).keyValidator(info.getValidator()).readRepairChance(0.0).dcLocalReadRepairChance(0.0).caching(Caching.NONE).reloadSecondaryIndexMetadata(parent);
    }

    public CFMetaData reloadSecondaryIndexMetadata(CFMetaData parent) {
        this.gcGraceSeconds(parent.gcGraceSeconds);
        this.minCompactionThreshold(parent.minCompactionThreshold);
        this.maxCompactionThreshold(parent.maxCompactionThreshold);
        this.compactionStrategyClass(parent.compactionStrategyClass);
        this.compactionStrategyOptions(parent.compactionStrategyOptions);
        this.compressionParameters(parent.compressionParameters);
        return this;
    }

    public CFMetaData clone() {
        return CFMetaData.copyOpts(new CFMetaData(this.ksName, this.cfName, this.cfType, this.comparator, this.subcolumnComparator, this.cfId), this);
    }

    public static CFMetaData rename(CFMetaData cfm, String newName) {
        return CFMetaData.copyOpts(new CFMetaData(cfm.ksName, newName, cfm.cfType, cfm.comparator, cfm.subcolumnComparator, cfm.cfId), cfm);
    }

    static CFMetaData copyOpts(CFMetaData newCFMD, CFMetaData oldCFMD) {
        return newCFMD.comment(oldCFMD.comment).readRepairChance(oldCFMD.readRepairChance).dcLocalReadRepairChance(oldCFMD.dcLocalReadRepairChance).replicateOnWrite(oldCFMD.replicateOnWrite).gcGraceSeconds(oldCFMD.gcGraceSeconds).defaultValidator(oldCFMD.defaultValidator).minCompactionThreshold(oldCFMD.minCompactionThreshold).maxCompactionThreshold(oldCFMD.maxCompactionThreshold).columnMetadata(oldCFMD.column_metadata).compactionStrategyClass(oldCFMD.compactionStrategyClass).compactionStrategyOptions(oldCFMD.compactionStrategyOptions).compressionParameters(oldCFMD.compressionParameters).bloomFilterFpChance(oldCFMD.bloomFilterFpChance).caching(oldCFMD.caching);
    }

    public String indexColumnFamilyName(ColumnDefinition info) {
        return this.cfName + '.' + (info.getIndexName() == null ? ByteBufferUtil.bytesToHex(info.name) : info.getIndexName());
    }

    public String getComment() {
        return this.comment;
    }

    public double getReadRepairChance() {
        return this.readRepairChance;
    }

    public double getDcLocalReadRepair() {
        return this.dcLocalReadRepairChance;
    }

    public boolean getReplicateOnWrite() {
        return this.replicateOnWrite;
    }

    public int getGcGraceSeconds() {
        return this.gcGraceSeconds;
    }

    public AbstractType<?> getDefaultValidator() {
        return this.defaultValidator;
    }

    public AbstractType<?> getKeyValidator() {
        return this.keyValidator;
    }

    public Integer getMinCompactionThreshold() {
        return this.minCompactionThreshold;
    }

    public Integer getMaxCompactionThreshold() {
        return this.maxCompactionThreshold;
    }

    public ByteBuffer getKeyName() {
        return this.keyAlias == null ? DEFAULT_KEY_NAME : this.keyAlias;
    }

    public ByteBuffer getKeyAlias() {
        return this.keyAlias;
    }

    public List<ByteBuffer> getColumnAliases() {
        return this.columnAliases;
    }

    public ByteBuffer getValueAlias() {
        return this.valueAlias;
    }

    public CompressionParameters compressionParameters() {
        return this.compressionParameters;
    }

    public Map<ByteBuffer, ColumnDefinition> getColumn_metadata() {
        return Collections.unmodifiableMap(this.column_metadata);
    }

    public AbstractType<?> getComparatorFor(ByteBuffer superColumnName) {
        return superColumnName == null ? this.comparator : this.subcolumnComparator;
    }

    public Double getBloomFilterFpChance() {
        return this.bloomFilterFpChance;
    }

    public Caching getCaching() {
        return this.caching;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        CFMetaData rhs = (CFMetaData)obj;
        return new EqualsBuilder().append((Object)this.ksName, (Object)rhs.ksName).append((Object)this.cfName, (Object)rhs.cfName).append((Object)this.cfType, (Object)rhs.cfType).append(this.comparator, rhs.comparator).append(this.subcolumnComparator, rhs.subcolumnComparator).append((Object)this.comment, (Object)rhs.comment).append(this.readRepairChance, rhs.readRepairChance).append(this.dcLocalReadRepairChance, rhs.dcLocalReadRepairChance).append(this.replicateOnWrite, rhs.replicateOnWrite).append(this.gcGraceSeconds, rhs.gcGraceSeconds).append(this.defaultValidator, rhs.defaultValidator).append(this.keyValidator, rhs.keyValidator).append(this.minCompactionThreshold, rhs.minCompactionThreshold).append(this.maxCompactionThreshold, rhs.maxCompactionThreshold).append(this.cfId.intValue(), rhs.cfId.intValue()).append(this.column_metadata, rhs.column_metadata).append((Object)this.keyAlias, (Object)rhs.keyAlias).append(this.columnAliases, rhs.columnAliases).append((Object)this.valueAlias, (Object)rhs.valueAlias).append(this.compactionStrategyClass, rhs.compactionStrategyClass).append(this.compactionStrategyOptions, rhs.compactionStrategyOptions).append((Object)this.compressionParameters, (Object)rhs.compressionParameters).append((Object)this.bloomFilterFpChance, (Object)rhs.bloomFilterFpChance).append((Object)this.caching, (Object)rhs.caching).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder(29, 1597).append((Object)this.ksName).append((Object)this.cfName).append((Object)this.cfType).append(this.comparator).append(this.subcolumnComparator).append((Object)this.comment).append(this.readRepairChance).append(this.dcLocalReadRepairChance).append(this.replicateOnWrite).append(this.gcGraceSeconds).append(this.defaultValidator).append(this.keyValidator).append(this.minCompactionThreshold).append(this.maxCompactionThreshold).append((Object)this.cfId).append(this.column_metadata).append((Object)this.keyAlias).append(this.columnAliases).append((Object)this.valueAlias).append(this.compactionStrategyClass).append(this.compactionStrategyOptions).append((Object)this.compressionParameters).append((Object)this.bloomFilterFpChance).append((Object)this.caching).toHashCode();
    }

    public AbstractType<?> getValueValidator(ByteBuffer column) {
        return this.getValueValidator(this.column_metadata.get(column));
    }

    public AbstractType<?> getValueValidator(ColumnDefinition columnDefinition) {
        return columnDefinition == null ? this.defaultValidator : columnDefinition.getValidator();
    }

    public static void applyImplicitDefaults(CfDef cf_def) {
        if (!cf_def.isSetComment()) {
            cf_def.setComment("");
        }
        if (!cf_def.isSetReplicate_on_write()) {
            cf_def.setReplicate_on_write(true);
        }
        if (!cf_def.isSetMin_compaction_threshold()) {
            cf_def.setMin_compaction_threshold(4);
        }
        if (!cf_def.isSetMax_compaction_threshold()) {
            cf_def.setMax_compaction_threshold(32);
        }
        if (null == cf_def.compaction_strategy) {
            cf_def.compaction_strategy = DEFAULT_COMPACTION_STRATEGY_CLASS;
        }
        if (null == cf_def.compaction_strategy_options) {
            cf_def.compaction_strategy_options = Collections.emptyMap();
        }
        if (!cf_def.isSetCompression_options()) {
            cf_def.setCompression_options((Map)new HashMap<String, String>(){
                {
                    this.put("sstable_compression", SnappyCompressor.class.getCanonicalName());
                }
            });
        }
        if (!cf_def.isSetDclocal_read_repair_chance()) {
            cf_def.setDclocal_read_repair_chance(0.0);
        }
    }

    public static CFMetaData fromThrift(CfDef cf_def) throws InvalidRequestException, ConfigurationException {
        ColumnFamilyType cfType = ColumnFamilyType.create(cf_def.column_type);
        if (cfType == null) {
            throw new InvalidRequestException("Invalid column type " + cf_def.column_type);
        }
        CFMetaData.applyImplicitDefaults(cf_def);
        CFMetaData newCFMD = new CFMetaData(cf_def.keyspace, cf_def.name, cfType, TypeParser.parse(cf_def.comparator_type), cf_def.subcomparator_type == null ? null : TypeParser.parse(cf_def.subcomparator_type), cf_def.isSetId() ? cf_def.id : Schema.instance.nextCFId());
        if (cf_def.isSetGc_grace_seconds()) {
            newCFMD.gcGraceSeconds(cf_def.gc_grace_seconds);
        }
        if (cf_def.isSetMin_compaction_threshold()) {
            newCFMD.minCompactionThreshold(cf_def.min_compaction_threshold);
        }
        if (cf_def.isSetMax_compaction_threshold()) {
            newCFMD.maxCompactionThreshold(cf_def.max_compaction_threshold);
        }
        if (cf_def.isSetKey_alias()) {
            newCFMD.keyAlias(cf_def.key_alias);
        }
        if (cf_def.isSetColumn_aliases() && cf_def.column_aliases != null) {
            newCFMD.columnAliases(cf_def.column_aliases);
        }
        if (cf_def.isSetValue_alias()) {
            newCFMD.valueAlias(cf_def.value_alias);
        }
        if (cf_def.isSetKey_validation_class()) {
            newCFMD.keyValidator(TypeParser.parse(cf_def.key_validation_class));
        }
        if (cf_def.isSetCompaction_strategy()) {
            newCFMD.compactionStrategyClass = CFMetaData.createCompactionStrategy(cf_def.compaction_strategy);
        }
        if (cf_def.isSetCompaction_strategy_options()) {
            newCFMD.compactionStrategyOptions(new HashMap<String, String>(cf_def.compaction_strategy_options));
        }
        if (cf_def.isSetBloom_filter_fp_chance()) {
            newCFMD.bloomFilterFpChance(cf_def.bloom_filter_fp_chance);
        }
        if (cf_def.isSetCaching()) {
            newCFMD.caching(Caching.fromString(cf_def.caching));
        }
        if (cf_def.isSetDclocal_read_repair_chance()) {
            newCFMD.dcLocalReadRepairChance(cf_def.dclocal_read_repair_chance);
        }
        CompressionParameters cp = CompressionParameters.create(cf_def.compression_options);
        return newCFMD.comment(cf_def.comment).readRepairChance(cf_def.read_repair_chance).replicateOnWrite(cf_def.replicate_on_write).defaultValidator(TypeParser.parse(cf_def.default_validation_class)).keyValidator(TypeParser.parse(cf_def.key_validation_class)).columnMetadata(ColumnDefinition.fromThrift(cf_def.column_metadata)).compressionParameters(cp).validate();
    }

    public void reload() throws IOException {
        Row cfDefRow = SystemTable.readSchemaRow(this.ksName, this.cfName);
        if (cfDefRow.cf == null || cfDefRow.cf.isEmpty()) {
            throw new IOException(String.format("%s not found in the schema definitions table.", this.ksName + ":" + this.cfName));
        }
        try {
            this.apply(CFMetaData.fromSchema(cfDefRow));
        }
        catch (ConfigurationException e) {
            throw new IOException(e);
        }
    }

    public void apply(CFMetaData cfm) throws ConfigurationException {
        logger.debug("applying {} to {}", (Object)cfm, (Object)this);
        if (!cfm.ksName.equals(this.ksName)) {
            throw new ConfigurationException(String.format("Keyspace mismatch (found %s; expected %s)", cfm.ksName, this.ksName));
        }
        if (!cfm.cfName.equals(this.cfName)) {
            throw new ConfigurationException(String.format("Column family mismatch (found %s; expected %s)", cfm.cfName, this.cfName));
        }
        if (!cfm.cfId.equals(this.cfId)) {
            throw new ConfigurationException(String.format("Column family ID mismatch (found %s; expected %s)", cfm.cfId, this.cfId));
        }
        if (!cfm.cfType.equals((Object)this.cfType)) {
            throw new ConfigurationException("types do not match.");
        }
        if (!cfm.comparator.isCompatibleWith(this.comparator)) {
            throw new ConfigurationException("comparators do not match or are not compatible.");
        }
        if (cfm.subcolumnComparator == null) {
            if (this.subcolumnComparator != null) {
                throw new ConfigurationException("subcolumncomparators do not match.");
            }
        } else if (!cfm.subcolumnComparator.isCompatibleWith(this.subcolumnComparator)) {
            throw new ConfigurationException("subcolumncomparators do not match or are note compatible.");
        }
        this.comparator = cfm.comparator;
        this.subcolumnComparator = cfm.subcolumnComparator;
        this.comment = CFMetaData.enforceCommentNotNull(cfm.comment);
        this.readRepairChance = cfm.readRepairChance;
        this.dcLocalReadRepairChance = cfm.dcLocalReadRepairChance;
        this.replicateOnWrite = cfm.replicateOnWrite;
        this.gcGraceSeconds = cfm.gcGraceSeconds;
        this.defaultValidator = cfm.defaultValidator;
        this.keyValidator = cfm.keyValidator;
        this.minCompactionThreshold = cfm.minCompactionThreshold;
        this.maxCompactionThreshold = cfm.maxCompactionThreshold;
        this.keyAlias = cfm.keyAlias;
        this.columnAliases = cfm.columnAliases;
        this.valueAlias = cfm.valueAlias;
        this.bloomFilterFpChance = cfm.bloomFilterFpChance;
        this.caching = cfm.caching;
        MapDifference columnDiff = Maps.difference(this.column_metadata, cfm.column_metadata);
        for (ColumnDefinition cd : columnDiff.entriesOnlyOnLeft().values()) {
            this.column_metadata.remove(cd.name);
        }
        for (ColumnDefinition cd : columnDiff.entriesOnlyOnRight().values()) {
            this.column_metadata.put(cd.name, cd);
        }
        for (ByteBuffer name : columnDiff.entriesDiffering().keySet()) {
            ColumnDefinition oldDef = this.column_metadata.get(name);
            ColumnDefinition def = cfm.column_metadata.get(name);
            oldDef.apply(def, this.getColumnDefinitionComparator());
        }
        this.compactionStrategyClass = cfm.compactionStrategyClass;
        this.compactionStrategyOptions = cfm.compactionStrategyOptions;
        this.compressionParameters = cfm.compressionParameters();
        this.updateCfDef();
        logger.debug("application result is {}", (Object)this);
    }

    public static Class<? extends AbstractCompactionStrategy> createCompactionStrategy(String className) throws ConfigurationException {
        className = className.contains(".") ? className : "org.apache.cassandra.db.compaction." + className;
        return FBUtilities.classForName(className, "compaction strategy");
    }

    public AbstractCompactionStrategy createCompactionStrategyInstance(ColumnFamilyStore cfs) {
        try {
            Constructor<? extends AbstractCompactionStrategy> constructor = this.compactionStrategyClass.getConstructor(ColumnFamilyStore.class, Map.class);
            return constructor.newInstance(cfs, this.compactionStrategyOptions);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
        catch (InstantiationException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    public CfDef toThrift() {
        CfDef def = new CfDef(this.ksName, this.cfName);
        def.setId(this.cfId.intValue());
        def.setColumn_type(this.cfType.name());
        def.setComparator_type(this.comparator.toString());
        if (this.subcolumnComparator != null) {
            assert (this.cfType == ColumnFamilyType.Super) : String.format("%s CF %s should not have subcomparator %s defined", new Object[]{this.cfType, this.cfName, this.subcolumnComparator});
            def.setSubcomparator_type(this.subcolumnComparator.toString());
        }
        def.setComment(CFMetaData.enforceCommentNotNull(this.comment));
        def.setRead_repair_chance(this.readRepairChance);
        def.setDclocal_read_repair_chance(this.dcLocalReadRepairChance);
        def.setReplicate_on_write(this.replicateOnWrite);
        def.setGc_grace_seconds(this.gcGraceSeconds);
        def.setDefault_validation_class(this.defaultValidator == null ? null : this.defaultValidator.toString());
        def.setKey_validation_class(this.keyValidator.toString());
        def.setMin_compaction_threshold(this.minCompactionThreshold);
        def.setMax_compaction_threshold(this.maxCompactionThreshold);
        def.setKey_alias(this.keyAlias);
        ArrayList<ColumnDef> column_meta = new ArrayList<ColumnDef>(this.column_metadata.size());
        for (ColumnDefinition cd : this.column_metadata.values()) {
            ColumnDef tcd = new ColumnDef();
            tcd.setIndex_name(cd.getIndexName());
            tcd.setIndex_type(cd.getIndexType());
            tcd.setIndex_options(cd.getIndexOptions());
            tcd.setName(cd.name);
            tcd.setValidation_class(cd.getValidator().toString());
            column_meta.add(tcd);
        }
        def.setColumn_metadata(column_meta);
        def.setCompaction_strategy(this.compactionStrategyClass.getName());
        def.setCompaction_strategy_options(new HashMap<String, String>(this.compactionStrategyOptions));
        def.setCompression_options(this.compressionParameters.asThriftOptions());
        if (this.bloomFilterFpChance != null) {
            def.setBloom_filter_fp_chance(this.bloomFilterFpChance.doubleValue());
        }
        def.setCaching(this.caching.toString());
        return def;
    }

    public ColumnDefinition getColumnDefinition(ByteBuffer name) {
        return this.column_metadata.get(name);
    }

    public ColumnDefinition getColumnDefinitionForIndex(String indexName) {
        for (ColumnDefinition def : this.column_metadata.values()) {
            if (!indexName.equals(def.getIndexName())) continue;
            return def;
        }
        return null;
    }

    public static void addDefaultIndexNames(CfDef cf_def) throws InvalidRequestException {
        if (cf_def.column_metadata == null) {
            return;
        }
        try {
            AbstractType<?> comparator = TypeParser.parse(cf_def.comparator_type);
            for (ColumnDef column : cf_def.column_metadata) {
                if (column.index_type == null || column.index_name != null) continue;
                column.index_name = CFMetaData.getDefaultIndexName(cf_def.name, comparator, column.name);
            }
        }
        catch (ConfigurationException e) {
            throw new InvalidRequestException(e.getMessage());
        }
    }

    public static String getDefaultIndexName(String cfName, AbstractType<?> comparator, ByteBuffer columnName) {
        return (cfName + "_" + comparator.getString(columnName) + "_idx").replaceAll("\\W", "");
    }

    public IColumnSerializer getColumnSerializer() {
        if (this.cfType == ColumnFamilyType.Standard) {
            return Column.serializer();
        }
        return SuperColumn.serializer(this.subcolumnComparator);
    }

    public CFMetaData validate() throws ConfigurationException {
        if (this.comparator instanceof CounterColumnType) {
            throw new ConfigurationException("CounterColumnType is not a valid comparator");
        }
        if (this.subcolumnComparator instanceof CounterColumnType) {
            throw new ConfigurationException("CounterColumnType is not a valid sub-column comparator");
        }
        if (this.keyValidator instanceof CounterColumnType) {
            throw new ConfigurationException("CounterColumnType is not a valid key validator");
        }
        if (this.defaultValidator instanceof CounterColumnType) {
            for (ColumnDefinition def : this.column_metadata.values()) {
                if (def.getValidator() instanceof CounterColumnType) continue;
                throw new ConfigurationException("Cannot add a non counter column (" + this.comparator.getString(def.name) + ") in a counter column family");
            }
        } else {
            for (ColumnDefinition def : this.column_metadata.values()) {
                if (!(def.getValidator() instanceof CounterColumnType)) continue;
                throw new ConfigurationException("Cannot add a counter column (" + this.comparator.getString(def.name) + ") in a non counter column family");
            }
        }
        return this;
    }

    public RowMutation toSchemaUpdate(CFMetaData newState, long modificationTimestamp) {
        RowMutation rm = new RowMutation("system", SystemTable.getSchemaKSKey(this.ksName));
        newState.toSchemaNoColumns(rm, modificationTimestamp);
        MapDifference columnDiff = Maps.difference(this.column_metadata, newState.column_metadata);
        for (ColumnDefinition cd : columnDiff.entriesOnlyOnLeft().values()) {
            cd.deleteFromSchema(rm, this.cfName, this.getColumnDefinitionComparator(), modificationTimestamp);
        }
        for (ColumnDefinition cd : columnDiff.entriesOnlyOnRight().values()) {
            cd.toSchema(rm, this.cfName, this.getColumnDefinitionComparator(), modificationTimestamp);
        }
        for (ByteBuffer name : columnDiff.entriesDiffering().keySet()) {
            ColumnDefinition cd = newState.getColumnDefinition(name);
            cd.toSchema(rm, this.cfName, this.getColumnDefinitionComparator(), modificationTimestamp);
        }
        return rm;
    }

    public RowMutation dropFromSchema(long timestamp) {
        RowMutation rm = new RowMutation("system", SystemTable.getSchemaKSKey(this.ksName));
        ColumnFamily cf = rm.addOrGet("schema_columnfamilies");
        int ldt = (int)(System.currentTimeMillis() / 1000L);
        cf.addColumn(DeletedColumn.create(ldt, timestamp, this.cfName, "id"));
        cf.addColumn(DeletedColumn.create(ldt, timestamp, this.cfName, "type"));
        cf.addColumn(DeletedColumn.create(ldt, timestamp, this.cfName, "comparator"));
        cf.addColumn(DeletedColumn.create(ldt, timestamp, this.cfName, "subcomparator"));
        cf.addColumn(DeletedColumn.create(ldt, timestamp, this.cfName, "comment"));
        cf.addColumn(DeletedColumn.create(ldt, timestamp, this.cfName, "read_repair_chance"));
        cf.addColumn(DeletedColumn.create(ldt, timestamp, this.cfName, "local_read_repair_chance"));
        cf.addColumn(DeletedColumn.create(ldt, timestamp, this.cfName, "replicate_on_write"));
        cf.addColumn(DeletedColumn.create(ldt, timestamp, this.cfName, "gc_grace_seconds"));
        cf.addColumn(DeletedColumn.create(ldt, timestamp, this.cfName, "default_validator"));
        cf.addColumn(DeletedColumn.create(ldt, timestamp, this.cfName, "key_validator"));
        cf.addColumn(DeletedColumn.create(ldt, timestamp, this.cfName, "min_compaction_threshold"));
        cf.addColumn(DeletedColumn.create(ldt, timestamp, this.cfName, "max_compaction_threshold"));
        cf.addColumn(DeletedColumn.create(ldt, timestamp, this.cfName, "key_alias"));
        cf.addColumn(DeletedColumn.create(ldt, timestamp, this.cfName, "bloom_filter_fp_chance"));
        cf.addColumn(DeletedColumn.create(ldt, timestamp, this.cfName, "caching"));
        cf.addColumn(DeletedColumn.create(ldt, timestamp, this.cfName, "compaction_strategy_class"));
        cf.addColumn(DeletedColumn.create(ldt, timestamp, this.cfName, "compression_parameters"));
        cf.addColumn(DeletedColumn.create(ldt, timestamp, this.cfName, "value_alias"));
        cf.addColumn(DeletedColumn.create(ldt, timestamp, this.cfName, "column_aliases"));
        cf.addColumn(DeletedColumn.create(ldt, timestamp, this.cfName, "compaction_strategy_options"));
        for (ColumnDefinition cd : this.column_metadata.values()) {
            cd.deleteFromSchema(rm, this.cfName, this.getColumnDefinitionComparator(), timestamp);
        }
        return rm;
    }

    public void toSchema(RowMutation rm, long timestamp) {
        this.toSchemaNoColumns(rm, timestamp);
        for (ColumnDefinition cd : this.column_metadata.values()) {
            cd.toSchema(rm, this.cfName, this.getColumnDefinitionComparator(), timestamp);
        }
    }

    private void toSchemaNoColumns(RowMutation rm, long timestamp) {
        ColumnFamily cf = rm.addOrGet("schema_columnfamilies");
        int ldt = (int)(System.currentTimeMillis() / 1000L);
        cf.addColumn(Column.create(this.cfId, timestamp, this.cfName, "id"));
        cf.addColumn(Column.create(this.cfType.toString(), timestamp, this.cfName, "type"));
        cf.addColumn(Column.create(this.comparator.toString(), timestamp, this.cfName, "comparator"));
        if (this.subcolumnComparator != null) {
            cf.addColumn(Column.create(this.subcolumnComparator.toString(), timestamp, this.cfName, "subcomparator"));
        }
        cf.addColumn(this.comment == null ? DeletedColumn.create(ldt, timestamp, this.cfName, "comment") : Column.create(this.comment, timestamp, this.cfName, "comment"));
        cf.addColumn(Column.create(this.readRepairChance, timestamp, this.cfName, "read_repair_chance"));
        cf.addColumn(Column.create(this.dcLocalReadRepairChance, timestamp, this.cfName, "local_read_repair_chance"));
        cf.addColumn(Column.create(this.replicateOnWrite, timestamp, this.cfName, "replicate_on_write"));
        cf.addColumn(Column.create(this.gcGraceSeconds, timestamp, this.cfName, "gc_grace_seconds"));
        cf.addColumn(Column.create(this.defaultValidator.toString(), timestamp, this.cfName, "default_validator"));
        cf.addColumn(Column.create(this.keyValidator.toString(), timestamp, this.cfName, "key_validator"));
        cf.addColumn(Column.create(this.minCompactionThreshold, timestamp, this.cfName, "min_compaction_threshold"));
        cf.addColumn(Column.create(this.maxCompactionThreshold, timestamp, this.cfName, "max_compaction_threshold"));
        cf.addColumn(this.keyAlias == null ? DeletedColumn.create(ldt, timestamp, this.cfName, "key_alias") : Column.create(this.keyAlias, timestamp, this.cfName, "key_alias"));
        cf.addColumn(this.bloomFilterFpChance == null ? DeletedColumn.create(ldt, timestamp, this.cfName, "bloomFilterFpChance") : Column.create(this.bloomFilterFpChance, timestamp, this.cfName, "bloom_filter_fp_chance"));
        cf.addColumn(Column.create(this.caching.toString(), timestamp, this.cfName, "caching"));
        cf.addColumn(Column.create(this.compactionStrategyClass.getName(), timestamp, this.cfName, "compaction_strategy_class"));
        cf.addColumn(Column.create(FBUtilities.json(this.compressionParameters.asThriftOptions()), timestamp, this.cfName, "compression_parameters"));
        cf.addColumn(this.valueAlias == null ? DeletedColumn.create(ldt, timestamp, this.cfName, "value_alias") : Column.create(this.valueAlias, timestamp, this.cfName, "value_alias"));
        cf.addColumn(Column.create(FBUtilities.json(this.columnAliasesAsStrings()), timestamp, this.cfName, "column_aliases"));
        cf.addColumn(Column.create(FBUtilities.json(this.compactionStrategyOptions), timestamp, this.cfName, "compaction_strategy_options"));
    }

    static CFMetaData fromSchemaNoColumns(UntypedResultSet.Row result) {
        try {
            CFMetaData cfm = new CFMetaData(result.getString("keyspace"), result.getString("columnfamily"), ColumnFamilyType.valueOf(result.getString("type")), TypeParser.parse(result.getString("comparator")), result.has("subcomparator") ? TypeParser.parse(result.getString("subcomparator")) : null, result.getInt("id"));
            cfm.readRepairChance(result.getDouble("read_repair_chance"));
            cfm.dcLocalReadRepairChance(result.getDouble("local_read_repair_chance"));
            cfm.replicateOnWrite(result.getBoolean("replicate_on_write"));
            cfm.gcGraceSeconds(result.getInt("gc_grace_seconds"));
            cfm.defaultValidator(TypeParser.parse(result.getString("default_validator")));
            cfm.keyValidator(TypeParser.parse(result.getString("key_validator")));
            cfm.minCompactionThreshold(result.getInt("min_compaction_threshold"));
            cfm.maxCompactionThreshold(result.getInt("max_compaction_threshold"));
            if (result.has("comment")) {
                cfm.comment(result.getString("comment"));
            }
            if (result.has("key_alias")) {
                cfm.keyAlias(result.getBytes("key_alias"));
            }
            if (result.has("bloom_filter_fp_chance")) {
                cfm.bloomFilterFpChance(result.getDouble("bloom_filter_fp_chance"));
            }
            cfm.caching(Caching.valueOf(result.getString("caching")));
            cfm.compactionStrategyClass(CFMetaData.createCompactionStrategy(result.getString("compaction_strategy_class")));
            cfm.compressionParameters(CompressionParameters.create(FBUtilities.fromJsonMap(result.getString("compression_parameters"))));
            if (result.has("value_alias")) {
                cfm.valueAlias(result.getBytes("value_alias"));
            }
            cfm.columnAliases(CFMetaData.columnAliasesFromStrings(FBUtilities.fromJsonList(result.getString("column_aliases"))));
            cfm.compactionStrategyOptions(FBUtilities.fromJsonMap(result.getString("compaction_strategy_options")));
            return cfm;
        }
        catch (ConfigurationException e) {
            throw new RuntimeException(e);
        }
    }

    public static CFMetaData fromSchema(UntypedResultSet.Row result) {
        CFMetaData cfDef = CFMetaData.fromSchemaNoColumns(result);
        Row serializedColumnDefinitions = ColumnDefinition.readSchema(cfDef.ksName, cfDef.cfName);
        return CFMetaData.addColumnDefinitionSchema(cfDef, serializedColumnDefinitions).updateCfDef();
    }

    private static CFMetaData fromSchema(Row row) {
        UntypedResultSet.Row result = QueryProcessor.resultify("SELECT * FROM system.schema_columnfamilies", row).one();
        return CFMetaData.fromSchema(result);
    }

    private List<String> columnAliasesAsStrings() {
        ArrayList<String> aliases = new ArrayList<String>(this.columnAliases.size());
        for (ByteBuffer rawAlias : this.columnAliases) {
            aliases.add(UTF8Type.instance.compose(rawAlias));
        }
        return aliases;
    }

    private static List<ByteBuffer> columnAliasesFromStrings(List<String> aliases) {
        ArrayList<ByteBuffer> rawAliases = new ArrayList<ByteBuffer>(aliases.size());
        for (String alias : aliases) {
            rawAliases.add(UTF8Type.instance.decompose(alias));
        }
        return rawAliases;
    }

    public RowMutation toSchema(long timestamp) throws ConfigurationException {
        RowMutation rm = new RowMutation("system", SystemTable.getSchemaKSKey(this.ksName));
        this.toSchema(rm, timestamp);
        return rm;
    }

    public static AbstractType<?> getColumnDefinitionComparator(CfDef cfDef) throws ConfigurationException {
        AbstractType<?> cfComparator = TypeParser.parse(cfDef.column_type.equals("Super") ? cfDef.subcomparator_type : cfDef.comparator_type);
        if (cfComparator instanceof CompositeType) {
            List<AbstractType<?>> types = ((CompositeType)cfComparator).types;
            return types.get(types.size() - 1);
        }
        return cfComparator;
    }

    public AbstractType<?> getColumnDefinitionComparator() {
        AbstractType<?> cfComparator;
        AbstractType<?> abstractType = cfComparator = this.cfType == ColumnFamilyType.Super ? this.subcolumnComparator : this.comparator;
        if (cfComparator instanceof CompositeType) {
            List<AbstractType<?>> types = ((CompositeType)cfComparator).types;
            return types.get(types.size() - 1);
        }
        return cfComparator;
    }

    static CFMetaData addColumnDefinitionSchema(CFMetaData cfDef, Row serializedColumnDefinitions) {
        for (ColumnDefinition cd : ColumnDefinition.fromSchema(serializedColumnDefinitions, cfDef.getColumnDefinitionComparator())) {
            cfDef.column_metadata.put(cd.name, cd);
        }
        return cfDef;
    }

    public void addColumnDefinition(ColumnDefinition def) {
        this.column_metadata.put(def.name, def);
    }

    public boolean removeColumnDefinition(ColumnDefinition def) {
        return this.column_metadata.remove(def.name) != null;
    }

    private CFMetaData updateCfDef() {
        this.cqlCfDef = new CFDefinition(this);
        return this;
    }

    public CFDefinition getCfDef() {
        assert (this.cqlCfDef != null);
        return this.cqlCfDef;
    }

    public static boolean isNameValid(String name) {
        return name.matches("\\w+");
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("cfId", (Object)this.cfId).append("ksName", (Object)this.ksName).append("cfName", (Object)this.cfName).append("cfType", (Object)this.cfType).append("comparator", this.comparator).append("subcolumncomparator", this.subcolumnComparator).append("comment", (Object)this.comment).append("readRepairChance", this.readRepairChance).append("dclocalReadRepairChance", this.dcLocalReadRepairChance).append("replicateOnWrite", this.replicateOnWrite).append("gcGraceSeconds", this.gcGraceSeconds).append("defaultValidator", this.defaultValidator).append("keyValidator", this.keyValidator).append("minCompactionThreshold", this.minCompactionThreshold).append("maxCompactionThreshold", this.maxCompactionThreshold).append("keyAlias", (Object)this.keyAlias).append("columnAliases", this.columnAliases).append("valueAlias", (Object)this.valueAlias).append("column_metadata", this.column_metadata).append("compactionStrategyClass", this.compactionStrategyClass).append("compactionStrategyOptions", this.compactionStrategyOptions).append("compressionOptions", this.compressionParameters.asThriftOptions()).append("bloomFilterFpChance", (Object)this.bloomFilterFpChance).append("caching", (Object)this.caching).toString();
    }

    static {
        SchemaKeyspacesCf.columnMetadata(ColumnDefinition.utf8("name"), ColumnDefinition.bool("durable_writes"), ColumnDefinition.ascii("strategy_class"), ColumnDefinition.ascii("strategy_options"));
        SchemaColumnFamiliesCf = CFMetaData.newSchemaMetadata("schema_columnfamilies", 9, "ColumnFamily definitions", CompositeType.getInstance(Arrays.asList(AsciiType.instance, AsciiType.instance)), null).keyValidator(AsciiType.instance).keyAlias("keyspace").columnAliases(Arrays.asList(ByteBufferUtil.bytes("columnfamily"))).columnMetadata(ColumnDefinition.int32("id"), ColumnDefinition.ascii("type"), ColumnDefinition.ascii("comparator"), ColumnDefinition.ascii("subcomparator"), ColumnDefinition.utf8("comment"), ColumnDefinition.double_("read_repair_chance"), ColumnDefinition.double_("local_read_repair_chance"), ColumnDefinition.bool("replicate_on_write"), ColumnDefinition.int32("gc_grace_seconds"), ColumnDefinition.ascii("default_validator"), ColumnDefinition.ascii("key_validator"), ColumnDefinition.int32("min_compaction_threshold"), ColumnDefinition.int32("max_compaction_threshold"), ColumnDefinition.ascii("key_alias"), ColumnDefinition.double_("bloom_filter_fp_chance"), ColumnDefinition.ascii("caching"), ColumnDefinition.ascii("compaction_strategy_class"), ColumnDefinition.ascii("compression_parameters"), ColumnDefinition.utf8("value_alias"), ColumnDefinition.utf8("column_aliases"), ColumnDefinition.ascii("compaction_strategy_options"));
        SchemaColumnsCf = CFMetaData.newSchemaMetadata("schema_columns", 10, "ColumnFamily column attributes", CompositeType.getInstance(Arrays.asList(AsciiType.instance, AsciiType.instance, UTF8Type.instance)), null).keyValidator(AsciiType.instance).keyAlias("keyspace").columnAliases(Arrays.asList(ByteBufferUtil.bytes("columnfamily"), ByteBufferUtil.bytes("column"))).columnMetadata(ColumnDefinition.ascii("validator"), ColumnDefinition.ascii("index_type"), ColumnDefinition.ascii("index_options"), ColumnDefinition.ascii("index_name"));
    }

    public static enum Caching {
        ALL,
        KEYS_ONLY,
        ROWS_ONLY,
        NONE;


        public static Caching fromString(String cache) throws ConfigurationException {
            try {
                return Caching.valueOf(cache.toUpperCase());
            }
            catch (IllegalArgumentException e) {
                throw new ConfigurationException(String.format("%s not found, available types: %s.", cache, StringUtils.join((Object[])Caching.values(), (String)", ")));
            }
        }
    }
}

