/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.net;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.net.InetAddress;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.cassandra.io.IVersionedSerializer;
import org.apache.cassandra.net.CompactEndpointSerializationHelper;
import org.apache.cassandra.net.HeaderSerializer;
import org.apache.cassandra.service.StorageService;
import org.apache.cassandra.utils.FBUtilities;

public class Header {
    private static IVersionedSerializer<Header> serializer_ = new HeaderSerializer();
    private final InetAddress from_;
    private final StorageService.Verb verb_;
    protected final Map<String, byte[]> details_;

    static IVersionedSerializer<Header> serializer() {
        return serializer_;
    }

    Header(InetAddress from, StorageService.Verb verb) {
        this(from, verb, Collections.emptyMap());
    }

    Header(InetAddress from, StorageService.Verb verb, Map<String, byte[]> details) {
        assert (from != null);
        assert (verb != null);
        this.from_ = from;
        this.verb_ = verb;
        this.details_ = ImmutableMap.copyOf(details);
    }

    InetAddress getFrom() {
        return this.from_;
    }

    StorageService.Verb getVerb() {
        return this.verb_;
    }

    byte[] getDetail(String key) {
        return this.details_.get(key);
    }

    Header withDetailsAdded(String key, byte[] value) {
        HashMap detailsCopy = Maps.newHashMap(this.details_);
        detailsCopy.put(key, value);
        return new Header(this.from_, this.verb_, detailsCopy);
    }

    Header withDetailsRemoved(String key) {
        if (!this.details_.containsKey(key)) {
            return this;
        }
        HashMap detailsCopy = Maps.newHashMap(this.details_);
        detailsCopy.remove(key);
        return new Header(this.from_, this.verb_, detailsCopy);
    }

    public int serializedSize() {
        int size = 0;
        size += CompactEndpointSerializationHelper.serializedSize(this.getFrom());
        size += 4;
        size += 4;
        for (String key : this.details_.keySet()) {
            size += 2 + FBUtilities.encodedUTF8Length(key);
            byte[] value = this.details_.get(key);
            size += 4 + value.length;
        }
        return size;
    }
}

