/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.cassandra.db.RangeSliceCommand;
import org.apache.cassandra.dht.AbstractBounds;
import org.apache.cassandra.io.IVersionedSerializer;
import org.apache.cassandra.thrift.SlicePredicate;
import org.apache.cassandra.thrift.TBinaryProtocol;
import org.apache.cassandra.utils.ByteBufferUtil;
import org.apache.cassandra.utils.FBUtilities;
import org.apache.thrift.TBase;
import org.apache.thrift.TDeserializer;
import org.apache.thrift.TSerializer;
import org.apache.thrift.protocol.TProtocolFactory;

class RangeSliceCommandSerializer
implements IVersionedSerializer<RangeSliceCommand> {
    RangeSliceCommandSerializer() {
    }

    @Override
    public void serialize(RangeSliceCommand sliceCommand, DataOutput dos, int version) throws IOException {
        dos.writeUTF(sliceCommand.keyspace);
        dos.writeUTF(sliceCommand.column_family);
        ByteBuffer sc = sliceCommand.super_column;
        dos.writeInt(sc == null ? 0 : sc.remaining());
        if (sc != null) {
            ByteBufferUtil.write(sc, dos);
        }
        TSerializer ser = new TSerializer((TProtocolFactory)new TBinaryProtocol.Factory());
        FBUtilities.serialize(ser, (TBase)sliceCommand.predicate, dos);
        AbstractBounds.serializer().serialize(sliceCommand.range, dos);
        dos.writeInt(sliceCommand.max_keys);
    }

    @Override
    public RangeSliceCommand deserialize(DataInput dis, int version) throws IOException {
        String keyspace = dis.readUTF();
        String column_family = dis.readUTF();
        int scLength = dis.readInt();
        ByteBuffer super_column = null;
        if (scLength > 0) {
            byte[] buf = new byte[scLength];
            dis.readFully(buf);
            super_column = ByteBuffer.wrap(buf);
        }
        TDeserializer dser = new TDeserializer((TProtocolFactory)new TBinaryProtocol.Factory());
        SlicePredicate pred = new SlicePredicate();
        FBUtilities.deserialize(dser, (TBase)pred, dis);
        AbstractBounds range = AbstractBounds.serializer().deserialize(dis);
        int max_keys = dis.readInt();
        return new RangeSliceCommand(keyspace, column_family, super_column, pred, range, max_keys);
    }

    @Override
    public long serializedSize(RangeSliceCommand rangeSliceCommand, int version) {
        throw new UnsupportedOperationException();
    }
}

