/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cql;

import java.nio.charset.CharacterCodingException;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.cql.QueryProcessor;
import org.apache.cassandra.cql.Relation;
import org.apache.cassandra.cql.RelationType;
import org.apache.cassandra.cql.Term;
import org.apache.cassandra.utils.ByteBufferUtil;

public class WhereClause {
    private List<Relation> clauseRelations = new ArrayList<Relation>();
    private List<Relation> columns = new ArrayList<Relation>();
    private Set<Term> keys = new LinkedHashSet<Term>();
    private Term startKey;
    private Term finishKey;
    private boolean includeStartKey = false;
    private boolean includeFinishKey = false;
    private boolean multiKey = false;
    private String keyAlias = null;

    public WhereClause(Relation firstRelation) {
        this.and(firstRelation);
    }

    public WhereClause() {
    }

    public void and(Relation relation) {
        this.clauseRelations.add(relation);
    }

    public void andKeyEquals(Term key) {
        this.keys.add(key);
    }

    public List<Relation> getColumnRelations() {
        return this.columns;
    }

    public boolean isKeyRange() {
        return this.startKey != null;
    }

    public Term getStartKey() {
        return this.startKey;
    }

    public Term getFinishKey() {
        return this.finishKey;
    }

    public Set<Term> getKeys() {
        return this.keys;
    }

    public boolean includeStartKey() {
        return this.includeStartKey;
    }

    public boolean includeFinishKey() {
        return this.includeFinishKey;
    }

    public void setKeyAlias(String alias) {
        this.keyAlias = alias.toUpperCase();
    }

    public boolean isMultiKey() {
        return this.multiKey;
    }

    public void setMultiKey(boolean multiKey) {
        this.multiKey = multiKey;
    }

    public String getKeyAlias() {
        return this.keyAlias == null ? QueryProcessor.DEFAULT_KEY_NAME : this.keyAlias;
    }

    public void extractKeysFromColumns(CFMetaData cfm) {
        String realKeyAlias = null;
        try {
            realKeyAlias = ByteBufferUtil.string(cfm.getKeyName()).toUpperCase();
        }
        catch (CharacterCodingException e) {
            throw new RuntimeException(e);
        }
        if (!this.keys.isEmpty()) {
            return;
        }
        for (Relation relation : this.clauseRelations) {
            String name = relation.getEntity().getText().toUpperCase();
            if (name.equals(realKeyAlias) || name.equals("KEY")) {
                if (this.keyAlias == null) {
                    this.keyAlias = name;
                }
                if (relation.operator() == RelationType.EQ) {
                    this.keys.add(relation.getValue());
                    continue;
                }
                if (relation.operator() == RelationType.GT || relation.operator() == RelationType.GTE) {
                    this.startKey = relation.getValue();
                    this.includeStartKey = relation.operator() == RelationType.GTE;
                    continue;
                }
                if (relation.operator() != RelationType.LT && relation.operator() != RelationType.LTE) continue;
                this.finishKey = relation.getValue();
                this.includeFinishKey = relation.operator() == RelationType.LTE;
                continue;
            }
            this.columns.add(relation);
        }
    }
}

