/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cql;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.charset.CharacterCodingException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeoutException;
import org.antlr.runtime.ANTLRStringStream;
import org.antlr.runtime.CharStream;
import org.antlr.runtime.CommonTokenStream;
import org.antlr.runtime.RecognitionException;
import org.antlr.runtime.TokenSource;
import org.antlr.runtime.TokenStream;
import org.apache.cassandra.auth.Permission;
import org.apache.cassandra.cli.CliUtils;
import org.apache.cassandra.concurrent.Stage;
import org.apache.cassandra.concurrent.StageManager;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.config.ColumnDefinition;
import org.apache.cassandra.config.ConfigurationException;
import org.apache.cassandra.config.KSMetaData;
import org.apache.cassandra.config.Schema;
import org.apache.cassandra.cql.AbstractModification;
import org.apache.cassandra.cql.AlterTableStatement;
import org.apache.cassandra.cql.BatchStatement;
import org.apache.cassandra.cql.CQLStatement;
import org.apache.cassandra.cql.CqlLexer;
import org.apache.cassandra.cql.CqlParser;
import org.apache.cassandra.cql.CreateColumnFamilyStatement;
import org.apache.cassandra.cql.CreateIndexStatement;
import org.apache.cassandra.cql.CreateKeyspaceStatement;
import org.apache.cassandra.cql.DeleteStatement;
import org.apache.cassandra.cql.DropIndexStatement;
import org.apache.cassandra.cql.Relation;
import org.apache.cassandra.cql.RelationType;
import org.apache.cassandra.cql.SelectStatement;
import org.apache.cassandra.cql.StatementType;
import org.apache.cassandra.cql.Term;
import org.apache.cassandra.cql.UpdateStatement;
import org.apache.cassandra.db.CounterColumn;
import org.apache.cassandra.db.IColumn;
import org.apache.cassandra.db.IMutation;
import org.apache.cassandra.db.RangeSliceCommand;
import org.apache.cassandra.db.ReadCommand;
import org.apache.cassandra.db.Row;
import org.apache.cassandra.db.SliceByNamesReadCommand;
import org.apache.cassandra.db.SliceFromReadCommand;
import org.apache.cassandra.db.Table;
import org.apache.cassandra.db.context.CounterContext;
import org.apache.cassandra.db.filter.QueryPath;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.db.marshal.AsciiType;
import org.apache.cassandra.db.marshal.MarshalException;
import org.apache.cassandra.db.marshal.TypeParser;
import org.apache.cassandra.db.migration.AddColumnFamily;
import org.apache.cassandra.db.migration.AddKeyspace;
import org.apache.cassandra.db.migration.DropColumnFamily;
import org.apache.cassandra.db.migration.DropKeyspace;
import org.apache.cassandra.db.migration.Migration;
import org.apache.cassandra.db.migration.UpdateColumnFamily;
import org.apache.cassandra.db.migration.avro.CfDef;
import org.apache.cassandra.dht.Bounds;
import org.apache.cassandra.dht.IPartitioner;
import org.apache.cassandra.dht.RandomPartitioner;
import org.apache.cassandra.dht.Token;
import org.apache.cassandra.service.ClientState;
import org.apache.cassandra.service.StorageProxy;
import org.apache.cassandra.service.StorageService;
import org.apache.cassandra.thrift.Column;
import org.apache.cassandra.thrift.ColumnDef;
import org.apache.cassandra.thrift.ConsistencyLevel;
import org.apache.cassandra.thrift.CqlMetadata;
import org.apache.cassandra.thrift.CqlResult;
import org.apache.cassandra.thrift.CqlResultType;
import org.apache.cassandra.thrift.CqlRow;
import org.apache.cassandra.thrift.IndexClause;
import org.apache.cassandra.thrift.IndexExpression;
import org.apache.cassandra.thrift.IndexOperator;
import org.apache.cassandra.thrift.IndexType;
import org.apache.cassandra.thrift.InvalidRequestException;
import org.apache.cassandra.thrift.KsDef;
import org.apache.cassandra.thrift.SchemaDisagreementException;
import org.apache.cassandra.thrift.SlicePredicate;
import org.apache.cassandra.thrift.SliceRange;
import org.apache.cassandra.thrift.ThriftValidation;
import org.apache.cassandra.thrift.TimedOutException;
import org.apache.cassandra.thrift.UnavailableException;
import org.apache.cassandra.utils.ByteBufferUtil;
import org.apache.cassandra.utils.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueryProcessor {
    public static final String CQL_VERSION = "2.0.0";
    private static final Logger logger = LoggerFactory.getLogger(QueryProcessor.class);
    private static final long timeLimitForSchemaAgreement = 10000L;
    public static final String DEFAULT_KEY_NAME = QueryProcessor.bufferToString(CFMetaData.DEFAULT_KEY_NAME);

    private static List<Row> getSlice(CFMetaData metadata, SelectStatement select) throws InvalidRequestException, TimedOutException, UnavailableException {
        QueryPath queryPath = new QueryPath(select.getColumnFamily());
        ArrayList<ReadCommand> commands = new ArrayList<ReadCommand>();
        if (!select.isColumnRange()) {
            List<ByteBuffer> columnNames = QueryProcessor.getColumnNames(select, metadata);
            QueryProcessor.validateColumnNames(columnNames);
            for (Term rawKey : select.getKeys()) {
                ByteBuffer key = rawKey.getByteBuffer(metadata.getKeyValidator());
                QueryProcessor.validateKey(key);
                commands.add(new SliceByNamesReadCommand(metadata.ksName, key, queryPath, columnNames));
            }
        } else {
            AbstractType comparator = select.getComparator(metadata.ksName);
            ByteBuffer start = select.getColumnStart().getByteBuffer(comparator);
            ByteBuffer finish = select.getColumnFinish().getByteBuffer(comparator);
            for (Term rawKey : select.getKeys()) {
                ByteBuffer key = rawKey.getByteBuffer(metadata.getKeyValidator());
                QueryProcessor.validateKey(key);
                QueryProcessor.validateSliceRange(metadata, start, finish, select.isColumnsReversed());
                commands.add(new SliceFromReadCommand(metadata.ksName, key, queryPath, start, finish, select.isColumnsReversed(), select.getColumnsLimit()));
            }
        }
        try {
            return StorageProxy.read(commands, select.getConsistencyLevel());
        }
        catch (TimeoutException e) {
            throw new TimedOutException();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static List<ByteBuffer> getColumnNames(SelectStatement select, CFMetaData metadata) throws InvalidRequestException {
        String keyString = QueryProcessor.getKeyString(metadata);
        ArrayList<ByteBuffer> columnNames = new ArrayList<ByteBuffer>();
        for (Term column : select.getColumnNames()) {
            if (column.getText().equalsIgnoreCase(keyString)) continue;
            columnNames.add(column.getByteBuffer(metadata.comparator));
        }
        return columnNames;
    }

    private static List<Row> multiRangeSlice(CFMetaData metadata, SelectStatement select) throws TimedOutException, UnavailableException, InvalidRequestException {
        List<Row> rows;
        Object finishToken;
        IPartitioner p = StorageService.getPartitioner();
        AbstractType keyType = Schema.instance.getCFMetaData(metadata.ksName, select.getColumnFamily()).getKeyValidator();
        ByteBuffer startKey = select.getKeyStart() != null ? select.getKeyStart().getByteBuffer(keyType) : new Term().getByteBuffer();
        ByteBuffer finishKey = select.getKeyFinish() != null ? select.getKeyFinish().getByteBuffer(keyType) : new Term().getByteBuffer();
        Object startToken = p.getToken(startKey);
        if (((Token)startToken).compareTo(finishToken = p.getToken(finishKey)) > 0 && !((Token)finishToken).equals(p.getMinimumToken())) {
            if (p instanceof RandomPartitioner) {
                throw new InvalidRequestException("Start key's md5 sorts after end key's md5. This is not allowed; you probably should not specify end key at all, under RandomPartitioner");
            }
            throw new InvalidRequestException("Start key must sort before (or equal to) finish key in your partitioner!");
        }
        Bounds bounds = new Bounds((Token)startToken, (Token)finishToken);
        SlicePredicate thriftSlicePredicate = QueryProcessor.slicePredicateFromSelect(select, metadata);
        QueryProcessor.validateSlicePredicate(metadata, thriftSlicePredicate);
        int limit = select.isKeyRange() && select.getKeyStart() != null ? select.getNumRecords() + 1 : select.getNumRecords();
        try {
            rows = StorageProxy.getRangeSlice(new RangeSliceCommand(metadata.ksName, select.getColumnFamily(), null, thriftSlicePredicate, bounds, limit), select.getConsistencyLevel());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        catch (UnavailableException e) {
            throw new UnavailableException();
        }
        catch (TimeoutException e) {
            throw new TimedOutException();
        }
        if (select.getKeyStart() != null && !select.includeStartKey() && !rows.isEmpty() && rows.get((int)0).key.key.equals(startKey)) {
            rows.remove(0);
        }
        if (select.getKeyFinish() != null && !select.includeFinishKey() && !rows.isEmpty()) {
            int lastIndex = rows.size() - 1;
            if (rows.get((int)lastIndex).key.key.equals(finishKey)) {
                rows.remove(lastIndex);
            }
        }
        return rows.subList(0, select.getNumRecords() < rows.size() ? select.getNumRecords() : rows.size());
    }

    private static List<Row> getIndexedSlices(CFMetaData metadata, SelectStatement select) throws TimedOutException, UnavailableException, InvalidRequestException {
        List<Row> rows;
        SlicePredicate thriftSlicePredicate = QueryProcessor.slicePredicateFromSelect(select, metadata);
        QueryProcessor.validateSlicePredicate(metadata, thriftSlicePredicate);
        ArrayList<IndexExpression> expressions = new ArrayList<IndexExpression>();
        for (Relation columnRelation : select.getColumnRelations()) {
            ByteBuffer entity = columnRelation.getEntity().getByteBuffer(metadata.comparator);
            ByteBuffer value = columnRelation.getValue().getByteBuffer(select.getValueValidator(metadata.ksName, entity));
            expressions.add(new IndexExpression(entity, IndexOperator.valueOf((String)columnRelation.operator().toString()), value));
        }
        AbstractType keyType = Schema.instance.getCFMetaData(metadata.ksName, select.getColumnFamily()).getKeyValidator();
        ByteBuffer startKey = !select.isKeyRange() ? new Term().getByteBuffer() : select.getKeyStart().getByteBuffer(keyType);
        IndexClause thriftIndexClause = new IndexClause(expressions, startKey, select.getNumRecords());
        try {
            rows = StorageProxy.scan(metadata.ksName, select.getColumnFamily(), thriftIndexClause, thriftSlicePredicate, select.getConsistencyLevel());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        catch (TimeoutException e) {
            throw new TimedOutException();
        }
        return rows;
    }

    private static void batchUpdate(ClientState clientState, List<UpdateStatement> updateStatements, ConsistencyLevel consistency) throws InvalidRequestException, UnavailableException, TimedOutException {
        String globalKeyspace = clientState.getKeyspace();
        ArrayList<IMutation> rowMutations = new ArrayList<IMutation>();
        ArrayList<String> cfamsSeen = new ArrayList<String>();
        for (UpdateStatement update : updateStatements) {
            String keyspace;
            String string = keyspace = update.keyspace == null ? globalKeyspace : update.keyspace;
            if (!cfamsSeen.contains(update.getColumnFamily())) {
                clientState.hasColumnFamilyAccess(keyspace, update.getColumnFamily(), Permission.WRITE);
                cfamsSeen.add(update.getColumnFamily());
            }
            rowMutations.addAll(update.prepareRowMutations(keyspace, clientState));
        }
        for (IMutation mutation : rowMutations) {
            QueryProcessor.validateKey(mutation.key());
        }
        try {
            StorageProxy.mutate(rowMutations, consistency);
        }
        catch (UnavailableException e) {
            throw new UnavailableException();
        }
        catch (TimeoutException e) {
            throw new TimedOutException();
        }
    }

    private static SlicePredicate slicePredicateFromSelect(SelectStatement select, CFMetaData metadata) throws InvalidRequestException {
        SlicePredicate thriftSlicePredicate = new SlicePredicate();
        if (select.isColumnRange() || select.getColumnNames().size() == 0) {
            SliceRange sliceRange = new SliceRange();
            sliceRange.start = select.getColumnStart().getByteBuffer(metadata.comparator);
            sliceRange.finish = select.getColumnFinish().getByteBuffer(metadata.comparator);
            sliceRange.reversed = select.isColumnsReversed();
            sliceRange.count = select.getColumnsLimit();
            thriftSlicePredicate.slice_range = sliceRange;
        } else {
            thriftSlicePredicate.column_names = QueryProcessor.getColumnNames(select, metadata);
        }
        return thriftSlicePredicate;
    }

    private static void validateSelect(String keyspace, SelectStatement select) throws InvalidRequestException {
        if (!select.isKeyRange() && select.getKeyFinish() != null) {
            throw new InvalidRequestException("Key range clauses must include a start key (i.e. KEY > term)");
        }
        if (select.isKeyRange() && select.getKeys().size() > 0) {
            throw new InvalidRequestException("You cannot combine key range and by-key clauses in a SELECT");
        }
        if (select.isKeyRange() && select.getKeyFinish() != null && select.getColumnRelations().size() > 0) {
            throw new InvalidRequestException("You cannot combine key range and by-column clauses in a SELECT");
        }
        if (!select.isMultiKey() && select.getKeys().size() > 1) {
            throw new InvalidRequestException("You cannot use more than one KEY = in a SELECT");
        }
        if (select.getColumnRelations().size() > 0) {
            AbstractType comparator = select.getComparator(keyspace);
            SortedSet<ByteBuffer> indexed = Table.open((String)keyspace).getColumnFamilyStore((String)select.getColumnFamily()).indexManager.getIndexedColumns();
            for (Relation relation : select.getColumnRelations()) {
                if (relation.operator() != RelationType.EQ || !indexed.contains(relation.getEntity().getByteBuffer(comparator))) continue;
                return;
            }
            throw new InvalidRequestException("No indexed columns present in by-columns clause with \"equals\" operator");
        }
    }

    private static void applyMigrationOnStage(final Migration m) throws SchemaDisagreementException, InvalidRequestException {
        Future<Object> f = StageManager.getStage(Stage.MIGRATION).submit(new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                m.apply();
                m.announce();
                return null;
            }
        });
        try {
            f.get();
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        catch (ExecutionException e) {
            if (e.getCause() != null) {
                InvalidRequestException ex = new InvalidRequestException(e.getCause().getMessage());
                ex.initCause(e.getCause());
                throw ex;
            }
            InvalidRequestException ex = new InvalidRequestException(e.getMessage());
            ex.initCause((Throwable)e);
            throw ex;
        }
        QueryProcessor.validateSchemaIsSettled();
    }

    public static void validateKey(ByteBuffer key) throws InvalidRequestException {
        if (key == null || key.remaining() == 0) {
            throw new InvalidRequestException("Key may not be empty");
        }
        if (key.remaining() > 65535) {
            throw new InvalidRequestException("Key length of " + key.remaining() + " is longer than maximum of " + 65535);
        }
    }

    public static void validateKeyAlias(CFMetaData cfm, String key) throws InvalidRequestException {
        assert (key.toUpperCase().equals(key));
        String realKeyAlias = QueryProcessor.bufferToString(cfm.getKeyName()).toUpperCase();
        if (!realKeyAlias.equals(key)) {
            throw new InvalidRequestException(String.format("Expected key '%s' to be present in WHERE clause for '%s'", realKeyAlias, cfm.cfName));
        }
    }

    private static void validateColumnNames(Iterable<ByteBuffer> columns) throws InvalidRequestException {
        for (ByteBuffer name : columns) {
            if (name.remaining() > 65535) {
                throw new InvalidRequestException(String.format("column name is too long (%s > %s)", name.remaining(), 65535));
            }
            if (name.remaining() != 0) continue;
            throw new InvalidRequestException("zero-length column name");
        }
    }

    public static void validateColumnName(ByteBuffer column) throws InvalidRequestException {
        QueryProcessor.validateColumnNames(Arrays.asList(column));
    }

    public static void validateColumn(CFMetaData metadata, ByteBuffer name, ByteBuffer value) throws InvalidRequestException {
        QueryProcessor.validateColumnName(name);
        AbstractType validator = metadata.getValueValidator(name);
        try {
            if (validator != null) {
                validator.validate(value);
            }
        }
        catch (MarshalException me) {
            throw new InvalidRequestException(String.format("Invalid column value for column (name=%s); %s", ByteBufferUtil.bytesToHex(name), me.getMessage()));
        }
    }

    private static void validateSlicePredicate(CFMetaData metadata, SlicePredicate predicate) throws InvalidRequestException {
        if (predicate.slice_range != null) {
            QueryProcessor.validateSliceRange(metadata, predicate.slice_range);
        } else {
            QueryProcessor.validateColumnNames(predicate.column_names);
        }
    }

    private static void validateSliceRange(CFMetaData metadata, SliceRange range) throws InvalidRequestException {
        QueryProcessor.validateSliceRange(metadata, range.start, range.finish, range.reversed);
    }

    private static void validateSliceRange(CFMetaData metadata, ByteBuffer start, ByteBuffer finish, boolean reversed) throws InvalidRequestException {
        Comparator<ByteBuffer> orderedComparator;
        AbstractType comparator = metadata.getComparatorFor(null);
        Comparator<ByteBuffer> comparator2 = orderedComparator = reversed ? comparator.reverseComparator : comparator;
        if (start.remaining() > 0 && finish.remaining() > 0 && orderedComparator.compare(start, finish) > 0) {
            throw new InvalidRequestException("range finish must come after start in traversal order");
        }
    }

    private static void validateSchemaAgreement() throws SchemaDisagreementException {
        if (QueryProcessor.describeSchemaVersions().size() > 1) {
            throw new SchemaDisagreementException();
        }
    }

    private static Map<String, List<String>> describeSchemaVersions() {
        return Maps.filterKeys(StorageProxy.describeSchemaVersions(), (Predicate)Predicates.not((Predicate)Predicates.equalTo((Object)"UNREACHABLE")));
    }

    public static CqlResult process(String queryString, ClientState clientState) throws RecognitionException, UnavailableException, InvalidRequestException, TimedOutException, SchemaDisagreementException {
        logger.trace("CQL QUERY: {}", (Object)queryString);
        CQLStatement statement = QueryProcessor.getStatement(queryString);
        return QueryProcessor.process(statement, clientState);
    }

    public static CqlResult process(CQLStatement statement, ClientState clientState) throws RecognitionException, UnavailableException, InvalidRequestException, TimedOutException, SchemaDisagreementException {
        String keyspace = null;
        if (statement.type != StatementType.SELECT && StatementType.requiresKeyspace.contains((Object)statement.type)) {
            keyspace = clientState.getKeyspace();
        }
        CqlResult result = new CqlResult();
        logger.debug("CQL statement type: {}", (Object)statement.type.toString());
        switch (statement.type) {
            case SELECT: {
                SelectStatement select = (SelectStatement)statement.statement;
                String oldKeyspace = clientState.getRawKeyspace();
                if (select.isSetKeyspace()) {
                    keyspace = CliUtils.unescapeSQLString(select.getKeyspace());
                    ThriftValidation.validateTable(keyspace);
                } else {
                    if (oldKeyspace == null) {
                        throw new InvalidRequestException("no keyspace has been specified");
                    }
                    keyspace = oldKeyspace;
                }
                clientState.hasColumnFamilyAccess(keyspace, select.getColumnFamily(), Permission.READ);
                CFMetaData metadata = ThriftValidation.validateColumnFamily(keyspace, select.getColumnFamily());
                select.extractKeyAliasFromColumns(metadata);
                if (select.getKeys().size() > 0) {
                    QueryProcessor.validateKeyAlias(metadata, select.getKeyAlias());
                }
                QueryProcessor.validateSelect(keyspace, select);
                List<Row> rows = !select.isKeyRange() && select.getKeys().size() > 0 ? QueryProcessor.getSlice(metadata, select) : (select.getKeyFinish() != null || select.getColumnRelations().size() == 0 ? QueryProcessor.multiRangeSlice(metadata, select) : QueryProcessor.getIndexedSlices(metadata, select));
                result.type = CqlResultType.ROWS;
                if (select.isCountOperation()) {
                    QueryProcessor.validateCountOperation(select);
                    ByteBuffer countBytes = ByteBufferUtil.bytes("count");
                    result.schema = new CqlMetadata(Collections.emptyMap(), Collections.emptyMap(), "AsciiType", "LongType");
                    List<Column> columns = Collections.singletonList(new Column(countBytes).setValue(ByteBufferUtil.bytes((long)rows.size())));
                    result.rows = Collections.singletonList(new CqlRow(countBytes, columns));
                    return result;
                }
                result.schema = new CqlMetadata(new HashMap(), new HashMap(), TypeParser.getShortName(metadata.comparator), TypeParser.getShortName(metadata.getDefaultValidator()));
                ArrayList<CqlRow> cqlRows = new ArrayList<CqlRow>();
                for (Row row : rows) {
                    ArrayList<Column> thriftColumns = new ArrayList<Column>();
                    if (select.isColumnRange()) {
                        if (select.isWildcard()) {
                            thriftColumns.add(new Column(metadata.getKeyName()).setValue(row.key.key).setTimestamp(-1L));
                            result.schema.name_types.put(metadata.getKeyName(), TypeParser.getShortName(AsciiType.instance));
                            result.schema.value_types.put(metadata.getKeyName(), TypeParser.getShortName(metadata.getKeyValidator()));
                        }
                        if (row.cf != null) {
                            for (IColumn c : row.cf.getSortedColumns()) {
                                if (c.isMarkedForDelete()) continue;
                                ColumnDefinition cd = metadata.getColumnDefinition(c.name());
                                if (cd != null) {
                                    result.schema.value_types.put(c.name(), TypeParser.getShortName(cd.getValidator()));
                                }
                                thriftColumns.add(QueryProcessor.thriftify(c));
                            }
                        }
                    } else {
                        String keyString = QueryProcessor.getKeyString(metadata);
                        for (Term term : select.getColumnNames()) {
                            IColumn c;
                            ByteBuffer name;
                            if (term.getText().equalsIgnoreCase(keyString)) {
                                ByteBuffer requestedKey = ByteBufferUtil.bytes(term.getText());
                                thriftColumns.add(new Column(requestedKey).setValue(row.key.key).setTimestamp(-1L));
                                result.schema.name_types.put(requestedKey, TypeParser.getShortName(AsciiType.instance));
                                result.schema.value_types.put(requestedKey, TypeParser.getShortName(metadata.getKeyValidator()));
                                continue;
                            }
                            if (row.cf == null) continue;
                            try {
                                name = term.getByteBuffer(metadata.comparator);
                            }
                            catch (InvalidRequestException e) {
                                throw new AssertionError((Object)e);
                            }
                            ColumnDefinition cd = metadata.getColumnDefinition(name);
                            if (cd != null) {
                                result.schema.value_types.put(name, TypeParser.getShortName(cd.getValidator()));
                            }
                            if ((c = row.cf.getColumn(name)) == null || c.isMarkedForDelete()) {
                                thriftColumns.add(new Column().setName(name));
                                continue;
                            }
                            thriftColumns.add(QueryProcessor.thriftify(c));
                        }
                    }
                    CqlRow cqlRow = new CqlRow();
                    cqlRow.key = row.key.key;
                    cqlRow.columns = thriftColumns;
                    if (select.isColumnsReversed()) {
                        Collections.reverse(cqlRow.columns);
                    }
                    cqlRows.add(cqlRow);
                }
                result.rows = cqlRows;
                return result;
            }
            case INSERT: 
            case UPDATE: {
                UpdateStatement update = (UpdateStatement)statement.statement;
                QueryProcessor.batchUpdate(clientState, Collections.singletonList(update), update.getConsistencyLevel());
                result.type = CqlResultType.VOID;
                return result;
            }
            case BATCH: {
                BatchStatement batch = (BatchStatement)statement.statement;
                if (batch.getTimeToLive() != 0) {
                    throw new InvalidRequestException("Global TTL on the BATCH statement is not supported.");
                }
                for (AbstractModification up : batch.getStatements()) {
                    if (up.isSetConsistencyLevel()) {
                        throw new InvalidRequestException("Consistency level must be set on the BATCH, not individual statements");
                    }
                    if (!batch.isSetTimestamp() || !up.isSetTimestamp()) continue;
                    throw new InvalidRequestException("Timestamp must be set either on BATCH or individual statements");
                }
                List<IMutation> mutations = batch.getMutations(keyspace, clientState);
                for (IMutation mutation : mutations) {
                    QueryProcessor.validateKey(mutation.key());
                }
                try {
                    StorageProxy.mutate(mutations, batch.getConsistencyLevel());
                }
                catch (UnavailableException e) {
                    throw new UnavailableException();
                }
                catch (TimeoutException e) {
                    throw new TimedOutException();
                }
                result.type = CqlResultType.VOID;
                return result;
            }
            case USE: {
                clientState.setKeyspace(CliUtils.unescapeSQLString((String)statement.statement));
                result.type = CqlResultType.VOID;
                return result;
            }
            case TRUNCATE: {
                Pair columnFamily = (Pair)statement.statement;
                keyspace = columnFamily.left == null ? clientState.getKeyspace() : (String)columnFamily.left;
                ThriftValidation.validateColumnFamily(keyspace, (String)columnFamily.right);
                clientState.hasColumnFamilyAccess(keyspace, (String)columnFamily.right, Permission.WRITE);
                try {
                    StorageProxy.truncateBlocking(keyspace, (String)columnFamily.right);
                }
                catch (TimeoutException e) {
                    throw (UnavailableException)new UnavailableException().initCause((Throwable)e);
                }
                catch (IOException e) {
                    throw (UnavailableException)new UnavailableException().initCause((Throwable)e);
                }
                result.type = CqlResultType.VOID;
                return result;
            }
            case DELETE: {
                DeleteStatement delete = (DeleteStatement)statement.statement;
                keyspace = delete.keyspace == null ? clientState.getKeyspace() : delete.keyspace;
                List<IMutation> deletions = delete.prepareRowMutations(keyspace, clientState);
                for (IMutation deletion : deletions) {
                    QueryProcessor.validateKey(deletion.key());
                }
                try {
                    StorageProxy.mutate(deletions, delete.getConsistencyLevel());
                }
                catch (TimeoutException e) {
                    throw new TimedOutException();
                }
                result.type = CqlResultType.VOID;
                return result;
            }
            case CREATE_KEYSPACE: {
                CreateKeyspaceStatement create = (CreateKeyspaceStatement)statement.statement;
                create.validate();
                ThriftValidation.validateKeyspaceNotSystem(create.getName());
                clientState.hasKeyspaceSchemaAccess(Permission.WRITE);
                QueryProcessor.validateSchemaAgreement();
                try {
                    KsDef ksd = new KsDef(create.getName(), create.getStrategyClass(), Collections.emptyList()).setStrategy_options(create.getStrategyOptions());
                    ThriftValidation.validateKsDef(ksd);
                    ThriftValidation.validateKeyspaceNotYetExisting(create.getName());
                    QueryProcessor.applyMigrationOnStage(new AddKeyspace(KSMetaData.fromThrift(ksd, new CFMetaData[0])));
                }
                catch (ConfigurationException e) {
                    InvalidRequestException ex = new InvalidRequestException(e.getMessage());
                    ex.initCause((Throwable)e);
                    throw ex;
                }
                catch (IOException e) {
                    InvalidRequestException ex = new InvalidRequestException(e.getMessage());
                    ex.initCause((Throwable)e);
                    throw ex;
                }
                result.type = CqlResultType.VOID;
                return result;
            }
            case CREATE_COLUMNFAMILY: {
                CreateColumnFamilyStatement createCf = (CreateColumnFamilyStatement)statement.statement;
                clientState.hasColumnFamilySchemaAccess(Permission.WRITE);
                QueryProcessor.validateSchemaAgreement();
                CFMetaData cfmd = createCf.getCFMetaData(keyspace);
                ThriftValidation.validateCfDef(cfmd.toThrift(), null);
                try {
                    QueryProcessor.applyMigrationOnStage(new AddColumnFamily(cfmd));
                }
                catch (ConfigurationException e) {
                    InvalidRequestException ex = new InvalidRequestException(e.toString());
                    ex.initCause((Throwable)e);
                    throw ex;
                }
                catch (IOException e) {
                    InvalidRequestException ex = new InvalidRequestException(e.toString());
                    ex.initCause((Throwable)e);
                    throw ex;
                }
                result.type = CqlResultType.VOID;
                return result;
            }
            case CREATE_INDEX: {
                InvalidRequestException ex;
                CreateIndexStatement createIdx = (CreateIndexStatement)statement.statement;
                clientState.hasColumnFamilySchemaAccess(Permission.WRITE);
                QueryProcessor.validateSchemaAgreement();
                CFMetaData oldCfm = Schema.instance.getCFMetaData(keyspace, createIdx.getColumnFamily());
                if (oldCfm == null) {
                    throw new InvalidRequestException("No such column family: " + createIdx.getColumnFamily());
                }
                boolean columnExists = false;
                ByteBuffer columnName = createIdx.getColumnName().getByteBuffer();
                org.apache.cassandra.thrift.CfDef cf_def = oldCfm.toThrift();
                for (ColumnDef cd : cf_def.column_metadata) {
                    if (!cd.name.equals(columnName)) continue;
                    if (cd.index_type != null) {
                        throw new InvalidRequestException("Index already exists");
                    }
                    logger.debug("Updating column {} definition for index {}", (Object)oldCfm.comparator.getString(columnName), (Object)createIdx.getIndexName());
                    cd.setIndex_type(IndexType.KEYS);
                    cd.setIndex_name(createIdx.getIndexName());
                    columnExists = true;
                    break;
                }
                if (!columnExists) {
                    throw new InvalidRequestException("No column definition found for column " + oldCfm.comparator.getString(columnName));
                }
                CFMetaData.addDefaultIndexNames(cf_def);
                ThriftValidation.validateCfDef(cf_def, oldCfm);
                try {
                    CfDef result1;
                    try {
                        result1 = CFMetaData.fromThrift(cf_def).toAvro();
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                    QueryProcessor.applyMigrationOnStage(new UpdateColumnFamily(result1));
                }
                catch (ConfigurationException e) {
                    ex = new InvalidRequestException(e.toString());
                    ex.initCause((Throwable)e);
                    throw ex;
                }
                catch (IOException e) {
                    ex = new InvalidRequestException(e.toString());
                    ex.initCause((Throwable)e);
                    throw ex;
                }
                result.type = CqlResultType.VOID;
                return result;
            }
            case DROP_INDEX: {
                DropIndexStatement dropIdx = (DropIndexStatement)statement.statement;
                clientState.hasColumnFamilySchemaAccess(Permission.WRITE);
                QueryProcessor.validateSchemaAgreement();
                try {
                    QueryProcessor.applyMigrationOnStage(dropIdx.generateMutation(clientState.getKeyspace()));
                }
                catch (ConfigurationException e) {
                    InvalidRequestException ex = new InvalidRequestException(e.toString());
                    ex.initCause((Throwable)e);
                    throw ex;
                }
                catch (IOException e) {
                    InvalidRequestException ex = new InvalidRequestException(e.toString());
                    ex.initCause((Throwable)e);
                    throw ex;
                }
                result.type = CqlResultType.VOID;
                return result;
            }
            case DROP_KEYSPACE: {
                String deleteKeyspace = (String)statement.statement;
                ThriftValidation.validateKeyspaceNotSystem(deleteKeyspace);
                clientState.hasKeyspaceSchemaAccess(Permission.WRITE);
                QueryProcessor.validateSchemaAgreement();
                try {
                    QueryProcessor.applyMigrationOnStage(new DropKeyspace(deleteKeyspace));
                }
                catch (ConfigurationException e) {
                    InvalidRequestException ex = new InvalidRequestException(e.getMessage());
                    ex.initCause((Throwable)e);
                    throw ex;
                }
                catch (IOException e) {
                    InvalidRequestException ex = new InvalidRequestException(e.getMessage());
                    ex.initCause((Throwable)e);
                    throw ex;
                }
                result.type = CqlResultType.VOID;
                return result;
            }
            case DROP_COLUMNFAMILY: {
                String deleteColumnFamily = (String)statement.statement;
                clientState.hasColumnFamilySchemaAccess(Permission.WRITE);
                QueryProcessor.validateSchemaAgreement();
                try {
                    QueryProcessor.applyMigrationOnStage(new DropColumnFamily(keyspace, deleteColumnFamily));
                }
                catch (ConfigurationException e) {
                    InvalidRequestException ex = new InvalidRequestException(e.getMessage());
                    ex.initCause((Throwable)e);
                    throw ex;
                }
                catch (IOException e) {
                    InvalidRequestException ex = new InvalidRequestException(e.getMessage());
                    ex.initCause((Throwable)e);
                    throw ex;
                }
                result.type = CqlResultType.VOID;
                return result;
            }
            case ALTER_TABLE: {
                AlterTableStatement alterTable = (AlterTableStatement)statement.statement;
                ThriftValidation.validateColumnFamily(keyspace, alterTable.columnFamily);
                clientState.hasColumnFamilyAccess(alterTable.columnFamily, Permission.WRITE);
                QueryProcessor.validateSchemaAgreement();
                try {
                    QueryProcessor.applyMigrationOnStage(new UpdateColumnFamily(alterTable.getCfDef(keyspace)));
                }
                catch (ConfigurationException e) {
                    InvalidRequestException ex = new InvalidRequestException(e.getMessage());
                    ex.initCause((Throwable)e);
                    throw ex;
                }
                catch (IOException e) {
                    InvalidRequestException ex = new InvalidRequestException(e.getMessage());
                    ex.initCause((Throwable)e);
                    throw ex;
                }
                result.type = CqlResultType.VOID;
                return result;
            }
        }
        return null;
    }

    private static Column thriftify(IColumn c) {
        ByteBuffer value = c instanceof CounterColumn ? ByteBufferUtil.bytes(CounterContext.instance().total(c.value())) : c.value();
        return new Column(c.name()).setValue(value).setTimestamp(c.timestamp());
    }

    private static String getKeyString(CFMetaData metadata) {
        String keyString;
        try {
            keyString = ByteBufferUtil.string(metadata.getKeyName());
        }
        catch (CharacterCodingException e) {
            throw new AssertionError((Object)e);
        }
        return keyString;
    }

    private static CQLStatement getStatement(String queryStr) throws InvalidRequestException, RecognitionException {
        ANTLRStringStream stream = new ANTLRStringStream(queryStr);
        CqlLexer lexer = new CqlLexer((CharStream)stream);
        CommonTokenStream tokenStream = new CommonTokenStream((TokenSource)lexer);
        CqlParser parser = new CqlParser((TokenStream)tokenStream);
        CQLStatement statement = parser.query();
        lexer.throwLastRecognitionError();
        parser.throwLastRecognitionError();
        return statement;
    }

    private static void validateSchemaIsSettled() throws SchemaDisagreementException {
        long limit = System.currentTimeMillis() + 10000L;
        block0: while (limit - System.currentTimeMillis() >= 0L) {
            String currentVersionId = Schema.instance.getVersion().toString();
            for (String version : QueryProcessor.describeSchemaVersions().keySet()) {
                if (version.equals(currentVersionId)) continue;
                continue block0;
            }
            return;
        }
        throw new SchemaDisagreementException();
    }

    private static void validateCountOperation(SelectStatement select) throws InvalidRequestException {
        if (select.isWildcard()) {
            return;
        }
        if (!select.isColumnRange()) {
            List<Term> columnNames = select.getColumnNames();
            String firstColumn = columnNames.get(0).getText();
            if (columnNames.size() == 1 && (firstColumn.equals("*") || firstColumn.equals("1"))) {
                return;
            }
        }
        throw new InvalidRequestException("Only COUNT(*) and COUNT(1) operations are currently supported.");
    }

    private static String bufferToString(ByteBuffer string) {
        try {
            return ByteBufferUtil.string(string);
        }
        catch (CharacterCodingException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }
}

