/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.config;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import java.io.IOError;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.config.ConfigurationException;
import org.apache.cassandra.config.KSMetaData;
import org.apache.cassandra.db.ColumnFamilyType;
import org.apache.cassandra.db.Table;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.db.migration.Migration;
import org.apache.cassandra.io.sstable.Descriptor;
import org.apache.cassandra.utils.Pair;
import org.cliffc.high_scale_lib.NonBlockingHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Schema {
    private static final Logger logger = LoggerFactory.getLogger(Schema.class);
    public static final UUID INITIAL_VERSION = new UUID(4096L, 0L);
    public static final Schema instance = new Schema(INITIAL_VERSION);
    private static final int MIN_CF_ID = 1000;
    private final AtomicInteger cfIdGen = new AtomicInteger(1000);
    private final Map<String, KSMetaData> tables = new NonBlockingHashMap();
    private final Map<String, Table> tableInstances = new NonBlockingHashMap();
    private final BiMap<Pair<String, String>, Integer> cfIdMap = HashBiMap.create();
    private volatile UUID version;

    public Schema(UUID initialVersion) {
        this.version = initialVersion;
    }

    public Schema load(Collection<KSMetaData> tableDefs, UUID version) {
        for (KSMetaData def : tableDefs) {
            if (!Migration.isLegalName(def.name)) {
                throw new RuntimeException("invalid keyspace name: " + def.name);
            }
            for (CFMetaData cfm : def.cfMetaData().values()) {
                if (!Migration.isLegalName(cfm.cfName)) {
                    throw new RuntimeException("invalid column family name: " + cfm.cfName);
                }
                try {
                    this.load(cfm);
                }
                catch (ConfigurationException ex) {
                    throw new IOError(ex);
                }
            }
            this.setTableDefinition(def, version);
        }
        this.setVersion(version);
        return this;
    }

    public Table getTableInstance(String tableName) {
        return this.tableInstances.get(tableName);
    }

    public void storeTableInstance(Table table) {
        if (this.tableInstances.containsKey(table.name)) {
            throw new IllegalArgumentException(String.format("Table %s was already initialized.", table.name));
        }
        this.tableInstances.put(table.name, table);
    }

    public Table removeTableInstance(String tableName) {
        return this.tableInstances.remove(tableName);
    }

    public void clearTableDefinition(KSMetaData ksm, UUID newVersion) {
        this.tables.remove(ksm.name);
        this.version = newVersion;
    }

    public CFMetaData getCFMetaData(String tableName, String cfName) {
        assert (tableName != null);
        KSMetaData ksm = this.tables.get(tableName);
        return ksm == null ? null : ksm.cfMetaData().get(cfName);
    }

    public CFMetaData getCFMetaData(Integer cfId) {
        Pair<String, String> cf = this.getCF(cfId);
        return cf == null ? null : this.getCFMetaData((String)cf.left, (String)cf.right);
    }

    public CFMetaData getCFMetaData(Descriptor descriptor) {
        return this.getCFMetaData(descriptor.ksname, descriptor.cfname);
    }

    public ColumnFamilyType getColumnFamilyType(String ksName, String cfName) {
        assert (ksName != null && cfName != null);
        CFMetaData cfMetaData = this.getCFMetaData(ksName, cfName);
        return cfMetaData == null ? null : cfMetaData.cfType;
    }

    public AbstractType getComparator(String ksName, String cfName) {
        assert (ksName != null);
        CFMetaData cfmd = this.getCFMetaData(ksName, cfName);
        if (cfmd == null) {
            throw new IllegalArgumentException("Unknown ColumnFamily " + cfName + " in keyspace " + ksName);
        }
        return cfmd.comparator;
    }

    public AbstractType getSubComparator(String ksName, String cfName) {
        assert (ksName != null);
        return this.getCFMetaData((String)ksName, (String)cfName).subcolumnComparator;
    }

    public AbstractType getValueValidator(String ksName, String cfName, ByteBuffer column) {
        return this.getCFMetaData(ksName, cfName).getValueValidator(column);
    }

    public KSMetaData getKSMetaData(String table) {
        assert (table != null);
        return this.tables.get(table);
    }

    public List<String> getNonSystemTables() {
        ArrayList<String> tablesList = new ArrayList<String>(this.tables.keySet());
        tablesList.remove("system");
        return Collections.unmodifiableList(tablesList);
    }

    public KSMetaData getTableDefinition(String table) {
        return this.getKSMetaData(table);
    }

    public Map<String, CFMetaData> getTableMetaData(String tableName) {
        assert (tableName != null);
        KSMetaData ksm = this.tables.get(tableName);
        assert (ksm != null);
        return ksm.cfMetaData();
    }

    public Set<String> getTables() {
        return this.tables.keySet();
    }

    public Collection<KSMetaData> getTableDefinitions() {
        return this.tables.values();
    }

    public void setTableDefinition(KSMetaData ksm, UUID newVersion) {
        if (ksm != null) {
            this.tables.put(ksm.name, ksm);
        }
        this.version = newVersion;
    }

    public void addSystemTable(KSMetaData systemTable) {
        this.tables.put(systemTable.name, systemTable);
    }

    public Pair<String, String> getCF(Integer cfId) {
        return (Pair)this.cfIdMap.inverse().get((Object)cfId);
    }

    public Integer getId(String ksName, String cfName) {
        return (Integer)this.cfIdMap.get(new Pair<String, String>(ksName, cfName));
    }

    public void load(CFMetaData cfm) throws ConfigurationException {
        Pair<String, String> key = new Pair<String, String>(cfm.ksName, cfm.cfName);
        if (this.cfIdMap.containsKey(key)) {
            throw new ConfigurationException("Attempt to assign id to existing column family.");
        }
        logger.debug("Adding {} to cfIdMap", (Object)cfm);
        this.cfIdMap.put(key, (Object)cfm.cfId);
    }

    public void purge(CFMetaData cfm) {
        this.cfIdMap.remove(new Pair<String, String>(cfm.ksName, cfm.cfName));
    }

    public void fixCFMaxId() {
        this.cfIdGen.set(this.cfIdMap.size() == 0 ? 1000 : Math.max((Integer)Collections.max(this.cfIdMap.values()) + 1, 1000));
    }

    public int nextCFId() {
        return this.cfIdGen.getAndIncrement();
    }

    public UUID getVersion() {
        return this.version;
    }

    public void setVersion(UUID newVersion) {
        this.version = newVersion;
    }
}

