/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.compaction;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.cassandra.db.ColumnFamilyStore;
import org.apache.cassandra.db.compaction.AbstractCompactionStrategy;
import org.apache.cassandra.db.compaction.AbstractCompactionTask;
import org.apache.cassandra.db.compaction.CompactionTask;
import org.apache.cassandra.io.sstable.SSTable;
import org.apache.cassandra.io.sstable.SSTableReader;
import org.apache.cassandra.utils.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SizeTieredCompactionStrategy
extends AbstractCompactionStrategy {
    private static final Logger logger = LoggerFactory.getLogger(SizeTieredCompactionStrategy.class);
    protected static final long DEFAULT_MIN_SSTABLE_SIZE = 0x3200000L;
    protected static final String MIN_SSTABLE_SIZE_KEY = "min_sstable_size";
    protected static long minSSTableSize;
    protected volatile int estimatedRemainingTasks = 0;

    public SizeTieredCompactionStrategy(ColumnFamilyStore cfs, Map<String, String> options) {
        super(cfs, options);
        String optionValue = options.get(MIN_SSTABLE_SIZE_KEY);
        minSSTableSize = null != optionValue ? Long.parseLong(optionValue) : 0x3200000L;
        cfs.setMaximumCompactionThreshold(cfs.metadata.getMaxCompactionThreshold());
        cfs.setMinimumCompactionThreshold(cfs.metadata.getMinCompactionThreshold());
    }

    @Override
    public List<AbstractCompactionTask> getBackgroundTasks(int gcBefore) {
        if (this.cfs.isCompactionDisabled()) {
            logger.debug("Compaction is currently disabled.");
            return Collections.emptyList();
        }
        LinkedList<AbstractCompactionTask> tasks = new LinkedList<AbstractCompactionTask>();
        List buckets = SizeTieredCompactionStrategy.getBuckets(SizeTieredCompactionStrategy.createSSTableAndLengthPairs(this.cfs.getSSTables()), minSSTableSize);
        for (List bucket : buckets) {
            if (bucket.size() < this.cfs.getMinimumCompactionThreshold()) continue;
            Collections.sort(bucket, new Comparator<SSTableReader>(){

                @Override
                public int compare(SSTableReader o1, SSTableReader o2) {
                    return o1.descriptor.generation - o2.descriptor.generation;
                }
            });
            tasks.add(new CompactionTask(this.cfs, bucket.subList(0, Math.min(bucket.size(), this.cfs.getMaximumCompactionThreshold())), gcBefore));
        }
        this.updateEstimatedCompactionsByTasks(tasks);
        return tasks;
    }

    @Override
    public List<AbstractCompactionTask> getMaximalTasks(int gcBefore) {
        LinkedList<AbstractCompactionTask> tasks = new LinkedList<AbstractCompactionTask>();
        if (!this.cfs.getSSTables().isEmpty()) {
            tasks.add(new CompactionTask(this.cfs, this.cfs.getSSTables(), gcBefore));
        }
        return tasks;
    }

    @Override
    public AbstractCompactionTask getUserDefinedTask(Collection<SSTableReader> sstables, int gcBefore) {
        return new CompactionTask(this.cfs, sstables, gcBefore).isUserDefined(true).compactionFileLocation(this.cfs.table.getDataFileLocation(1L));
    }

    @Override
    public int getEstimatedRemainingTasks() {
        return this.estimatedRemainingTasks;
    }

    private static List<Pair<SSTableReader, Long>> createSSTableAndLengthPairs(Collection<SSTableReader> collection) {
        ArrayList<Pair<SSTableReader, Long>> tableLengthPairs = new ArrayList<Pair<SSTableReader, Long>>();
        for (SSTableReader table : collection) {
            tableLengthPairs.add(new Pair<SSTableReader, Long>(table, table.onDiskLength()));
        }
        return tableLengthPairs;
    }

    static <T> List<List<T>> getBuckets(Collection<Pair<T, Long>> files, long minSSTableSize) {
        ArrayList<Pair<T, Long>> sortedFiles = new ArrayList<Pair<T, Long>>(files);
        Collections.sort(sortedFiles, new Comparator<Pair<T, Long>>(){

            @Override
            public int compare(Pair<T, Long> p1, Pair<T, Long> p2) {
                return ((Long)p1.right).compareTo((Long)p2.right);
            }
        });
        HashMap<List, Long> buckets = new HashMap<List, Long>();
        for (Pair pair : sortedFiles) {
            long size = (Long)pair.right;
            boolean bFound = false;
            for (Map.Entry entry : buckets.entrySet()) {
                List bucket = (List)entry.getKey();
                long averageSize = (Long)entry.getValue();
                if ((size <= averageSize / 2L || size >= 3L * averageSize / 2L) && (size >= minSSTableSize || averageSize >= minSSTableSize)) continue;
                buckets.remove(bucket);
                long totalSize = (long)bucket.size() * averageSize;
                averageSize = (totalSize + size) / (long)(bucket.size() + 1);
                bucket.add(pair.left);
                buckets.put(bucket, averageSize);
                bFound = true;
                break;
            }
            if (bFound) continue;
            ArrayList bucket = new ArrayList();
            bucket.add(pair.left);
            buckets.put(bucket, size);
        }
        return new LinkedList<List<T>>(buckets.keySet());
    }

    private void updateEstimatedCompactionsByTasks(List<AbstractCompactionTask> tasks) {
        int n = 0;
        for (AbstractCompactionTask task : tasks) {
            Collection<SSTableReader> sstablesToBeCompacted;
            if (!(task instanceof CompactionTask) || (sstablesToBeCompacted = task.getSSTables()).size() < this.cfs.getMinimumCompactionThreshold()) continue;
            n = (int)((double)n + Math.ceil((double)sstablesToBeCompacted.size() / (double)this.cfs.getMaximumCompactionThreshold()));
        }
        this.estimatedRemainingTasks = n;
    }

    public long getMinSSTableSize() {
        return minSSTableSize;
    }

    @Override
    public long getMaxSSTableSize() {
        return Long.MAX_VALUE;
    }

    @Override
    public boolean isKeyExistenceExpensive(Set<? extends SSTable> sstablesToIgnore) {
        return this.cfs.getSSTables().size() - sstablesToIgnore.size() > 20;
    }

    public String toString() {
        return String.format("SizeTieredCompactionStrategy[%s/%s]", this.cfs.getMinimumCompactionThreshold(), this.cfs.getMaximumCompactionThreshold());
    }
}

