/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cql;

import com.google.common.collect.Sets;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.config.ColumnDefinition;
import org.apache.cassandra.config.ConfigurationException;
import org.apache.cassandra.cql.Term;
import org.apache.cassandra.db.ColumnFamilyType;
import org.apache.cassandra.db.compaction.AbstractCompactionStrategy;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.db.marshal.TypeParser;
import org.apache.cassandra.io.compress.CompressionParameters;
import org.apache.cassandra.thrift.InvalidRequestException;
import org.apache.cassandra.utils.ByteBufferUtil;
import org.apache.cassandra.utils.FBUtilities;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CreateColumnFamilyStatement {
    private static Logger logger = LoggerFactory.getLogger(CreateColumnFamilyStatement.class);
    private static final String KW_COMPARATOR = "comparator";
    private static final String KW_COMMENT = "comment";
    private static final String KW_ROWCACHESIZE = "row_cache_size";
    private static final String KW_KEYCACHESIZE = "key_cache_size";
    private static final String KW_READREPAIRCHANCE = "read_repair_chance";
    private static final String KW_GCGRACESECONDS = "gc_grace_seconds";
    private static final String KW_DEFAULTVALIDATION = "default_validation";
    private static final String KW_MINCOMPACTIONTHRESHOLD = "min_compaction_threshold";
    private static final String KW_MAXCOMPACTIONTHRESHOLD = "max_compaction_threshold";
    private static final String KW_ROWCACHESAVEPERIODSECS = "row_cache_save_period_in_seconds";
    private static final String KW_KEYCACHESAVEPERIODSECS = "key_cache_save_period_in_seconds";
    private static final String KW_REPLICATEONWRITE = "replicate_on_write";
    private static final String KW_ROW_CACHE_PROVIDER = "row_cache_provider";
    private static final String KW_COMPACTION_STRATEGY_CLASS = "compaction_strategy_class";
    public static final Map<String, String> comparators = new HashMap<String, String>();
    private static final Set<String> keywords = new HashSet<String>();
    private static final Set<String> obsoleteKeywords = new HashSet<String>();
    private static final String COMPACTION_OPTIONS_PREFIX = "compaction_strategy_options";
    private static final String COMPRESSION_PARAMETERS_PREFIX = "compression_parameters";
    private final String name;
    private final Map<Term, String> columns = new HashMap<Term, String>();
    private final Map<String, String> properties = new HashMap<String, String>();
    private List<String> keyValidator = new ArrayList<String>();
    private ByteBuffer keyAlias = null;
    private Class<? extends AbstractCompactionStrategy> compactionStrategyClass;
    private final Map<String, String> compactionStrategyOptions = new HashMap<String, String>();
    private final Map<String, String> compressionParameters = new HashMap<String, String>();

    public CreateColumnFamilyStatement(String name) {
        this.name = name;
    }

    private void validate() throws InvalidRequestException {
        AbstractType<?> comparator;
        String compStrategy = this.getPropertyString(KW_COMPACTION_STRATEGY_CLASS, "SizeTieredCompactionStrategy");
        try {
            this.compactionStrategyClass = CFMetaData.createCompactionStrategy(compStrategy);
        }
        catch (ConfigurationException e) {
            throw new InvalidRequestException(e.getMessage());
        }
        HashSet<String> propsToRemove = new HashSet<String>();
        for (String property : this.properties.keySet()) {
            if (!property.contains(":")) continue;
            String key = property.split(":")[1];
            String val = this.properties.get(property);
            if (property.startsWith(COMPACTION_OPTIONS_PREFIX)) {
                this.compactionStrategyOptions.put(key, val);
                propsToRemove.add(property);
            }
            if (!property.startsWith(COMPRESSION_PARAMETERS_PREFIX)) continue;
            this.compressionParameters.put(key, val);
            propsToRemove.add(property);
        }
        for (String property : propsToRemove) {
            this.properties.remove(property);
        }
        if (!this.name.matches("\\w+")) {
            throw new InvalidRequestException(String.format("\"%s\" is not a valid column family name", this.name));
        }
        Iterator<String> i$ = Sets.difference(this.properties.keySet(), (Set)Sets.union(keywords, obsoleteKeywords)).iterator();
        if (i$.hasNext()) {
            String bogus = i$.next();
            throw new InvalidRequestException(bogus + " is not a valid keyword argument for CREATE COLUMNFAMILY");
        }
        for (String obsolete : Sets.intersection(this.properties.keySet(), obsoleteKeywords)) {
            logger.warn("Ignoring obsolete property {}", (Object)obsolete);
        }
        Integer minCompaction = this.getPropertyInt(KW_MINCOMPACTIONTHRESHOLD, null);
        Integer maxCompaction = this.getPropertyInt(KW_MAXCOMPACTIONTHRESHOLD, null);
        if (minCompaction != null && maxCompaction != null) {
            if (minCompaction > maxCompaction && maxCompaction != 0) {
                throw new InvalidRequestException(String.format("%s cannot be larger than %s", KW_MINCOMPACTIONTHRESHOLD, KW_MAXCOMPACTIONTHRESHOLD));
            }
        } else if (minCompaction != null) {
            if (minCompaction > 32) {
                throw new InvalidRequestException(String.format("%s cannot be larger than %s, (default %s)", KW_MINCOMPACTIONTHRESHOLD, KW_MAXCOMPACTIONTHRESHOLD, 32));
            }
        } else if (maxCompaction != null && maxCompaction < 4 && maxCompaction != 0) {
            throw new InvalidRequestException(String.format("%s cannot be smaller than %s, (default %s)", KW_MAXCOMPACTIONTHRESHOLD, KW_MINCOMPACTIONTHRESHOLD, 4));
        }
        if (this.keyValidator.size() < 1) {
            throw new InvalidRequestException("You must specify a PRIMARY KEY");
        }
        if (this.keyValidator.size() > 1) {
            throw new InvalidRequestException("You may only specify one PRIMARY KEY");
        }
        try {
            comparator = this.getComparator();
        }
        catch (ConfigurationException e) {
            throw new InvalidRequestException(e.toString());
        }
        for (Map.Entry<Term, String> column : this.columns.entrySet()) {
            ByteBuffer name = column.getKey().getByteBuffer(comparator);
            if (this.keyAlias == null || !this.keyAlias.equals(name)) continue;
            throw new InvalidRequestException("Invalid column name: " + column.getKey().getText() + ", because it equals to the key_alias.");
        }
    }

    public void addColumn(Term term, String comparator) {
        this.columns.put(term, comparator);
    }

    public void setKeyType(String validator) {
        this.keyValidator.add(validator);
    }

    public String getKeyType() {
        return this.keyValidator.get(0);
    }

    public void setKeyAlias(String alias) {
        if (!alias.toUpperCase().equals("KEY")) {
            this.keyAlias = ByteBufferUtil.bytes(alias);
        }
    }

    public void addProperty(String name, String value) {
        this.properties.put(name, value);
    }

    public String getName() {
        return this.name;
    }

    private Map<ByteBuffer, ColumnDefinition> getColumns(AbstractType<?> comparator) throws InvalidRequestException {
        HashMap<ByteBuffer, ColumnDefinition> columnDefs = new HashMap<ByteBuffer, ColumnDefinition>();
        for (Map.Entry<Term, String> col : this.columns.entrySet()) {
            try {
                ByteBuffer columnName = comparator.fromString(col.getKey().getText());
                String validatorClassName = comparators.containsKey(col.getValue()) ? comparators.get(col.getValue()) : col.getValue();
                AbstractType validator = TypeParser.parse(validatorClassName);
                columnDefs.put(columnName, new ColumnDefinition(columnName, validator, null, null, null));
            }
            catch (ConfigurationException e) {
                InvalidRequestException ex = new InvalidRequestException(e.toString());
                ex.initCause((Throwable)e);
                throw ex;
            }
        }
        return columnDefs;
    }

    private AbstractType<?> getComparator() throws ConfigurationException {
        return TypeParser.parse(comparators.get(this.getPropertyString(KW_COMPARATOR, "text")) != null ? comparators.get(this.getPropertyString(KW_COMPARATOR, "text")) : this.getPropertyString(KW_COMPARATOR, "text"));
    }

    private AbstractType<?> getValidator() throws ConfigurationException {
        return TypeParser.parse(comparators.get(this.getPropertyString(KW_DEFAULTVALIDATION, "text")) != null ? comparators.get(this.getPropertyString(KW_DEFAULTVALIDATION, "text")) : this.getPropertyString(KW_DEFAULTVALIDATION, "text"));
    }

    public CFMetaData getCFMetaData(String keyspace) throws InvalidRequestException {
        CFMetaData newCFMD;
        this.validate();
        try {
            AbstractType<?> comparator = this.getComparator();
            newCFMD = new CFMetaData(keyspace, this.name, ColumnFamilyType.Standard, comparator, null);
            newCFMD.comment(this.properties.get(KW_COMMENT)).rowCacheSize(this.getPropertyDouble(KW_ROWCACHESIZE, 0.0)).keyCacheSize(this.getPropertyDouble(KW_KEYCACHESIZE, 200000.0)).readRepairChance(this.getPropertyDouble(KW_READREPAIRCHANCE, 0.1)).replicateOnWrite(this.getPropertyBoolean(KW_REPLICATEONWRITE, true)).gcGraceSeconds(this.getPropertyInt(KW_GCGRACESECONDS, 864000)).defaultValidator(this.getValidator()).minCompactionThreshold(this.getPropertyInt(KW_MINCOMPACTIONTHRESHOLD, 4)).maxCompactionThreshold(this.getPropertyInt(KW_MAXCOMPACTIONTHRESHOLD, 32)).rowCacheSavePeriod(this.getPropertyInt(KW_ROWCACHESAVEPERIODSECS, 0)).keyCacheSavePeriod(this.getPropertyInt(KW_KEYCACHESAVEPERIODSECS, 14400)).mergeShardsChance(0.0).columnMetadata(this.getColumns(comparator)).keyValidator(TypeParser.parse(comparators.get(this.getKeyType()))).rowCacheProvider(FBUtilities.newCacheProvider(this.getPropertyString(KW_ROW_CACHE_PROVIDER, CFMetaData.DEFAULT_ROW_CACHE_PROVIDER.getClass().getName()))).keyAlias(this.keyAlias).compactionStrategyClass(this.compactionStrategyClass).compactionStrategyOptions(this.compactionStrategyOptions).compressionParameters(CompressionParameters.create(this.compressionParameters)).validate();
        }
        catch (ConfigurationException e) {
            throw new InvalidRequestException(e.toString());
        }
        return newCFMD;
    }

    private String getPropertyString(String key, String defaultValue) {
        String value = this.properties.get(key);
        return value != null ? value : defaultValue;
    }

    private Boolean getPropertyBoolean(String key, Boolean defaultValue) throws InvalidRequestException {
        String value = this.properties.get(key);
        return value == null ? defaultValue.booleanValue() : value.toLowerCase().matches("(1|true|yes)");
    }

    private Double getPropertyDouble(String key, Double defaultValue) throws InvalidRequestException {
        Double result;
        String value = this.properties.get(key);
        if (value == null) {
            result = defaultValue;
        } else {
            try {
                result = Double.parseDouble(value);
            }
            catch (NumberFormatException e) {
                throw new InvalidRequestException(String.format("%s not valid for \"%s\"", value, key));
            }
        }
        return result;
    }

    private Integer getPropertyInt(String key, Integer defaultValue) throws InvalidRequestException {
        Integer result;
        String value = this.properties.get(key);
        if (value == null) {
            result = defaultValue;
        } else {
            try {
                result = Integer.parseInt(value);
            }
            catch (NumberFormatException e) {
                throw new InvalidRequestException(String.format("%s not valid for \"%s\"", value, key));
            }
        }
        return result;
    }

    static {
        comparators.put("ascii", "AsciiType");
        comparators.put("bigint", "LongType");
        comparators.put("blob", "BytesType");
        comparators.put("boolean", "BooleanType");
        comparators.put("counter", "CounterColumnType");
        comparators.put("decimal", "DecimalType");
        comparators.put("double", "DoubleType");
        comparators.put("float", "FloatType");
        comparators.put("int", "Int32Type");
        comparators.put("text", "UTF8Type");
        comparators.put("timestamp", "DateType");
        comparators.put("uuid", "UUIDType");
        comparators.put("varchar", "UTF8Type");
        comparators.put("varint", "IntegerType");
        keywords.add(KW_COMPARATOR);
        keywords.add(KW_COMMENT);
        keywords.add(KW_ROWCACHESIZE);
        keywords.add(KW_KEYCACHESIZE);
        keywords.add(KW_READREPAIRCHANCE);
        keywords.add(KW_GCGRACESECONDS);
        keywords.add(KW_DEFAULTVALIDATION);
        keywords.add(KW_MINCOMPACTIONTHRESHOLD);
        keywords.add(KW_MAXCOMPACTIONTHRESHOLD);
        keywords.add(KW_ROWCACHESAVEPERIODSECS);
        keywords.add(KW_KEYCACHESAVEPERIODSECS);
        keywords.add(KW_REPLICATEONWRITE);
        keywords.add(KW_ROW_CACHE_PROVIDER);
        keywords.add(KW_COMPACTION_STRATEGY_CLASS);
        obsoleteKeywords.add("memtable_throughput_in_mb");
        obsoleteKeywords.add("memtable_operations_in_millions");
        obsoleteKeywords.add("memtable_flush_after_mins");
    }
}

