/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.index.keys;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.config.ColumnDefinition;
import org.apache.cassandra.config.ConfigurationException;
import org.apache.cassandra.db.Column;
import org.apache.cassandra.db.ColumnFamily;
import org.apache.cassandra.db.ColumnFamilyStore;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.ExpiringColumn;
import org.apache.cassandra.db.IColumn;
import org.apache.cassandra.db.index.PerColumnSecondaryIndex;
import org.apache.cassandra.db.index.SecondaryIndexSearcher;
import org.apache.cassandra.db.index.keys.KeysSearcher;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.db.marshal.BytesType;
import org.apache.cassandra.db.marshal.LocalByPartionerType;
import org.apache.cassandra.dht.ByteOrderedPartitioner;
import org.apache.cassandra.dht.IPartitioner;
import org.apache.cassandra.dht.LocalPartitioner;
import org.apache.cassandra.dht.OrderPreservingPartitioner;
import org.apache.cassandra.service.StorageService;
import org.apache.cassandra.utils.ByteBufferUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KeysIndex
extends PerColumnSecondaryIndex {
    private static final Logger logger = LoggerFactory.getLogger(KeysIndex.class);
    private ColumnFamilyStore indexCfs;

    @Override
    public void init() {
        assert (this.baseCfs != null && this.columnDefs != null);
        ColumnDefinition columnDef = (ColumnDefinition)this.columnDefs.iterator().next();
        CFMetaData indexedCfMetadata = CFMetaData.newIndexMetadata(this.baseCfs.metadata, columnDef, KeysIndex.indexComparator());
        this.indexCfs = ColumnFamilyStore.createColumnFamilyStore(this.baseCfs.table, indexedCfMetadata.cfName, new LocalPartitioner(columnDef.getValidator()), indexedCfMetadata);
    }

    public static AbstractType indexComparator() {
        IPartitioner rowPartitioner = StorageService.getPartitioner();
        return rowPartitioner instanceof OrderPreservingPartitioner || rowPartitioner instanceof ByteOrderedPartitioner ? BytesType.instance : new LocalByPartionerType(StorageService.getPartitioner());
    }

    @Override
    public void deleteColumn(DecoratedKey<?> valueKey, ByteBuffer rowKey, IColumn column) {
        if (column.isMarkedForDelete()) {
            return;
        }
        int localDeletionTime = (int)(System.currentTimeMillis() / 1000L);
        ColumnFamily cfi = ColumnFamily.create(this.indexCfs.metadata);
        cfi.addTombstone(rowKey, localDeletionTime, column.timestamp());
        this.indexCfs.apply(valueKey, cfi);
        if (logger.isDebugEnabled()) {
            logger.debug("removed index entry for cleaned-up value {}:{}", valueKey, (Object)cfi);
        }
    }

    @Override
    public void insertColumn(DecoratedKey<?> valueKey, ByteBuffer rowKey, IColumn column) {
        ColumnFamily cfi = ColumnFamily.create(this.indexCfs.metadata);
        if (column instanceof ExpiringColumn) {
            ExpiringColumn ec = (ExpiringColumn)column;
            cfi.addColumn(new ExpiringColumn(rowKey, ByteBufferUtil.EMPTY_BYTE_BUFFER, ec.timestamp(), ec.getTimeToLive(), ec.getLocalDeletionTime()));
        } else {
            cfi.addColumn(new Column(rowKey, ByteBufferUtil.EMPTY_BYTE_BUFFER, column.timestamp()));
        }
        if (logger.isDebugEnabled()) {
            logger.debug("applying index row {} in {}", (Object)this.indexCfs.metadata.getKeyValidator().getString(valueKey.key), (Object)cfi);
        }
        this.indexCfs.apply(valueKey, cfi);
    }

    @Override
    public void updateColumn(DecoratedKey<?> valueKey, ByteBuffer rowKey, IColumn col) {
        this.insertColumn(valueKey, rowKey, col);
    }

    @Override
    public void removeIndex(ByteBuffer columnName) throws IOException {
        this.indexCfs.invalidate();
    }

    @Override
    public void forceBlockingFlush() throws IOException {
        try {
            this.indexCfs.forceBlockingFlush();
        }
        catch (ExecutionException e) {
            throw new IOException(e);
        }
        catch (InterruptedException e) {
            throw new IOException(e);
        }
    }

    @Override
    public void invalidate() {
        this.indexCfs.invalidate();
    }

    @Override
    public ColumnFamilyStore getIndexCfs() {
        return this.indexCfs;
    }

    @Override
    public SecondaryIndexSearcher createSecondaryIndexSearcher(Set<ByteBuffer> columns) {
        return new KeysSearcher(this.baseCfs.indexManager, columns);
    }

    @Override
    public String getIndexName() {
        return this.indexCfs.columnFamily;
    }

    @Override
    public void validateOptions() throws ConfigurationException {
    }

    @Override
    public long getLiveSize() {
        return this.indexCfs.getMemtableDataSize();
    }
}

