/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.security.MessageDigest;
import java.util.Collection;
import java.util.Comparator;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.db.AbstractColumnContainer;
import org.apache.cassandra.db.Column;
import org.apache.cassandra.db.ColumnFamilyStore;
import org.apache.cassandra.db.IColumn;
import org.apache.cassandra.db.ISortedColumns;
import org.apache.cassandra.db.SuperColumnSerializer;
import org.apache.cassandra.db.ThreadSafeSortedColumns;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.db.marshal.MarshalException;
import org.apache.cassandra.io.util.DataOutputBuffer;
import org.apache.cassandra.utils.Allocator;
import org.apache.cassandra.utils.HeapAllocator;
import org.cliffc.high_scale_lib.NonBlockingHashMap;

public class SuperColumn
extends AbstractColumnContainer
implements IColumn {
    private static NonBlockingHashMap<Comparator, SuperColumnSerializer> serializers = new NonBlockingHashMap();
    private ByteBuffer name;

    public static SuperColumnSerializer serializer(AbstractType comparator) {
        SuperColumnSerializer serializer = (SuperColumnSerializer)serializers.get((Object)comparator);
        if (serializer == null) {
            serializer = new SuperColumnSerializer(comparator);
            serializers.put((Object)comparator, (Object)serializer);
        }
        return serializer;
    }

    public SuperColumn(ByteBuffer name, AbstractType comparator) {
        this(name, ThreadSafeSortedColumns.factory().create(comparator, false));
    }

    SuperColumn(ByteBuffer name, ISortedColumns columns) {
        super(columns);
        assert (name != null);
        assert (name.remaining() <= 65535);
        this.name = name;
    }

    public SuperColumn cloneMeShallow() {
        SuperColumn sc = new SuperColumn(this.name, this.getComparator());
        sc.deletionInfo.set(this.deletionInfo.get());
        return sc;
    }

    public IColumn cloneMe() {
        SuperColumn sc = new SuperColumn(this.name, this.columns.cloneMe());
        sc.deletionInfo.set(this.deletionInfo.get());
        return sc;
    }

    @Override
    public ByteBuffer name() {
        return this.name;
    }

    @Override
    public Collection<IColumn> getSubColumns() {
        return this.getSortedColumns();
    }

    @Override
    public IColumn getSubColumn(ByteBuffer columnName) {
        IColumn column = this.columns.getColumn(columnName);
        assert (column == null || column instanceof Column);
        return column;
    }

    @Override
    public int size() {
        int size = 0;
        for (IColumn subColumn : this.getSubColumns()) {
            size += subColumn.serializedSize();
        }
        return size;
    }

    @Override
    public int serializedSize() {
        return 2 + this.name.remaining() + 4 + 8 + 4 + this.size();
    }

    @Override
    public long timestamp() {
        throw new UnsupportedOperationException("This operation is not supported for Super Columns.");
    }

    @Override
    public long maxTimestamp() {
        long maxTimestamp = this.getMarkedForDeleteAt();
        for (IColumn subColumn : this.getSubColumns()) {
            maxTimestamp = Math.max(maxTimestamp, subColumn.maxTimestamp());
        }
        return maxTimestamp;
    }

    @Override
    public long mostRecentLiveChangeAt() {
        long max = Long.MIN_VALUE;
        for (IColumn column : this.getSubColumns()) {
            if (column.isMarkedForDelete() || column.timestamp() <= max) continue;
            max = column.timestamp();
        }
        return max;
    }

    @Override
    public ByteBuffer value() {
        throw new UnsupportedOperationException("This operation is not supported for Super Columns.");
    }

    @Override
    public void addColumn(IColumn column, Allocator allocator) {
        assert (column instanceof Column) : "A super column can only contain simple columns";
        super.addColumn(column, allocator);
    }

    void putColumn(SuperColumn column, Allocator allocator) {
        for (IColumn subColumn : column.getSubColumns()) {
            this.addColumn(subColumn, allocator);
        }
        this.delete(column);
    }

    @Override
    public IColumn diff(IColumn columnNew) {
        SuperColumn columnDiff = new SuperColumn(columnNew.name(), ((SuperColumn)columnNew).getComparator());
        if (columnNew.getMarkedForDeleteAt() > this.getMarkedForDeleteAt()) {
            columnDiff.delete(columnNew.getLocalDeletionTime(), columnNew.getMarkedForDeleteAt());
        }
        for (IColumn subColumn : columnNew.getSubColumns()) {
            IColumn columnInternal = this.columns.getColumn(subColumn.name());
            if (columnInternal == null) {
                columnDiff.addColumn(subColumn);
                continue;
            }
            IColumn subColumnDiff = columnInternal.diff(subColumn);
            if (subColumnDiff == null) continue;
            columnDiff.addColumn(subColumnDiff);
        }
        if (!columnDiff.getSubColumns().isEmpty() || columnNew.isMarkedForDelete()) {
            return columnDiff;
        }
        return null;
    }

    @Override
    public void updateDigest(MessageDigest digest) {
        assert (this.name != null);
        digest.update(this.name.duplicate());
        DataOutputBuffer buffer = new DataOutputBuffer();
        try {
            buffer.writeLong(this.getMarkedForDeleteAt());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        digest.update(buffer.getData(), 0, buffer.getLength());
        for (IColumn column : this.getSubColumns()) {
            column.updateDigest(digest);
        }
    }

    @Override
    public String getString(AbstractType comparator) {
        StringBuilder sb = new StringBuilder();
        sb.append("SuperColumn(");
        sb.append(comparator.getString(this.name));
        if (this.isMarkedForDelete()) {
            sb.append(" -delete at ").append(this.getMarkedForDeleteAt()).append("-");
        }
        sb.append(" [");
        sb.append(this.getComparator().getColumnsString(this.getSubColumns()));
        sb.append("])");
        return sb.toString();
    }

    @Override
    public boolean isLive() {
        return this.mostRecentLiveChangeAt() > this.getMarkedForDeleteAt();
    }

    @Override
    public IColumn localCopy(ColumnFamilyStore cfs) {
        return this.localCopy(cfs, HeapAllocator.instance);
    }

    @Override
    public IColumn localCopy(ColumnFamilyStore cfs, Allocator allocator) {
        SuperColumn sc = new SuperColumn(allocator.clone(this.name), this.getComparator());
        sc.deletionInfo.set(this.deletionInfo.get());
        for (IColumn c : this.columns) {
            sc.addColumn(c.localCopy(cfs, allocator));
        }
        return sc;
    }

    @Override
    public IColumn reconcile(IColumn c) {
        return this.reconcile(null, null);
    }

    @Override
    public IColumn reconcile(IColumn c, Allocator allocator) {
        throw new UnsupportedOperationException("This operation is unsupported on super columns.");
    }

    @Override
    public int serializationFlags() {
        throw new UnsupportedOperationException("Super columns don't have a serialization mask");
    }

    @Override
    public void validateFields(CFMetaData metadata) throws MarshalException {
        metadata.comparator.validate(this.name());
        for (IColumn column : this.getSubColumns()) {
            column.validateFields(metadata);
        }
    }
}

