/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.io.sstable;

import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import org.apache.cassandra.db.commitlog.ReplayPosition;
import org.apache.cassandra.io.sstable.Descriptor;
import org.apache.cassandra.io.sstable.SSTable;
import org.apache.cassandra.io.util.FileUtils;
import org.apache.cassandra.utils.EstimatedHistogram;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SSTableMetadata {
    private static Logger logger = LoggerFactory.getLogger(SSTableMetadata.class);
    protected final EstimatedHistogram estimatedRowSize;
    protected final EstimatedHistogram estimatedColumnCount;
    protected final ReplayPosition replayPosition;
    protected final long maxTimestamp;
    protected final double compressionRatio;
    public static final SSTableMetadataSerializer serializer = new SSTableMetadataSerializer();

    private SSTableMetadata() {
        this(SSTableMetadata.defaultRowSizeHistogram(), SSTableMetadata.defaultColumnCountHistogram(), ReplayPosition.NONE, Long.MIN_VALUE, Double.MIN_VALUE);
    }

    private SSTableMetadata(EstimatedHistogram rowSizes, EstimatedHistogram columnCounts, ReplayPosition replayPosition, long maxTimestamp, double cr) {
        this.estimatedRowSize = rowSizes;
        this.estimatedColumnCount = columnCounts;
        this.replayPosition = replayPosition;
        this.maxTimestamp = maxTimestamp;
        this.compressionRatio = cr;
    }

    public static SSTableMetadata createDefaultInstance() {
        return new SSTableMetadata();
    }

    public static Collector createCollector() {
        return new Collector();
    }

    public EstimatedHistogram getEstimatedRowSize() {
        return this.estimatedRowSize;
    }

    public EstimatedHistogram getEstimatedColumnCount() {
        return this.estimatedColumnCount;
    }

    public ReplayPosition getReplayPosition() {
        return this.replayPosition;
    }

    public long getMaxTimestamp() {
        return this.maxTimestamp;
    }

    public double getCompressionRatio() {
        return this.compressionRatio;
    }

    static EstimatedHistogram defaultColumnCountHistogram() {
        return new EstimatedHistogram(114);
    }

    static EstimatedHistogram defaultRowSizeHistogram() {
        return new EstimatedHistogram(150);
    }

    public static class SSTableMetadataSerializer {
        private static final Logger logger = LoggerFactory.getLogger(SSTableMetadataSerializer.class);

        public void serialize(SSTableMetadata sstableStats, DataOutput dos) throws IOException {
            EstimatedHistogram.serializer.serialize(sstableStats.getEstimatedRowSize(), dos);
            EstimatedHistogram.serializer.serialize(sstableStats.getEstimatedColumnCount(), dos);
            ReplayPosition.serializer.serialize(sstableStats.getReplayPosition(), dos);
            dos.writeLong(sstableStats.getMaxTimestamp());
            dos.writeDouble(sstableStats.getCompressionRatio());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public SSTableMetadata deserialize(Descriptor descriptor) throws IOException {
            logger.debug("Load metadata for {}", (Object)descriptor);
            File statsFile = new File(descriptor.filenameFor(SSTable.COMPONENT_STATS));
            if (!statsFile.exists()) {
                logger.debug("No sstable stats for {}", (Object)descriptor);
                return new SSTableMetadata();
            }
            DataInputStream dis = new DataInputStream(new BufferedInputStream(new FileInputStream(statsFile)));
            try {
                SSTableMetadata sSTableMetadata = this.deserialize(dis, descriptor);
                return sSTableMetadata;
            }
            finally {
                FileUtils.closeQuietly(dis);
            }
        }

        public SSTableMetadata deserialize(DataInputStream dis, Descriptor desc) throws IOException {
            EstimatedHistogram rowSizes = EstimatedHistogram.serializer.deserialize(dis);
            EstimatedHistogram columnCounts = EstimatedHistogram.serializer.deserialize(dis);
            ReplayPosition replayPosition = desc.metadataIncludesReplayPosition ? ReplayPosition.serializer.deserialize(dis) : ReplayPosition.NONE;
            long maxTimestamp = desc.tracksMaxTimestamp ? dis.readLong() : Long.MIN_VALUE;
            double compressionRatio = desc.hasCompressionRatio ? dis.readDouble() : Double.MIN_VALUE;
            return new SSTableMetadata(rowSizes, columnCounts, replayPosition, maxTimestamp, compressionRatio);
        }
    }

    public static class Collector {
        protected EstimatedHistogram estimatedRowSize = SSTableMetadata.defaultRowSizeHistogram();
        protected EstimatedHistogram estimatedColumnCount = SSTableMetadata.defaultColumnCountHistogram();
        protected ReplayPosition replayPosition = ReplayPosition.NONE;
        protected long maxTimestamp = Long.MIN_VALUE;
        protected double compressionRatio = Double.MIN_VALUE;

        private Collector() {
        }

        public void addRowSize(long rowSize) {
            this.estimatedRowSize.add(rowSize);
        }

        public void addColumnCount(long columnCount) {
            this.estimatedColumnCount.add(columnCount);
        }

        public void addCompressionRatio(long compressed, long uncompressed) {
            this.compressionRatio = (double)compressed / (double)uncompressed;
        }

        public void updateMaxTimestamp(long potentialMax) {
            this.maxTimestamp = Math.max(this.maxTimestamp, potentialMax);
        }

        public SSTableMetadata finalizeMetadata() {
            return new SSTableMetadata(this.estimatedRowSize, this.estimatedColumnCount, this.replayPosition, this.maxTimestamp, this.compressionRatio);
        }

        public Collector estimatedRowSize(EstimatedHistogram estimatedRowSize) {
            this.estimatedRowSize = estimatedRowSize;
            return this;
        }

        public Collector estimatedColumnCount(EstimatedHistogram estimatedColumnCount) {
            this.estimatedColumnCount = estimatedColumnCount;
            return this;
        }

        public Collector replayPosition(ReplayPosition replayPosition) {
            this.replayPosition = replayPosition;
            return this;
        }
    }
}

