/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.index.keys;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.db.ColumnFamily;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.IColumn;
import org.apache.cassandra.db.Row;
import org.apache.cassandra.db.columniterator.IColumnIterator;
import org.apache.cassandra.db.filter.IFilter;
import org.apache.cassandra.db.filter.NamesQueryFilter;
import org.apache.cassandra.db.filter.QueryFilter;
import org.apache.cassandra.db.filter.QueryPath;
import org.apache.cassandra.db.filter.SliceQueryFilter;
import org.apache.cassandra.db.index.SecondaryIndex;
import org.apache.cassandra.db.index.SecondaryIndexManager;
import org.apache.cassandra.db.index.SecondaryIndexSearcher;
import org.apache.cassandra.dht.AbstractBounds;
import org.apache.cassandra.dht.LocalToken;
import org.apache.cassandra.dht.Token;
import org.apache.cassandra.thrift.IndexClause;
import org.apache.cassandra.thrift.IndexExpression;
import org.apache.cassandra.thrift.IndexOperator;
import org.apache.cassandra.utils.ByteBufferUtil;
import org.apache.cassandra.utils.HeapAllocator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KeysSearcher
extends SecondaryIndexSearcher {
    private static final Logger logger = LoggerFactory.getLogger(KeysSearcher.class);

    public KeysSearcher(SecondaryIndexManager indexManager, Set<ByteBuffer> columns) {
        super(indexManager, columns);
    }

    private IndexExpression highestSelectivityPredicate(IndexClause clause) {
        IndexExpression best = null;
        int bestMeanCount = Integer.MAX_VALUE;
        for (IndexExpression expression : clause.expressions) {
            int columns;
            SecondaryIndex index;
            if (!this.columns.contains(expression.column_name) || (index = this.indexManager.getIndexForColumn(expression.column_name)) == null || expression.op != IndexOperator.EQ || (columns = index.getIndexCfs().getMeanColumns()) >= bestMeanCount) continue;
            best = expression;
            bestMeanCount = columns;
        }
        return best;
    }

    private String expressionString(IndexExpression expr) {
        return String.format("'%s.%s %s %s'", this.baseCfs.columnFamily, this.baseCfs.getComparator().getString(expr.column_name), expr.op, this.baseCfs.metadata.getColumn_metadata().get(expr.column_name).getValidator().getString(expr.value));
    }

    private static boolean isIdentityFilter(SliceQueryFilter filter) {
        return filter.start.equals(ByteBufferUtil.EMPTY_BYTE_BUFFER) && filter.finish.equals(ByteBufferUtil.EMPTY_BYTE_BUFFER) && filter.count == Integer.MAX_VALUE;
    }

    @Override
    public List<Row> search(IndexClause clause, AbstractBounds range, IFilter dataFilter) {
        IndexExpression primary = this.highestSelectivityPredicate(clause);
        SecondaryIndex index = this.indexManager.getIndexForColumn(primary.column_name);
        if (logger.isDebugEnabled()) {
            logger.debug("Primary scan clause is " + this.baseCfs.getComparator().getString(primary.column_name));
        }
        assert (index != null);
        DecoratedKey<LocalToken> indexKey = this.indexManager.getIndexKeyFor(primary.column_name, primary.value);
        IFilter firstFilter = dataFilter;
        if (dataFilter instanceof SliceQueryFilter) {
            if (this.baseCfs.getMaxRowSize() < (long)DatabaseDescriptor.getColumnIndexSize()) {
                logger.debug("Expanding slice filter to entire row to cover additional expressions");
                firstFilter = new SliceQueryFilter(ByteBufferUtil.EMPTY_BYTE_BUFFER, ByteBufferUtil.EMPTY_BYTE_BUFFER, ((SliceQueryFilter)dataFilter).reversed, Integer.MAX_VALUE);
            }
        } else {
            logger.debug("adding columns to firstFilter to cover additional expressions");
            assert (dataFilter instanceof NamesQueryFilter);
            TreeSet<ByteBuffer> columns = new TreeSet<ByteBuffer>(this.baseCfs.getComparator());
            for (IndexExpression expr : clause.expressions) {
                columns.add(expr.column_name);
            }
            if (columns.size() > 0) {
                columns.addAll(((NamesQueryFilter)dataFilter).columns);
                firstFilter = new NamesQueryFilter(columns);
            }
        }
        ArrayList<Row> rows = new ArrayList<Row>();
        ByteBuffer startKey = clause.start_key;
        QueryPath path = new QueryPath(this.baseCfs.columnFamily);
        ByteBuffer lastDataKey = null;
        block1: while (true) {
            if (logger.isDebugEnabled()) {
                logger.debug(String.format("Scanning index %s starting with %s", this.expressionString(primary), index.getBaseCfs().metadata.getKeyValidator().getString(startKey)));
            }
            int count = Math.max(clause.count, 2);
            QueryFilter indexFilter = QueryFilter.getSliceFilter(indexKey, new QueryPath(index.getIndexCfs().getColumnFamilyName()), startKey, ByteBufferUtil.EMPTY_BYTE_BUFFER, false, count);
            ColumnFamily indexRow = index.getIndexCfs().getColumnFamily(indexFilter);
            logger.debug("fetched {}", (Object)indexRow);
            if (indexRow == null) break;
            ByteBuffer dataKey = null;
            int n = 0;
            for (IColumn column : indexRow.getSortedColumns()) {
                if (column.isMarkedForDelete()) {
                    logger.debug("skipping {}", (Object)column.name());
                    continue;
                }
                dataKey = column.name();
                ++n;
                if (logger.isDebugEnabled()) {
                    logger.debug("fetching {}", (Object)column.name());
                }
                DecoratedKey dk = this.baseCfs.partitioner.decorateKey(dataKey);
                if (!range.right.equals(this.baseCfs.partitioner.getMinimumToken()) && range.right.compareTo(dk.token) < 0) break block1;
                if (!range.contains((Token)dk.token) || dataKey.equals(lastDataKey)) continue;
                ColumnFamily data = this.baseCfs.getColumnFamily(new QueryFilter(dk, path, firstFilter));
                if (data == null) {
                    data = ColumnFamily.create(this.baseCfs.metadata);
                }
                logger.debug("fetched data row {}", (Object)data);
                NamesQueryFilter extraFilter = null;
                if (dataFilter instanceof SliceQueryFilter && !KeysSearcher.isIdentityFilter((SliceQueryFilter)dataFilter)) {
                    boolean needExtraFilter = false;
                    for (IndexExpression expr : clause.expressions) {
                        if (data.getColumn(expr.column_name) != null) continue;
                        logger.debug("adding extraFilter to cover additional expressions");
                        needExtraFilter = true;
                        break;
                    }
                    if (needExtraFilter) {
                        extraFilter = this.getExtraFilter(clause);
                        for (IndexExpression expr : clause.expressions) {
                            if (data.getColumn(expr.column_name) == null) continue;
                            extraFilter.columns.remove(expr.column_name);
                        }
                        assert (!extraFilter.columns.isEmpty());
                        ColumnFamily cf = this.baseCfs.getColumnFamily(new QueryFilter(dk, path, extraFilter));
                        if (cf != null) {
                            data.addAll(cf, HeapAllocator.instance);
                        }
                    }
                }
                if (SecondaryIndexSearcher.satisfies(data, clause, primary)) {
                    logger.debug("row {} satisfies all clauses", (Object)data);
                    if (firstFilter != dataFilter || extraFilter != null) {
                        ColumnFamily expandedData = data;
                        data = expandedData.cloneMeShallow();
                        IColumnIterator iter = dataFilter.getMemtableColumnIterator(expandedData, dk, this.baseCfs.getComparator());
                        new QueryFilter(dk, path, dataFilter).collateColumns(data, Collections.singletonList(iter), this.baseCfs.getComparator(), this.baseCfs.gcBefore());
                    }
                    rows.add(new Row(dk, data));
                }
                if (rows.size() != clause.count) continue;
                break block1;
            }
            if (n < clause.count || startKey.equals(dataKey)) break;
            lastDataKey = startKey = dataKey;
        }
        return rows;
    }
}

