/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.index;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import org.apache.cassandra.config.ColumnDefinition;
import org.apache.cassandra.config.ConfigurationException;
import org.apache.cassandra.db.ColumnFamilyStore;
import org.apache.cassandra.db.SystemTable;
import org.apache.cassandra.db.compaction.CompactionManager;
import org.apache.cassandra.db.index.PerRowSecondaryIndex;
import org.apache.cassandra.db.index.SecondaryIndexBuilder;
import org.apache.cassandra.db.index.SecondaryIndexSearcher;
import org.apache.cassandra.db.index.keys.KeysIndex;
import org.apache.cassandra.io.sstable.ReducingKeyIterator;
import org.apache.cassandra.io.sstable.SSTableReader;
import org.apache.cassandra.utils.ByteBufferUtil;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class SecondaryIndex {
    private static final Logger logger = LoggerFactory.getLogger(SecondaryIndex.class);
    public static final String CUSTOM_INDEX_OPTION_NAME = "class_name";
    protected ColumnFamilyStore baseCfs;
    protected Set<ColumnDefinition> columnDefs = Collections.newSetFromMap(new ConcurrentHashMap());

    public abstract void init();

    public abstract void validateOptions() throws ConfigurationException;

    public abstract String getIndexName();

    public abstract String getNameForSystemTable(ByteBuffer var1);

    public boolean isIndexBuilt(ByteBuffer columnName) {
        return SystemTable.isIndexBuilt(this.baseCfs.table.name, this.getNameForSystemTable(columnName));
    }

    protected abstract SecondaryIndexSearcher createSecondaryIndexSearcher(Set<ByteBuffer> var1);

    public abstract void forceBlockingFlush() throws IOException;

    public abstract ColumnFamilyStore getIndexCfs();

    public abstract void removeIndex(ByteBuffer var1) throws IOException;

    public abstract void renameIndex(String var1) throws IOException;

    public abstract void unregisterMbean();

    protected void buildIndexBlocking() throws IOException {
        logger.info(String.format("Submitting index build of %s for data in %s", this.getIndexName(), StringUtils.join(this.baseCfs.getSSTables(), (String)", ")));
        TreeSet<ByteBuffer> columnNames = new TreeSet<ByteBuffer>();
        for (ColumnDefinition cdef : this.columnDefs) {
            columnNames.add(cdef.name);
        }
        Collection<SSTableReader> sstables = this.baseCfs.markCurrentSSTablesReferenced();
        SecondaryIndexBuilder builder = new SecondaryIndexBuilder(this.baseCfs, columnNames, new ReducingKeyIterator(sstables));
        Future<?> future = CompactionManager.instance.submitIndexBuild(builder);
        try {
            future.get();
            this.forceBlockingFlush();
            if (this instanceof PerRowSecondaryIndex) {
                for (ByteBuffer columnName : columnNames) {
                    SystemTable.setIndexBuilt(this.baseCfs.table.name, this.getIndexName() + ByteBufferUtil.string(columnName));
                }
            } else {
                SystemTable.setIndexBuilt(this.baseCfs.table.name, this.getIndexName());
            }
        }
        catch (InterruptedException e) {
            throw new AssertionError((Object)e);
        }
        catch (ExecutionException e) {
            throw new IOException(e);
        }
        finally {
            SSTableReader.releaseReferences(sstables);
        }
        logger.info("Index build of " + this.getIndexName() + " complete");
    }

    public Future<?> buildIndexAsync() {
        boolean allAreBuilt = true;
        for (ColumnDefinition cdef : this.columnDefs) {
            if (SystemTable.isIndexBuilt(this.baseCfs.table.name, this.getNameForSystemTable(cdef.name))) continue;
            allAreBuilt = false;
            break;
        }
        if (allAreBuilt) {
            return null;
        }
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                try {
                    SecondaryIndex.this.baseCfs.forceBlockingFlush();
                }
                catch (ExecutionException e) {
                    throw new RuntimeException(e);
                }
                catch (InterruptedException e) {
                    throw new AssertionError((Object)e);
                }
                try {
                    SecondaryIndex.this.buildIndexBlocking();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        };
        FutureTask<Object> f = new FutureTask<Object>(runnable, null);
        new Thread(f, "Creating index: " + this.getIndexName()).start();
        return f;
    }

    public ColumnFamilyStore getBaseCfs() {
        return this.baseCfs;
    }

    private void setBaseCfs(ColumnFamilyStore baseCfs) {
        this.baseCfs = baseCfs;
    }

    Set<ColumnDefinition> getColumnDefs() {
        return this.columnDefs;
    }

    void addColumnDef(ColumnDefinition columnDef) {
        this.columnDefs.add(columnDef);
    }

    void removeColumnDef(ByteBuffer name) {
        Iterator<ColumnDefinition> it = this.columnDefs.iterator();
        while (it.hasNext()) {
            if (!it.next().name.equals(name)) continue;
            it.remove();
        }
    }

    public static SecondaryIndex createInstance(ColumnFamilyStore baseCfs, ColumnDefinition cdef) throws ConfigurationException {
        SecondaryIndex index;
        switch (cdef.getIndexType()) {
            case KEYS: {
                index = new KeysIndex();
                break;
            }
            case CUSTOM: {
                assert (cdef.getIndexOptions() != null);
                String class_name = cdef.getIndexOptions().get(CUSTOM_INDEX_OPTION_NAME);
                assert (class_name != null);
                try {
                    index = (SecondaryIndex)Class.forName(class_name).newInstance();
                    break;
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
            default: {
                throw new RuntimeException("Unknown index type: " + cdef.getIndexName());
            }
        }
        index.addColumnDef(cdef);
        ((SecondaryIndex)index).validateOptions();
        super.setBaseCfs(baseCfs);
        return index;
    }
}

