/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db;

import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import org.apache.cassandra.db.ColumnFamily;
import org.apache.cassandra.db.Row;
import org.apache.cassandra.io.ICompactSerializer;
import org.apache.cassandra.service.StorageService;
import org.apache.cassandra.utils.ByteBufferUtil;

class RowSerializer
implements ICompactSerializer<Row> {
    RowSerializer() {
    }

    @Override
    public void serialize(Row row, DataOutputStream dos, int version) throws IOException {
        ByteBufferUtil.writeWithShortLength(row.key.key, dos);
        ColumnFamily.serializer().serialize(row.cf, (DataOutput)dos);
    }

    public Row deserialize(DataInputStream dis, int version, boolean fromRemote) throws IOException {
        return new Row(StorageService.getPartitioner().decorateKey(ByteBufferUtil.readWithShortLength(dis)), ColumnFamily.serializer().deserialize(dis, false, fromRemote));
    }

    @Override
    public Row deserialize(DataInputStream dis, int version) throws IOException {
        return this.deserialize(dis, version, false);
    }
}

