/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Arrays;
import org.apache.cassandra.db.RangeSliceCommandSerializer;
import org.apache.cassandra.dht.AbstractBounds;
import org.apache.cassandra.io.util.DataOutputBuffer;
import org.apache.cassandra.net.Message;
import org.apache.cassandra.net.MessageProducer;
import org.apache.cassandra.service.IReadCommand;
import org.apache.cassandra.service.StorageService;
import org.apache.cassandra.thrift.ColumnParent;
import org.apache.cassandra.thrift.SlicePredicate;
import org.apache.cassandra.utils.FBUtilities;

public class RangeSliceCommand
implements MessageProducer,
IReadCommand {
    private static final RangeSliceCommandSerializer serializer = new RangeSliceCommandSerializer();
    public final String keyspace;
    public final String column_family;
    public final ByteBuffer super_column;
    public final SlicePredicate predicate;
    public final AbstractBounds range;
    public final int max_keys;

    public RangeSliceCommand(String keyspace, ColumnParent column_parent, SlicePredicate predicate, AbstractBounds range, int max_keys) {
        this(keyspace, column_parent.getColumn_family(), column_parent.super_column, predicate, range, max_keys);
    }

    public RangeSliceCommand(String keyspace, String column_family, ByteBuffer super_column, SlicePredicate predicate, AbstractBounds range, int max_keys) {
        this.keyspace = keyspace;
        this.column_family = column_family;
        this.super_column = super_column;
        this.predicate = predicate;
        this.range = range;
        this.max_keys = max_keys;
    }

    @Override
    public Message getMessage(Integer version) throws IOException {
        DataOutputBuffer dob = new DataOutputBuffer();
        serializer.serialize(this, (DataOutputStream)dob, (int)version);
        return new Message(FBUtilities.getLocalAddress(), StorageService.Verb.RANGE_SLICE, Arrays.copyOf(dob.getData(), dob.getLength()), version);
    }

    public String toString() {
        return "RangeSliceCommand{keyspace='" + this.keyspace + '\'' + ", column_family='" + this.column_family + '\'' + ", super_column=" + this.super_column + ", predicate=" + this.predicate + ", range=" + this.range + ", max_keys=" + this.max_keys + '}';
    }

    public static RangeSliceCommand read(Message message) throws IOException {
        byte[] bytes = message.getMessageBody();
        ByteArrayInputStream bis = new ByteArrayInputStream(bytes);
        return serializer.deserialize(new DataInputStream(bis), message.getVersion());
    }

    @Override
    public String getKeyspace() {
        return this.keyspace;
    }
}

