/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db;

import com.google.common.collect.Iterators;
import com.google.common.collect.PeekingIterator;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentNavigableMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.cassandra.concurrent.DebuggableThreadPoolExecutor;
import org.apache.cassandra.db.Column;
import org.apache.cassandra.db.ColumnFamily;
import org.apache.cassandra.db.ColumnFamilyStore;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.IColumn;
import org.apache.cassandra.db.IFlushable;
import org.apache.cassandra.db.SuperColumn;
import org.apache.cassandra.db.columniterator.IColumnIterator;
import org.apache.cassandra.db.columniterator.SimpleAbstractColumnIterator;
import org.apache.cassandra.db.commitlog.ReplayPosition;
import org.apache.cassandra.db.filter.AbstractColumnIterator;
import org.apache.cassandra.db.filter.NamesQueryFilter;
import org.apache.cassandra.db.filter.SliceQueryFilter;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.io.sstable.SSTableReader;
import org.apache.cassandra.io.sstable.SSTableWriter;
import org.apache.cassandra.utils.WrappedRunnable;
import org.github.jamm.MemoryMeter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Memtable
implements Comparable<Memtable>,
IFlushable {
    private static final Logger logger = LoggerFactory.getLogger(Memtable.class);
    private static final double MIN_SANE_LIVE_RATIO = 1.0;
    private static final double MAX_SANE_LIVE_RATIO = 64.0;
    private static final MemoryMeter meter = new MemoryMeter();
    private static final ExecutorService meterExecutor = new ThreadPoolExecutor(1, 1, (long)Integer.MAX_VALUE, TimeUnit.MILLISECONDS, (BlockingQueue)new SynchronousQueue()){

        @Override
        protected void afterExecute(Runnable r, Throwable t) {
            super.afterExecute(r, t);
            DebuggableThreadPoolExecutor.logExceptionsAfterExecute(r, t);
        }
    };
    private volatile boolean isFrozen;
    private final AtomicLong currentThroughput = new AtomicLong(0L);
    private final AtomicLong currentOperations = new AtomicLong(0L);
    private final long creationTime;
    private final ConcurrentNavigableMap<DecoratedKey, ColumnFamily> columnFamilies = new ConcurrentSkipListMap<DecoratedKey, ColumnFamily>();
    public final ColumnFamilyStore cfs;
    private final long THRESHOLD;
    private final long THRESHOLD_COUNT;
    static volatile Memtable activelyMeasuring;

    public Memtable(ColumnFamilyStore cfs) {
        this.cfs = cfs;
        this.creationTime = System.currentTimeMillis();
        this.THRESHOLD = (long)cfs.getMemtableThroughputInMB() * 1024L * 1024L;
        this.THRESHOLD_COUNT = (long)(cfs.getMemtableOperationsInMillions() * 1024.0 * 1024.0);
    }

    @Override
    public int compareTo(Memtable rhs) {
        long diff = this.creationTime - rhs.creationTime;
        if (diff > 0L) {
            return 1;
        }
        if (diff < 0L) {
            return -1;
        }
        return 0;
    }

    public long getLiveSize() {
        return (long)((double)this.currentThroughput.get() * this.cfs.liveRatio * 1.25);
    }

    public long getSerializedSize() {
        return this.currentThroughput.get();
    }

    public long getOperations() {
        return this.currentOperations.get();
    }

    boolean isThresholdViolated() {
        return this.currentThroughput.get() >= this.THRESHOLD || this.currentOperations.get() >= this.THRESHOLD_COUNT;
    }

    boolean isFrozen() {
        return this.isFrozen;
    }

    void freeze() {
        this.isFrozen = true;
    }

    void put(DecoratedKey key, ColumnFamily columnFamily) {
        assert (!this.isFrozen);
        this.resolve(key, columnFamily);
    }

    public void updateLiveRatio() {
        if (!MemoryMeter.isInitialized()) {
            logger.warn("MemoryMeter uninitialized (jamm not specified as java agent); assuming liveRatio of 10.0.  Usually this means cassandra-env.sh disabled jamm because you are using a buggy JRE; upgrade to the Sun JRE instead");
            this.cfs.liveRatio = 10.0;
            return;
        }
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                activelyMeasuring = Memtable.this;
                long start = System.currentTimeMillis();
                long deepSize = meter.measure((Object)Memtable.this.columnFamilies);
                int objects = 0;
                for (Map.Entry entry : Memtable.this.columnFamilies.entrySet()) {
                    deepSize += meter.measureDeep(entry.getKey()) + meter.measureDeep(entry.getValue());
                    objects += ((ColumnFamily)entry.getValue()).getColumnCount();
                }
                double newRatio = (double)deepSize / (double)Memtable.this.currentThroughput.get();
                if (newRatio < 1.0) {
                    logger.warn("setting live ratio to minimum of 1.0 instead of {}", (Object)newRatio);
                    newRatio = 1.0;
                }
                if (newRatio > 64.0) {
                    logger.warn("setting live ratio to maximum of 64 instead of {}", (Object)newRatio);
                    newRatio = 64.0;
                }
                Memtable.this.cfs.liveRatio = Math.max(Memtable.this.cfs.liveRatio, newRatio);
                logger.info("{} liveRatio is {} (just-counted was {}).  calculation took {}ms for {} columns", new Object[]{Memtable.this.cfs, Memtable.this.cfs.liveRatio, newRatio, System.currentTimeMillis() - start, objects});
                activelyMeasuring = null;
            }
        };
        try {
            meterExecutor.submit(runnable);
        }
        catch (RejectedExecutionException e) {
            logger.debug("Meter thread is busy; skipping liveRatio update for {}", (Object)this.cfs);
        }
    }

    private void resolve(DecoratedKey key, ColumnFamily cf) {
        this.currentThroughput.addAndGet(cf.size());
        this.currentOperations.addAndGet(cf.getColumnCount() == 0 ? (cf.isMarkedForDelete() ? 1L : 0L) : (long)cf.getColumnCount());
        ColumnFamily oldCf = this.columnFamilies.putIfAbsent(key, cf);
        if (oldCf == null) {
            return;
        }
        oldCf.resolve(cf);
    }

    public String contents() {
        StringBuilder builder = new StringBuilder();
        builder.append("{");
        for (Map.Entry entry : this.columnFamilies.entrySet()) {
            builder.append(entry.getKey()).append(": ").append(entry.getValue()).append(", ");
        }
        builder.append("}");
        return builder.toString();
    }

    private SSTableReader writeSortedContents(ReplayPosition context) throws IOException {
        logger.info("Writing " + this);
        long keySize = 0L;
        for (DecoratedKey key : this.columnFamilies.keySet()) {
            keySize += (long)key.key.remaining();
        }
        long estimatedSize = (long)((double)(keySize + keySize + this.currentThroughput.get()) * 1.2);
        SSTableWriter writer = this.cfs.createFlushWriter(this.columnFamilies.size(), estimatedSize, context);
        for (Map.Entry entry : this.columnFamilies.entrySet()) {
            writer.append((DecoratedKey)entry.getKey(), (ColumnFamily)entry.getValue());
        }
        SSTableReader ssTable = writer.closeAndOpenReader();
        logger.info(String.format("Completed flushing %s (%d bytes)", ssTable.getFilename(), new File(ssTable.getFilename()).length()));
        return ssTable;
    }

    @Override
    public void flushAndSignal(final CountDownLatch latch, ExecutorService sorter, ExecutorService writer, final ReplayPosition context) {
        writer.execute(new WrappedRunnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void runMayThrow() throws IOException {
                Memtable.this.cfs.flushLock.lock();
                try {
                    if (!Memtable.this.cfs.isDropped()) {
                        SSTableReader sstable = Memtable.this.writeSortedContents(context);
                        Memtable.this.cfs.replaceFlushed(Memtable.this, sstable);
                    }
                }
                finally {
                    Memtable.this.cfs.flushLock.unlock();
                }
                latch.countDown();
            }
        });
    }

    public String toString() {
        return String.format("Memtable-%s@%s(%s/%s serialized/live bytes, %s ops)", this.cfs.getColumnFamilyName(), this.hashCode(), this.currentThroughput, this.getLiveSize(), this.currentOperations);
    }

    public Iterator<Map.Entry<DecoratedKey, ColumnFamily>> getEntryIterator(DecoratedKey startWith) {
        return this.columnFamilies.tailMap((Object)startWith).entrySet().iterator();
    }

    public boolean isClean() {
        return this.columnFamilies.isEmpty();
    }

    public String getTableName() {
        return this.cfs.table.name;
    }

    public static IColumnIterator getSliceIterator(final DecoratedKey key, final ColumnFamily cf, SliceQueryFilter filter, AbstractType typeComparator) {
        assert (cf != null);
        boolean isSuper = cf.isSuper();
        Collection<IColumn> filteredColumns = filter.reversed ? cf.getReverseSortedColumns() : cf.getSortedColumns();
        IColumn startColumn = isSuper ? new SuperColumn(filter.start, (AbstractType)null) : new Column(filter.start);
        Comparator<IColumn> comparator = filter.getColumnComparator(typeComparator);
        final PeekingIterator filteredIter = Iterators.peekingIterator(filteredColumns.iterator());
        if (!filter.reversed || filter.start.remaining() != 0) {
            while (filteredIter.hasNext() && comparator.compare((IColumn)filteredIter.peek(), startColumn) < 0) {
                filteredIter.next();
            }
        }
        return new AbstractColumnIterator(){

            @Override
            public ColumnFamily getColumnFamily() {
                return cf;
            }

            @Override
            public DecoratedKey getKey() {
                return key;
            }

            @Override
            public boolean hasNext() {
                return filteredIter.hasNext();
            }

            @Override
            public IColumn next() {
                return (IColumn)filteredIter.next();
            }
        };
    }

    public static IColumnIterator getNamesIterator(final DecoratedKey key, final ColumnFamily cf, final NamesQueryFilter filter) {
        assert (cf != null);
        final boolean isStandard = !cf.isSuper();
        return new SimpleAbstractColumnIterator(){
            private Iterator<ByteBuffer> iter;
            {
                this.iter = filter.columns.iterator();
            }

            @Override
            public ColumnFamily getColumnFamily() {
                return cf;
            }

            @Override
            public DecoratedKey getKey() {
                return key;
            }

            protected IColumn computeNext() {
                while (this.iter.hasNext()) {
                    ByteBuffer current = this.iter.next();
                    IColumn column = cf.getColumn(current);
                    if (column == null) continue;
                    return isStandard ? column : ((SuperColumn)column).cloneMe();
                }
                return (IColumn)this.endOfData();
            }
        };
    }

    public ColumnFamily getColumnFamily(DecoratedKey key) {
        return (ColumnFamily)this.columnFamilies.get(key);
    }

    void clearUnsafe() {
        this.columnFamilies.clear();
    }

    public boolean isExpired() {
        return System.currentTimeMillis() > this.creationTime + (long)(this.cfs.getMemtableFlushAfterMins() * 60) * 1000L;
    }

    public long creationTime() {
        return this.creationTime;
    }
}

