/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.config;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.avro.util.Utf8;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.config.ConfigurationException;
import org.apache.cassandra.db.migration.avro.KsDef;
import org.apache.cassandra.io.SerDeUtils;
import org.apache.cassandra.locator.AbstractReplicationStrategy;
import org.apache.cassandra.locator.LocalStrategy;
import org.apache.cassandra.locator.NetworkTopologyStrategy;
import org.apache.cassandra.thrift.CfDef;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.lang.StringUtils;

public final class KSMetaData {
    public final String name;
    public final Class<? extends AbstractReplicationStrategy> strategyClass;
    public final Map<String, String> strategyOptions;
    private final Map<String, CFMetaData> cfMetaData;
    public final boolean durableWrites;

    private KSMetaData(String name, Class<? extends AbstractReplicationStrategy> strategyClass, Map<String, String> strategyOptions, boolean durableWrites, Iterable<CFMetaData> cfDefs) {
        this.name = name;
        this.strategyClass = strategyClass == null ? NetworkTopologyStrategy.class : strategyClass;
        this.strategyOptions = strategyOptions;
        HashMap<String, CFMetaData> cfmap = new HashMap<String, CFMetaData>();
        for (CFMetaData cfm : cfDefs) {
            cfmap.put(cfm.cfName, cfm);
        }
        this.cfMetaData = Collections.unmodifiableMap(cfmap);
        this.durableWrites = durableWrites;
    }

    public static KSMetaData cloneWith(KSMetaData ksm, Iterable<CFMetaData> cfDefs) {
        return new KSMetaData(ksm.name, ksm.strategyClass, ksm.strategyOptions, ksm.durableWrites, cfDefs);
    }

    public static KSMetaData systemKeyspace() {
        List<CFMetaData> cfDefs = Arrays.asList(CFMetaData.StatusCf, CFMetaData.HintsCf, CFMetaData.MigrationsCf, CFMetaData.SchemaCf, CFMetaData.IndexCf, CFMetaData.NodeIdCf);
        return new KSMetaData("system", LocalStrategy.class, KSMetaData.optsWithRF(1), true, cfDefs);
    }

    public static KSMetaData testMetadata(String name, Class<? extends AbstractReplicationStrategy> strategyClass, Map<String, String> strategyOptions, CFMetaData ... cfDefs) {
        return new KSMetaData(name, strategyClass, strategyOptions, true, Arrays.asList(cfDefs));
    }

    public static KSMetaData testMetadataNotDurable(String name, Class<? extends AbstractReplicationStrategy> strategyClass, Map<String, String> strategyOptions, CFMetaData ... cfDefs) {
        return new KSMetaData(name, strategyClass, strategyOptions, false, Arrays.asList(cfDefs));
    }

    public static Map<String, String> forwardsCompatibleOptions(org.apache.cassandra.thrift.KsDef ks_def) {
        HashMap<String, String> options = ks_def.strategy_options == null ? new HashMap<String, String>() : new HashMap(ks_def.strategy_options);
        KSMetaData.maybeAddReplicationFactor(options, ks_def.strategy_class, ks_def.isSetReplication_factor() ? Integer.valueOf(ks_def.replication_factor) : null);
        return options;
    }

    private static void maybeAddReplicationFactor(Map<String, String> options, String cls, Integer rf) {
        if (rf != null && (cls.endsWith("SimpleStrategy") || cls.endsWith("OldNetworkTopologyStrategy"))) {
            options.put("replication_factor", rf.toString());
        }
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof KSMetaData)) {
            return false;
        }
        KSMetaData other = (KSMetaData)obj;
        return other.name.equals(this.name) && ObjectUtils.equals(other.strategyClass, this.strategyClass) && ObjectUtils.equals(other.strategyOptions, this.strategyOptions) && other.cfMetaData.size() == this.cfMetaData.size() && ((Object)other.cfMetaData).equals(this.cfMetaData) && other.durableWrites == this.durableWrites;
    }

    public Map<String, CFMetaData> cfMetaData() {
        return this.cfMetaData;
    }

    public KsDef deflate() {
        KsDef ks = new KsDef();
        ks.name = new Utf8(this.name);
        ks.strategy_class = new Utf8(this.strategyClass.getName());
        if (this.strategyOptions != null) {
            ks.strategy_options = new HashMap<CharSequence, CharSequence>();
            for (Map.Entry entry : this.strategyOptions.entrySet()) {
                ks.strategy_options.put((CharSequence)new Utf8((String)entry.getKey()), (CharSequence)new Utf8((String)entry.getValue()));
            }
        }
        ks.cf_defs = SerDeUtils.createArray(this.cfMetaData.size(), org.apache.cassandra.db.migration.avro.CfDef.SCHEMA$);
        for (CFMetaData cFMetaData : this.cfMetaData.values()) {
            ks.cf_defs.add(cFMetaData.deflate());
        }
        ks.durable_writes = this.durableWrites;
        return ks;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.name).append(", rep strategy:").append(this.strategyClass.getSimpleName()).append("{").append(StringUtils.join(this.cfMetaData.values(), (String)", ")).append("}").append(", durable_writes: ").append(this.durableWrites);
        return sb.toString();
    }

    public static KSMetaData inflate(KsDef ks) {
        Class<?> repStratClass;
        try {
            String strategyClassName = KSMetaData.convertOldStrategyName(((Object)ks.strategy_class).toString());
            repStratClass = Class.forName(strategyClassName);
        }
        catch (Exception ex) {
            throw new RuntimeException("Could not create ReplicationStrategy of type " + ks.strategy_class, ex);
        }
        HashMap<String, String> strategyOptions = new HashMap<String, String>();
        if (ks.strategy_options != null) {
            for (Map.Entry<CharSequence, CharSequence> e : ks.strategy_options.entrySet()) {
                String name = ((Object)e.getKey()).toString();
                if (repStratClass == NetworkTopologyStrategy.class && name.trim().toLowerCase().equals("replication_factor")) continue;
                strategyOptions.put(name, ((Object)e.getValue()).toString());
            }
        }
        KSMetaData.maybeAddReplicationFactor(strategyOptions, ((Object)ks.strategy_class).toString(), ks.replication_factor);
        int cfsz = ks.cf_defs.size();
        ArrayList<CFMetaData> cfMetaData = new ArrayList<CFMetaData>(cfsz);
        Iterator<org.apache.cassandra.db.migration.avro.CfDef> cfiter = ks.cf_defs.iterator();
        for (int i = 0; i < cfsz; ++i) {
            cfMetaData.add(CFMetaData.inflate(cfiter.next()));
        }
        return new KSMetaData(((Object)ks.name).toString(), repStratClass, strategyOptions, ks.durable_writes, cfMetaData);
    }

    public static String convertOldStrategyName(String name) {
        return name.replace("RackUnawareStrategy", "SimpleStrategy").replace("RackAwareStrategy", "OldNetworkTopologyStrategy");
    }

    public static Map<String, String> optsWithRF(Integer rf) {
        HashMap<String, String> ret = new HashMap<String, String>();
        ret.put("replication_factor", rf.toString());
        return ret;
    }

    public static KSMetaData fromThrift(org.apache.cassandra.thrift.KsDef ksd, CFMetaData ... cfDefs) throws ConfigurationException {
        return new KSMetaData(ksd.name, AbstractReplicationStrategy.getClass(ksd.strategy_class), KSMetaData.forwardsCompatibleOptions(ksd), ksd.durable_writes, Arrays.asList(cfDefs));
    }

    public static org.apache.cassandra.thrift.KsDef toThrift(KSMetaData ksm) {
        ArrayList<CfDef> cfDefs = new ArrayList<CfDef>();
        for (CFMetaData cfm : ksm.cfMetaData().values()) {
            cfDefs.add(CFMetaData.convertToThrift(cfm));
        }
        org.apache.cassandra.thrift.KsDef ksdef = new org.apache.cassandra.thrift.KsDef(ksm.name, ksm.strategyClass.getName(), cfDefs);
        ksdef.setStrategy_options(ksm.strategyOptions);
        if (ksm.strategyOptions != null && ksm.strategyOptions.containsKey("replication_factor")) {
            ksdef.setReplication_factor(Integer.parseInt(ksm.strategyOptions.get("replication_factor")));
        }
        ksdef.setDurable_writes(ksm.durableWrites);
        return ksdef;
    }
}

