/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.thrift;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.apache.cassandra.concurrent.JMXEnabledThreadPoolExecutor;
import org.apache.cassandra.concurrent.NamedThreadFactory;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.service.AbstractCassandraDaemon;
import org.apache.cassandra.thrift.Cassandra;
import org.apache.cassandra.thrift.CassandraServer;
import org.apache.cassandra.thrift.CustomTHsHaServer;
import org.apache.cassandra.thrift.CustomTNonBlockingServer;
import org.apache.cassandra.thrift.CustomTThreadPoolServer;
import org.apache.cassandra.thrift.TBinaryProtocol;
import org.apache.cassandra.thrift.TCustomNonblockingServerSocket;
import org.apache.cassandra.thrift.TCustomServerSocket;
import org.apache.thrift.TProcessor;
import org.apache.thrift.protocol.TProtocolFactory;
import org.apache.thrift.server.TNonblockingServer;
import org.apache.thrift.server.TServer;
import org.apache.thrift.server.TThreadPoolServer;
import org.apache.thrift.transport.TFramedTransport;
import org.apache.thrift.transport.TNonblockingServerTransport;
import org.apache.thrift.transport.TServerTransport;
import org.apache.thrift.transport.TTransportException;
import org.apache.thrift.transport.TTransportFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CassandraDaemon
extends AbstractCassandraDaemon {
    private static Logger logger;
    private static final String SYNC = "sync";
    private static final String ASYNC = "async";
    private static final String HSHA = "hsha";
    public static final List<String> rpc_server_types;
    private ThriftServer server;

    @Override
    protected void startServer() {
        if (this.server == null) {
            this.server = new ThriftServer(this.listenAddr, this.listenPort);
            this.server.start();
        }
    }

    @Override
    protected void stopServer() {
        if (this.server != null) {
            this.server.stopServer();
            try {
                this.server.join();
            }
            catch (InterruptedException e) {
                logger.error("Interrupted while waiting thrift server to stop", (Throwable)e);
            }
            this.server = null;
        }
    }

    public static void main(String[] args) {
        new CassandraDaemon().activate();
    }

    static {
        AbstractCassandraDaemon.initLog4j();
        logger = LoggerFactory.getLogger(CassandraDaemon.class);
        rpc_server_types = Arrays.asList(SYNC, ASYNC, HSHA);
    }

    private static class ThriftServer
    extends Thread {
        private TServer serverEngine;

        public ThriftServer(InetAddress listenAddr, int listenPort) {
            CassandraServer cassandraServer = new CassandraServer();
            Cassandra.Processor processor = new Cassandra.Processor((Cassandra.Iface)cassandraServer);
            logger.info(String.format("Binding thrift service to %s:%s", listenAddr, listenPort));
            TBinaryProtocol.Factory tProtocolFactory = new TBinaryProtocol.Factory(true, true, DatabaseDescriptor.getThriftMaxMessageLength());
            int tFramedTransportSize = DatabaseDescriptor.getThriftFramedTransportSize();
            TFramedTransport.Factory inTransportFactory = new TFramedTransport.Factory(tFramedTransportSize);
            TFramedTransport.Factory outTransportFactory = new TFramedTransport.Factory(tFramedTransportSize);
            logger.info("Using TFastFramedTransport with a max frame size of {} bytes.", (Object)tFramedTransportSize);
            if (DatabaseDescriptor.getRpcServerType().equalsIgnoreCase(CassandraDaemon.SYNC)) {
                TCustomServerSocket serverTransport;
                try {
                    serverTransport = new TCustomServerSocket(new InetSocketAddress(listenAddr, listenPort), DatabaseDescriptor.getRpcKeepAlive(), DatabaseDescriptor.getRpcSendBufferSize(), DatabaseDescriptor.getRpcRecvBufferSize());
                }
                catch (TTransportException e) {
                    throw new RuntimeException(String.format("Unable to create thrift socket to %s:%s", listenAddr, listenPort), e);
                }
                TThreadPoolServer.Args serverArgs = (TThreadPoolServer.Args)((TThreadPoolServer.Args)((TThreadPoolServer.Args)((TThreadPoolServer.Args)((TThreadPoolServer.Args)new TThreadPoolServer.Args((TServerTransport)serverTransport).minWorkerThreads(DatabaseDescriptor.getRpcMinThreads().intValue()).maxWorkerThreads(DatabaseDescriptor.getRpcMaxThreads().intValue()).inputTransportFactory((TTransportFactory)inTransportFactory)).outputTransportFactory((TTransportFactory)outTransportFactory)).inputProtocolFactory((TProtocolFactory)tProtocolFactory)).outputProtocolFactory((TProtocolFactory)tProtocolFactory)).processor((TProcessor)processor);
                AbstractCassandraDaemon.CleaningThreadPool executorService = new AbstractCassandraDaemon.CleaningThreadPool(cassandraServer.clientState, serverArgs.minWorkerThreads, serverArgs.maxWorkerThreads);
                this.serverEngine = new CustomTThreadPoolServer(serverArgs, executorService);
                logger.info(String.format("Using synchronous/threadpool thrift server on %s : %s", listenAddr, listenPort));
            } else {
                TCustomNonblockingServerSocket serverTransport;
                try {
                    serverTransport = new TCustomNonblockingServerSocket(new InetSocketAddress(listenAddr, listenPort), DatabaseDescriptor.getRpcKeepAlive(), DatabaseDescriptor.getRpcSendBufferSize(), DatabaseDescriptor.getRpcRecvBufferSize());
                }
                catch (TTransportException e) {
                    throw new RuntimeException(String.format("Unable to create thrift socket to %s:%s", listenAddr, listenPort), e);
                }
                if (DatabaseDescriptor.getRpcServerType().equalsIgnoreCase(CassandraDaemon.ASYNC)) {
                    TNonblockingServer.Args serverArgs = (TNonblockingServer.Args)((TNonblockingServer.Args)((TNonblockingServer.Args)((TNonblockingServer.Args)((TNonblockingServer.Args)new TNonblockingServer.Args((TNonblockingServerTransport)serverTransport).inputTransportFactory((TTransportFactory)inTransportFactory)).outputTransportFactory((TTransportFactory)outTransportFactory)).inputProtocolFactory((TProtocolFactory)tProtocolFactory)).outputProtocolFactory((TProtocolFactory)tProtocolFactory)).processor((TProcessor)processor);
                    logger.info(String.format("Using non-blocking/asynchronous thrift server on %s : %s", listenAddr, listenPort));
                    this.serverEngine = new CustomTNonBlockingServer(serverArgs);
                } else if (DatabaseDescriptor.getRpcServerType().equalsIgnoreCase(CassandraDaemon.HSHA)) {
                    JMXEnabledThreadPoolExecutor executorService = new JMXEnabledThreadPoolExecutor((int)DatabaseDescriptor.getRpcMinThreads(), (int)DatabaseDescriptor.getRpcMaxThreads(), DatabaseDescriptor.getRpcTimeout(), TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), new NamedThreadFactory("RPC-Thread"), "RPC-THREAD-POOL");
                    TNonblockingServer.Args serverArgs = (TNonblockingServer.Args)((TNonblockingServer.Args)((TNonblockingServer.Args)((TNonblockingServer.Args)((TNonblockingServer.Args)new TNonblockingServer.Args((TNonblockingServerTransport)serverTransport).inputTransportFactory((TTransportFactory)inTransportFactory)).outputTransportFactory((TTransportFactory)outTransportFactory)).inputProtocolFactory((TProtocolFactory)tProtocolFactory)).outputProtocolFactory((TProtocolFactory)tProtocolFactory)).processor((TProcessor)processor);
                    logger.info(String.format("Using custom half-sync/half-async thrift server on %s : %s", listenAddr, listenPort));
                    this.serverEngine = new CustomTHsHaServer(serverArgs, executorService, Runtime.getRuntime().availableProcessors());
                }
            }
        }

        @Override
        public void run() {
            logger.info("Listening for thrift clients...");
            this.serverEngine.serve();
        }

        public void stopServer() {
            logger.info("Stop listening to thrift clients");
            this.serverEngine.stop();
        }
    }
}

