/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.utils;

import java.nio.ByteBuffer;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.cassandra.db.CounterColumn;
import org.apache.cassandra.db.SystemTable;
import org.apache.cassandra.utils.ByteBufferUtil;
import org.apache.cassandra.utils.FBUtilities;
import org.apache.cassandra.utils.UUIDGen;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NodeId
implements Comparable<NodeId> {
    private static final Logger logger = LoggerFactory.getLogger(NodeId.class);
    public static final int LENGTH = 16;
    private ByteBuffer id;

    private static LocalNodeIdHistory localIds() {
        return LocalIds.instance;
    }

    public static NodeId getLocalId() {
        return (NodeId)NodeId.localIds().current.get();
    }

    public static synchronized void renewLocalId() {
        NodeId.localIds().renewCurrent();
    }

    public static List<NodeIdRecord> getOldLocalNodeIds() {
        return NodeId.localIds().olds;
    }

    public static NodeId fromInt(int n) {
        long lowBits = 0xC000000000000000L | (long)n;
        return new NodeId(ByteBuffer.allocate(16).putLong(0, 0L).putLong(8, lowBits));
    }

    public static NodeId wrap(ByteBuffer id) {
        return new NodeId(id);
    }

    public static NodeId wrap(ByteBuffer bb, int offset) {
        ByteBuffer dup = bb.duplicate();
        dup.position(offset);
        dup.limit(dup.position() + 16);
        return NodeId.wrap(dup);
    }

    private NodeId(ByteBuffer id) {
        if (id.remaining() != 16) {
            throw new IllegalArgumentException("A NodeId representation is exactly 16 bytes");
        }
        this.id = id;
    }

    public static NodeId generate() {
        return new NodeId(ByteBuffer.wrap(UUIDGen.decompose(UUIDGen.makeType1UUIDFromHost(FBUtilities.getLocalAddress()))));
    }

    public ByteBuffer bytes() {
        return this.id;
    }

    public boolean isLocalId() {
        return this.equals(NodeId.getLocalId());
    }

    @Override
    public int compareTo(NodeId o) {
        return ByteBufferUtil.compareSubArrays(this.id, this.id.position(), o.id, o.id.position(), 16);
    }

    public String toString() {
        return UUIDGen.getUUID(this.id).toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NodeId otherId = (NodeId)o;
        return this.id.equals(otherId.id);
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public static class NodeIdRecord {
        public final NodeId id;
        public final long timestamp;

        public NodeIdRecord(NodeId id, long timestamp) {
            this.id = id;
            this.timestamp = timestamp;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            NodeIdRecord otherRecord = (NodeIdRecord)o;
            return this.id.equals(otherRecord.id) && this.timestamp == otherRecord.timestamp;
        }

        public String toString() {
            return String.format("(%s, %d)", this.id.toString(), this.timestamp);
        }
    }

    private static class LocalNodeIdHistory {
        private final AtomicReference<NodeId> current;
        private final List<NodeIdRecord> olds;

        LocalNodeIdHistory() {
            NodeId id = SystemTable.getCurrentLocalNodeId();
            if (id == null) {
                id = NodeId.generate();
                logger.info("No saved local node id, using newly generated: {}", (Object)id);
                SystemTable.writeCurrentLocalNodeId(null, id, System.currentTimeMillis());
                this.current = new AtomicReference<NodeId>(id);
                this.olds = new CopyOnWriteArrayList<NodeIdRecord>();
            } else {
                logger.info("Saved local node id: {}", (Object)id);
                this.current = new AtomicReference<NodeId>(id);
                this.olds = new CopyOnWriteArrayList<NodeIdRecord>(SystemTable.getOldLocalNodeIds());
            }
        }

        synchronized void renewCurrent() {
            long now = System.currentTimeMillis();
            NodeId newNodeId = NodeId.generate();
            NodeId old = this.current.get();
            SystemTable.writeCurrentLocalNodeId(old, newNodeId, now);
            this.current.set(newNodeId);
            this.olds.add(new NodeIdRecord(old, now));
        }
    }

    public static class OneShotRenewer {
        private boolean renewed = false;
        private final NodeId initialId = NodeId.getLocalId();

        public void maybeRenew(CounterColumn column) {
            if (!this.renewed && column.hasNodeId(this.initialId)) {
                NodeId.renewLocalId();
                this.renewed = true;
            }
        }
    }

    private static class LocalIds {
        static final LocalNodeIdHistory instance = new LocalNodeIdHistory();

        private LocalIds() {
        }
    }
}

