/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.locator;

import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.cassandra.locator.AbstractEndpointSnitch;

public abstract class AbstractNetworkTopologySnitch
extends AbstractEndpointSnitch {
    @Override
    public abstract String getRack(InetAddress var1);

    @Override
    public abstract String getDatacenter(InetAddress var1);

    @Override
    public List<InetAddress> getSortedListByProximity(InetAddress address, Collection<InetAddress> addresses) {
        ArrayList<InetAddress> preferred = new ArrayList<InetAddress>(addresses);
        this.sortByProximity(address, preferred);
        return preferred;
    }

    @Override
    public void sortByProximity(final InetAddress address, List<InetAddress> addresses) {
        Collections.sort(addresses, new Comparator<InetAddress>(){

            @Override
            public int compare(InetAddress a1, InetAddress a2) {
                return AbstractNetworkTopologySnitch.this.compareEndpoints(address, a1, a2);
            }
        });
    }

    @Override
    public int compareEndpoints(InetAddress address, InetAddress a1, InetAddress a2) {
        if (address.equals(a1) && !address.equals(a2)) {
            return -1;
        }
        if (address.equals(a2) && !address.equals(a1)) {
            return 1;
        }
        String addressDatacenter = this.getDatacenter(address);
        String a1Datacenter = this.getDatacenter(a1);
        String a2Datacenter = this.getDatacenter(a2);
        if (addressDatacenter.equals(a1Datacenter) && !addressDatacenter.equals(a2Datacenter)) {
            return -1;
        }
        if (addressDatacenter.equals(a2Datacenter) && !addressDatacenter.equals(a1Datacenter)) {
            return 1;
        }
        String addressRack = this.getRack(address);
        String a1Rack = this.getRack(a1);
        String a2Rack = this.getRack(a2);
        if (addressRack.equals(a1Rack) && !addressRack.equals(a2Rack)) {
            return -1;
        }
        if (addressRack.equals(a2Rack) && !addressRack.equals(a1Rack)) {
            return 1;
        }
        return 0;
    }
}

