/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cql;

import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.config.ConfigurationException;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.config.KSMetaData;
import org.apache.cassandra.db.migration.UpdateColumnFamily;
import org.apache.cassandra.db.migration.avro.CfDef;
import org.apache.cassandra.db.migration.avro.ColumnDef;
import org.apache.cassandra.thrift.InvalidRequestException;

public class DropIndexStatement {
    public final String index;

    public DropIndexStatement(String indexName) {
        this.index = indexName;
    }

    public UpdateColumnFamily generateMutation(String keyspace) throws InvalidRequestException, ConfigurationException, IOException {
        Map.Entry<String, CFMetaData> cf;
        CFMetaData cfm;
        CfDef cfDef = null;
        KSMetaData ksm = DatabaseDescriptor.getTableDefinition(keyspace);
        Iterator<Map.Entry<String, CFMetaData>> i$ = ksm.cfMetaData().entrySet().iterator();
        while (i$.hasNext() && (cfDef = this.getUpdatedCFDef(CFMetaData.convertToAvro(cfm = (cf = i$.next()).getValue()))) == null) {
        }
        if (cfDef == null) {
            throw new InvalidRequestException("Index '" + this.index + "' could not be found in any of the ColumnFamilies of keyspace '" + keyspace + "'");
        }
        return new UpdateColumnFamily(cfDef);
    }

    private CfDef getUpdatedCFDef(CfDef cfDef) throws InvalidRequestException {
        boolean foundColumn = false;
        for (ColumnDef column : cfDef.column_metadata) {
            if (column.index_type == null || column.index_name == null || !column.index_name.equals(this.index)) continue;
            foundColumn = true;
            column.index_name = null;
            column.index_type = null;
        }
        return foundColumn ? cfDef : null;
    }
}

