/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cache;

import com.sun.jna.Memory;
import java.util.concurrent.atomic.AtomicInteger;

public class FreeableMemory
extends Memory {
    AtomicInteger references = new AtomicInteger(1);

    public FreeableMemory(long size) {
        super(size);
    }

    public boolean reference() {
        int n;
        do {
            if ((n = this.references.get()) > 0) continue;
            return false;
        } while (!this.references.compareAndSet(n, n + 1));
        return true;
    }

    public void unreference() {
        if (this.references.decrementAndGet() == 0) {
            this.free();
        }
    }

    private void free() {
        assert (this.peer != 0L);
        super.finalize();
    }

    protected void finalize() {
        assert (this.references.get() == 0);
        assert (this.peer == 0L);
    }

    public byte getValidByte(long offset) {
        assert (this.peer != 0L);
        return super.getByte(offset);
    }
}

