/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.service;

import com.google.common.collect.Multimap;
import java.net.InetAddress;
import java.util.Collection;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.net.Message;
import org.apache.cassandra.service.IWriteResponseHandler;
import org.apache.cassandra.thrift.ConsistencyLevel;
import org.apache.cassandra.thrift.UnavailableException;
import org.apache.cassandra.utils.SimpleCondition;

public abstract class AbstractWriteResponseHandler
implements IWriteResponseHandler {
    protected final SimpleCondition condition = new SimpleCondition();
    protected final long startTime = System.currentTimeMillis();
    protected final Collection<InetAddress> writeEndpoints;
    protected final Multimap<InetAddress, InetAddress> hintedEndpoints;
    protected final ConsistencyLevel consistencyLevel;

    protected AbstractWriteResponseHandler(Collection<InetAddress> writeEndpoints, Multimap<InetAddress, InetAddress> hintedEndpoints, ConsistencyLevel consistencyLevel) {
        this.consistencyLevel = consistencyLevel;
        this.hintedEndpoints = hintedEndpoints;
        this.writeEndpoints = writeEndpoints;
    }

    @Override
    public void get() throws TimeoutException {
        boolean success;
        long timeout = DatabaseDescriptor.getRpcTimeout() - (System.currentTimeMillis() - this.startTime);
        try {
            success = this.condition.await(timeout, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException ex) {
            throw new AssertionError((Object)ex);
        }
        if (!success) {
            throw new TimeoutException();
        }
    }

    @Override
    public abstract void response(Message var1);

    @Override
    public abstract void assureSufficientLiveNodes() throws UnavailableException;
}

