/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.io.sstable;

import java.io.File;
import java.io.IOException;
import java.util.Map;
import java.util.TreeMap;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.db.ColumnFamily;
import org.apache.cassandra.db.ColumnFamilyType;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.io.sstable.AbstractSSTableSimpleWriter;
import org.apache.cassandra.io.sstable.SSTableWriter;

public class SSTableSimpleUnsortedWriter
extends AbstractSSTableSimpleWriter {
    private final Map<DecoratedKey, ColumnFamily> keys = new TreeMap<DecoratedKey, ColumnFamily>();
    private final long bufferSize;
    private long currentSize;

    public SSTableSimpleUnsortedWriter(File directory, String keyspace, String columnFamily, AbstractType comparator, AbstractType subComparator, int bufferSizeInMB) throws IOException {
        super(directory, new CFMetaData(keyspace, columnFamily, subComparator == null ? ColumnFamilyType.Standard : ColumnFamilyType.Super, comparator, subComparator));
        this.bufferSize = (long)bufferSizeInMB * 1024L * 1024L;
    }

    @Override
    protected void writeRow(DecoratedKey key, ColumnFamily columnFamily) throws IOException {
        this.currentSize = (long)((double)this.currentSize + ((double)key.key.remaining() + (double)columnFamily.serializedSize() * 1.2));
        if (this.currentSize > this.bufferSize) {
            this.sync();
        }
    }

    @Override
    protected ColumnFamily getColumnFamily() {
        ColumnFamily previous = this.keys.get(this.currentKey);
        if (previous == null) {
            previous = ColumnFamily.create(this.metadata);
            this.keys.put(this.currentKey, previous);
        } else {
            this.currentSize = (long)((double)this.currentSize - ((double)this.currentKey.key.remaining() + (double)previous.serializedSize() * 1.2));
        }
        return previous;
    }

    @Override
    public void close() throws IOException {
        this.sync();
    }

    private void sync() throws IOException {
        if (this.keys.isEmpty()) {
            return;
        }
        SSTableWriter writer = this.getWriter();
        for (Map.Entry<DecoratedKey, ColumnFamily> entry : this.keys.entrySet()) {
            writer.append(entry.getKey(), entry.getValue());
        }
        writer.closeAndOpenReader();
        this.currentSize = 0L;
        this.keys.clear();
    }
}

