/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cql;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.cql.QueryProcessor;
import org.apache.cassandra.cql.Relation;
import org.apache.cassandra.cql.RelationType;
import org.apache.cassandra.cql.Term;
import org.apache.cassandra.utils.ByteBufferUtil;

public class WhereClause {
    private Set<Term> keys = new LinkedHashSet<Term>();
    private Term startKey;
    private Term finishKey;
    private List<Relation> columns = new ArrayList<Relation>();
    private boolean includeStartKey = false;
    private boolean includeFinishKey = false;
    private boolean multiKey = false;
    private String keyAlias = null;

    public WhereClause(Relation firstRelation) {
        this.and(firstRelation);
    }

    public WhereClause() {
    }

    public void and(Relation relation) {
        if (relation != null && relation.isKey()) {
            if (relation.operator().equals((Object)RelationType.EQ)) {
                this.keys.add(relation.getValue());
            } else if (relation.operator().equals((Object)RelationType.GT) || relation.operator().equals((Object)RelationType.GTE)) {
                this.startKey = relation.getValue();
                this.includeStartKey = relation.operator().equals((Object)RelationType.GTE);
            } else if (relation.operator().equals((Object)RelationType.LT) || relation.operator().equals((Object)RelationType.LTE)) {
                this.finishKey = relation.getValue();
                this.includeFinishKey = relation.operator().equals((Object)RelationType.LTE);
            }
        } else {
            this.columns.add(relation);
        }
    }

    public void andKeyEquals(Term key) {
        this.keys.add(key);
    }

    public List<Relation> getColumnRelations() {
        return this.columns;
    }

    public boolean isKeyRange() {
        return this.startKey != null;
    }

    public Term getStartKey() {
        return this.startKey;
    }

    public Term getFinishKey() {
        return this.finishKey;
    }

    public Set<Term> getKeys() {
        return this.keys;
    }

    public boolean includeStartKey() {
        return this.includeStartKey;
    }

    public boolean includeFinishKey() {
        return this.includeFinishKey;
    }

    public void setKeyAlias(String alias) {
        this.keyAlias = alias.toUpperCase();
    }

    public boolean isMultiKey() {
        return this.multiKey;
    }

    public void setMultiKey(boolean multiKey) {
        this.multiKey = multiKey;
    }

    public String getKeyAlias() {
        return this.keyAlias == null ? QueryProcessor.DEFAULT_KEY_NAME : this.keyAlias;
    }

    public void extractKeysFromColumns(CFMetaData cfm) {
        ByteBuffer realKeyAlias = cfm.getKeyName();
        if (!this.keys.isEmpty()) {
            return;
        }
        Iterator<Relation> iter = this.columns.iterator();
        while (iter.hasNext()) {
            Relation relation = iter.next();
            ByteBuffer name = ByteBufferUtil.bytes(relation.getEntity().getText());
            if (!name.equals(realKeyAlias)) continue;
            this.keyAlias = relation.getEntity().getText().toUpperCase();
            this.keys.add(relation.getValue());
            iter.remove();
            break;
        }
    }
}

