/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cli;

import java.util.LinkedHashSet;
import java.util.Set;
import org.apache.cassandra.thrift.CfDef;
import org.apache.cassandra.thrift.IndexOperator;
import org.apache.cassandra.thrift.KsDef;
import org.apache.commons.lang.StringEscapeUtils;

public class CliUtils {
    public static String unescapeSQLString(String b) {
        if (b.charAt(0) == '\'' && b.charAt(b.length() - 1) == '\'') {
            b = b.substring(1, b.length() - 1);
        }
        return StringEscapeUtils.unescapeJava((String)b);
    }

    public static String escapeSQLString(String b) {
        return StringEscapeUtils.escapeJava((String)b).replace("'", "\\'");
    }

    public static IndexOperator getIndexOperator(String operator) {
        if (operator.equals("=")) {
            return IndexOperator.EQ;
        }
        if (operator.equals(">=")) {
            return IndexOperator.GTE;
        }
        if (operator.equals(">")) {
            return IndexOperator.GT;
        }
        if (operator.equals("<")) {
            return IndexOperator.LT;
        }
        if (operator.equals("<=")) {
            return IndexOperator.LTE;
        }
        return null;
    }

    public static Set<String> getCfNamesByKeySpace(KsDef keySpace) {
        LinkedHashSet<String> names = new LinkedHashSet<String>();
        for (CfDef cfDef : keySpace.getCf_defs()) {
            names.add(cfDef.getName());
        }
        return names;
    }
}

