/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.service;

import java.io.IOError;
import java.io.IOException;
import java.net.InetAddress;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.cassandra.db.ColumnFamily;
import org.apache.cassandra.db.ColumnFamilyStore;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.IColumn;
import org.apache.cassandra.db.ReadResponse;
import org.apache.cassandra.db.Row;
import org.apache.cassandra.db.RowMutation;
import org.apache.cassandra.db.columniterator.IdentityQueryFilter;
import org.apache.cassandra.db.filter.QueryFilter;
import org.apache.cassandra.db.filter.QueryPath;
import org.apache.cassandra.gms.Gossiper;
import org.apache.cassandra.net.Message;
import org.apache.cassandra.net.MessagingService;
import org.apache.cassandra.service.AbstractRowResolver;
import org.apache.cassandra.service.DigestMismatchException;
import org.apache.commons.collections.iterators.CollatingIterator;

public class RowRepairResolver
extends AbstractRowResolver {
    public RowRepairResolver(String table, ByteBuffer key) {
        super(key, table);
    }

    @Override
    public Row resolve() throws DigestMismatchException, IOException {
        ColumnFamily resolved;
        if (logger.isDebugEnabled()) {
            logger.debug("resolving " + this.replies.size() + " responses");
        }
        long startTime = System.currentTimeMillis();
        ArrayList<ColumnFamily> versions = new ArrayList<ColumnFamily>();
        ArrayList<InetAddress> endpoints = new ArrayList<InetAddress>();
        for (Map.Entry entry : this.replies.entrySet()) {
            Message message = (Message)entry.getKey();
            ReadResponse response = (ReadResponse)entry.getValue();
            assert (!response.isDigestQuery());
            versions.add(response.row().cf);
            endpoints.add(message.getFrom());
        }
        if (versions.size() > 1) {
            resolved = RowRepairResolver.resolveSuperset(versions);
            if (logger.isDebugEnabled()) {
                logger.debug("versions merged");
            }
            if (resolved != null) {
                RowRepairResolver.maybeScheduleRepairs(resolved, this.table, this.key, versions, endpoints);
            }
        } else {
            resolved = (ColumnFamily)versions.get(0);
        }
        if (logger.isDebugEnabled()) {
            logger.debug("resolve: " + (System.currentTimeMillis() - startTime) + " ms.");
        }
        return new Row(this.key, resolved);
    }

    public static void maybeScheduleRepairs(ColumnFamily resolved, String table, DecoratedKey key, List<ColumnFamily> versions, List<InetAddress> endpoints) {
        for (int i = 0; i < versions.size(); ++i) {
            Message repairMessage;
            ColumnFamily diffCf = ColumnFamily.diff(versions.get(i), resolved);
            if (diffCf == null) continue;
            RowMutation rowMutation = new RowMutation(table, key.key);
            rowMutation.add(diffCf);
            try {
                repairMessage = rowMutation.getMessage(Gossiper.instance.getVersion(endpoints.get(i)));
            }
            catch (IOException e) {
                throw new IOError(e);
            }
            MessagingService.instance().sendOneWay(repairMessage, endpoints.get(i));
        }
    }

    static ColumnFamily resolveSuperset(List<ColumnFamily> versions) {
        assert (versions.size() > 0);
        ColumnFamily resolved = null;
        for (ColumnFamily cf : versions) {
            if (cf == null) continue;
            if (resolved == null) {
                resolved = cf.cloneMeShallow();
                continue;
            }
            resolved.delete(cf);
        }
        if (resolved == null) {
            return null;
        }
        QueryFilter filter = new QueryFilter(null, new QueryPath(resolved.metadata().cfName), new IdentityQueryFilter());
        CollatingIterator iter = new CollatingIterator(resolved.metadata().comparator.columnComparator);
        for (ColumnFamily version : versions) {
            if (version == null) continue;
            iter.addIterator(version.getColumnsMap().values().iterator());
        }
        filter.collectCollatedColumns(resolved, (Iterator<IColumn>)iter, Integer.MIN_VALUE);
        return ColumnFamilyStore.removeDeleted(resolved, Integer.MIN_VALUE);
    }

    @Override
    public Row getData() throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isDataPresent() {
        throw new UnsupportedOperationException();
    }
}

