/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.compaction;

import java.io.DataOutput;
import java.io.IOException;
import java.security.MessageDigest;
import java.util.List;
import org.apache.cassandra.db.ColumnFamily;
import org.apache.cassandra.db.ColumnFamilyStore;
import org.apache.cassandra.db.ColumnIndexer;
import org.apache.cassandra.db.CounterColumn;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.compaction.AbstractCompactedRow;
import org.apache.cassandra.db.compaction.CompactionController;
import org.apache.cassandra.io.sstable.SSTableIdentityIterator;
import org.apache.cassandra.io.util.DataOutputBuffer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PrecompactedRow
extends AbstractCompactedRow {
    private static Logger logger = LoggerFactory.getLogger(PrecompactedRow.class);
    private final ColumnFamily compactedCf;
    private final int gcBefore;

    public PrecompactedRow(DecoratedKey key, ColumnFamily compacted) {
        super(key);
        this.compactedCf = compacted;
        this.gcBefore = Integer.MAX_VALUE;
    }

    public PrecompactedRow(CompactionController controller, List<SSTableIdentityIterator> rows) {
        super(rows.get(0).getKey());
        this.gcBefore = controller.gcBefore;
        ColumnFamily cf = null;
        for (SSTableIdentityIterator row : rows) {
            ColumnFamily thisCF;
            try {
                thisCF = row.getColumnFamilyWithColumns();
            }
            catch (IOException e) {
                logger.error("Skipping row " + this.key + " in " + row.getPath(), (Throwable)e);
                continue;
            }
            if (cf == null) {
                cf = thisCF;
                continue;
            }
            cf.addAll(thisCF);
        }
        boolean shouldPurge = controller.shouldPurge(this.key);
        ColumnFamily columnFamily = this.compactedCf = shouldPurge ? ColumnFamilyStore.removeDeleted(cf, controller.gcBefore) : cf;
        if (shouldPurge && this.compactedCf != null && this.compactedCf.metadata().getDefaultValidator().isCommutative()) {
            CounterColumn.removeOldShards(this.compactedCf, controller.gcBefore);
        }
    }

    @Override
    public void write(DataOutput out) throws IOException {
        if (this.compactedCf != null) {
            DataOutputBuffer buffer = new DataOutputBuffer();
            DataOutputBuffer headerBuffer = new DataOutputBuffer();
            ColumnIndexer.serialize(this.compactedCf, headerBuffer);
            ColumnFamily.serializer().serializeForSSTable(this.compactedCf, buffer);
            out.writeLong(headerBuffer.getLength() + buffer.getLength());
            out.write(headerBuffer.getData(), 0, headerBuffer.getLength());
            out.write(buffer.getData(), 0, buffer.getLength());
        }
    }

    @Override
    public void update(MessageDigest digest) {
        if (this.compactedCf != null) {
            DataOutputBuffer buffer = new DataOutputBuffer();
            try {
                ColumnFamily.serializer().serializeCFInfo(this.compactedCf, buffer);
                buffer.writeInt(this.compactedCf.getColumnCount());
                digest.update(buffer.getData(), 0, buffer.getLength());
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            this.compactedCf.updateDigest(digest);
        }
    }

    @Override
    public boolean isEmpty() {
        return this.compactedCf == null || ColumnFamilyStore.removeDeletedCF(this.compactedCf, this.gcBefore) == null;
    }

    @Override
    public int columnCount() {
        return this.compactedCf == null ? 0 : this.compactedCf.getColumnCount();
    }

    public ColumnFamily getFullColumnFamily() throws IOException {
        return this.compactedCf;
    }
}

