/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.config.KSMetaData;
import org.apache.cassandra.db.ColumnFamily;
import org.apache.cassandra.db.ColumnFamilyStore;
import org.apache.cassandra.db.ColumnFamilyType;
import org.apache.cassandra.db.HintedHandOffManager;
import org.apache.cassandra.db.IColumn;
import org.apache.cassandra.db.IMutation;
import org.apache.cassandra.db.Row;
import org.apache.cassandra.db.SuperColumn;
import org.apache.cassandra.db.Table;
import org.apache.cassandra.db.filter.QueryPath;
import org.apache.cassandra.io.ICompactSerializer;
import org.apache.cassandra.net.Message;
import org.apache.cassandra.net.MessageProducer;
import org.apache.cassandra.service.StorageService;
import org.apache.cassandra.thrift.Column;
import org.apache.cassandra.thrift.ColumnOrSuperColumn;
import org.apache.cassandra.thrift.CounterColumn;
import org.apache.cassandra.thrift.Deletion;
import org.apache.cassandra.utils.ByteBufferUtil;
import org.apache.cassandra.utils.FBUtilities;
import org.apache.commons.lang.StringUtils;

public class RowMutation
implements IMutation,
MessageProducer {
    private static RowMutationSerializer serializer_ = new RowMutationSerializer();
    public static final String HINT = "HINT";
    public static final String FORWARD_HEADER = "FORWARD";
    private String table_;
    private ByteBuffer key_;
    protected Map<Integer, ColumnFamily> modifications_ = new HashMap<Integer, ColumnFamily>();
    private Map<Integer, byte[]> preserializedBuffers = new HashMap<Integer, byte[]>();

    public static RowMutationSerializer serializer() {
        return serializer_;
    }

    public RowMutation(String table, ByteBuffer key) {
        this.table_ = table;
        this.key_ = key;
    }

    public RowMutation(String table, Row row) {
        this.table_ = table;
        this.key_ = row.key.key;
        this.add(row.cf);
    }

    protected RowMutation(String table, ByteBuffer key, Map<Integer, ColumnFamily> modifications) {
        this.table_ = table;
        this.key_ = key;
        this.modifications_ = modifications;
    }

    @Override
    public String getTable() {
        return this.table_;
    }

    @Override
    public Collection<Integer> getColumnFamilyIds() {
        return this.modifications_.keySet();
    }

    @Override
    public ByteBuffer key() {
        return this.key_;
    }

    public Collection<ColumnFamily> getColumnFamilies() {
        return this.modifications_.values();
    }

    public ColumnFamily getColumnFamily(Integer cfId) {
        return this.modifications_.get(cfId);
    }

    void addHints(RowMutation rm) throws IOException {
        for (ColumnFamily cf : rm.getColumnFamilies()) {
            ByteBuffer combined = HintedHandOffManager.makeCombinedName(rm.getTable(), cf.metadata().cfName);
            QueryPath path = new QueryPath("HintsColumnFamily", rm.key(), combined);
            this.add(path, ByteBufferUtil.EMPTY_BYTE_BUFFER, System.currentTimeMillis(), cf.metadata().getGcGraceSeconds());
        }
    }

    public void add(ColumnFamily columnFamily) {
        assert (columnFamily != null);
        ColumnFamily prev = this.modifications_.put(columnFamily.id(), columnFamily);
        if (prev != null) {
            throw new IllegalArgumentException("ColumnFamily " + columnFamily + " already has modifications in this mutation: " + prev);
        }
    }

    public boolean isEmpty() {
        return this.modifications_.isEmpty();
    }

    public void add(QueryPath path, ByteBuffer value, long timestamp, int timeToLive) {
        Integer id = CFMetaData.getId(this.table_, path.columnFamilyName);
        ColumnFamily columnFamily = this.modifications_.get(id);
        if (columnFamily == null) {
            columnFamily = ColumnFamily.create(this.table_, path.columnFamilyName);
            this.modifications_.put(id, columnFamily);
        }
        columnFamily.addColumn(path, value, timestamp, timeToLive);
    }

    public void addCounter(QueryPath path, long value) {
        Integer id = CFMetaData.getId(this.table_, path.columnFamilyName);
        ColumnFamily columnFamily = this.modifications_.get(id);
        if (columnFamily == null) {
            columnFamily = ColumnFamily.create(this.table_, path.columnFamilyName);
            this.modifications_.put(id, columnFamily);
        }
        columnFamily.addCounter(path, value);
    }

    public void add(QueryPath path, ByteBuffer value, long timestamp) {
        this.add(path, value, timestamp, 0);
    }

    public void delete(QueryPath path, long timestamp) {
        Integer id = CFMetaData.getId(this.table_, path.columnFamilyName);
        int localDeleteTime = (int)(System.currentTimeMillis() / 1000L);
        ColumnFamily columnFamily = this.modifications_.get(id);
        if (columnFamily == null) {
            columnFamily = ColumnFamily.create(this.table_, path.columnFamilyName);
            this.modifications_.put(id, columnFamily);
        }
        if (path.superColumnName == null && path.columnName == null) {
            columnFamily.delete(localDeleteTime, timestamp);
        } else if (path.columnName == null) {
            SuperColumn sc = new SuperColumn(path.superColumnName, columnFamily.getSubComparator());
            sc.markForDeleteAt(localDeleteTime, timestamp);
            columnFamily.addColumn(sc);
        } else {
            columnFamily.addTombstone(path, localDeleteTime, timestamp);
        }
    }

    @Override
    public void apply() throws IOException {
        KSMetaData ksm = DatabaseDescriptor.getTableDefinition(this.getTable());
        Table.open(this.table_).apply(this, ksm.isDurableWrites());
    }

    public void applyUnsafe() throws IOException {
        Table.open(this.table_).apply(this, false);
    }

    void applyBinary() throws IOException, ExecutionException, InterruptedException {
        Table.open(this.table_).load(this);
    }

    @Override
    public Message getMessage(Integer version) throws IOException {
        return this.makeRowMutationMessage(StorageService.Verb.MUTATION, version);
    }

    public Message makeRowMutationMessage(StorageService.Verb verb, int version) throws IOException {
        return new Message(FBUtilities.getLocalAddress(), verb, this.getSerializedBuffer(version), version);
    }

    public synchronized byte[] getSerializedBuffer(int version) throws IOException {
        byte[] preserializedBuffer = this.preserializedBuffers.get(version);
        if (preserializedBuffer == null) {
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            DataOutputStream dout = new DataOutputStream(bout);
            RowMutation.serializer().serialize(this, dout, version);
            dout.close();
            preserializedBuffer = bout.toByteArray();
            this.preserializedBuffers.put(version, preserializedBuffer);
        }
        return preserializedBuffer;
    }

    public String toString() {
        return this.toString(false);
    }

    @Override
    public String toString(boolean shallow) {
        StringBuilder buff = new StringBuilder("RowMutation(");
        buff.append("keyspace='").append(this.table_).append('\'');
        buff.append(", key='").append(ByteBufferUtil.bytesToHex(this.key_)).append('\'');
        buff.append(", modifications=[");
        if (shallow) {
            ArrayList<String> cfnames = new ArrayList<String>();
            for (Integer cfid : this.modifications_.keySet()) {
                CFMetaData cfm = DatabaseDescriptor.getCFMetaData(cfid);
                cfnames.add(cfm == null ? "-dropped-" : cfm.cfName);
            }
            buff.append(StringUtils.join(cfnames, (String)", "));
        } else {
            buff.append(StringUtils.join(this.modifications_.values(), (String)", "));
        }
        return buff.append("])").toString();
    }

    public void addColumnOrSuperColumn(String cfName, ColumnOrSuperColumn cosc) {
        if (cosc.super_column != null) {
            for (Column column : cosc.super_column.columns) {
                this.add(new QueryPath(cfName, cosc.super_column.name, column.name), column.value, column.timestamp, column.ttl);
            }
        } else if (cosc.column != null) {
            this.add(new QueryPath(cfName, null, cosc.column.name), cosc.column.value, cosc.column.timestamp, cosc.column.ttl);
        } else if (cosc.counter_super_column != null) {
            for (CounterColumn column : cosc.counter_super_column.columns) {
                this.addCounter(new QueryPath(cfName, cosc.counter_super_column.name, column.name), column.value);
            }
        } else {
            this.addCounter(new QueryPath(cfName, null, cosc.counter_column.name), cosc.counter_column.value);
        }
    }

    public void deleteColumnOrSuperColumn(String cfName, Deletion del) {
        if (del.predicate != null && del.predicate.column_names != null) {
            for (ByteBuffer c : del.predicate.column_names) {
                if (del.super_column == null && DatabaseDescriptor.getColumnFamilyType(this.table_, cfName) == ColumnFamilyType.Super) {
                    this.delete(new QueryPath(cfName, c), del.timestamp);
                    continue;
                }
                this.delete(new QueryPath(cfName, del.super_column, c), del.timestamp);
            }
        } else {
            this.delete(new QueryPath(cfName, del.super_column), del.timestamp);
        }
    }

    static RowMutation fromBytes(byte[] raw, int version) throws IOException {
        RowMutation rm = serializer_.deserialize(new DataInputStream(new ByteArrayInputStream(raw)), version);
        rm.preserializedBuffers.put(version, raw);
        return rm;
    }

    public RowMutation localCopy() {
        RowMutation rm = new RowMutation(this.table_, ByteBufferUtil.clone(this.key_));
        Table table = Table.open(this.table_);
        for (Map.Entry<Integer, ColumnFamily> entry : this.modifications_.entrySet()) {
            ColumnFamily cf = entry.getValue().cloneMeShallow();
            ColumnFamilyStore cfs = table.getColumnFamilyStore(cf.id());
            for (Map.Entry<ByteBuffer, IColumn> ce : entry.getValue().getColumnsMap().entrySet()) {
                cf.addColumn(ce.getValue().localCopy(cfs));
            }
            rm.modifications_.put(entry.getKey(), cf);
        }
        return rm;
    }

    public static class RowMutationSerializer
    implements ICompactSerializer<RowMutation> {
        @Override
        public void serialize(RowMutation rm, DataOutputStream dos, int version) throws IOException {
            dos.writeUTF(rm.getTable());
            ByteBufferUtil.writeWithShortLength(rm.key(), dos);
            int size = rm.modifications_.size();
            dos.writeInt(size);
            if (size > 0) {
                for (Map.Entry<Integer, ColumnFamily> entry : rm.modifications_.entrySet()) {
                    dos.writeInt(entry.getKey());
                    ColumnFamily.serializer().serialize(entry.getValue(), (DataOutput)dos);
                }
            }
        }

        public RowMutation deserialize(DataInputStream dis, int version, boolean fromRemote) throws IOException {
            String table = dis.readUTF();
            ByteBuffer key = ByteBufferUtil.readWithShortLength(dis);
            HashMap<Integer, ColumnFamily> modifications = new HashMap<Integer, ColumnFamily>();
            int size = dis.readInt();
            for (int i = 0; i < size; ++i) {
                Integer cfid = dis.readInt();
                ColumnFamily cf = ColumnFamily.serializer().deserialize(dis, true, fromRemote);
                modifications.put(cfid, cf);
            }
            return new RowMutation(table, key, modifications);
        }

        @Override
        public RowMutation deserialize(DataInputStream dis, int version) throws IOException {
            return this.deserialize(dis, version, true);
        }
    }
}

