/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.thrift;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.service.AbstractCassandraDaemon;
import org.apache.cassandra.thrift.Cassandra;
import org.apache.cassandra.thrift.CassandraServer;
import org.apache.cassandra.thrift.CustomTThreadPoolServer;
import org.apache.cassandra.thrift.TBinaryProtocol;
import org.apache.cassandra.thrift.TCustomServerSocket;
import org.apache.thrift.TProcessor;
import org.apache.thrift.protocol.TProtocolFactory;
import org.apache.thrift.server.TServer;
import org.apache.thrift.server.TThreadPoolServer;
import org.apache.thrift.transport.TFramedTransport;
import org.apache.thrift.transport.TServerTransport;
import org.apache.thrift.transport.TTransportException;
import org.apache.thrift.transport.TTransportFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CassandraDaemon
extends AbstractCassandraDaemon {
    private static Logger logger = LoggerFactory.getLogger(CassandraDaemon.class);
    private ThriftServer server;

    @Override
    protected void startServer() {
        if (this.server == null) {
            this.server = new ThriftServer(this.listenAddr, this.listenPort);
            this.server.start();
        }
    }

    @Override
    protected void stopServer() {
        if (this.server != null) {
            this.server.stopServer();
            try {
                this.server.join();
            }
            catch (InterruptedException e) {
                logger.error("Interrupted while waiting thrift server to stop", (Throwable)e);
            }
            this.server = null;
        }
    }

    public static void main(String[] args) {
        new CassandraDaemon().activate();
    }

    private static class ThriftServer
    extends Thread {
        private TServer serverEngine;

        public ThriftServer(InetAddress listenAddr, int listenPort) {
            CassandraServer cassandraServer = new CassandraServer();
            Cassandra.Processor processor = new Cassandra.Processor((Cassandra.Iface)cassandraServer);
            TCustomServerSocket tServerSocket = null;
            try {
                tServerSocket = new TCustomServerSocket(new InetSocketAddress(listenAddr, listenPort), DatabaseDescriptor.getRpcKeepAlive(), DatabaseDescriptor.getRpcSendBufferSize(), DatabaseDescriptor.getRpcRecvBufferSize());
            }
            catch (TTransportException e) {
                throw new RuntimeException(String.format("Unable to create thrift socket to %s:%s", listenAddr, listenPort), e);
            }
            logger.info(String.format("Binding thrift service to %s:%s", listenAddr, listenPort));
            TBinaryProtocol.Factory tProtocolFactory = new TBinaryProtocol.Factory(true, true, DatabaseDescriptor.getThriftMaxMessageLength());
            int tFramedTransportSize = DatabaseDescriptor.getThriftFramedTransportSize();
            TFramedTransport.Factory inTransportFactory = new TFramedTransport.Factory(tFramedTransportSize);
            TFramedTransport.Factory outTransportFactory = new TFramedTransport.Factory(tFramedTransportSize);
            logger.info("Using TFastFramedTransport with a max frame size of {} bytes.", (Object)tFramedTransportSize);
            TThreadPoolServer.Args args = (TThreadPoolServer.Args)((TThreadPoolServer.Args)((TThreadPoolServer.Args)((TThreadPoolServer.Args)((TThreadPoolServer.Args)new TThreadPoolServer.Args((TServerTransport)tServerSocket).minWorkerThreads(DatabaseDescriptor.getRpcMinThreads().intValue()).maxWorkerThreads(DatabaseDescriptor.getRpcMaxThreads().intValue()).inputTransportFactory((TTransportFactory)inTransportFactory)).outputTransportFactory((TTransportFactory)outTransportFactory)).inputProtocolFactory((TProtocolFactory)tProtocolFactory)).outputProtocolFactory((TProtocolFactory)tProtocolFactory)).processor((TProcessor)processor);
            AbstractCassandraDaemon.CleaningThreadPool executorService = new AbstractCassandraDaemon.CleaningThreadPool(cassandraServer.clientState, args.minWorkerThreads, args.maxWorkerThreads);
            this.serverEngine = new CustomTThreadPoolServer(args, executorService);
        }

        @Override
        public void run() {
            logger.info("Listening for thrift clients...");
            this.serverEngine.serve();
        }

        public void stopServer() {
            logger.info("Stop listening to thrift clients");
            this.serverEngine.stop();
        }
    }
}

