/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db;

import java.io.IOError;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.TreeSet;
import java.util.concurrent.ExecutionException;
import org.apache.cassandra.config.ConfigurationException;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.db.Column;
import org.apache.cassandra.db.ColumnFamily;
import org.apache.cassandra.db.ColumnFamilyStore;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.DeletedColumn;
import org.apache.cassandra.db.IColumn;
import org.apache.cassandra.db.RowMutation;
import org.apache.cassandra.db.Table;
import org.apache.cassandra.db.Truncation;
import org.apache.cassandra.db.filter.QueryFilter;
import org.apache.cassandra.db.filter.QueryPath;
import org.apache.cassandra.db.marshal.BytesType;
import org.apache.cassandra.dht.IPartitioner;
import org.apache.cassandra.dht.Token;
import org.apache.cassandra.service.StorageService;
import org.apache.cassandra.utils.ByteBufferUtil;
import org.apache.cassandra.utils.FBUtilities;
import org.apache.cassandra.utils.NodeId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SystemTable {
    private static Logger logger = LoggerFactory.getLogger(SystemTable.class);
    public static final String STATUS_CF = "LocationInfo";
    public static final String INDEX_CF = "IndexInfo";
    public static final String NODE_ID_CF = "NodeIdInfo";
    private static final ByteBuffer LOCATION_KEY = ByteBufferUtil.bytes("L");
    private static final ByteBuffer RING_KEY = ByteBufferUtil.bytes("Ring");
    private static final ByteBuffer BOOTSTRAP_KEY = ByteBufferUtil.bytes("Bootstrap");
    private static final ByteBuffer COOKIE_KEY = ByteBufferUtil.bytes("Cookies");
    private static final ByteBuffer BOOTSTRAP = ByteBufferUtil.bytes("B");
    private static final ByteBuffer TOKEN = ByteBufferUtil.bytes("Token");
    private static final ByteBuffer GENERATION = ByteBufferUtil.bytes("Generation");
    private static final ByteBuffer CLUSTERNAME = ByteBufferUtil.bytes("ClusterName");
    private static final ByteBuffer PARTITIONER = ByteBufferUtil.bytes("Partioner");
    private static final ByteBuffer CURRENT_LOCAL_NODE_ID_KEY = ByteBufferUtil.bytes("CurrentLocal");
    private static final ByteBuffer ALL_LOCAL_NODE_ID_KEY = ByteBufferUtil.bytes("Local");

    private static DecoratedKey decorate(ByteBuffer key) {
        return StorageService.getPartitioner().decorateKey(key);
    }

    public static void purgeIncompatibleHints() throws IOException {
        ByteBuffer hintsPurged6to7 = ByteBufferUtil.bytes("Hints purged as part of upgrading from 0.6.x to 0.7");
        Table table = Table.open("system");
        QueryFilter dotSeven = QueryFilter.getNamesFilter(SystemTable.decorate(COOKIE_KEY), new QueryPath(STATUS_CF), hintsPurged6to7);
        ColumnFamily cf = table.getColumnFamilyStore(STATUS_CF).getColumnFamily(dotSeven);
        if (cf == null) {
            logger.info("Upgrading to 0.7. Purging hints if there are any. Old hints will be snapshotted.");
            new Truncation("system", "HintsColumnFamily").apply();
            RowMutation rm = new RowMutation("system", COOKIE_KEY);
            rm.add(new QueryPath(STATUS_CF, null, hintsPurged6to7), ByteBufferUtil.bytes("oh yes, it they were purged."), System.currentTimeMillis());
            rm.apply();
        }
    }

    public static synchronized void updateToken(InetAddress ep, Token token) {
        IPartitioner p = StorageService.getPartitioner();
        ColumnFamily cf = ColumnFamily.create("system", STATUS_CF);
        cf.addColumn(new Column(p.getTokenFactory().toByteArray(token), ByteBuffer.wrap(ep.getAddress()), System.currentTimeMillis()));
        RowMutation rm = new RowMutation("system", RING_KEY);
        rm.add(cf);
        try {
            rm.apply();
        }
        catch (IOException e) {
            throw new IOError(e);
        }
    }

    public static synchronized void removeToken(Token token) {
        IPartitioner p = StorageService.getPartitioner();
        RowMutation rm = new RowMutation("system", RING_KEY);
        rm.delete(new QueryPath(STATUS_CF, null, p.getTokenFactory().toByteArray(token)), System.currentTimeMillis());
        try {
            rm.apply();
        }
        catch (IOException e) {
            throw new IOError(e);
        }
    }

    public static synchronized void updateToken(Token token) {
        IPartitioner p = StorageService.getPartitioner();
        ColumnFamily cf = ColumnFamily.create("system", STATUS_CF);
        cf.addColumn(new Column(TOKEN, p.getTokenFactory().toByteArray(token), System.currentTimeMillis()));
        RowMutation rm = new RowMutation("system", LOCATION_KEY);
        rm.add(cf);
        try {
            rm.apply();
        }
        catch (IOException e) {
            throw new IOError(e);
        }
        SystemTable.forceBlockingFlush(STATUS_CF);
    }

    private static void forceBlockingFlush(String cfname) {
        try {
            Table.open("system").getColumnFamilyStore(cfname).forceBlockingFlush();
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e);
        }
        catch (InterruptedException e) {
            throw new AssertionError((Object)e);
        }
    }

    public static HashMap<Token, InetAddress> loadTokens() {
        HashMap<Token, InetAddress> tokenMap = new HashMap<Token, InetAddress>();
        IPartitioner p = StorageService.getPartitioner();
        Table table = Table.open("system");
        QueryFilter filter = QueryFilter.getIdentityFilter(SystemTable.decorate(RING_KEY), new QueryPath(STATUS_CF));
        ColumnFamily cf = table.getColumnFamilyStore(STATUS_CF).getColumnFamily(filter);
        if (cf != null) {
            for (IColumn column : cf.getSortedColumns()) {
                try {
                    ByteBuffer v = column.value();
                    byte[] addr = new byte[v.remaining()];
                    ByteBufferUtil.arrayCopy(v, v.position(), addr, 0, v.remaining());
                    tokenMap.put(p.getTokenFactory().fromByteArray(column.name()), InetAddress.getByAddress(addr));
                }
                catch (UnknownHostException e) {
                    throw new IOError(e);
                }
            }
        }
        return tokenMap;
    }

    public static void checkHealth() throws ConfigurationException, IOException {
        Table table = null;
        try {
            table = Table.open("system");
        }
        catch (AssertionError err) {
            ConfigurationException ex = new ConfigurationException("Could not read system table. Did you change partitioners?");
            ex.initCause((Throwable)((Object)err));
            throw ex;
        }
        TreeSet<ByteBuffer> cols = new TreeSet<ByteBuffer>(BytesType.instance);
        cols.add(PARTITIONER);
        cols.add(CLUSTERNAME);
        QueryFilter filter = QueryFilter.getNamesFilter(SystemTable.decorate(LOCATION_KEY), new QueryPath(STATUS_CF), cols);
        ColumnFamily cf = table.getColumnFamilyStore(STATUS_CF).getColumnFamily(filter);
        if (cf == null) {
            ColumnFamilyStore cfs = table.getColumnFamilyStore(STATUS_CF);
            if (!cfs.getSSTables().isEmpty()) {
                throw new ConfigurationException("Found system table files, but they couldn't be loaded. Did you change the partitioner?");
            }
            RowMutation rm = new RowMutation("system", LOCATION_KEY);
            cf = ColumnFamily.create("system", STATUS_CF);
            cf.addColumn(new Column(PARTITIONER, ByteBufferUtil.bytes(DatabaseDescriptor.getPartitioner().getClass().getName()), FBUtilities.timestampMicros()));
            cf.addColumn(new Column(CLUSTERNAME, ByteBufferUtil.bytes(DatabaseDescriptor.getClusterName()), FBUtilities.timestampMicros()));
            rm.add(cf);
            rm.apply();
            return;
        }
        IColumn partitionerCol = cf.getColumn(PARTITIONER);
        IColumn clusterCol = cf.getColumn(CLUSTERNAME);
        assert (partitionerCol != null);
        assert (clusterCol != null);
        if (!DatabaseDescriptor.getPartitioner().getClass().getName().equals(ByteBufferUtil.string(partitionerCol.value()))) {
            throw new ConfigurationException("Detected partitioner mismatch! Did you change the partitioner?");
        }
        String savedClusterName = ByteBufferUtil.string(clusterCol.value());
        if (!DatabaseDescriptor.getClusterName().equals(savedClusterName)) {
            throw new ConfigurationException("Saved cluster name " + savedClusterName + " != configured name " + DatabaseDescriptor.getClusterName());
        }
    }

    public static Token getSavedToken() {
        Table table = Table.open("system");
        QueryFilter filter = QueryFilter.getNamesFilter(SystemTable.decorate(LOCATION_KEY), new QueryPath(STATUS_CF), TOKEN);
        ColumnFamily cf = table.getColumnFamilyStore(STATUS_CF).getColumnFamily(filter);
        return cf == null ? null : StorageService.getPartitioner().getTokenFactory().fromByteArray(cf.getColumn(TOKEN).value());
    }

    public static int incrementAndGetGeneration() throws IOException {
        Table table = Table.open("system");
        QueryFilter filter = QueryFilter.getNamesFilter(SystemTable.decorate(LOCATION_KEY), new QueryPath(STATUS_CF), GENERATION);
        ColumnFamily cf = table.getColumnFamilyStore(STATUS_CF).getColumnFamily(filter);
        int generation = cf == null ? (int)(System.currentTimeMillis() / 1000L) : Math.max(ByteBufferUtil.toInt(cf.getColumn(GENERATION).value()) + 1, (int)(System.currentTimeMillis() / 1000L));
        RowMutation rm = new RowMutation("system", LOCATION_KEY);
        cf = ColumnFamily.create("system", STATUS_CF);
        cf.addColumn(new Column(GENERATION, ByteBufferUtil.bytes(generation), FBUtilities.timestampMicros()));
        rm.add(cf);
        rm.apply();
        SystemTable.forceBlockingFlush(STATUS_CF);
        return generation;
    }

    public static boolean isBootstrapped() {
        Table table = Table.open("system");
        QueryFilter filter = QueryFilter.getNamesFilter(SystemTable.decorate(BOOTSTRAP_KEY), new QueryPath(STATUS_CF), BOOTSTRAP);
        ColumnFamily cf = table.getColumnFamilyStore(STATUS_CF).getColumnFamily(filter);
        if (cf == null) {
            return false;
        }
        IColumn c = cf.getColumn(BOOTSTRAP);
        return c.value().get(c.value().position()) == 1;
    }

    public static void setBootstrapped(boolean isBootstrapped) {
        ColumnFamily cf = ColumnFamily.create("system", STATUS_CF);
        cf.addColumn(new Column(BOOTSTRAP, ByteBuffer.wrap(new byte[]{(byte)(isBootstrapped ? 1 : 0)}), System.currentTimeMillis()));
        RowMutation rm = new RowMutation("system", BOOTSTRAP_KEY);
        rm.add(cf);
        try {
            rm.apply();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static boolean isIndexBuilt(String table, String indexName) {
        QueryFilter filter;
        ColumnFamilyStore cfs = Table.open("system").getColumnFamilyStore(INDEX_CF);
        return cfs.getColumnFamily(filter = QueryFilter.getNamesFilter(SystemTable.decorate(ByteBufferUtil.bytes(table)), new QueryPath(INDEX_CF), ByteBufferUtil.bytes(indexName))) != null;
    }

    public static void setIndexBuilt(String table, String indexName) {
        ColumnFamily cf = ColumnFamily.create("system", INDEX_CF);
        cf.addColumn(new Column(ByteBufferUtil.bytes(indexName), ByteBufferUtil.EMPTY_BYTE_BUFFER, System.currentTimeMillis()));
        RowMutation rm = new RowMutation("system", ByteBufferUtil.bytes(table));
        rm.add(cf);
        try {
            rm.apply();
        }
        catch (IOException e) {
            throw new IOError(e);
        }
        SystemTable.forceBlockingFlush(INDEX_CF);
    }

    public static void setIndexRemoved(String table, String indexName) {
        RowMutation rm = new RowMutation("system", ByteBufferUtil.bytes(table));
        rm.delete(new QueryPath(INDEX_CF, null, ByteBufferUtil.bytes(indexName)), System.currentTimeMillis());
        try {
            rm.apply();
        }
        catch (IOException e) {
            throw new IOError(e);
        }
        SystemTable.forceBlockingFlush(INDEX_CF);
    }

    public static NodeId getCurrentLocalNodeId() {
        ByteBuffer id = null;
        Table table = Table.open("system");
        QueryFilter filter = QueryFilter.getIdentityFilter(SystemTable.decorate(CURRENT_LOCAL_NODE_ID_KEY), new QueryPath(NODE_ID_CF));
        ColumnFamily cf = table.getColumnFamilyStore(NODE_ID_CF).getColumnFamily(filter);
        if (cf != null) {
            cf = ColumnFamilyStore.removeDeleted(cf, 0);
            assert (cf.getColumnCount() <= 1);
            if (cf.getColumnCount() > 0) {
                id = cf.iterator().next().name();
            }
        }
        if (id != null) {
            return NodeId.wrap(id);
        }
        return null;
    }

    public static void writeCurrentLocalNodeId(NodeId oldNodeId, NodeId newNodeId) {
        long now = System.currentTimeMillis();
        ByteBuffer ip = ByteBuffer.wrap(FBUtilities.getLocalAddress().getAddress());
        ColumnFamily cf = ColumnFamily.create("system", NODE_ID_CF);
        cf.addColumn(new Column(newNodeId.bytes(), ip, now));
        ColumnFamily cf2 = cf.cloneMe();
        if (oldNodeId != null) {
            cf2.addColumn(new DeletedColumn(oldNodeId.bytes(), (int)(now / 1000L), now));
        }
        RowMutation rmCurrent = new RowMutation("system", CURRENT_LOCAL_NODE_ID_KEY);
        RowMutation rmAll = new RowMutation("system", ALL_LOCAL_NODE_ID_KEY);
        rmCurrent.add(cf2);
        rmAll.add(cf);
        try {
            rmCurrent.apply();
            rmAll.apply();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static List<NodeId.NodeIdRecord> getOldLocalNodeIds() {
        ArrayList<NodeId.NodeIdRecord> l = new ArrayList<NodeId.NodeIdRecord>();
        Table table = Table.open("system");
        QueryFilter filter = QueryFilter.getIdentityFilter(SystemTable.decorate(ALL_LOCAL_NODE_ID_KEY), new QueryPath(NODE_ID_CF));
        ColumnFamily cf = table.getColumnFamilyStore(NODE_ID_CF).getColumnFamily(filter);
        NodeId previous = null;
        for (IColumn c : cf.getReverseSortedColumns()) {
            if (previous != null) {
                l.add(new NodeId.NodeIdRecord(previous, c.timestamp()));
            }
            previous = NodeId.wrap(c.name());
        }
        return l;
    }
}

