/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.tools;

import java.io.IOException;
import java.net.InetAddress;
import java.util.List;
import org.apache.cassandra.tools.NodeProbe;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;

public class ClusterCmd {
    private static final String HOST_OPT_LONG = "host";
    private static final String HOST_OPT_SHORT = "h";
    private static final String PORT_OPT_LONG = "port";
    private static final String PORT_OPT_SHORT = "p";
    private static final int defaultPort = 7199;
    private static Options options = null;
    private CommandLine cmd = null;
    private NodeProbe probe;

    private ClusterCmd(String[] cmdArgs) throws ParseException, IOException, InterruptedException {
        int port;
        this.parseArgs(cmdArgs);
        String host = this.cmd.getOptionValue(HOST_OPT_SHORT);
        String portNum = this.cmd.getOptionValue(PORT_OPT_SHORT);
        if (portNum != null) {
            try {
                port = Integer.parseInt(portNum);
            }
            catch (NumberFormatException e) {
                throw new ParseException("Port must be a number");
            }
        } else {
            port = 7199;
        }
        this.probe = new NodeProbe(host, port);
    }

    public ClusterCmd(String host, int port) throws IOException, InterruptedException {
        this.probe = new NodeProbe(host, port);
    }

    public ClusterCmd(String host) throws IOException, InterruptedException {
        this(host, 7199);
    }

    private void parseArgs(String[] args) throws ParseException {
        PosixParser parser = new PosixParser();
        this.cmd = parser.parse(options, args);
    }

    private String[] getArgs() {
        return this.cmd.getArgs();
    }

    private static void printUsage() {
        HelpFormatter hf = new HelpFormatter();
        String header = String.format("%nAvailable commands: get_endpoints [keyspace] [key], global_snapshot [name], clear_global_snapshot,truncate <keyspace> <cfname>", new Object[0]);
        String usage = String.format("java %s -host <arg> <command>%n", ClusterCmd.class.getName());
        hf.printHelp(usage, "", options, header);
    }

    public void close() throws IOException {
        this.probe.close();
    }

    public void printEndpoints(String keyspace, String key) {
        List<InetAddress> endpoints = this.probe.getEndpoints(keyspace, key);
        System.out.println(String.format("%-17s: %s", "Key", key));
        System.out.println(String.format("%-17s: %s", "Endpoints", endpoints));
    }

    public void takeGlobalSnapshot(String snapshotName) throws IOException, InterruptedException {
        for (String liveNode : this.probe.getLiveNodes()) {
            try {
                NodeProbe hostProbe = new NodeProbe(liveNode, this.probe.port);
                hostProbe.takeSnapshot(snapshotName, new String[0]);
                System.out.println(liveNode + " snapshot taken in directory: " + snapshotName);
            }
            catch (IOException e) {
                System.out.println(liveNode + " snapshot FAILED: " + e.getMessage());
            }
        }
    }

    public void clearGlobalSnapshot(String tag) throws IOException, InterruptedException {
        for (String liveNode : this.probe.getLiveNodes()) {
            try {
                NodeProbe hostProbe = new NodeProbe(liveNode, this.probe.port);
                hostProbe.clearSnapshot(tag, new String[0]);
                System.out.println(liveNode + " snapshot cleared");
            }
            catch (IOException e) {
                System.out.println(liveNode + " snapshot clear FAILED: " + e.getMessage());
            }
        }
    }

    public void truncate(String tableName, String cfName) {
        this.probe.truncate(tableName, cfName);
    }

    public static void main(String[] args) throws IOException, InterruptedException {
        String[] arguments;
        String cmdName;
        ClusterCmd clusterCmd = null;
        try {
            clusterCmd = new ClusterCmd(args);
        }
        catch (ParseException pe) {
            System.err.println(pe.getMessage());
            ClusterCmd.printUsage();
            System.exit(1);
        }
        catch (IOException ioe) {
            System.err.println("Error connecting to remote JMX agent!");
            ioe.printStackTrace();
            System.exit(3);
        }
        if (clusterCmd.getArgs().length < 1) {
            System.err.println("Missing argument for command.");
            ClusterCmd.printUsage();
            System.exit(1);
        }
        if ((cmdName = (arguments = clusterCmd.getArgs())[0]).equals("get_endpoints")) {
            if (arguments.length <= 2) {
                System.err.println("missing keyspace and/or key argument");
                ClusterCmd.printUsage();
                System.exit(1);
            }
            clusterCmd.printEndpoints(arguments[1], arguments[2]);
        } else if (cmdName.equals("global_snapshot")) {
            String snapshotName = arguments.length > 1 ? arguments[1] : new Long(System.currentTimeMillis()).toString();
            clusterCmd.takeGlobalSnapshot(snapshotName);
        } else if (cmdName.equals("clear_global_snapshot")) {
            String snapshotName = arguments.length > 1 ? arguments[1] : "";
            clusterCmd.clearGlobalSnapshot(snapshotName);
        } else if (cmdName.equals("truncate")) {
            if (arguments.length != 3) {
                System.err.println("truncate requires <keyspace> and <columnfamily> arguments");
            }
            String tableName = arguments[1];
            String cfName = arguments[2];
            clusterCmd.truncate(tableName, cfName);
        } else {
            System.err.println("Unrecognized command: " + cmdName + ".");
            ClusterCmd.printUsage();
            System.exit(1);
        }
        System.exit(0);
    }

    static {
        options = new Options();
        Option optHost = new Option(HOST_OPT_SHORT, HOST_OPT_LONG, true, "node hostname or ip address");
        optHost.setRequired(true);
        options.addOption(optHost);
        options.addOption(PORT_OPT_SHORT, PORT_OPT_LONG, true, "remote jmx agent port number (defaults to 7199)");
    }
}

