/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cql.jdbc;

import java.nio.ByteBuffer;
import org.apache.cassandra.db.marshal.AbstractType;

class TypedColumn<N, V> {
    private final N name;
    private final V value;
    private final String nameString;
    private final String valueString;
    private final AbstractType<V> validator;

    public TypedColumn(AbstractType<N> comparator, byte[] name, AbstractType<V> validator, byte[] value) {
        ByteBuffer bbName = ByteBuffer.wrap(name);
        ByteBuffer bbValue = value == null ? null : ByteBuffer.wrap(value);
        this.name = comparator.compose(bbName);
        this.value = value == null ? null : validator.compose(bbValue);
        this.nameString = comparator.getString(bbName);
        this.valueString = value == null ? null : validator.getString(bbValue);
        this.validator = validator;
    }

    public N getName() {
        return this.name;
    }

    public V getValue() {
        return this.value;
    }

    public String getNameString() {
        return this.nameString;
    }

    public String getValueString() {
        return this.valueString;
    }

    public AbstractType<V> getValidator() {
        return this.validator;
    }
}

