/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cli;

import com.google.common.base.Charsets;
import com.google.common.base.Joiner;
import java.io.IOError;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.nio.charset.CharacterCodingException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.antlr.runtime.tree.Tree;
import org.apache.cassandra.cli.CliCommandHelp;
import org.apache.cassandra.cli.CliCompiler;
import org.apache.cassandra.cli.CliMain;
import org.apache.cassandra.cli.CliSessionState;
import org.apache.cassandra.cli.CliUserHelp;
import org.apache.cassandra.cli.CliUtils;
import org.apache.cassandra.config.ConfigurationException;
import org.apache.cassandra.db.ColumnFamilyStoreMBean;
import org.apache.cassandra.db.CompactionManagerMBean;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.db.marshal.AsciiType;
import org.apache.cassandra.db.marshal.BytesType;
import org.apache.cassandra.db.marshal.CounterColumnType;
import org.apache.cassandra.db.marshal.IntegerType;
import org.apache.cassandra.db.marshal.LexicalUUIDType;
import org.apache.cassandra.db.marshal.LongType;
import org.apache.cassandra.db.marshal.MarshalException;
import org.apache.cassandra.db.marshal.TimeUUIDType;
import org.apache.cassandra.db.marshal.UTF8Type;
import org.apache.cassandra.io.CompactionInfo;
import org.apache.cassandra.io.CompactionType;
import org.apache.cassandra.locator.SimpleSnitch;
import org.apache.cassandra.thrift.AuthenticationException;
import org.apache.cassandra.thrift.AuthenticationRequest;
import org.apache.cassandra.thrift.AuthorizationException;
import org.apache.cassandra.thrift.Cassandra;
import org.apache.cassandra.thrift.CfDef;
import org.apache.cassandra.thrift.Column;
import org.apache.cassandra.thrift.ColumnDef;
import org.apache.cassandra.thrift.ColumnOrSuperColumn;
import org.apache.cassandra.thrift.ColumnParent;
import org.apache.cassandra.thrift.ColumnPath;
import org.apache.cassandra.thrift.ConsistencyLevel;
import org.apache.cassandra.thrift.CounterColumn;
import org.apache.cassandra.thrift.IndexClause;
import org.apache.cassandra.thrift.IndexExpression;
import org.apache.cassandra.thrift.IndexOperator;
import org.apache.cassandra.thrift.IndexType;
import org.apache.cassandra.thrift.InvalidRequestException;
import org.apache.cassandra.thrift.KeyRange;
import org.apache.cassandra.thrift.KeySlice;
import org.apache.cassandra.thrift.KsDef;
import org.apache.cassandra.thrift.NotFoundException;
import org.apache.cassandra.thrift.SchemaDisagreementException;
import org.apache.cassandra.thrift.SlicePredicate;
import org.apache.cassandra.thrift.SliceRange;
import org.apache.cassandra.thrift.SuperColumn;
import org.apache.cassandra.thrift.TimedOutException;
import org.apache.cassandra.thrift.UnavailableException;
import org.apache.cassandra.tools.NodeProbe;
import org.apache.cassandra.utils.ByteBufferUtil;
import org.apache.cassandra.utils.FBUtilities;
import org.apache.cassandra.utils.UUIDGen;
import org.apache.thrift.TBaseHelper;
import org.apache.thrift.TException;
import org.yaml.snakeyaml.Loader;
import org.yaml.snakeyaml.TypeDescription;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.constructor.BaseConstructor;
import org.yaml.snakeyaml.constructor.Constructor;

public class CliClient {
    private static final String DEFAULT_PLACEMENT_STRATEGY = "org.apache.cassandra.locator.NetworkTopologyStrategy";
    private Cassandra.Client thriftClient = null;
    private CliSessionState sessionState = null;
    private String keySpace = null;
    private String username = null;
    private Map<String, KsDef> keyspacesMap = new HashMap<String, KsDef>();
    private Map<String, AbstractType> cfKeysComparators;
    private ConsistencyLevel consistencyLevel = ConsistencyLevel.ONE;
    private CliUserHelp help;

    public CliClient(CliSessionState cliSessionState, Cassandra.Client thriftClient) {
        this.sessionState = cliSessionState;
        this.thriftClient = thriftClient;
        this.cfKeysComparators = new HashMap<String, AbstractType>();
        this.help = this.getHelp();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CliUserHelp getHelp() {
        InputStream is = CliClient.class.getClassLoader().getResourceAsStream("org/apache/cassandra/cli/CliHelp.yaml");
        assert (is != null);
        try {
            Constructor constructor = new Constructor(CliUserHelp.class);
            TypeDescription desc = new TypeDescription(CliUserHelp.class);
            desc.putListPropertyType("commands", CliCommandHelp.class);
            Yaml yaml = new Yaml(new Loader((BaseConstructor)constructor));
            CliUserHelp cliUserHelp = (CliUserHelp)yaml.load(is);
            return cliUserHelp;
        }
        finally {
            try {
                is.close();
            }
            catch (IOException e) {
                throw new IOError(e);
            }
        }
    }

    public void printBanner() {
        this.sessionState.out.println(this.help.banner);
    }

    public void executeCLIStatement(String statement) {
        Tree tree = CliCompiler.compileQuery(statement);
        try {
            switch (tree.getType()) {
                case 8: {
                    this.cleanupAndExit();
                    break;
                }
                case 14: {
                    this.executeGet(tree);
                    break;
                }
                case 15: {
                    this.executeGetWithConditions(tree);
                    break;
                }
                case 9: {
                    this.executeHelp(tree);
                    break;
                }
                case 16: {
                    this.executeSet(tree);
                    break;
                }
                case 18: {
                    this.executeDelete(tree);
                    break;
                }
                case 17: {
                    this.executeCount(tree);
                    break;
                }
                case 22: {
                    this.executeAddKeySpace(tree.getChild(0));
                    break;
                }
                case 21: {
                    this.executeAddColumnFamily(tree.getChild(0));
                    break;
                }
                case 25: {
                    this.executeUpdateKeySpace(tree.getChild(0));
                    break;
                }
                case 26: {
                    this.executeUpdateColumnFamily(tree.getChild(0));
                    break;
                }
                case 24: {
                    this.executeDelColumnFamily(tree);
                    break;
                }
                case 23: {
                    this.executeDelKeySpace(tree);
                    break;
                }
                case 11: {
                    this.executeShowClusterName();
                    break;
                }
                case 12: {
                    this.executeShowVersion();
                    break;
                }
                case 13: {
                    this.executeShowKeySpaces();
                    break;
                }
                case 5: {
                    this.executeDescribeKeySpace(tree);
                    break;
                }
                case 6: {
                    this.executeDescribeCluster();
                    break;
                }
                case 7: {
                    this.executeUseKeySpace(tree);
                    break;
                }
                case 4: {
                    this.executeConnect(tree);
                    break;
                }
                case 27: {
                    this.executeList(tree);
                    break;
                }
                case 28: {
                    this.executeTruncate(tree.getChild(0).getText());
                    break;
                }
                case 29: {
                    this.executeAssumeStatement(tree);
                    break;
                }
                case 30: {
                    this.executeConsistencyLevelStatement(tree);
                }
                case 19: {
                    this.executeIncr(tree, 1L);
                    break;
                }
                case 20: {
                    this.executeIncr(tree, -1L);
                    break;
                }
                case 10: {
                    break;
                }
                default: {
                    this.sessionState.err.println("Invalid Statement (Type: " + tree.getType() + ")");
                    if (this.sessionState.batch) {
                        System.exit(2);
                    }
                    break;
                }
            }
        }
        catch (InvalidRequestException e) {
            throw new RuntimeException(e.getWhy());
        }
        catch (SchemaDisagreementException e) {
            throw new RuntimeException("schema does not match across nodes, (try again later).");
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    private void cleanupAndExit() {
        CliMain.disconnect();
        System.exit(0);
    }

    public KsDef getKSMetaData(String keyspace) throws NotFoundException, InvalidRequestException, TException {
        if (!this.keyspacesMap.containsKey(keyspace)) {
            this.keyspacesMap.put(keyspace, this.thriftClient.describe_keyspace(keyspace));
        }
        return this.keyspacesMap.get(keyspace);
    }

    private void executeHelp(Tree tree) {
        if (tree.getChildCount() > 0) {
            String token = tree.getChild(0).getText();
            for (CliCommandHelp ch : this.help.commands) {
                if (!token.equals(ch.name)) continue;
                this.sessionState.out.println(ch.help);
                break;
            }
        } else {
            this.sessionState.out.println(this.help.help);
        }
    }

    private void executeCount(Tree statement) throws TException, InvalidRequestException, UnavailableException, TimedOutException {
        if (!CliMain.isConnected() || !this.hasKeySpace()) {
            return;
        }
        Tree columnFamilySpec = statement.getChild(0);
        String key = CliCompiler.getKey(columnFamilySpec);
        String columnFamily = CliCompiler.getColumnFamily(columnFamilySpec, (List<CfDef>)this.keyspacesMap.get((Object)this.keySpace).cf_defs);
        int columnSpecCnt = CliCompiler.numColumnSpecifiers(columnFamilySpec);
        ColumnParent colParent = new ColumnParent(columnFamily).setSuper_column((ByteBuffer)null);
        if (columnSpecCnt != 0) {
            byte[] superColumn = this.columnNameAsByteArray(CliCompiler.getColumn(columnFamilySpec, 0), columnFamily);
            colParent = new ColumnParent(columnFamily).setSuper_column(superColumn);
        }
        SliceRange range = new SliceRange(ByteBufferUtil.EMPTY_BYTE_BUFFER, ByteBufferUtil.EMPTY_BYTE_BUFFER, false, Integer.MAX_VALUE);
        SlicePredicate predicate = new SlicePredicate().setColumn_names(null).setSlice_range(range);
        int count = this.thriftClient.get_count(ByteBufferUtil.bytes(key), colParent, predicate, this.consistencyLevel);
        this.sessionState.out.printf("%d columns%n", count);
    }

    private void executeDelete(Tree statement) throws TException, InvalidRequestException, UnavailableException, TimedOutException {
        if (!CliMain.isConnected() || !this.hasKeySpace()) {
            return;
        }
        Tree columnFamilySpec = statement.getChild(0);
        String key = CliCompiler.getKey(columnFamilySpec);
        String columnFamily = CliCompiler.getColumnFamily(columnFamilySpec, (List<CfDef>)this.keyspacesMap.get((Object)this.keySpace).cf_defs);
        int columnSpecCnt = CliCompiler.numColumnSpecifiers(columnFamilySpec);
        byte[] superColumnName = null;
        byte[] columnName = null;
        CfDef cfDef = this.getCfDef(columnFamily);
        boolean isSuper = cfDef.column_type.equals("Super");
        if (columnSpecCnt < 0 || columnSpecCnt > 2) {
            this.sessionState.out.println("Invalid row, super column, or column specification.");
            return;
        }
        if (columnSpecCnt == 1) {
            if (isSuper) {
                superColumnName = this.columnNameAsByteArray(CliCompiler.getColumn(columnFamilySpec, 0), cfDef);
            } else {
                columnName = this.columnNameAsByteArray(CliCompiler.getColumn(columnFamilySpec, 0), cfDef);
            }
        } else if (columnSpecCnt == 2) {
            superColumnName = this.columnNameAsByteArray(CliCompiler.getColumn(columnFamilySpec, 0), cfDef);
            columnName = this.subColumnNameAsByteArray(CliCompiler.getColumn(columnFamilySpec, 1), cfDef);
        }
        ColumnPath path = new ColumnPath(columnFamily);
        if (superColumnName != null) {
            path.setSuper_column(superColumnName);
        }
        if (columnName != null) {
            path.setColumn(columnName);
        }
        if (this.isCounterCF(cfDef)) {
            this.thriftClient.remove_counter(ByteBufferUtil.bytes(key), path, this.consistencyLevel);
        } else {
            this.thriftClient.remove(ByteBufferUtil.bytes(key), path, FBUtilities.timestampMicros(), this.consistencyLevel);
        }
        this.sessionState.out.println(String.format("%s removed.", columnSpecCnt == 0 ? "row" : "column"));
    }

    private void doSlice(String keyspace, ByteBuffer key, String columnFamily, byte[] superColumnName) throws InvalidRequestException, UnavailableException, TimedOutException, TException, IllegalAccessException, NotFoundException, InstantiationException, NoSuchFieldException {
        ColumnParent parent = new ColumnParent(columnFamily);
        if (superColumnName != null) {
            parent.setSuper_column(superColumnName);
        }
        SliceRange range = new SliceRange(ByteBufferUtil.EMPTY_BYTE_BUFFER, ByteBufferUtil.EMPTY_BYTE_BUFFER, false, 1000000);
        SlicePredicate predicate = new SlicePredicate().setColumn_names(null).setSlice_range(range);
        CfDef cfDef = this.getCfDef(columnFamily);
        boolean isSuperCF = cfDef.column_type.equals("Super");
        List columns = this.thriftClient.get_slice(key, parent, predicate, this.consistencyLevel);
        for (ColumnOrSuperColumn cosc : columns) {
            String formattedName;
            Column column;
            AbstractType validator;
            SuperColumn superColumn;
            if (cosc.isSetSuper_column()) {
                superColumn = cosc.super_column;
                this.sessionState.out.printf("=> (super_column=%s,", this.formatColumnName(keyspace, columnFamily, superColumn.name));
                for (Column col : superColumn.getColumns()) {
                    validator = this.getValidatorForValue(cfDef, col.getName());
                    this.sessionState.out.printf("%n     (column=%s, value=%s, timestamp=%d%s)", this.formatSubcolumnName(keyspace, columnFamily, col.name), validator.getString(col.value), col.timestamp, col.isSetTtl() ? String.format(", ttl=%d", col.getTtl()) : "");
                }
                this.sessionState.out.println(")");
                continue;
            }
            if (cosc.isSetColumn()) {
                column = cosc.column;
                validator = this.getValidatorForValue(cfDef, column.getName());
                formattedName = isSuperCF ? this.formatSubcolumnName(keyspace, columnFamily, column.name) : this.formatColumnName(keyspace, columnFamily, column.name);
                this.sessionState.out.printf("=> (column=%s, value=%s, timestamp=%d%s)%n", formattedName, validator.getString(column.value), column.timestamp, column.isSetTtl() ? String.format(", ttl=%d", column.getTtl()) : "");
                continue;
            }
            if (cosc.isSetCounter_super_column()) {
                superColumn = cosc.counter_super_column;
                this.sessionState.out.printf("=> (super_column=%s,", this.formatColumnName(keyspace, columnFamily, superColumn.name));
                for (Column col : superColumn.getColumns()) {
                    this.sessionState.out.printf("%n     (counter=%s, value=%s)", this.formatSubcolumnName(keyspace, columnFamily, col.name), col.value);
                }
                this.sessionState.out.println(")");
                continue;
            }
            column = cosc.counter_column;
            formattedName = isSuperCF ? this.formatSubcolumnName(keyspace, columnFamily, column.name) : this.formatColumnName(keyspace, columnFamily, column.name);
            this.sessionState.out.printf("=> (counter=%s, value=%s)%n", formattedName, column.value);
        }
        this.sessionState.out.println("Returned " + columns.size() + " results.");
    }

    private AbstractType getFormatType(String compareWith) {
        Function function;
        try {
            function = Function.valueOf(compareWith.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            try {
                return FBUtilities.getComparator(compareWith);
            }
            catch (ConfigurationException ce) {
                StringBuilder errorMessage = new StringBuilder("Unknown comparator '" + compareWith + "'. ");
                errorMessage.append("Available functions: ");
                throw new RuntimeException(errorMessage.append(Function.getFunctionNames()).toString());
            }
        }
        return function.getValidator();
    }

    private void executeGet(Tree statement) throws TException, NotFoundException, InvalidRequestException, UnavailableException, TimedOutException, IllegalAccessException, InstantiationException, ClassNotFoundException, NoSuchFieldException {
        String valueAsString;
        Column column;
        ByteBuffer columnName;
        if (!CliMain.isConnected() || !this.hasKeySpace()) {
            return;
        }
        Tree columnFamilySpec = statement.getChild(0);
        String columnFamily = CliCompiler.getColumnFamily(columnFamilySpec, (List<CfDef>)this.keyspacesMap.get((Object)this.keySpace).cf_defs);
        ByteBuffer key = this.getKeyAsBytes(columnFamily, columnFamilySpec.getChild(1));
        int columnSpecCnt = CliCompiler.numColumnSpecifiers(columnFamilySpec);
        CfDef cfDef = this.getCfDef(columnFamily);
        boolean isSuper = cfDef.column_type.equals("Super");
        byte[] superColumnName = null;
        if (columnSpecCnt == 0) {
            this.doSlice(this.keySpace, key, columnFamily, superColumnName);
            return;
        }
        if (columnSpecCnt == 1) {
            columnName = this.getColumnName(columnFamily, columnFamilySpec.getChild(2));
            if (isSuper) {
                superColumnName = columnName.array();
                this.doSlice(this.keySpace, key, columnFamily, superColumnName);
                return;
            }
        } else if (columnSpecCnt == 2) {
            superColumnName = this.getColumnName(columnFamily, columnFamilySpec.getChild(2)).array();
            columnName = this.getSubColumnName(columnFamily, columnFamilySpec.getChild(3));
        } else {
            this.sessionState.out.println("Invalid row, super column, or column specification.");
            return;
        }
        AbstractType validator = this.getValidatorForValue(cfDef, TBaseHelper.byteBufferToByteArray((ByteBuffer)columnName));
        ColumnPath path = new ColumnPath(columnFamily);
        if (superColumnName != null) {
            path.setSuper_column(superColumnName);
        }
        path.setColumn(columnName);
        if (this.isCounterCF(cfDef)) {
            this.doGetCounter(key, path);
            return;
        }
        try {
            column = this.thriftClient.get((ByteBuffer)key, (ColumnPath)path, (ConsistencyLevel)this.consistencyLevel).column;
        }
        catch (NotFoundException e) {
            this.sessionState.out.println("Value was not found");
            return;
        }
        byte[] columnValue = column.getValue();
        if (statement.getChildCount() == 2) {
            Tree typeTree = statement.getChild(1).getChild(0);
            String typeName = CliUtils.unescapeSQLString(typeTree.getText());
            AbstractType valueValidator = this.getFormatType(typeName);
            valueAsString = valueValidator.getString(ByteBuffer.wrap(columnValue));
            this.updateColumnMetaData(cfDef, columnName, valueValidator.getClass().getName());
        } else {
            valueAsString = validator == null ? new String(columnValue, Charsets.UTF_8) : validator.getString(ByteBuffer.wrap(columnValue));
        }
        String formattedColumnName = isSuper ? this.formatSubcolumnName(this.keySpace, columnFamily, column.name) : this.formatColumnName(this.keySpace, columnFamily, column.name);
        this.sessionState.out.printf("=> (column=%s, value=%s, timestamp=%d%s)%n", formattedColumnName, valueAsString, column.timestamp, column.isSetTtl() ? String.format(", ttl=%d", column.getTtl()) : "");
    }

    private void doGetCounter(ByteBuffer key, ColumnPath path) throws TException, NotFoundException, InvalidRequestException, UnavailableException, TimedOutException, IllegalAccessException, InstantiationException, ClassNotFoundException, NoSuchFieldException {
        CounterColumn column;
        boolean isSuper = path.super_column != null;
        try {
            column = this.thriftClient.get((ByteBuffer)key, (ColumnPath)path, (ConsistencyLevel)this.consistencyLevel).counter_column;
        }
        catch (NotFoundException e) {
            this.sessionState.out.println("Value was not found");
            return;
        }
        String formattedColumnName = isSuper ? this.formatSubcolumnName(this.keySpace, path.column_family, column.name) : this.formatColumnName(this.keySpace, path.column_family, column.name);
        this.sessionState.out.printf("=> (counter=%s, value=%d)%n", formattedColumnName, column.value);
    }

    private void executeGetWithConditions(Tree statement) {
        if (!CliMain.isConnected() || !this.hasKeySpace()) {
            return;
        }
        IndexClause clause = new IndexClause();
        String columnFamily = CliCompiler.getColumnFamily(statement, (List<CfDef>)this.keyspacesMap.get((Object)this.keySpace).cf_defs);
        Tree conditions = statement.getChild(1);
        CfDef columnFamilyDef = this.getCfDef(columnFamily);
        SlicePredicate predicate = new SlicePredicate();
        SliceRange sliceRange = new SliceRange();
        sliceRange.setStart(new byte[0]).setFinish(new byte[0]);
        predicate.setSlice_range(sliceRange);
        for (int i = 0; i < conditions.getChildCount(); ++i) {
            Tree condition = conditions.getChild(i);
            String operator = condition.getChild(0).getText();
            String columnNameString = CliUtils.unescapeSQLString(condition.getChild(1).getText());
            Tree valueTree = condition.getChild(2);
            try {
                ByteBuffer value;
                ByteBuffer columnName = this.columnNameAsBytes(columnNameString, columnFamily);
                if (valueTree.getType() == 36) {
                    value = this.convertValueByFunction(valueTree, columnFamilyDef, columnName);
                } else {
                    String valueString = CliUtils.unescapeSQLString(valueTree.getText());
                    value = this.columnValueAsBytes(columnName, columnFamily, valueString);
                }
                IndexOperator idxOperator = CliUtils.getIndexOperator(operator);
                clause.addToExpressions(new IndexExpression(columnName, idxOperator, value));
                continue;
            }
            catch (Exception e) {
                throw new RuntimeException(e.getMessage());
            }
        }
        clause.setStart_key(new byte[0]);
        if (statement.getChildCount() == 3) {
            Tree limitNode = statement.getChild(2);
            int limitValue = Integer.parseInt(limitNode.getChild(0).getText());
            if (limitValue == 0) {
                throw new IllegalArgumentException("LIMIT should be greater than zero.");
            }
            clause.setCount(limitValue);
        }
        try {
            ColumnParent parent = new ColumnParent(columnFamily);
            List slices = this.thriftClient.get_indexed_slices(parent, clause, predicate, this.consistencyLevel);
            this.printSliceList(columnFamilyDef, slices);
        }
        catch (InvalidRequestException e) {
            throw new RuntimeException(e.getWhy());
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    private void executeSet(Tree statement) throws TException, InvalidRequestException, UnavailableException, TimedOutException, NoSuchFieldException, InstantiationException, IllegalAccessException {
        ByteBuffer columnValueInBytes;
        ByteBuffer columnName;
        if (!CliMain.isConnected() || !this.hasKeySpace()) {
            return;
        }
        Tree columnFamilySpec = statement.getChild(0);
        Tree keyTree = columnFamilySpec.getChild(1);
        String columnFamily = CliCompiler.getColumnFamily(columnFamilySpec, (List<CfDef>)this.keyspacesMap.get((Object)this.keySpace).cf_defs);
        CfDef cfDef = this.getCfDef(columnFamily);
        int columnSpecCnt = CliCompiler.numColumnSpecifiers(columnFamilySpec);
        String value = CliUtils.unescapeSQLString(statement.getChild(1).getText());
        Tree valueTree = statement.getChild(1);
        byte[] superColumnName = null;
        if (columnSpecCnt == 0) {
            this.sessionState.err.println("No column name specified, (type 'help;' or '?' for help on syntax).");
            return;
        }
        if (columnSpecCnt == 1) {
            if (cfDef.column_type.equals("Super")) {
                this.sessionState.out.println("Column family " + columnFamily + " may only contain SuperColumns");
                return;
            }
            columnName = this.getColumnName(columnFamily, columnFamilySpec.getChild(2));
        } else {
            assert (columnSpecCnt == 2) : "serious parsing error (this is a bug).";
            superColumnName = this.getColumnName(columnFamily, columnFamilySpec.getChild(2)).array();
            columnName = this.getSubColumnName(columnFamily, columnFamilySpec.getChild(3));
        }
        switch (valueTree.getType()) {
            case 36: {
                columnValueInBytes = this.convertValueByFunction(valueTree, cfDef, columnName, true);
                break;
            }
            default: {
                columnValueInBytes = this.columnValueAsBytes(columnName, columnFamily, value);
            }
        }
        ColumnParent parent = new ColumnParent(columnFamily);
        if (superColumnName != null) {
            parent.setSuper_column(superColumnName);
        }
        Column columnToInsert = new Column(columnName).setValue(columnValueInBytes).setTimestamp(FBUtilities.timestampMicros());
        if (statement.getChildCount() == 3) {
            String ttl = statement.getChild(2).getText();
            try {
                columnToInsert.setTtl(Integer.parseInt(ttl));
            }
            catch (NumberFormatException e) {
                this.sessionState.err.println(String.format("TTL '%s' is invalid, should be a positive integer.", ttl));
                return;
            }
            catch (Exception e) {
                throw new RuntimeException(e.getMessage());
            }
        }
        this.thriftClient.insert(this.getKeyAsBytes(columnFamily, keyTree), parent, columnToInsert, this.consistencyLevel);
        this.sessionState.out.println("Value inserted.");
    }

    private void executeIncr(Tree statement, long multiplier) throws TException, NotFoundException, InvalidRequestException, UnavailableException, TimedOutException, IllegalAccessException, InstantiationException, ClassNotFoundException, NoSuchFieldException {
        ByteBuffer columnName;
        if (!CliMain.isConnected() || !this.hasKeySpace()) {
            return;
        }
        Tree columnFamilySpec = statement.getChild(0);
        String columnFamily = CliCompiler.getColumnFamily(columnFamilySpec, (List<CfDef>)this.keyspacesMap.get((Object)this.keySpace).cf_defs);
        ByteBuffer key = this.getKeyAsBytes(columnFamily, columnFamilySpec.getChild(1));
        int columnSpecCnt = CliCompiler.numColumnSpecifiers(columnFamilySpec);
        CfDef cfDef = this.getCfDef(columnFamily);
        boolean isSuper = cfDef.column_type.equals("Super");
        byte[] superColumnName = null;
        if (columnSpecCnt == 1) {
            columnName = this.getColumnName(columnFamily, columnFamilySpec.getChild(2));
        } else if (columnSpecCnt == 2) {
            superColumnName = this.getColumnName(columnFamily, columnFamilySpec.getChild(2)).array();
            columnName = this.getSubColumnName(columnFamily, columnFamilySpec.getChild(3));
        } else {
            this.sessionState.out.println("Invalid row, super column, or column specification.");
            return;
        }
        ColumnParent parent = new ColumnParent(columnFamily);
        if (superColumnName != null) {
            parent.setSuper_column(superColumnName);
        }
        long value = 1L;
        if (statement.getChildCount() == 2) {
            String byValue = statement.getChild(1).getText();
            try {
                value = Long.parseLong(byValue);
            }
            catch (NumberFormatException e) {
                this.sessionState.err.println(String.format("'%s' is an invalid value, should be an integer.", byValue));
                return;
            }
            catch (Exception e) {
                throw new RuntimeException(e.getMessage());
            }
        }
        CounterColumn columnToInsert = new CounterColumn(columnName, multiplier * value);
        this.thriftClient.add(key, parent, columnToInsert, this.consistencyLevel);
        this.sessionState.out.printf("Value %s%n", multiplier < 0L ? "decremented." : "incremented.");
    }

    private void executeShowClusterName() throws TException {
        if (!CliMain.isConnected()) {
            return;
        }
        this.sessionState.out.println(this.thriftClient.describe_cluster_name());
    }

    private void executeAddKeySpace(Tree statement) {
        if (!CliMain.isConnected()) {
            return;
        }
        String keyspaceName = statement.getChild(0).getText();
        KsDef ksDef = new KsDef(keyspaceName, DEFAULT_PLACEMENT_STRATEGY, new LinkedList());
        try {
            String mySchemaVersion = this.thriftClient.system_add_keyspace(this.updateKsDefAttributes(statement, ksDef));
            this.sessionState.out.println(mySchemaVersion);
            this.validateSchemaIsSettled(mySchemaVersion);
            this.keyspacesMap.put(keyspaceName, this.thriftClient.describe_keyspace(keyspaceName));
        }
        catch (InvalidRequestException e) {
            throw new RuntimeException(e.getWhy());
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    private void executeAddColumnFamily(Tree statement) {
        if (!CliMain.isConnected() || !this.hasKeySpace()) {
            return;
        }
        CfDef cfDef = new CfDef(this.keySpace, statement.getChild(0).getText());
        try {
            String mySchemaVersion = this.thriftClient.system_add_column_family(this.updateCfDefAttributes(statement, cfDef));
            this.sessionState.out.println(mySchemaVersion);
            this.validateSchemaIsSettled(mySchemaVersion);
            this.keyspacesMap.put(this.keySpace, this.thriftClient.describe_keyspace(this.keySpace));
        }
        catch (InvalidRequestException e) {
            throw new RuntimeException(e.getWhy());
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    private void executeUpdateKeySpace(Tree statement) {
        if (!CliMain.isConnected()) {
            return;
        }
        try {
            String keyspaceName = CliCompiler.getKeySpace(statement, (List<KsDef>)this.thriftClient.describe_keyspaces());
            KsDef currentKsDef = this.getKSMetaData(keyspaceName);
            KsDef updatedKsDef = this.updateKsDefAttributes(statement, currentKsDef);
            String mySchemaVersion = this.thriftClient.system_update_keyspace(updatedKsDef);
            this.sessionState.out.println(mySchemaVersion);
            this.validateSchemaIsSettled(mySchemaVersion);
            this.keyspacesMap.put(keyspaceName, this.thriftClient.describe_keyspace(keyspaceName));
        }
        catch (InvalidRequestException e) {
            throw new RuntimeException(e.getWhy());
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    private void executeUpdateColumnFamily(Tree statement) {
        if (!CliMain.isConnected() || !this.hasKeySpace()) {
            return;
        }
        String cfName = CliCompiler.getColumnFamily(statement, (List<CfDef>)this.keyspacesMap.get((Object)this.keySpace).cf_defs);
        CfDef cfDef = this.getCfDef(cfName);
        try {
            String mySchemaVersion = this.thriftClient.system_update_column_family(this.updateCfDefAttributes(statement, cfDef));
            this.sessionState.out.println(mySchemaVersion);
            this.validateSchemaIsSettled(mySchemaVersion);
            this.keyspacesMap.put(this.keySpace, this.thriftClient.describe_keyspace(this.keySpace));
        }
        catch (InvalidRequestException e) {
            throw new RuntimeException(e.getWhy());
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    private KsDef updateKsDefAttributes(Tree statement, KsDef ksDefToUpdate) {
        Map currentStrategyOptions;
        KsDef ksDef = new KsDef(ksDefToUpdate);
        ksDef.setCf_defs(new LinkedList());
        block6: for (int i = 1; i < statement.getChildCount(); i += 2) {
            String currentStatement = statement.getChild(i).getText().toUpperCase();
            AddKeyspaceArgument mArgument = AddKeyspaceArgument.valueOf(currentStatement);
            String mValue = statement.getChild(i + 1).getText();
            switch (mArgument) {
                case PLACEMENT_STRATEGY: {
                    ksDef.setStrategy_class(CliUtils.unescapeSQLString(mValue));
                    continue block6;
                }
                case STRATEGY_OPTIONS: {
                    ksDef.setStrategy_options(this.getStrategyOptionsFromTree(statement.getChild(i + 1)));
                    continue block6;
                }
                default: {
                    assert (false);
                    continue block6;
                }
            }
        }
        if (ksDef.getStrategy_class().contains(".NetworkTopologyStrategy") && ((currentStrategyOptions = ksDef.getStrategy_options()) == null || currentStrategyOptions.isEmpty())) {
            SimpleSnitch snitch = new SimpleSnitch();
            HashMap<String, String> options = new HashMap<String, String>();
            try {
                options.put(snitch.getDatacenter(InetAddress.getLocalHost()), "1");
            }
            catch (UnknownHostException e) {
                throw new RuntimeException(e.getMessage());
            }
            ksDef.setStrategy_options(options);
        }
        return ksDef;
    }

    private CfDef updateCfDefAttributes(Tree statement, CfDef cfDefToUpdate) {
        CfDef cfDef = new CfDef(cfDefToUpdate);
        block22: for (int i = 1; i < statement.getChildCount(); i += 2) {
            String currentArgument = statement.getChild(i).getText().toUpperCase();
            ColumnFamilyArgument mArgument = ColumnFamilyArgument.valueOf(currentArgument);
            String mValue = statement.getChild(i + 1).getText();
            switch (mArgument) {
                case COLUMN_TYPE: {
                    cfDef.setColumn_type(CliUtils.unescapeSQLString(mValue));
                    continue block22;
                }
                case COMPARATOR: {
                    cfDef.setComparator_type(CliUtils.unescapeSQLString(mValue));
                    continue block22;
                }
                case SUBCOMPARATOR: {
                    cfDef.setSubcomparator_type(CliUtils.unescapeSQLString(mValue));
                    continue block22;
                }
                case COMMENT: {
                    cfDef.setComment(CliUtils.unescapeSQLString(mValue));
                    continue block22;
                }
                case ROWS_CACHED: {
                    cfDef.setRow_cache_size(Double.parseDouble(mValue));
                    continue block22;
                }
                case KEYS_CACHED: {
                    cfDef.setKey_cache_size(Double.parseDouble(mValue));
                    continue block22;
                }
                case READ_REPAIR_CHANCE: {
                    double chance = Double.parseDouble(mValue);
                    if (chance < 0.0 || chance > 1.0) {
                        throw new RuntimeException("Error: read_repair_chance must be between 0 and 1.");
                    }
                    cfDef.setRead_repair_chance(chance);
                    continue block22;
                }
                case GC_GRACE: {
                    cfDef.setGc_grace_seconds(Integer.parseInt(mValue));
                    continue block22;
                }
                case COLUMN_METADATA: {
                    Tree arrayOfMetaAttributes = statement.getChild(i + 1);
                    if (!arrayOfMetaAttributes.getText().equals("ARRAY")) {
                        throw new RuntimeException("'column_metadata' format - [{ k:v, k:v, ..}, { ... }, ...]");
                    }
                    cfDef.setColumn_metadata(this.getCFColumnMetaFromTree(cfDef, arrayOfMetaAttributes));
                    continue block22;
                }
                case MEMTABLE_OPERATIONS: {
                    cfDef.setMemtable_operations_in_millions(Double.parseDouble(mValue));
                    continue block22;
                }
                case MEMTABLE_FLUSH_AFTER: {
                    cfDef.setMemtable_flush_after_mins(Integer.parseInt(mValue));
                    continue block22;
                }
                case MEMTABLE_THROUGHPUT: {
                    cfDef.setMemtable_throughput_in_mb(Integer.parseInt(mValue));
                    continue block22;
                }
                case ROW_CACHE_SAVE_PERIOD: {
                    cfDef.setRow_cache_save_period_in_seconds(Integer.parseInt(mValue));
                    continue block22;
                }
                case KEY_CACHE_SAVE_PERIOD: {
                    cfDef.setKey_cache_save_period_in_seconds(Integer.parseInt(mValue));
                    continue block22;
                }
                case DEFAULT_VALIDATION_CLASS: {
                    cfDef.setDefault_validation_class(mValue);
                    continue block22;
                }
                case MIN_COMPACTION_THRESHOLD: {
                    cfDef.setMin_compaction_threshold(Integer.parseInt(mValue));
                    continue block22;
                }
                case MAX_COMPACTION_THRESHOLD: {
                    cfDef.setMax_compaction_threshold(Integer.parseInt(mValue));
                    continue block22;
                }
                case REPLICATE_ON_WRITE: {
                    cfDef.setReplicate_on_write(Boolean.parseBoolean(mValue));
                    continue block22;
                }
                case ROW_CACHE_PROVIDER: {
                    cfDef.setRow_cache_provider(mValue);
                    continue block22;
                }
                case KEY_VALIDATION_CLASS: {
                    cfDef.setKey_validation_class(CliUtils.unescapeSQLString(mValue));
                    continue block22;
                }
                default: {
                    assert (false);
                    continue block22;
                }
            }
        }
        return cfDef;
    }

    private void executeDelKeySpace(Tree statement) throws TException, InvalidRequestException, NotFoundException, SchemaDisagreementException {
        if (!CliMain.isConnected()) {
            return;
        }
        String keyspaceName = CliCompiler.getKeySpace(statement, (List<KsDef>)this.thriftClient.describe_keyspaces());
        String version = this.thriftClient.system_drop_keyspace(keyspaceName);
        this.sessionState.out.println(version);
        this.validateSchemaIsSettled(version);
    }

    private void executeDelColumnFamily(Tree statement) throws TException, InvalidRequestException, NotFoundException, SchemaDisagreementException {
        if (!CliMain.isConnected() || !this.hasKeySpace()) {
            return;
        }
        String cfName = CliCompiler.getColumnFamily(statement, (List<CfDef>)this.keyspacesMap.get((Object)this.keySpace).cf_defs);
        String mySchemaVersion = this.thriftClient.system_drop_column_family(cfName);
        this.sessionState.out.println(mySchemaVersion);
        this.validateSchemaIsSettled(mySchemaVersion);
    }

    private void executeList(Tree statement) throws TException, InvalidRequestException, NotFoundException, IllegalAccessException, InstantiationException, NoSuchFieldException, UnavailableException, TimedOutException, CharacterCodingException {
        if (!CliMain.isConnected() || !this.hasKeySpace()) {
            return;
        }
        String columnFamily = CliCompiler.getColumnFamily(statement, (List<CfDef>)this.keyspacesMap.get((Object)this.keySpace).cf_defs);
        String rawStartKey = "";
        String rawEndKey = "";
        int limitCount = Integer.MAX_VALUE;
        for (int i = 1; i < statement.getChildCount(); ++i) {
            Tree child = statement.getChild(i);
            if (child.getType() == 43) {
                if (child.getChildCount() <= 0) continue;
                rawStartKey = CliUtils.unescapeSQLString(child.getChild(0).getText());
                if (child.getChildCount() <= 1) continue;
                rawEndKey = CliUtils.unescapeSQLString(child.getChild(1).getText());
                continue;
            }
            if (child.getChildCount() != 1) {
                this.sessionState.out.println("Invalid limit clause");
                return;
            }
            limitCount = Integer.parseInt(child.getChild(0).getText());
            if (limitCount > 0) continue;
            this.sessionState.out.println("Invalid limit " + limitCount);
            return;
        }
        if (limitCount == Integer.MAX_VALUE) {
            limitCount = 100;
            this.sessionState.out.println("Using default limit of 100");
        }
        CfDef columnFamilyDef = this.getCfDef(columnFamily);
        SlicePredicate predicate = new SlicePredicate();
        SliceRange sliceRange = new SliceRange();
        sliceRange.setStart(new byte[0]).setFinish(new byte[0]);
        sliceRange.setCount(Integer.MAX_VALUE);
        predicate.setSlice_range(sliceRange);
        KeyRange range = new KeyRange(limitCount);
        AbstractType keyComparator = this.cfKeysComparators.get(columnFamily);
        ByteBuffer startKey = rawStartKey.isEmpty() ? ByteBufferUtil.EMPTY_BYTE_BUFFER : this.getBytesAccordingToType(rawStartKey, keyComparator);
        ByteBuffer endKey = rawEndKey.isEmpty() ? ByteBufferUtil.EMPTY_BYTE_BUFFER : this.getBytesAccordingToType(rawEndKey, keyComparator);
        range.setStart_key(startKey).setEnd_key(endKey);
        ColumnParent columnParent = new ColumnParent(columnFamily);
        List keySlices = this.thriftClient.get_range_slices(columnParent, predicate, range, this.consistencyLevel);
        this.printSliceList(columnFamilyDef, keySlices);
    }

    private void executeTruncate(String columnFamily) {
        if (!CliMain.isConnected() || !this.hasKeySpace()) {
            return;
        }
        CfDef cfDef = this.getCfDef(CliCompiler.getColumnFamily(columnFamily, (List<CfDef>)this.keyspacesMap.get((Object)this.keySpace).cf_defs));
        try {
            this.thriftClient.truncate(cfDef.getName());
            this.sessionState.out.println(columnFamily + " truncated.");
        }
        catch (InvalidRequestException e) {
            throw new RuntimeException(e.getWhy());
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    private void executeConsistencyLevelStatement(Tree statement) {
        if (!CliMain.isConnected()) {
            return;
        }
        String userSuppliedLevel = statement.getChild(0).getText().toUpperCase();
        try {
            this.consistencyLevel = ConsistencyLevel.valueOf((String)userSuppliedLevel);
        }
        catch (IllegalArgumentException e) {
            String elements = "ONE, TWO, THREE, QUORUM, ALL, LOCAL_QUORUM, EACH_QUORUM, ANY";
            this.sessionState.out.println(String.format("'%s' is invalid. Available: %s", userSuppliedLevel, elements));
            return;
        }
        this.sessionState.out.println(String.format("Consistency level is set to '%s'.", this.consistencyLevel));
    }

    private void executeAssumeStatement(Tree statement) {
        AbstractType comparator;
        if (!CliMain.isConnected() || !this.hasKeySpace()) {
            return;
        }
        String cfName = CliCompiler.getColumnFamily(statement, (List<CfDef>)this.keyspacesMap.get((Object)this.keySpace).cf_defs);
        CfDef columnFamily = this.getCfDef(cfName);
        String assumptionElement = statement.getChild(1).getText().toUpperCase();
        String defaultType = statement.getChild(2).getText();
        try {
            comparator = Function.valueOf(defaultType.toUpperCase()).getValidator();
        }
        catch (Exception e) {
            String functions = Function.getFunctionNames();
            this.sessionState.out.println("Type '" + defaultType + "' was not found. Available: " + functions);
            return;
        }
        if (assumptionElement.equals("COMPARATOR")) {
            columnFamily.setComparator_type(defaultType);
        } else if (assumptionElement.equals("SUB_COMPARATOR")) {
            columnFamily.setSubcomparator_type(defaultType);
        } else if (assumptionElement.equals("VALIDATOR")) {
            columnFamily.setDefault_validation_class(defaultType);
        } else if (assumptionElement.equals("KEYS")) {
            this.cfKeysComparators.put(columnFamily.getName(), comparator);
        } else {
            String elements = "VALIDATOR, COMPARATOR, KEYS, SUB_COMPARATOR.";
            this.sessionState.out.println(String.format("'%s' is invalid. Available: %s", assumptionElement, elements));
            return;
        }
        this.sessionState.out.println(String.format("Assumption for column family '%s' added successfully.", columnFamily.getName()));
    }

    private void executeShowVersion() throws TException {
        if (!CliMain.isConnected()) {
            return;
        }
        this.sessionState.out.println(this.thriftClient.describe_version());
    }

    private void executeShowKeySpaces() throws TException, InvalidRequestException {
        if (!CliMain.isConnected()) {
            return;
        }
        List keySpaces = this.thriftClient.describe_keyspaces();
        Collections.sort(keySpaces, new KsDefNamesComparator());
        for (KsDef keySpace : keySpaces) {
            this.describeKeySpace(keySpace.name, keySpace);
        }
    }

    private boolean hasKeySpace() {
        if (this.keySpace == null) {
            this.sessionState.out.println("Not authenticated to a working keyspace.");
            return false;
        }
        return true;
    }

    public String getKeySpace() {
        return this.keySpace == null ? "unknown" : this.keySpace;
    }

    public void setKeySpace(String keySpace) throws NotFoundException, InvalidRequestException, TException {
        this.keySpace = keySpace;
        this.getKSMetaData(keySpace);
    }

    public String getUsername() {
        return this.username == null ? "default" : this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    private void executeUseKeySpace(Tree statement) throws TException {
        if (!CliMain.isConnected()) {
            return;
        }
        int childCount = statement.getChildCount();
        String username = null;
        String password = null;
        String keySpaceName = statement.getChild(0).getText();
        if (childCount == 3) {
            username = statement.getChild(1).getText();
            password = statement.getChild(2).getText();
        }
        if (keySpaceName == null) {
            this.sessionState.out.println("Keyspace argument required");
            return;
        }
        try {
            HashMap<String, String> credentials = new HashMap<String, String>();
            keySpaceName = CliCompiler.getKeySpace(keySpaceName, (List<KsDef>)this.thriftClient.describe_keyspaces());
            this.thriftClient.set_keyspace(keySpaceName);
            if (username != null && password != null) {
                password = password.replace("'", "");
                credentials.put("username", username);
                credentials.put("password", password);
                AuthenticationRequest authRequest = new AuthenticationRequest(credentials);
                this.thriftClient.login(authRequest);
            }
            this.keySpace = keySpaceName;
            this.username = username != null ? username : "default";
            CliMain.updateCompletor(CliUtils.getCfNamesByKeySpace(this.getKSMetaData(this.keySpace)));
            this.sessionState.out.println("Authenticated to keyspace: " + this.keySpace);
        }
        catch (AuthenticationException e) {
            this.sessionState.err.println("Exception during authentication to the cassandra node: verify keyspace exists, and you are using correct credentials.");
        }
        catch (AuthorizationException e) {
            this.sessionState.err.println("You are not authorized to use keyspace: " + keySpaceName);
        }
        catch (InvalidRequestException e) {
            this.sessionState.err.println(keySpaceName + " does not exist.");
        }
        catch (NotFoundException e) {
            this.sessionState.err.println(keySpaceName + " does not exist.");
        }
        catch (TException e) {
            if (this.sessionState.debug) {
                e.printStackTrace();
            }
            this.sessionState.err.println("Login failure. Did you specify 'keyspace', 'username' and 'password'?");
        }
    }

    private void describeKeySpace(String keySpaceName, KsDef metadata) throws TException {
        NodeProbe probe = this.sessionState.getNodeProbe();
        CompactionManagerMBean compactionManagerMBean = probe == null ? null : probe.getCompactionManagerProxy();
        this.sessionState.out.println("Keyspace: " + keySpaceName + ":");
        try {
            KsDef ks_def = metadata == null ? this.thriftClient.describe_keyspace(keySpaceName) : metadata;
            this.sessionState.out.println("  Replication Strategy: " + ks_def.strategy_class);
            Map options = ks_def.strategy_options;
            this.sessionState.out.println("    Options: [" + (options == null ? "" : FBUtilities.toString(options)) + "]");
            this.sessionState.out.println("  Column Families:");
            Collections.sort(ks_def.cf_defs, new CfDefNamesComparator());
            for (CfDef cf_def : ks_def.cf_defs) {
                ColumnFamilyStoreMBean cfMBean = probe == null ? null : probe.getCfsProxy(ks_def.getName(), cf_def.getName());
                boolean isSuper = cf_def.column_type.equals("Super");
                this.sessionState.out.printf("    ColumnFamily: %s%s%n", cf_def.name, isSuper ? " (Super)" : "");
                if (cf_def.comment != null && !cf_def.comment.isEmpty()) {
                    this.sessionState.out.printf("    \"%s\"%n", cf_def.comment);
                }
                if (cf_def.key_validation_class != null) {
                    this.sessionState.out.printf("      Key Validation Class: %s%n", cf_def.key_validation_class);
                }
                if (cf_def.default_validation_class != null) {
                    this.sessionState.out.printf("      Default column value validator: %s%n", cf_def.default_validation_class);
                }
                this.sessionState.out.printf("      Columns sorted by: %s%s%n", cf_def.comparator_type, cf_def.column_type.equals("Super") ? "/" + cf_def.subcomparator_type : "");
                this.sessionState.out.printf("      Row cache size / save period in seconds: %s/%s%n", cf_def.row_cache_size, cf_def.row_cache_save_period_in_seconds);
                this.sessionState.out.printf("      Key cache size / save period in seconds: %s/%s%n", cf_def.key_cache_size, cf_def.key_cache_save_period_in_seconds);
                this.sessionState.out.printf("      Memtable thresholds: %s/%s/%s (millions of ops/MB/minutes)%n", cf_def.memtable_operations_in_millions, cf_def.memtable_throughput_in_mb, cf_def.memtable_flush_after_mins);
                this.sessionState.out.printf("      GC grace seconds: %s%n", cf_def.gc_grace_seconds);
                this.sessionState.out.printf("      Compaction min/max thresholds: %s/%s%n", cf_def.min_compaction_threshold, cf_def.max_compaction_threshold);
                this.sessionState.out.printf("      Read repair chance: %s%n", cf_def.read_repair_chance);
                this.sessionState.out.printf("      Replicate on write: %s%n", cf_def.replicate_on_write);
                if (cfMBean != null) {
                    this.sessionState.out.printf("      Built indexes: %s%n", cfMBean.getBuiltIndexes());
                }
                if (cf_def.getColumn_metadataSize() == 0) continue;
                String leftSpace = "      ";
                String columnLeftSpace = leftSpace + "    ";
                String compareWith = isSuper ? cf_def.subcomparator_type : cf_def.comparator_type;
                AbstractType columnNameValidator = this.getFormatType(compareWith);
                this.sessionState.out.println(leftSpace + "Column Metadata:");
                for (ColumnDef columnDef : cf_def.getColumn_metadata()) {
                    String columnName = columnNameValidator.getString(columnDef.name);
                    if (columnNameValidator instanceof BytesType) {
                        try {
                            String columnString = UTF8Type.instance.getString(columnDef.name);
                            columnName = columnString + " (" + columnName + ")";
                        }
                        catch (MarshalException e) {
                            // empty catch block
                        }
                    }
                    this.sessionState.out.println(leftSpace + "  Column Name: " + columnName);
                    this.sessionState.out.println(columnLeftSpace + "Validation Class: " + columnDef.getValidation_class());
                    if (columnDef.isSetIndex_name()) {
                        this.sessionState.out.println(columnLeftSpace + "Index Name: " + columnDef.getIndex_name());
                    }
                    if (!columnDef.isSetIndex_type()) continue;
                    this.sessionState.out.println(columnLeftSpace + "Index Type: " + columnDef.getIndex_type().name());
                }
            }
            if (compactionManagerMBean != null) {
                for (CompactionInfo info : compactionManagerMBean.getCompactions()) {
                    if (info.getTaskType() != CompactionType.INDEX_BUILD) continue;
                    this.sessionState.out.printf("%nCurrently building index %s, completed %d of %d bytes.%n", info.getColumnFamily(), info.getBytesComplete(), info.getTotalBytes());
                }
            }
            if (probe != null) {
                probe.close();
            }
        }
        catch (InvalidRequestException e) {
            this.sessionState.out.println("Invalid request: " + (Object)((Object)e));
        }
        catch (NotFoundException e) {
            this.sessionState.out.println("Keyspace " + keySpaceName + " could not be found.");
        }
        catch (IOException e) {
            this.sessionState.out.println("Error while closing JMX connection: " + e.getMessage());
        }
    }

    private void executeDescribeKeySpace(Tree statement) throws TException, InvalidRequestException {
        if (!CliMain.isConnected()) {
            return;
        }
        String keySpaceName = statement.getChildCount() == 0 ? this.keySpace : CliCompiler.getKeySpace(statement, (List<KsDef>)this.thriftClient.describe_keyspaces());
        if (keySpaceName == null) {
            this.sessionState.out.println("Keyspace argument required if you are not authorized in any keyspace.");
            return;
        }
        this.describeKeySpace(keySpaceName, null);
    }

    private void executeDescribeCluster() {
        if (!CliMain.isConnected()) {
            return;
        }
        this.sessionState.out.println("Cluster Information:");
        try {
            this.sessionState.out.println("   Snitch: " + this.thriftClient.describe_snitch());
            this.sessionState.out.println("   Partitioner: " + this.thriftClient.describe_partitioner());
            this.sessionState.out.println("   Schema versions: ");
            Map versions = this.thriftClient.describe_schema_versions();
            for (String version : versions.keySet()) {
                this.sessionState.out.println("\t" + version + ": " + versions.get(version));
            }
        }
        catch (Exception e) {
            String message = e instanceof InvalidRequestException ? ((InvalidRequestException)((Object)e)).getWhy() : e.getMessage();
            this.sessionState.err.println("Error retrieving data: " + message);
        }
    }

    private void executeConnect(Tree statement) {
        Tree idList = statement.getChild(0);
        int portNumber = Integer.parseInt(statement.getChild(1).getText());
        StringBuilder hostName = new StringBuilder();
        int idCount = idList.getChildCount();
        for (int idx = 0; idx < idCount; ++idx) {
            hostName.append(idList.getChild(idx).getText());
        }
        CliMain.disconnect();
        this.sessionState.hostName = hostName.toString();
        this.sessionState.thriftPort = portNumber;
        if (statement.getChildCount() == 4) {
            this.sessionState.username = statement.getChild(2).getText();
            this.sessionState.password = CliUtils.unescapeSQLString(statement.getChild(3).getText());
        }
        CliMain.connect(this.sessionState.hostName, this.sessionState.thriftPort);
    }

    private CfDef getCfDef(String keySpaceName, String columnFamilyName) {
        KsDef keySpaceDefinition = this.keyspacesMap.get(keySpaceName);
        for (CfDef columnFamilyDef : keySpaceDefinition.cf_defs) {
            if (!columnFamilyDef.name.equals(columnFamilyName)) continue;
            return columnFamilyDef;
        }
        throw new RuntimeException("No such column family: " + columnFamilyName);
    }

    private CfDef getCfDef(String columnFamilyName) {
        return this.getCfDef(this.keySpace, columnFamilyName);
    }

    private List<ColumnDef> getCFColumnMetaFromTree(CfDef cfDef, Tree meta) {
        ArrayList<ColumnDef> columnDefinitions = new ArrayList<ColumnDef>();
        for (int i = 0; i < meta.getChildCount(); ++i) {
            Tree metaHash = meta.getChild(i);
            ColumnDef columnDefinition = new ColumnDef();
            for (int j = 0; j < metaHash.getChildCount(); ++j) {
                Tree metaPair = metaHash.getChild(j);
                String metaKey = CliUtils.unescapeSQLString(metaPair.getChild(0).getText());
                String metaVal = CliUtils.unescapeSQLString(metaPair.getChild(1).getText());
                if (metaKey.equals("column_name")) {
                    if (cfDef.column_type.equals("Super")) {
                        columnDefinition.setName(this.subColumnNameAsByteArray(metaVal, cfDef));
                        continue;
                    }
                    columnDefinition.setName(this.columnNameAsByteArray(metaVal, cfDef));
                    continue;
                }
                if (metaKey.equals("validation_class")) {
                    columnDefinition.setValidation_class(metaVal);
                    continue;
                }
                if (metaKey.equals("index_type")) {
                    columnDefinition.setIndex_type(this.getIndexTypeFromString(metaVal));
                    continue;
                }
                if (!metaKey.equals("index_name")) continue;
                columnDefinition.setIndex_name(metaVal);
            }
            try {
                columnDefinition.validate();
            }
            catch (TException e) {
                throw new RuntimeException(e.getMessage(), e);
            }
            columnDefinitions.add(columnDefinition);
        }
        return columnDefinitions;
    }

    private IndexType getIndexTypeFromString(String indexTypeAsString) {
        IndexType indexType;
        try {
            indexType = IndexType.findByValue((int)new Integer(indexTypeAsString));
        }
        catch (NumberFormatException e) {
            try {
                indexType = IndexType.valueOf((String)indexTypeAsString);
            }
            catch (IllegalArgumentException ie) {
                throw new RuntimeException("IndexType '" + indexTypeAsString + "' is unsupported.");
            }
        }
        if (indexType == null) {
            throw new RuntimeException("IndexType '" + indexTypeAsString + "' is unsupported.");
        }
        return indexType;
    }

    private ByteBuffer getBytesAccordingToType(String object, AbstractType comparator) {
        if (comparator == null) {
            comparator = BytesType.instance;
        }
        try {
            return comparator.fromString(object);
        }
        catch (MarshalException e) {
            throw new RuntimeException(e.toString());
        }
    }

    private ByteBuffer columnNameAsBytes(String column, String columnFamily) {
        CfDef columnFamilyDef = this.getCfDef(columnFamily);
        return this.columnNameAsBytes(column, columnFamilyDef);
    }

    private ByteBuffer columnNameAsBytes(String column, CfDef columnFamilyDef) {
        String comparatorClass = columnFamilyDef.comparator_type;
        return this.getBytesAccordingToType(column, this.getFormatType(comparatorClass));
    }

    private byte[] columnNameAsByteArray(String column, String columnFamily) {
        return TBaseHelper.byteBufferToByteArray((ByteBuffer)this.columnNameAsBytes(column, columnFamily));
    }

    private byte[] columnNameAsByteArray(String column, CfDef cfDef) {
        return TBaseHelper.byteBufferToByteArray((ByteBuffer)this.columnNameAsBytes(column, cfDef));
    }

    private ByteBuffer subColumnNameAsBytes(String superColumn, String columnFamily) {
        CfDef columnFamilyDef = this.getCfDef(columnFamily);
        return this.subColumnNameAsBytes(superColumn, columnFamilyDef);
    }

    private ByteBuffer subColumnNameAsBytes(String superColumn, CfDef columnFamilyDef) {
        String comparatorClass = columnFamilyDef.subcomparator_type;
        if (comparatorClass == null) {
            this.sessionState.out.println(String.format("Notice: defaulting to BytesType subcomparator for '%s'", columnFamilyDef.getName()));
            comparatorClass = "BytesType";
        }
        return this.getBytesAccordingToType(superColumn, this.getFormatType(comparatorClass));
    }

    private byte[] subColumnNameAsByteArray(String superColumn, String columnFamily) {
        return TBaseHelper.byteBufferToByteArray((ByteBuffer)this.subColumnNameAsBytes(superColumn, columnFamily));
    }

    private byte[] subColumnNameAsByteArray(String superColumn, CfDef cfDef) {
        return TBaseHelper.byteBufferToByteArray((ByteBuffer)this.subColumnNameAsBytes(superColumn, cfDef));
    }

    private ByteBuffer columnValueAsBytes(ByteBuffer columnName, String columnFamilyName, String columnValue) {
        CfDef columnFamilyDef = this.getCfDef(columnFamilyName);
        for (ColumnDef columnDefinition : columnFamilyDef.getColumn_metadata()) {
            byte[] currentColumnName = columnDefinition.getName();
            if (ByteBufferUtil.compare(currentColumnName, columnName) != 0) continue;
            try {
                String validationClass = columnDefinition.getValidation_class();
                return this.getBytesAccordingToType(columnValue, this.getFormatType(validationClass));
            }
            catch (Exception e) {
                throw new RuntimeException(e.getMessage(), e);
            }
        }
        return ByteBufferUtil.bytes(columnValue);
    }

    private AbstractType getValidatorForValue(CfDef ColumnFamilyDef, byte[] columnNameInBytes) {
        String defaultValidator = ColumnFamilyDef.default_validation_class;
        for (ColumnDef columnDefinition : ColumnFamilyDef.getColumn_metadata()) {
            byte[] nameInBytes = columnDefinition.getName();
            if (!Arrays.equals(nameInBytes, columnNameInBytes)) continue;
            return this.getFormatType(columnDefinition.getValidation_class());
        }
        if (defaultValidator != null && !defaultValidator.isEmpty()) {
            return this.getFormatType(defaultValidator);
        }
        return null;
    }

    private Map<String, String> getStrategyOptionsFromTree(Tree options) {
        HashMap<String, String> strategyOptions = new HashMap<String, String>();
        for (int i = 0; i < options.getChildCount(); ++i) {
            Tree optionsHash = options.getChild(i);
            for (int j = 0; j < optionsHash.getChildCount(); ++j) {
                Tree optionPair = optionsHash.getChild(j);
                String key = CliUtils.unescapeSQLString(optionPair.getChild(0).getText());
                String val = CliUtils.unescapeSQLString(optionPair.getChild(1).getText());
                strategyOptions.put(key, val);
            }
        }
        return strategyOptions;
    }

    private ByteBuffer convertValueByFunction(Tree functionCall, CfDef columnFamily, ByteBuffer columnName) {
        return this.convertValueByFunction(functionCall, columnFamily, columnName, false);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private ByteBuffer convertValueByFunction(Tree functionCall, CfDef columnFamily, ByteBuffer columnName, boolean withUpdate) {
        String functionName = functionCall.getChild(0).getText();
        Tree argumentTree = functionCall.getChild(1);
        String functionArg = argumentTree == null ? "" : CliUtils.unescapeSQLString(argumentTree.getText());
        AbstractType validator = CliClient.getTypeByFunction(functionName);
        try {
            ByteBuffer value;
            if (functionArg.isEmpty()) {
                if (validator instanceof TimeUUIDType) {
                    value = ByteBuffer.wrap(UUIDGen.getTimeUUIDBytes());
                } else if (validator instanceof LexicalUUIDType) {
                    value = ByteBuffer.wrap(UUIDGen.decompose(UUID.randomUUID()));
                } else {
                    if (!(validator instanceof BytesType)) throw new RuntimeException(String.format("Argument for '%s' could not be empty.", functionName));
                    value = ByteBuffer.wrap(new byte[0]);
                }
            } else {
                value = this.getBytesAccordingToType(functionArg, validator);
            }
            if (!withUpdate) return value;
            this.updateColumnMetaData(columnFamily, columnName, validator.getClass().getName());
            return value;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    public static AbstractType getTypeByFunction(String functionName) {
        Function function;
        try {
            function = Function.valueOf(functionName.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            StringBuilder errorMessage = new StringBuilder("Function '" + functionName + "' not found. ");
            errorMessage.append("Available functions: ");
            throw new RuntimeException(errorMessage.append(Function.getFunctionNames()).toString());
        }
        return function.getValidator();
    }

    private void updateColumnMetaData(CfDef columnFamily, ByteBuffer columnName, String validationClass) {
        List columnMetaData = columnFamily.getColumn_metadata();
        ColumnDef column = this.getColumnDefByName(columnFamily, columnName);
        if (column != null) {
            if (column.getValidation_class().equals(validationClass)) {
                return;
            }
            column.setValidation_class(validationClass);
        } else {
            columnMetaData.add(new ColumnDef(columnName, validationClass));
        }
    }

    private ColumnDef getColumnDefByName(CfDef columnFamily, ByteBuffer columnName) {
        for (ColumnDef columnDef : columnFamily.getColumn_metadata()) {
            byte[] currName = columnDef.getName();
            if (ByteBufferUtil.compare(currName, columnName) != 0) continue;
            return columnDef;
        }
        return null;
    }

    private void printSliceList(CfDef columnFamilyDef, List<KeySlice> slices) throws NotFoundException, TException, IllegalAccessException, InstantiationException, NoSuchFieldException, CharacterCodingException {
        String columnFamilyName = columnFamilyDef.getName();
        AbstractType keyComparator = this.getKeyComparatorForCF(columnFamilyName);
        for (KeySlice ks : slices) {
            String keyName = keyComparator == null ? ByteBufferUtil.string(ks.key) : keyComparator.getString(ks.key);
            this.sessionState.out.printf("-------------------%n", new Object[0]);
            this.sessionState.out.printf("RowKey: %s%n", keyName);
            Iterator iterator = ks.getColumnsIterator();
            while (iterator.hasNext()) {
                SuperColumn superCol;
                AbstractType validator;
                Column col;
                ColumnOrSuperColumn columnOrSuperColumn = (ColumnOrSuperColumn)iterator.next();
                if (columnOrSuperColumn.column != null) {
                    col = columnOrSuperColumn.column;
                    validator = this.getValidatorForValue(columnFamilyDef, col.getName());
                    this.sessionState.out.printf("=> (column=%s, value=%s, timestamp=%d%s)%n", this.formatColumnName(this.keySpace, columnFamilyName, col.name), validator.getString(col.value), col.timestamp, col.isSetTtl() ? String.format(", ttl=%d", col.getTtl()) : "");
                    continue;
                }
                if (columnOrSuperColumn.super_column != null) {
                    superCol = columnOrSuperColumn.super_column;
                    this.sessionState.out.printf("=> (super_column=%s,", this.formatColumnName(this.keySpace, columnFamilyName, superCol.name));
                    for (Column col2 : superCol.columns) {
                        validator = this.getValidatorForValue(columnFamilyDef, col2.getName());
                        this.sessionState.out.printf("%n     (column=%s, value=%s, timestamp=%d%s)", this.formatSubcolumnName(this.keySpace, columnFamilyName, col2.name), validator.getString(col2.value), col2.timestamp, col2.isSetTtl() ? String.format(", ttl=%d", col2.getTtl()) : "");
                    }
                    this.sessionState.out.println(")");
                    continue;
                }
                if (columnOrSuperColumn.counter_column != null) {
                    col = columnOrSuperColumn.counter_column;
                    this.sessionState.out.printf("=> (counter=%s, value=%s)%n", this.formatColumnName(this.keySpace, columnFamilyName, col.name), col.value);
                    continue;
                }
                if (columnOrSuperColumn.counter_super_column == null) continue;
                superCol = columnOrSuperColumn.counter_super_column;
                this.sessionState.out.printf("=> (super_column=%s,", this.formatColumnName(this.keySpace, columnFamilyName, superCol.name));
                for (Column col2 : superCol.columns) {
                    this.sessionState.out.printf("%n     (counter=%s, value=%s)", this.formatSubcolumnName(this.keySpace, columnFamilyName, col2.name), col2.value);
                }
                this.sessionState.out.println(")");
            }
        }
        this.sessionState.out.printf("%n%d Row%s Returned.%n", slices.size(), slices.size() > 1 ? "s" : "");
    }

    private String formatSubcolumnName(String keyspace, String columnFamily, ByteBuffer name) throws NotFoundException, TException, IllegalAccessException, InstantiationException, NoSuchFieldException {
        return this.getFormatType(this.getCfDef((String)keyspace, (String)columnFamily).subcomparator_type).getString(name);
    }

    private String formatColumnName(String keyspace, String columnFamily, ByteBuffer name) throws NotFoundException, TException, IllegalAccessException, InstantiationException, NoSuchFieldException {
        return this.getFormatType(this.getCfDef((String)keyspace, (String)columnFamily).comparator_type).getString(name);
    }

    private ByteBuffer getColumnName(String columnFamily, Tree columnTree) {
        return columnTree.getType() == 36 ? this.convertValueByFunction(columnTree, null, null) : this.columnNameAsBytes(CliUtils.unescapeSQLString(columnTree.getText()), columnFamily);
    }

    private ByteBuffer getSubColumnName(String columnFamily, Tree columnTree) {
        return columnTree.getType() == 36 ? this.convertValueByFunction(columnTree, null, null) : this.subColumnNameAsBytes(CliUtils.unescapeSQLString(columnTree.getText()), columnFamily);
    }

    public ByteBuffer getKeyAsBytes(String columnFamily, Tree keyTree) {
        if (keyTree.getType() == 36) {
            return this.convertValueByFunction(keyTree, null, null);
        }
        String key = CliUtils.unescapeSQLString(keyTree.getText());
        return this.getBytesAccordingToType(key, this.getKeyComparatorForCF(columnFamily));
    }

    private AbstractType getKeyComparatorForCF(String columnFamily) {
        AbstractType keyComparator = this.cfKeysComparators.get(columnFamily);
        if (keyComparator == null) {
            String defaultValidationClass = this.getCfDef(columnFamily).getKey_validation_class();
            assert (defaultValidationClass != null);
            keyComparator = this.getFormatType(defaultValidationClass);
        }
        return keyComparator;
    }

    private void validateSchemaIsSettled(String currentVersionId) {
        this.sessionState.out.println("Waiting for schema agreement...");
        Map versions = null;
        long limit = System.currentTimeMillis() + (long)this.sessionState.schema_mwt;
        boolean inAgreement = false;
        block2: while (limit - System.currentTimeMillis() >= 0L && !inAgreement) {
            try {
                versions = this.thriftClient.describe_schema_versions();
            }
            catch (Exception e) {
                this.sessionState.err.println(e instanceof InvalidRequestException ? ((InvalidRequestException)((Object)e)).getWhy() : e.getMessage());
                continue;
            }
            for (String version : versions.keySet()) {
                if (version.equals(currentVersionId) || version.equals("UNREACHABLE")) continue;
                continue block2;
            }
            inAgreement = true;
        }
        if (versions.containsKey("UNREACHABLE")) {
            this.sessionState.err.printf("Warning: unreachable nodes %s", Joiner.on((String)", ").join((Iterable)versions.get("UNREACHABLE")));
        }
        if (!inAgreement) {
            this.sessionState.err.printf("The schema has not settled in %d seconds; further migrations are ill-advised until it does.%nVersions are %s%n", this.sessionState.schema_mwt / 1000, FBUtilities.toString(versions));
            System.exit(-1);
        }
        this.sessionState.out.println("... schemas agree across the cluster");
    }

    private boolean isCounterCF(CfDef cfdef) {
        String defaultValidator = cfdef.default_validation_class;
        if (defaultValidator != null && !defaultValidator.isEmpty()) {
            return this.getFormatType(defaultValidator) instanceof CounterColumnType;
        }
        return false;
    }

    private static class CfDefNamesComparator
    implements Comparator<CfDef> {
        private CfDefNamesComparator() {
        }

        @Override
        public int compare(CfDef a, CfDef b) {
            return a.name.compareTo(b.name);
        }
    }

    private static class KsDefNamesComparator
    implements Comparator<KsDef> {
        private KsDefNamesComparator() {
        }

        @Override
        public int compare(KsDef a, KsDef b) {
            return a.name.compareTo(b.name);
        }
    }

    protected static enum ColumnFamilyArgument {
        COLUMN_TYPE,
        COMPARATOR,
        SUBCOMPARATOR,
        COMMENT,
        ROWS_CACHED,
        ROW_CACHE_SAVE_PERIOD,
        KEYS_CACHED,
        KEY_CACHE_SAVE_PERIOD,
        READ_REPAIR_CHANCE,
        GC_GRACE,
        COLUMN_METADATA,
        MEMTABLE_OPERATIONS,
        MEMTABLE_THROUGHPUT,
        MEMTABLE_FLUSH_AFTER,
        DEFAULT_VALIDATION_CLASS,
        MIN_COMPACTION_THRESHOLD,
        MAX_COMPACTION_THRESHOLD,
        REPLICATE_ON_WRITE,
        ROW_CACHE_PROVIDER,
        KEY_VALIDATION_CLASS;

    }

    private static enum AddKeyspaceArgument {
        PLACEMENT_STRATEGY,
        STRATEGY_OPTIONS;

    }

    public static enum Function {
        BYTES(BytesType.instance),
        INTEGER(IntegerType.instance),
        LONG(LongType.instance),
        LEXICALUUID(LexicalUUIDType.instance),
        TIMEUUID(TimeUUIDType.instance),
        UTF8(UTF8Type.instance),
        ASCII(AsciiType.instance);

        private AbstractType validator;

        private Function(AbstractType validator) {
            this.validator = validator;
        }

        public AbstractType getValidator() {
            return this.validator;
        }

        public static String getFunctionNames() {
            Function[] functions = Function.values();
            StringBuilder functionNames = new StringBuilder();
            for (int i = 0; i < functions.length; ++i) {
                StringBuilder currentName = new StringBuilder(functions[i].name().toLowerCase());
                functionNames.append((CharSequence)currentName.append(i != functions.length - 1 ? ", " : "."));
            }
            return functionNames.toString();
        }
    }
}

