/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import org.apache.cassandra.db.Table;
import org.apache.cassandra.db.TruncationSerializer;
import org.apache.cassandra.io.ICompactSerializer;
import org.apache.cassandra.net.Message;
import org.apache.cassandra.service.StorageService;
import org.apache.cassandra.utils.FBUtilities;

public class Truncation {
    private static ICompactSerializer<Truncation> serializer = new TruncationSerializer();
    public final String keyspace;
    public final String columnFamily;

    public static ICompactSerializer<Truncation> serializer() {
        return serializer;
    }

    public Truncation(String keyspace, String columnFamily) {
        this.keyspace = keyspace;
        this.columnFamily = columnFamily;
    }

    public void apply() throws IOException {
        Table.open(this.keyspace).getColumnFamilyStore(this.columnFamily).truncate();
    }

    public Message makeTruncationMessage() throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(bos);
        Truncation.serializer().serialize(this, dos);
        return new Message(FBUtilities.getLocalAddress(), StorageService.Verb.TRUNCATE, bos.toByteArray());
    }

    public String toString() {
        return "Truncation(keyspace='" + this.keyspace + '\'' + ", cf='" + this.columnFamily + "')";
    }
}

