/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.gms;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.gms.ApplicationState;
import org.apache.cassandra.gms.EndpointState;
import org.apache.cassandra.gms.FailureDetector;
import org.apache.cassandra.gms.GossipDigest;
import org.apache.cassandra.gms.GossipDigestAck2Message;
import org.apache.cassandra.gms.GossipDigestAckMessage;
import org.apache.cassandra.gms.GossipDigestSynMessage;
import org.apache.cassandra.gms.HeartBeatState;
import org.apache.cassandra.gms.IEndpointStateChangeSubscriber;
import org.apache.cassandra.gms.IFailureDetectionEventListener;
import org.apache.cassandra.gms.IFailureDetector;
import org.apache.cassandra.gms.VersionedValue;
import org.apache.cassandra.net.Message;
import org.apache.cassandra.net.MessagingService;
import org.apache.cassandra.service.StorageService;
import org.apache.cassandra.utils.FBUtilities;
import org.cliffc.high_scale_lib.NonBlockingHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Gossiper
implements IFailureDetectionEventListener {
    static final ApplicationState[] STATES = ApplicationState.values();
    private ScheduledFuture<?> scheduledGossipTask;
    public static final int intervalInMillis_ = 1000;
    public static final int QUARANTINE_DELAY = 60000;
    private static Logger logger_ = LoggerFactory.getLogger(Gossiper.class);
    public static final Gossiper instance = new Gossiper();
    private InetAddress localEndpoint_;
    private long aVeryLongTime_ = 259200000L;
    private long FatClientTimeout_ = 30000L;
    private Random random_ = new Random();
    private Comparator<InetAddress> inetcomparator = new Comparator<InetAddress>(){

        @Override
        public int compare(InetAddress addr1, InetAddress addr2) {
            return addr1.getHostAddress().compareTo(addr2.getHostAddress());
        }
    };
    private List<IEndpointStateChangeSubscriber> subscribers_ = new CopyOnWriteArrayList<IEndpointStateChangeSubscriber>();
    private Set<InetAddress> liveEndpoints_ = new ConcurrentSkipListSet<InetAddress>(this.inetcomparator);
    private Map<InetAddress, Long> unreachableEndpoints_ = new ConcurrentHashMap<InetAddress, Long>();
    private Set<InetAddress> seeds_ = new ConcurrentSkipListSet<InetAddress>(this.inetcomparator);
    Map<InetAddress, EndpointState> endpointStateMap_ = new ConcurrentHashMap<InetAddress, EndpointState>();
    Map<InetAddress, Long> justRemovedEndpoints_ = new ConcurrentHashMap<InetAddress, Long>();
    private final ConcurrentMap<InetAddress, Integer> versions = new NonBlockingHashMap();

    private Gossiper() {
        this.localEndpoint_ = FBUtilities.getLocalAddress();
        FailureDetector.instance.registerFailureDetectionEventListener(this);
    }

    public void register(IEndpointStateChangeSubscriber subscriber) {
        this.subscribers_.add(subscriber);
    }

    public void unregister(IEndpointStateChangeSubscriber subscriber) {
        this.subscribers_.remove(subscriber);
    }

    public void setVersion(InetAddress address, int version) {
        Integer old = this.versions.put(address, version);
        EndpointState state = this.endpointStateMap_.get(address);
        if (state == null) {
            this.addSavedEndpoint(address);
        }
    }

    public Integer getVersion(InetAddress address) {
        return (Integer)this.versions.get(address);
    }

    public Set<InetAddress> getLiveMembers() {
        HashSet<InetAddress> liveMbrs = new HashSet<InetAddress>(this.liveEndpoints_);
        liveMbrs.add(this.localEndpoint_);
        return liveMbrs;
    }

    public Set<InetAddress> getUnreachableMembers() {
        return this.unreachableEndpoints_.keySet();
    }

    public long getEndpointDowntime(InetAddress ep) {
        Long downtime = this.unreachableEndpoints_.get(ep);
        if (downtime != null) {
            return System.currentTimeMillis() - downtime;
        }
        return 0L;
    }

    @Override
    public void convict(InetAddress endpoint) {
        EndpointState epState = this.endpointStateMap_.get(endpoint);
        if (epState.isAlive()) {
            logger_.info("InetAddress {} is now dead.", (Object)endpoint);
            this.isAlive(endpoint, epState, false);
        }
    }

    int getMaxEndpointStateVersion(EndpointState epState) {
        int maxVersion = epState.getHeartBeatState().getHeartBeatVersion();
        for (VersionedValue value : epState.getApplicationStateMap().values()) {
            maxVersion = Math.max(maxVersion, value.version);
        }
        return maxVersion;
    }

    void evictFromMembership(InetAddress endpoint) {
        this.unreachableEndpoints_.remove(endpoint);
    }

    public void removeEndpoint(InetAddress endpoint) {
        for (IEndpointStateChangeSubscriber subscriber : this.subscribers_) {
            subscriber.onRemove(endpoint);
        }
        this.liveEndpoints_.remove(endpoint);
        this.unreachableEndpoints_.remove(endpoint);
        FailureDetector.instance.remove(endpoint);
        this.justRemovedEndpoints_.put(endpoint, System.currentTimeMillis());
    }

    void makeRandomGossipDigest(List<GossipDigest> gDigests) {
        EndpointState epState = this.endpointStateMap_.get(this.localEndpoint_);
        int generation = epState.getHeartBeatState().getGeneration();
        int maxVersion = this.getMaxEndpointStateVersion(epState);
        gDigests.add(new GossipDigest(this.localEndpoint_, generation, maxVersion));
        ArrayList<InetAddress> endpoints = new ArrayList<InetAddress>(this.endpointStateMap_.keySet());
        Collections.shuffle(endpoints, this.random_);
        for (InetAddress endpoint : endpoints) {
            epState = this.endpointStateMap_.get(endpoint);
            if (epState != null) {
                generation = epState.getHeartBeatState().getGeneration();
                maxVersion = this.getMaxEndpointStateVersion(epState);
                gDigests.add(new GossipDigest(endpoint, generation, maxVersion));
                continue;
            }
            gDigests.add(new GossipDigest(endpoint, 0, 0));
        }
        StringBuilder sb = new StringBuilder();
        for (GossipDigest gDigest : gDigests) {
            sb.append(gDigest);
            sb.append(" ");
        }
        if (logger_.isTraceEnabled()) {
            logger_.trace("Gossip Digests are : " + sb.toString());
        }
    }

    public boolean isKnownEndpoint(InetAddress endpoint) {
        return this.endpointStateMap_.containsKey(endpoint);
    }

    public int getCurrentGenerationNumber(InetAddress endpoint) {
        return this.endpointStateMap_.get(endpoint).getHeartBeatState().getGeneration();
    }

    Message makeGossipDigestSynMessage(List<GossipDigest> gDigests) throws IOException {
        GossipDigestSynMessage gDigestMessage = new GossipDigestSynMessage(DatabaseDescriptor.getClusterName(), gDigests);
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(bos);
        GossipDigestSynMessage.serializer().serialize(gDigestMessage, dos);
        return new Message(this.localEndpoint_, StorageService.Verb.GOSSIP_DIGEST_SYN, bos.toByteArray());
    }

    Message makeGossipDigestAckMessage(GossipDigestAckMessage gDigestAckMessage) throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(bos);
        GossipDigestAckMessage.serializer().serialize(gDigestAckMessage, dos);
        return new Message(this.localEndpoint_, StorageService.Verb.GOSSIP_DIGEST_ACK, bos.toByteArray());
    }

    Message makeGossipDigestAck2Message(GossipDigestAck2Message gDigestAck2Message) throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(bos);
        GossipDigestAck2Message.serializer().serialize(gDigestAck2Message, dos);
        return new Message(this.localEndpoint_, StorageService.Verb.GOSSIP_DIGEST_ACK2, bos.toByteArray());
    }

    boolean sendGossip(Message message, Set<InetAddress> epSet) {
        int size = epSet.size();
        ArrayList<InetAddress> liveEndpoints = new ArrayList<InetAddress>(epSet);
        int index = size == 1 ? 0 : this.random_.nextInt(size);
        InetAddress to = (InetAddress)liveEndpoints.get(index);
        if (logger_.isTraceEnabled()) {
            logger_.trace("Sending a GossipDigestSynMessage to {} ...", (Object)to);
        }
        MessagingService.instance().sendOneWay(message, to);
        return this.seeds_.contains(to);
    }

    boolean doGossipToLiveMember(Message message) {
        int size = this.liveEndpoints_.size();
        if (size == 0) {
            return false;
        }
        return this.sendGossip(message, this.liveEndpoints_);
    }

    void doGossipToUnreachableMember(Message message) {
        double liveEndpoints = this.liveEndpoints_.size();
        double unreachableEndpoints = this.unreachableEndpoints_.size();
        if (unreachableEndpoints > 0.0) {
            double prob = unreachableEndpoints / (liveEndpoints + 1.0);
            double randDbl = this.random_.nextDouble();
            if (randDbl < prob) {
                this.sendGossip(message, this.unreachableEndpoints_.keySet());
            }
        }
    }

    void doGossipToSeed(Message message) {
        int size = this.seeds_.size();
        if (size > 0) {
            if (size == 1 && this.seeds_.contains(this.localEndpoint_)) {
                return;
            }
            if (this.liveEndpoints_.size() == 0) {
                this.sendGossip(message, this.seeds_);
            } else {
                double probability = (double)this.seeds_.size() / (double)(this.liveEndpoints_.size() + this.unreachableEndpoints_.size());
                double randDbl = this.random_.nextDouble();
                if (randDbl <= probability) {
                    this.sendGossip(message, this.seeds_);
                }
            }
        }
    }

    void doStatusCheck() {
        long now = System.currentTimeMillis();
        Set<InetAddress> eps = this.endpointStateMap_.keySet();
        for (InetAddress endpoint : eps) {
            if (endpoint.equals(this.localEndpoint_)) continue;
            FailureDetector.instance.interpret(endpoint);
            EndpointState epState = this.endpointStateMap_.get(endpoint);
            if (epState == null) continue;
            long duration = now - epState.getUpdateTimestamp();
            if (!epState.getHasToken() && !epState.isAlive() && duration > this.FatClientTimeout_) {
                if (StorageService.instance.getTokenMetadata().isMember(endpoint)) {
                    epState.setHasToken(true);
                } else if (!this.justRemovedEndpoints_.containsKey(endpoint)) {
                    logger_.info("FatClient " + endpoint + " has been silent for " + this.FatClientTimeout_ + "ms, removing from gossip");
                    this.removeEndpoint(endpoint);
                }
            }
            if (epState.isAlive() || duration <= this.aVeryLongTime_) continue;
            this.evictFromMembership(endpoint);
        }
        if (!this.justRemovedEndpoints_.isEmpty()) {
            HashMap<InetAddress, Long> copy = new HashMap<InetAddress, Long>(this.justRemovedEndpoints_);
            for (Map.Entry entry : copy.entrySet()) {
                if (now - (Long)entry.getValue() <= 60000L) continue;
                if (logger_.isDebugEnabled()) {
                    logger_.debug("60000 elapsed, " + entry.getKey() + " gossip quarantine over");
                }
                this.justRemovedEndpoints_.remove(entry.getKey());
                this.endpointStateMap_.remove(entry.getKey());
            }
        }
    }

    public EndpointState getEndpointStateForEndpoint(InetAddress ep) {
        return this.endpointStateMap_.get(ep);
    }

    public Set<Map.Entry<InetAddress, EndpointState>> getEndpointStates() {
        return this.endpointStateMap_.entrySet();
    }

    EndpointState getStateForVersionBiggerThan(InetAddress forEndpoint, int version) {
        EndpointState epState = this.endpointStateMap_.get(forEndpoint);
        EndpointState reqdEndpointState = null;
        if (epState != null) {
            int localHbVersion = epState.getHeartBeatState().getHeartBeatVersion();
            if (localHbVersion > version) {
                reqdEndpointState = new EndpointState(epState.getHeartBeatState());
                if (logger_.isTraceEnabled()) {
                    logger_.trace("local heartbeat version " + localHbVersion + " greater than " + version + " for " + forEndpoint);
                }
            }
            for (Map.Entry<ApplicationState, VersionedValue> entry : epState.getApplicationStateMap().entrySet()) {
                VersionedValue value = entry.getValue();
                if (value.version <= version) continue;
                if (reqdEndpointState == null) {
                    reqdEndpointState = new EndpointState(epState.getHeartBeatState());
                }
                ApplicationState key = entry.getKey();
                if (logger_.isTraceEnabled()) {
                    logger_.trace("Adding state " + (Object)((Object)key) + ": " + value.value);
                }
                reqdEndpointState.addApplicationState(key, value);
            }
        }
        return reqdEndpointState;
    }

    public int compareEndpointStartup(InetAddress addr1, InetAddress addr2) {
        EndpointState ep1 = this.getEndpointStateForEndpoint(addr1);
        EndpointState ep2 = this.getEndpointStateForEndpoint(addr2);
        assert (ep1 != null && ep2 != null);
        return ep1.getHeartBeatState().getGeneration() - ep2.getHeartBeatState().getGeneration();
    }

    void notifyFailureDetector(List<GossipDigest> gDigests) {
        IFailureDetector fd = FailureDetector.instance;
        for (GossipDigest gDigest : gDigests) {
            int localVersion;
            int remoteVersion;
            EndpointState localEndpointState = this.endpointStateMap_.get(gDigest.endpoint_);
            if (localEndpointState == null) continue;
            int remoteGeneration = gDigest.generation_;
            int localGeneration = this.endpointStateMap_.get((Object)gDigest.endpoint_).getHeartBeatState().generation_;
            if (remoteGeneration > localGeneration) {
                fd.report(gDigest.endpoint_);
                continue;
            }
            if (remoteGeneration != localGeneration || (remoteVersion = gDigest.maxVersion_) <= (localVersion = this.getMaxEndpointStateVersion(localEndpointState))) continue;
            fd.report(gDigest.endpoint_);
        }
    }

    void notifyFailureDetector(Map<InetAddress, EndpointState> remoteEpStateMap) {
        IFailureDetector fd = FailureDetector.instance;
        for (Map.Entry<InetAddress, EndpointState> entry : remoteEpStateMap.entrySet()) {
            InetAddress endpoint = entry.getKey();
            EndpointState remoteEndpointState = entry.getValue();
            EndpointState localEndpointState = this.endpointStateMap_.get(endpoint);
            if (localEndpointState == null) continue;
            int remoteGeneration = remoteEndpointState.getHeartBeatState().generation_;
            int localGeneration = localEndpointState.getHeartBeatState().generation_;
            if (remoteGeneration > localGeneration) {
                fd.report(endpoint);
                continue;
            }
            if (remoteGeneration != localGeneration) continue;
            int localVersion = this.getMaxEndpointStateVersion(localEndpointState);
            int remoteVersion = remoteEndpointState.getHeartBeatState().getHeartBeatVersion();
            if (remoteVersion <= localVersion) continue;
            fd.report(endpoint);
        }
    }

    void markAlive(InetAddress addr, EndpointState localState) {
        if (logger_.isTraceEnabled()) {
            logger_.trace("marking as alive {}", (Object)addr);
        }
        if (!localState.isAlive()) {
            this.isAlive(addr, localState, true);
            logger_.info("InetAddress {} is now UP", (Object)addr);
        }
    }

    private void handleNewJoin(InetAddress ep, EndpointState epState) {
        if (this.justRemovedEndpoints_.containsKey(ep)) {
            return;
        }
        logger_.info("Node {} is now part of the cluster", (Object)ep);
        this.handleMajorStateChange(ep, epState, false);
    }

    private void handleGenerationChange(InetAddress ep, EndpointState epState) {
        if (epState.isAlive()) {
            for (IEndpointStateChangeSubscriber subscriber : this.subscribers_) {
                subscriber.onDead(ep, epState);
            }
        }
        logger_.info("Node {} has restarted, now UP again", (Object)ep);
        this.handleMajorStateChange(ep, epState, true);
    }

    private void handleMajorStateChange(InetAddress ep, EndpointState epState, boolean isKnownNode) {
        this.endpointStateMap_.put(ep, epState);
        this.isAlive(ep, epState, isKnownNode);
        for (IEndpointStateChangeSubscriber subscriber : this.subscribers_) {
            subscriber.onJoin(ep, epState);
        }
    }

    void applyStateLocally(Map<InetAddress, EndpointState> epStateMap) {
        for (Map.Entry<InetAddress, EndpointState> entry : epStateMap.entrySet()) {
            InetAddress ep = entry.getKey();
            if (ep.equals(this.localEndpoint_)) continue;
            EndpointState localEpStatePtr = this.endpointStateMap_.get(ep);
            EndpointState remoteState = entry.getValue();
            if (localEpStatePtr != null) {
                int localGeneration = localEpStatePtr.getHeartBeatState().getGeneration();
                int remoteGeneration = remoteState.getHeartBeatState().getGeneration();
                if (remoteGeneration > localGeneration) {
                    this.handleGenerationChange(ep, remoteState);
                    continue;
                }
                if (remoteGeneration == localGeneration) {
                    int localMaxVersion = this.getMaxEndpointStateVersion(localEpStatePtr);
                    int remoteMaxVersion = this.getMaxEndpointStateVersion(remoteState);
                    if (remoteMaxVersion <= localMaxVersion) continue;
                    this.markAlive(ep, localEpStatePtr);
                    this.applyHeartBeatStateLocally(ep, localEpStatePtr, remoteState);
                    this.applyApplicationStateLocally(ep, localEpStatePtr, remoteState);
                    continue;
                }
                if (!logger_.isTraceEnabled()) continue;
                logger_.trace("Ignoring remote generation " + remoteGeneration + " < " + localGeneration);
                continue;
            }
            this.handleNewJoin(ep, remoteState);
        }
    }

    void applyHeartBeatStateLocally(InetAddress addr, EndpointState localState, EndpointState remoteState) {
        HeartBeatState localHbState = localState.getHeartBeatState();
        HeartBeatState remoteHbState = remoteState.getHeartBeatState();
        if (remoteHbState.getGeneration() > localHbState.getGeneration()) {
            if (logger_.isTraceEnabled()) {
                logger_.trace("Updating heartbeat state generation to " + remoteHbState.getGeneration() + " from " + localHbState.getGeneration() + " for " + addr);
            }
            localState.setHeartBeatState(remoteHbState);
        }
        if (localHbState.getGeneration() == remoteHbState.getGeneration()) {
            if (remoteHbState.getHeartBeatVersion() > localHbState.getHeartBeatVersion()) {
                int oldVersion = localHbState.getHeartBeatVersion();
                localState.setHeartBeatState(remoteHbState);
                if (logger_.isTraceEnabled()) {
                    logger_.trace("Updating heartbeat state version to " + localState.getHeartBeatState().getHeartBeatVersion() + " from " + oldVersion + " for " + addr + " ...");
                }
            } else if (logger_.isTraceEnabled()) {
                logger_.trace("Ignoring lower version " + remoteHbState.getHeartBeatVersion() + " for " + addr + " which is lower than " + localHbState.getHeartBeatVersion());
            }
        }
    }

    void applyApplicationStateLocally(InetAddress addr, EndpointState localStatePtr, EndpointState remoteStatePtr) {
        Map<ApplicationState, VersionedValue> localAppStateMap = localStatePtr.getApplicationStateMap();
        for (Map.Entry<ApplicationState, VersionedValue> remoteEntry : remoteStatePtr.getApplicationStateMap().entrySet()) {
            int localVersion;
            int remoteVersion;
            ApplicationState remoteKey = remoteEntry.getKey();
            VersionedValue remoteValue = remoteEntry.getValue();
            VersionedValue localValue = localAppStateMap.get((Object)remoteKey);
            if (localValue == null) {
                localStatePtr.addApplicationState(remoteKey, remoteValue);
                this.doNotifications(addr, remoteKey, remoteValue);
                continue;
            }
            int remoteGeneration = remoteStatePtr.getHeartBeatState().getGeneration();
            int localGeneration = localStatePtr.getHeartBeatState().getGeneration();
            assert (remoteGeneration >= localGeneration);
            if (remoteGeneration > localGeneration) {
                localStatePtr.addApplicationState(remoteKey, remoteValue);
                this.doNotifications(addr, remoteKey, remoteValue);
                continue;
            }
            if (remoteGeneration != localGeneration || (remoteVersion = remoteValue.version) <= (localVersion = localValue.version)) continue;
            localStatePtr.addApplicationState(remoteKey, remoteValue);
            this.doNotifications(addr, remoteKey, remoteValue);
        }
    }

    void doNotifications(InetAddress addr, ApplicationState state, VersionedValue value) {
        for (IEndpointStateChangeSubscriber subscriber : this.subscribers_) {
            subscriber.onChange(addr, state, value);
        }
    }

    void isAlive(InetAddress addr, EndpointState epState, boolean value) {
        epState.isAlive(value);
        if (value) {
            this.liveEndpoints_.add(addr);
            this.unreachableEndpoints_.remove(addr);
            for (IEndpointStateChangeSubscriber subscriber : this.subscribers_) {
                subscriber.onAlive(addr, epState);
            }
        } else {
            this.liveEndpoints_.remove(addr);
            this.unreachableEndpoints_.put(addr, System.currentTimeMillis());
            for (IEndpointStateChangeSubscriber subscriber : this.subscribers_) {
                subscriber.onDead(addr, epState);
            }
        }
        if (epState.isAGossiper()) {
            return;
        }
        epState.isAGossiper(true);
    }

    void requestAll(GossipDigest gDigest, List<GossipDigest> deltaGossipDigestList, int remoteGeneration) {
        deltaGossipDigestList.add(new GossipDigest(gDigest.getEndpoint(), remoteGeneration, 0));
        if (logger_.isTraceEnabled()) {
            logger_.trace("requestAll for " + gDigest.getEndpoint());
        }
    }

    void sendAll(GossipDigest gDigest, Map<InetAddress, EndpointState> deltaEpStateMap, int maxRemoteVersion) {
        EndpointState localEpStatePtr = this.getStateForVersionBiggerThan(gDigest.getEndpoint(), maxRemoteVersion);
        if (localEpStatePtr != null) {
            deltaEpStateMap.put(gDigest.getEndpoint(), localEpStatePtr);
        }
    }

    void examineGossiper(List<GossipDigest> gDigestList, List<GossipDigest> deltaGossipDigestList, Map<InetAddress, EndpointState> deltaEpStateMap) {
        for (GossipDigest gDigest : gDigestList) {
            int remoteGeneration = gDigest.getGeneration();
            int maxRemoteVersion = gDigest.getMaxVersion();
            EndpointState epStatePtr = this.endpointStateMap_.get(gDigest.getEndpoint());
            if (epStatePtr != null) {
                int localGeneration = epStatePtr.getHeartBeatState().getGeneration();
                int maxLocalVersion = this.getMaxEndpointStateVersion(epStatePtr);
                if (remoteGeneration == localGeneration && maxRemoteVersion == maxLocalVersion) continue;
                if (remoteGeneration > localGeneration) {
                    this.requestAll(gDigest, deltaGossipDigestList, remoteGeneration);
                }
                if (remoteGeneration < localGeneration) {
                    this.sendAll(gDigest, deltaEpStateMap, 0);
                }
                if (remoteGeneration != localGeneration) continue;
                if (maxRemoteVersion > maxLocalVersion) {
                    deltaGossipDigestList.add(new GossipDigest(gDigest.getEndpoint(), remoteGeneration, maxLocalVersion));
                }
                if (maxRemoteVersion >= maxLocalVersion) continue;
                this.sendAll(gDigest, deltaEpStateMap, maxRemoteVersion);
                continue;
            }
            this.requestAll(gDigest, deltaGossipDigestList, remoteGeneration);
        }
    }

    public void start(int generationNbr) {
        Set<InetAddress> seedHosts = DatabaseDescriptor.getSeeds();
        for (InetAddress seed : seedHosts) {
            if (seed.equals(this.localEndpoint_)) continue;
            this.seeds_.add(seed);
        }
        EndpointState localState = this.endpointStateMap_.get(this.localEndpoint_);
        if (localState == null) {
            HeartBeatState hbState = new HeartBeatState(generationNbr);
            localState = new EndpointState(hbState);
            localState.isAlive(true);
            localState.isAGossiper(true);
            this.endpointStateMap_.put(this.localEndpoint_, localState);
        }
        DatabaseDescriptor.getEndpointSnitch().gossiperStarting();
        this.scheduledGossipTask = StorageService.scheduledTasks.scheduleWithFixedDelay(new GossipTask(), 1000L, 1000L, TimeUnit.MILLISECONDS);
    }

    public void addSavedEndpoint(InetAddress ep) {
        EndpointState epState = this.endpointStateMap_.get(ep);
        if (epState == null) {
            epState = new EndpointState(new HeartBeatState(0));
            epState.isAlive(false);
            epState.isAGossiper(true);
            epState.setHasToken(true);
            this.endpointStateMap_.put(ep, epState);
            this.unreachableEndpoints_.put(ep, System.currentTimeMillis());
        }
    }

    public void addLocalApplicationState(ApplicationState state, VersionedValue value) {
        EndpointState epState = this.endpointStateMap_.get(this.localEndpoint_);
        assert (epState != null);
        epState.addApplicationState(state, value);
    }

    public void stop() {
        this.scheduledGossipTask.cancel(false);
    }

    public boolean isEnabled() {
        return !this.scheduledGossipTask.isCancelled();
    }

    public void initializeNodeUnsafe(InetAddress addr, int generationNbr) {
        EndpointState localState = this.endpointStateMap_.get(addr);
        if (localState == null) {
            HeartBeatState hbState = new HeartBeatState(generationNbr);
            localState = new EndpointState(hbState);
            localState.isAlive(true);
            localState.isAGossiper(true);
            this.endpointStateMap_.put(addr, localState);
        }
    }

    private class GossipTask
    implements Runnable {
        private GossipTask() {
        }

        @Override
        public void run() {
            try {
                MessagingService.instance().waitUntilListening();
                Gossiper.this.endpointStateMap_.get(Gossiper.this.localEndpoint_).getHeartBeatState().updateHeartBeat();
                ArrayList<GossipDigest> gDigests = new ArrayList<GossipDigest>();
                instance.makeRandomGossipDigest(gDigests);
                if (gDigests.size() > 0) {
                    Message message = Gossiper.this.makeGossipDigestSynMessage(gDigests);
                    boolean gossipedToSeed = Gossiper.this.doGossipToLiveMember(message);
                    Gossiper.this.doGossipToUnreachableMember(message);
                    if (!gossipedToSeed || Gossiper.this.liveEndpoints_.size() < Gossiper.this.seeds_.size()) {
                        Gossiper.this.doGossipToSeed(message);
                    }
                    if (logger_.isTraceEnabled()) {
                        logger_.trace("Performing status check ...");
                    }
                    Gossiper.this.doStatusCheck();
                }
            }
            catch (Exception e) {
                logger_.error("Gossip error", (Throwable)e);
            }
        }
    }
}

