/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.io.sstable;

import com.google.common.base.Function;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.cassandra.cache.JMXInstrumentedCache;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.db.ColumnFamily;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.io.sstable.CacheWriter;
import org.apache.cassandra.io.sstable.Descriptor;
import org.apache.cassandra.io.sstable.SSTableReader;
import org.apache.cassandra.utils.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SSTableTracker
implements Iterable<SSTableReader> {
    private static final Logger logger = LoggerFactory.getLogger(SSTableTracker.class);
    private volatile Set<SSTableReader> sstables;
    private final AtomicLong liveSize = new AtomicLong();
    private final AtomicLong totalSize = new AtomicLong();
    private final String ksname;
    private final String cfname;
    private final JMXInstrumentedCache<Pair<Descriptor, DecoratedKey>, Long> keyCache;
    private final JMXInstrumentedCache<DecoratedKey, ColumnFamily> rowCache;

    public SSTableTracker(String ksname, String cfname) {
        this.ksname = ksname;
        this.cfname = cfname;
        this.sstables = Collections.emptySet();
        this.keyCache = new JMXInstrumentedCache(ksname, cfname + "KeyCache", 0);
        this.rowCache = new JMXInstrumentedCache(ksname, cfname + "RowCache", 3);
    }

    public CacheWriter<Pair<Descriptor, DecoratedKey>, Long> getKeyCacheWriter() {
        Function<Pair<Descriptor, DecoratedKey>, ByteBuffer> function = new Function<Pair<Descriptor, DecoratedKey>, ByteBuffer>(){

            public ByteBuffer apply(Pair<Descriptor, DecoratedKey> key) {
                return ((DecoratedKey)key.right).key;
            }
        };
        return new CacheWriter<Pair<Descriptor, DecoratedKey>, Long>(this.cfname, this.keyCache, DatabaseDescriptor.getSerializedKeyCachePath(this.ksname, this.cfname), function);
    }

    public CacheWriter<DecoratedKey, ColumnFamily> getRowCacheWriter() {
        Function<DecoratedKey, ByteBuffer> function = new Function<DecoratedKey, ByteBuffer>(){

            public ByteBuffer apply(DecoratedKey key) {
                return key.key;
            }
        };
        return new CacheWriter<DecoratedKey, ColumnFamily>(this.cfname, this.rowCache, DatabaseDescriptor.getSerializedRowCachePath(this.ksname, this.cfname), function);
    }

    public synchronized void replace(Collection<SSTableReader> oldSSTables, Iterable<SSTableReader> replacements) {
        HashSet<SSTableReader> sstablesNew = new HashSet<SSTableReader>(this.sstables);
        for (SSTableReader sstable : replacements) {
            assert (sstable.getKeySamples() != null);
            if (logger.isDebugEnabled()) {
                logger.debug(String.format("adding %s to list of files tracked for %s.%s", sstable.descriptor, this.ksname, this.cfname));
            }
            sstablesNew.add(sstable);
            long size = sstable.bytesOnDisk();
            this.liveSize.addAndGet(size);
            this.totalSize.addAndGet(size);
            sstable.setTrackedBy(this);
        }
        long maxDataAge = -1L;
        for (SSTableReader sstable : oldSSTables) {
            if (logger.isDebugEnabled()) {
                logger.debug(String.format("removing %s from list of files tracked for %s.%s", sstable.descriptor, this.ksname, this.cfname));
            }
            boolean removed = sstablesNew.remove(sstable);
            assert (removed);
            sstable.markCompacted();
            maxDataAge = Math.max(maxDataAge, sstable.maxDataAge);
            this.liveSize.addAndGet(-sstable.bytesOnDisk());
        }
        this.sstables = Collections.unmodifiableSet(sstablesNew);
        this.updateCacheSizes();
    }

    public synchronized void add(Iterable<SSTableReader> sstables) {
        assert (sstables != null);
        this.replace(Collections.<SSTableReader>emptyList(), sstables);
    }

    public synchronized void markCompacted(Collection<SSTableReader> compacted) {
        this.replace(compacted, Collections.<SSTableReader>emptyList());
    }

    public synchronized void updateCacheSizes() {
        int rowCacheSize;
        int keyCacheSize;
        long keys = this.estimatedKeys();
        if (!this.keyCache.isCapacitySetManually() && (keyCacheSize = DatabaseDescriptor.getKeysCachedFor(this.ksname, this.cfname, keys)) != this.keyCache.getCapacity()) {
            if (logger.isDebugEnabled()) {
                logger.debug("key cache capacity for " + this.cfname + " is " + keyCacheSize);
            }
            this.keyCache.updateCapacity(keyCacheSize);
        }
        if (!this.rowCache.isCapacitySetManually() && (rowCacheSize = DatabaseDescriptor.getRowsCachedFor(this.ksname, this.cfname, keys)) != this.rowCache.getCapacity()) {
            if (logger.isDebugEnabled()) {
                logger.debug("row cache capacity for " + this.cfname + " is " + rowCacheSize);
            }
            this.rowCache.updateCapacity(rowCacheSize);
        }
    }

    public Set<SSTableReader> getSSTables() {
        return this.sstables;
    }

    public int size() {
        return this.sstables.size();
    }

    @Override
    public Iterator<SSTableReader> iterator() {
        return this.sstables.iterator();
    }

    public synchronized void clearUnsafe() {
        this.sstables = Collections.emptySet();
    }

    public JMXInstrumentedCache<DecoratedKey, ColumnFamily> getRowCache() {
        return this.rowCache;
    }

    public long estimatedKeys() {
        long n = 0L;
        for (SSTableReader sstable : this) {
            n += sstable.estimatedKeys();
        }
        return n;
    }

    public long getLiveSize() {
        return this.liveSize.get();
    }

    public long getTotalSize() {
        return this.totalSize.get();
    }

    public void spaceReclaimed(long size) {
        this.totalSize.addAndGet(-size);
    }

    public JMXInstrumentedCache<Pair<Descriptor, DecoratedKey>, Long> getKeyCache() {
        return this.keyCache;
    }
}

