/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.utils;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.util.Arrays;
import org.apache.cassandra.io.util.FileDataInput;
import org.apache.cassandra.utils.FBUtilities;
import org.apache.commons.lang.ArrayUtils;

public class ByteBufferUtil {
    public static final ByteBuffer EMPTY_BYTE_BUFFER = ByteBuffer.wrap(ArrayUtils.EMPTY_BYTE_ARRAY);

    public static int compareUnsigned(ByteBuffer o1, ByteBuffer o2) {
        assert (o1 != null);
        assert (o2 != null);
        int minLength = Math.min(o1.remaining(), o2.remaining());
        int x = 0;
        int i = o1.position();
        int j = o2.position();
        while (x < minLength) {
            if (o1.get(i) != o2.get(j)) {
                return (o1.get(i) & 0xFF) < (o2.get(j) & 0xFF) ? -1 : 1;
            }
            ++x;
            ++i;
            ++j;
        }
        return o1.remaining() == o2.remaining() ? 0 : (o1.remaining() < o2.remaining() ? -1 : 1);
    }

    public static int compare(byte[] o1, ByteBuffer o2) {
        return ByteBufferUtil.compareUnsigned(ByteBuffer.wrap(o1), o2);
    }

    public static int compare(ByteBuffer o1, byte[] o2) {
        return ByteBufferUtil.compareUnsigned(o1, ByteBuffer.wrap(o2));
    }

    public static String string(ByteBuffer buffer) throws CharacterCodingException {
        return ByteBufferUtil.string(buffer, Charset.defaultCharset());
    }

    public static String string(ByteBuffer buffer, int position, int length) throws CharacterCodingException {
        return ByteBufferUtil.string(buffer, position, length, Charset.defaultCharset());
    }

    public static String string(ByteBuffer buffer, int position, int length, Charset charset) throws CharacterCodingException {
        ByteBuffer copy = buffer.duplicate();
        copy.position(position);
        copy.limit(copy.position() + length);
        return ByteBufferUtil.string(copy, charset);
    }

    public static String string(ByteBuffer buffer, Charset charset) throws CharacterCodingException {
        return charset.newDecoder().decode(buffer.duplicate()).toString();
    }

    public static byte[] getArray(ByteBuffer buffer) {
        int length = buffer.remaining();
        if (buffer.hasArray()) {
            int start = buffer.position();
            if (buffer.arrayOffset() == 0 && start == 0 && length == buffer.array().length) {
                return buffer.array();
            }
            return Arrays.copyOfRange(buffer.array(), start + buffer.arrayOffset(), start + length + buffer.arrayOffset());
        }
        byte[] bytes = new byte[length];
        buffer.duplicate().get(bytes);
        return bytes;
    }

    public static int lastIndexOf(ByteBuffer buffer, byte valueToFind, int startIndex) {
        assert (buffer != null);
        if (startIndex < buffer.position()) {
            return -1;
        }
        if (startIndex >= buffer.limit()) {
            startIndex = buffer.limit() - 1;
        }
        for (int i = startIndex; i >= buffer.position(); --i) {
            if (valueToFind != buffer.get(i)) continue;
            return i;
        }
        return -1;
    }

    public static ByteBuffer bytes(String s) {
        try {
            return ByteBuffer.wrap(s.getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public static ByteBuffer clone(ByteBuffer o) {
        assert (o != null);
        if (o.remaining() == 0) {
            return EMPTY_BYTE_BUFFER;
        }
        ByteBuffer clone = ByteBuffer.allocate(o.remaining());
        if (o.hasArray()) {
            System.arraycopy(o.array(), o.arrayOffset() + o.position(), clone.array(), 0, o.remaining());
        } else {
            clone.put(o.duplicate());
            clone.flip();
        }
        return clone;
    }

    public static void arrayCopy(ByteBuffer buffer, int position, byte[] bytes, int offset, int length) {
        if (buffer.hasArray()) {
            System.arraycopy(buffer.array(), buffer.arrayOffset() + position, bytes, offset, length);
        } else {
            ((ByteBuffer)buffer.duplicate().position(position)).get(bytes, offset, length);
        }
    }

    public static void writeWithLength(ByteBuffer bytes, DataOutput out) throws IOException {
        out.writeInt(bytes.remaining());
        ByteBufferUtil.write(bytes, out);
    }

    public static void write(ByteBuffer buffer, DataOutput out) throws IOException {
        if (buffer.hasArray()) {
            out.write(buffer.array(), buffer.arrayOffset() + buffer.position(), buffer.remaining());
        } else {
            for (int i = buffer.position(); i < buffer.limit(); ++i) {
                out.writeByte(buffer.get(i));
            }
        }
    }

    public static void writeWithShortLength(ByteBuffer buffer, DataOutput out) {
        int length = buffer.remaining();
        assert (0 <= length && length <= 65535);
        try {
            out.writeByte(length >> 8 & 0xFF);
            out.writeByte(length & 0xFF);
            ByteBufferUtil.write(buffer, out);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static ByteBuffer readWithLength(DataInput in) throws IOException {
        int length = in.readInt();
        if (length < 0) {
            throw new IOException("Corrupt (negative) value length encountered");
        }
        return ByteBufferUtil.read(in, length);
    }

    private static int readShortLength(DataInput in) throws IOException {
        int length = (in.readByte() & 0xFF) << 8;
        return length | in.readByte() & 0xFF;
    }

    public static ByteBuffer readWithShortLength(DataInput in) throws IOException {
        return ByteBufferUtil.read(in, ByteBufferUtil.readShortLength(in));
    }

    public static ByteBuffer skipShortLength(DataInput in) throws IOException {
        int skipped;
        for (int skip = ByteBufferUtil.readShortLength(in); skip > 0; skip -= skipped) {
            skipped = in.skipBytes(skip);
            if (skipped != 0) continue;
            throw new EOFException();
        }
        return null;
    }

    private static ByteBuffer read(DataInput in, int length) throws IOException {
        ByteBuffer array;
        if (in instanceof FileDataInput) {
            array = ((FileDataInput)in).readBytes(length);
        } else {
            byte[] buff = new byte[length];
            in.readFully(buff);
            array = ByteBuffer.wrap(buff);
        }
        return array;
    }

    public static int toInt(ByteBuffer bytes) {
        return bytes.getInt(bytes.position());
    }

    public static ByteBuffer bytes(int i) {
        return ByteBuffer.allocate(4).putInt(0, i);
    }

    public static ByteBuffer bytes(long n) {
        return ByteBuffer.allocate(8).putLong(0, n);
    }

    public static InputStream inputStream(ByteBuffer bytes) {
        final ByteBuffer copy = bytes.duplicate();
        return new InputStream(){

            @Override
            public int read() throws IOException {
                if (!copy.hasRemaining()) {
                    return -1;
                }
                return copy.get() & 0xFF;
            }

            @Override
            public int read(byte[] bytes, int off, int len) throws IOException {
                len = Math.min(len, copy.remaining());
                copy.get(bytes, off, len);
                return len;
            }

            @Override
            public int available() throws IOException {
                return copy.remaining();
            }
        };
    }

    public static String bytesToHex(ByteBuffer bytes) {
        StringBuilder sb = new StringBuilder();
        for (int i = bytes.position(); i < bytes.limit(); ++i) {
            int bint = bytes.get(i) & 0xFF;
            if (bint <= 15) {
                sb.append("0");
            }
            sb.append(Integer.toHexString(bint));
        }
        return sb.toString();
    }

    public static ByteBuffer hexToBytes(String str) {
        return ByteBuffer.wrap(FBUtilities.hexToBytes(str));
    }
}

