/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.io;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterators;
import java.io.DataOutput;
import java.io.IOError;
import java.io.IOException;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.apache.cassandra.db.ColumnFamily;
import org.apache.cassandra.db.ColumnFamilyStore;
import org.apache.cassandra.db.ColumnIndexer;
import org.apache.cassandra.db.IColumn;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.io.AbstractCompactedRow;
import org.apache.cassandra.io.sstable.SSTable;
import org.apache.cassandra.io.sstable.SSTableIdentityIterator;
import org.apache.cassandra.io.util.DataOutputBuffer;
import org.apache.cassandra.io.util.IIterableColumns;
import org.apache.cassandra.utils.ReducingIterator;
import org.apache.commons.collections.iterators.CollatingIterator;

public class LazilyCompactedRow
extends AbstractCompactedRow
implements IIterableColumns {
    private final List<SSTableIdentityIterator> rows;
    private final boolean shouldPurge;
    private final int gcBefore;
    private final DataOutputBuffer headerBuffer;
    private final boolean forceDeserialize;
    private ColumnFamily emptyColumnFamily;
    private LazyColumnIterator iter;
    private int columnCount;
    private long columnSerializedSize;

    public LazilyCompactedRow(ColumnFamilyStore cfStore, List<SSTableIdentityIterator> rows, boolean major, int gcBefore, boolean forceDeserialize) {
        super(rows.get(0).getKey());
        this.gcBefore = gcBefore;
        this.forceDeserialize = forceDeserialize;
        this.rows = new ArrayList<SSTableIdentityIterator>(rows);
        HashSet<SSTable> sstables = new HashSet<SSTable>();
        for (SSTableIdentityIterator row : rows) {
            sstables.add(row.sstable);
            ColumnFamily cf = row.getColumnFamily();
            if (this.emptyColumnFamily == null) {
                this.emptyColumnFamily = cf;
                continue;
            }
            this.emptyColumnFamily.delete(cf);
        }
        this.shouldPurge = major || !cfStore.isKeyInRemainingSSTables(this.key, sstables);
        this.headerBuffer = new DataOutputBuffer();
        ColumnIndexer.serialize(this, this.headerBuffer);
        this.columnCount = this.iter.size;
        this.columnSerializedSize = this.iter.serializedSize;
        this.iter = null;
    }

    @Override
    public void write(DataOutput out) throws IOException {
        if (this.rows.size() == 1 && !this.shouldPurge && this.rows.get((int)0).sstable.descriptor.isLatestVersion && !this.forceDeserialize) {
            SSTableIdentityIterator row = this.rows.get(0);
            out.writeLong(row.dataSize);
            row.echoData(out);
            return;
        }
        DataOutputBuffer clockOut = new DataOutputBuffer();
        ColumnFamily.serializer().serializeCFInfo(this.emptyColumnFamily, clockOut);
        out.writeLong((long)(this.headerBuffer.getLength() + clockOut.getLength()) + this.columnSerializedSize);
        out.write(this.headerBuffer.getData(), 0, this.headerBuffer.getLength());
        out.write(clockOut.getData(), 0, clockOut.getLength());
        out.writeInt(this.columnCount);
        for (IColumn column : this) {
            this.emptyColumnFamily.getColumnSerializer().serialize(column, out);
        }
    }

    @Override
    public void update(MessageDigest digest) {
        digest.update(this.headerBuffer.getData(), 0, this.headerBuffer.getLength());
        DataOutputBuffer out = new DataOutputBuffer();
        for (IColumn column : this) {
            out.reset();
            try {
                this.emptyColumnFamily.getColumnSerializer().serialize(column, out);
            }
            catch (IOException e) {
                throw new IOError(e);
            }
            digest.update(out.getData(), 0, out.getLength());
        }
    }

    @Override
    public boolean isEmpty() {
        boolean cfIrrelevant = ColumnFamilyStore.removeDeletedCF(this.emptyColumnFamily, this.gcBefore) == null;
        return cfIrrelevant && this.columnCount == 0;
    }

    @Override
    public int getEstimatedColumnCount() {
        int n = 0;
        for (SSTableIdentityIterator row : this.rows) {
            n += row.columnCount;
        }
        return n;
    }

    @Override
    public AbstractType getComparator() {
        return this.emptyColumnFamily.getComparator();
    }

    @Override
    public Iterator<IColumn> iterator() {
        for (SSTableIdentityIterator row : this.rows) {
            row.reset();
        }
        Comparator<IColumn> nameComparator = new Comparator<IColumn>(){

            @Override
            public int compare(IColumn o1, IColumn o2) {
                return LazilyCompactedRow.this.getComparator().compare(o1.name(), o2.name());
            }
        };
        this.iter = new LazyColumnIterator((Iterator<IColumn>)new CollatingIterator((Comparator)nameComparator, this.rows));
        return Iterators.filter((Iterator)this.iter, (Predicate)Predicates.notNull());
    }

    @Override
    public int columnCount() {
        return this.columnCount;
    }

    private class LazyColumnIterator
    extends ReducingIterator<IColumn, IColumn> {
        ColumnFamily container;
        long serializedSize;
        int size;

        public LazyColumnIterator(Iterator<IColumn> source) {
            super(source);
            this.container = LazilyCompactedRow.this.emptyColumnFamily.cloneMeShallow();
            this.serializedSize = 4L;
            this.size = 0;
        }

        @Override
        protected boolean isEqual(IColumn o1, IColumn o2) {
            return o1.name().equals(o2.name());
        }

        @Override
        public void reduce(IColumn current) {
            this.container.addColumn(current);
        }

        @Override
        protected IColumn getReduced() {
            ColumnFamily purged;
            assert (this.container != null);
            IColumn reduced = this.container.iterator().next();
            ColumnFamily columnFamily = purged = LazilyCompactedRow.this.shouldPurge ? ColumnFamilyStore.removeDeleted(this.container, LazilyCompactedRow.this.gcBefore) : this.container;
            if (purged == null || !purged.iterator().hasNext()) {
                this.container.clear();
                return null;
            }
            this.container.clear();
            this.serializedSize += (long)reduced.serializedSize();
            ++this.size;
            return reduced;
        }
    }
}

