/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.gms;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.UUID;
import org.apache.cassandra.dht.IPartitioner;
import org.apache.cassandra.dht.Token;
import org.apache.cassandra.gms.VersionGenerator;
import org.apache.cassandra.io.ICompactSerializer;
import org.apache.cassandra.utils.FBUtilities;

public class VersionedValue
implements Comparable<VersionedValue> {
    public static final ICompactSerializer<VersionedValue> serializer = new VersionedValueSerializer();
    public static final char DELIMITER = ',';
    public static final String DELIMITER_STR = new String(new char[]{','});
    public static final String STATUS_BOOTSTRAPPING = "BOOT";
    public static final String STATUS_NORMAL = "NORMAL";
    public static final String STATUS_LEAVING = "LEAVING";
    public static final String STATUS_LEFT = "LEFT";
    public static final String REMOVING_TOKEN = "removing";
    public static final String REMOVED_TOKEN = "removed";
    public final int version;
    public final String value;

    private VersionedValue(String value, int version) {
        this.value = value;
        this.version = version;
    }

    private VersionedValue(String value) {
        this.value = value;
        this.version = VersionGenerator.getNextVersion();
    }

    @Override
    public int compareTo(VersionedValue value) {
        return this.version - value.version;
    }

    private static class VersionedValueSerializer
    implements ICompactSerializer<VersionedValue> {
        private VersionedValueSerializer() {
        }

        @Override
        public void serialize(VersionedValue value, DataOutputStream dos) throws IOException {
            dos.writeUTF(value.value);
            dos.writeInt(value.version);
        }

        @Override
        public VersionedValue deserialize(DataInputStream dis) throws IOException {
            String value = dis.readUTF();
            int version = dis.readInt();
            return new VersionedValue(value, version);
        }
    }

    public static class VersionedValueFactory {
        IPartitioner partitioner;

        public VersionedValueFactory(IPartitioner partitioner) {
            this.partitioner = partitioner;
        }

        public VersionedValue bootstrapping(Token token) {
            return new VersionedValue("BOOT," + this.partitioner.getTokenFactory().toString(token));
        }

        public VersionedValue normal(Token token) {
            return new VersionedValue("NORMAL," + this.partitioner.getTokenFactory().toString(token));
        }

        public VersionedValue load(double load) {
            return new VersionedValue(String.valueOf(load));
        }

        public VersionedValue migration(UUID newVersion) {
            return new VersionedValue(newVersion.toString());
        }

        public VersionedValue leaving(Token token) {
            return new VersionedValue("LEAVING," + this.partitioner.getTokenFactory().toString(token));
        }

        public VersionedValue left(Token token) {
            return new VersionedValue("LEFT," + this.partitioner.getTokenFactory().toString(token));
        }

        public VersionedValue removingNonlocal(Token localToken, Token token) {
            return new VersionedValue("NORMAL," + this.partitioner.getTokenFactory().toString(localToken) + ',' + VersionedValue.REMOVING_TOKEN + ',' + this.partitioner.getTokenFactory().toString(token));
        }

        public VersionedValue removedNonlocal(Token localToken, Token token) {
            return new VersionedValue("NORMAL," + this.partitioner.getTokenFactory().toString(localToken) + ',' + VersionedValue.REMOVED_TOKEN + ',' + this.partitioner.getTokenFactory().toString(token));
        }

        public VersionedValue datacenter(String dcId) {
            return new VersionedValue(dcId);
        }

        public VersionedValue rack(String rackId) {
            return new VersionedValue(rackId);
        }

        public VersionedValue releaseVersion() {
            return new VersionedValue(FBUtilities.getReleaseVersionString());
        }
    }
}

