/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.config;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.avro.util.Utf8;
import org.apache.cassandra.avro.CfDef;
import org.apache.cassandra.avro.ColumnDef;
import org.apache.cassandra.config.ColumnDefinition;
import org.apache.cassandra.config.ConfigurationException;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.db.ColumnFamilyType;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.db.marshal.BytesType;
import org.apache.cassandra.db.marshal.TimeUUIDType;
import org.apache.cassandra.db.marshal.UTF8Type;
import org.apache.cassandra.io.SerDeUtils;
import org.apache.cassandra.thrift.IndexType;
import org.apache.cassandra.utils.ByteBufferUtil;
import org.apache.cassandra.utils.Pair;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;

public final class CFMetaData {
    public static final double DEFAULT_ROW_CACHE_SIZE = 0.0;
    public static final double DEFAULT_KEY_CACHE_SIZE = 200000.0;
    public static final double DEFAULT_READ_REPAIR_CHANCE = 1.0;
    public static final int DEFAULT_SYSTEM_MEMTABLE_THROUGHPUT_IN_MB = 8;
    public static final int DEFAULT_ROW_CACHE_SAVE_PERIOD_IN_SECONDS = 0;
    public static final int DEFAULT_KEY_CACHE_SAVE_PERIOD_IN_SECONDS = 14400;
    public static final int DEFAULT_GC_GRACE_SECONDS = 864000;
    public static final int DEFAULT_MIN_COMPACTION_THRESHOLD = 4;
    public static final int DEFAULT_MAX_COMPACTION_THRESHOLD = 32;
    public static final int DEFAULT_MEMTABLE_LIFETIME_IN_MINS = 1440;
    public static final int DEFAULT_MEMTABLE_THROUGHPUT_IN_MB = CFMetaData.sizeMemtableThroughput();
    public static final double DEFAULT_MEMTABLE_OPERATIONS_IN_MILLIONS = CFMetaData.sizeMemtableOperations(DEFAULT_MEMTABLE_THROUGHPUT_IN_MB);
    private static final int MIN_CF_ID = 1000;
    private static final AtomicInteger idGen = new AtomicInteger(1000);
    private static final BiMap<Pair<String, String>, Integer> cfIdMap = HashBiMap.create();
    public static final CFMetaData StatusCf = CFMetaData.newSystemTable("LocationInfo", 0, "persistent metadata for the local node", BytesType.instance, null, 8);
    public static final CFMetaData HintsCf = CFMetaData.newSystemTable("HintsColumnFamily", 1, "hinted handoff data", BytesType.instance, BytesType.instance, Math.min(256, Math.max(32, DEFAULT_MEMTABLE_THROUGHPUT_IN_MB / 2)));
    public static final CFMetaData MigrationsCf = CFMetaData.newSystemTable("Migrations", 2, "individual schema mutations", TimeUUIDType.instance, null, 8);
    public static final CFMetaData SchemaCf = CFMetaData.newSystemTable("Schema", 3, "current state of the schema", UTF8Type.instance, null, 8);
    public static final CFMetaData IndexCf = CFMetaData.newSystemTable("IndexInfo", 5, "indexes that have been completed", UTF8Type.instance, null, 8);
    public final Integer cfId;
    public final String tableName;
    public final String cfName;
    public final ColumnFamilyType cfType;
    public final AbstractType comparator;
    public final AbstractType subcolumnComparator;
    private String comment;
    private double rowCacheSize;
    private double keyCacheSize;
    private double readRepairChance;
    private int gcGraceSeconds;
    private AbstractType defaultValidator;
    private Integer minCompactionThreshold;
    private Integer maxCompactionThreshold;
    private int rowCacheSavePeriodInSeconds;
    private int keyCacheSavePeriodInSeconds;
    private int memtableFlushAfterMins;
    private int memtableThroughputInMb;
    private double memtableOperationsInMillions;
    private final Map<ByteBuffer, ColumnDefinition> column_metadata;

    private static CFMetaData newSystemTable(String cfName, int cfId, String comment, AbstractType comparator, AbstractType subComparator, int memtableThroughPutInMB) {
        return new CFMetaData("system", cfName, subComparator == null ? ColumnFamilyType.Standard : ColumnFamilyType.Super, comparator, subComparator, comment, 0.0, 0.01, 0.0, 0, BytesType.instance, 4, 32, 0, 14400, 1440, memtableThroughPutInMB, CFMetaData.sizeMemtableOperations(memtableThroughPutInMB), cfId, Collections.<ByteBuffer, ColumnDefinition>emptyMap());
    }

    public static int sizeMemtableThroughput() {
        return (int)(Runtime.getRuntime().maxMemory() / 0x1000000L);
    }

    public static double sizeMemtableOperations(int mem_throughput) {
        return 0.3 * (double)mem_throughput / 64.0;
    }

    public static Pair<String, String> getCF(Integer cfId) {
        return (Pair)cfIdMap.inverse().get((Object)cfId);
    }

    public static Integer getId(String table, String cfName) {
        return (Integer)cfIdMap.get(new Pair<String, String>(table, cfName));
    }

    public static void fixMaxId() {
        idGen.set(cfIdMap.size() == 0 ? 1000 : Math.max((Integer)Collections.max(cfIdMap.values()) + 1, 1000));
    }

    private CFMetaData(String tableName, String cfName, ColumnFamilyType cfType, AbstractType comparator, AbstractType subcolumnComparator, String comment, double rowCacheSize, double keyCacheSize, double readRepairChance, int gcGraceSeconds, AbstractType defaultValidator, int minCompactionThreshold, int maxCompactionThreshold, int rowCacheSavePeriodInSeconds, int keyCacheSavePeriodInSeconds, int memtableFlushAfterMins, Integer memtableThroughputInMb, Double memtableOperationsInMillions, Integer cfId, Map<ByteBuffer, ColumnDefinition> column_metadata) {
        assert (column_metadata != null);
        this.tableName = tableName;
        this.cfName = cfName;
        this.cfType = cfType;
        this.comparator = comparator;
        this.subcolumnComparator = subcolumnComparator == null && cfType == ColumnFamilyType.Super ? BytesType.instance : subcolumnComparator;
        this.comment = comment == null ? "" : comment;
        this.rowCacheSize = rowCacheSize;
        this.keyCacheSize = keyCacheSize;
        this.readRepairChance = readRepairChance;
        this.gcGraceSeconds = gcGraceSeconds;
        this.defaultValidator = defaultValidator;
        this.minCompactionThreshold = minCompactionThreshold;
        this.maxCompactionThreshold = maxCompactionThreshold;
        this.rowCacheSavePeriodInSeconds = rowCacheSavePeriodInSeconds;
        this.keyCacheSavePeriodInSeconds = keyCacheSavePeriodInSeconds;
        this.memtableFlushAfterMins = memtableFlushAfterMins;
        this.memtableThroughputInMb = memtableThroughputInMb == null ? DEFAULT_MEMTABLE_THROUGHPUT_IN_MB : memtableThroughputInMb;
        this.memtableOperationsInMillions = memtableOperationsInMillions == null ? DEFAULT_MEMTABLE_OPERATIONS_IN_MILLIONS : memtableOperationsInMillions;
        this.cfId = cfId;
        this.column_metadata = new HashMap<ByteBuffer, ColumnDefinition>(column_metadata);
    }

    public static void map(CFMetaData cfm) throws ConfigurationException {
        Pair<String, String> key = new Pair<String, String>(cfm.tableName, cfm.cfName);
        if (cfIdMap.containsKey(key)) {
            throw new ConfigurationException("Attempt to assign id to existing column family.");
        }
        cfIdMap.put(key, (Object)cfm.cfId);
    }

    public CFMetaData(String tableName, String cfName, ColumnFamilyType cfType, AbstractType comparator, AbstractType subcolumnComparator, String comment, double rowCacheSize, double keyCacheSize, double readRepairChance, int gcGraceSeconds, AbstractType defaultValidator, int minCompactionThreshold, int maxCompactionThreshold, int rowCacheSavePeriodInSeconds, int keyCacheSavePeriodInSeconds, int memTime, Integer memSize, Double memOps, Map<ByteBuffer, ColumnDefinition> column_metadata) {
        this(tableName, cfName, cfType, comparator, subcolumnComparator, comment, rowCacheSize, keyCacheSize, readRepairChance, gcGraceSeconds, defaultValidator, minCompactionThreshold, maxCompactionThreshold, rowCacheSavePeriodInSeconds, keyCacheSavePeriodInSeconds, memTime, memSize, memOps, CFMetaData.nextId(), column_metadata);
    }

    public static CFMetaData newIndexMetadata(String table, String parentCf, ColumnDefinition info, AbstractType columnComparator) {
        return new CFMetaData(table, CFMetaData.indexName(parentCf, info), ColumnFamilyType.Standard, columnComparator, null, "", 0.0, 0.0, 0.0, 864000, BytesType.instance, 4, 32, 0, 14400, 1440, DEFAULT_MEMTABLE_THROUGHPUT_IN_MB, DEFAULT_MEMTABLE_OPERATIONS_IN_MILLIONS, Collections.<ByteBuffer, ColumnDefinition>emptyMap());
    }

    public static CFMetaData rename(CFMetaData cfm, String newName) {
        return new CFMetaData(cfm.tableName, newName, cfm.cfType, cfm.comparator, cfm.subcolumnComparator, cfm.comment, cfm.rowCacheSize, cfm.keyCacheSize, cfm.readRepairChance, cfm.gcGraceSeconds, cfm.defaultValidator, cfm.minCompactionThreshold, cfm.maxCompactionThreshold, cfm.rowCacheSavePeriodInSeconds, cfm.keyCacheSavePeriodInSeconds, cfm.memtableFlushAfterMins, cfm.memtableThroughputInMb, cfm.memtableOperationsInMillions, cfm.cfId, cfm.column_metadata);
    }

    public static CFMetaData renameTable(CFMetaData cfm, String tableName) {
        return new CFMetaData(tableName, cfm.cfName, cfm.cfType, cfm.comparator, cfm.subcolumnComparator, cfm.comment, cfm.rowCacheSize, cfm.keyCacheSize, cfm.readRepairChance, cfm.gcGraceSeconds, cfm.defaultValidator, cfm.minCompactionThreshold, cfm.maxCompactionThreshold, cfm.rowCacheSavePeriodInSeconds, cfm.keyCacheSavePeriodInSeconds, cfm.memtableFlushAfterMins, cfm.memtableThroughputInMb, cfm.memtableOperationsInMillions, cfm.cfId, cfm.column_metadata);
    }

    public static void purge(CFMetaData cfm) {
        cfIdMap.remove(new Pair<String, String>(cfm.tableName, cfm.cfName));
    }

    public static String indexName(String parentCf, ColumnDefinition info) {
        return parentCf + "." + (info.getIndexName() == null ? ByteBufferUtil.bytesToHex(info.name) : info.getIndexName());
    }

    public CfDef deflate() {
        CfDef cf = new CfDef();
        cf.id = this.cfId;
        cf.keyspace = new Utf8(this.tableName);
        cf.name = new Utf8(this.cfName);
        cf.column_type = new Utf8(this.cfType.name());
        cf.comparator_type = new Utf8(this.comparator.getClass().getName());
        if (this.subcolumnComparator != null) {
            cf.subcomparator_type = new Utf8(this.subcolumnComparator.getClass().getName());
        }
        cf.comment = new Utf8(this.comment);
        cf.row_cache_size = this.rowCacheSize;
        cf.key_cache_size = this.keyCacheSize;
        cf.read_repair_chance = this.readRepairChance;
        cf.gc_grace_seconds = this.gcGraceSeconds;
        cf.default_validation_class = new Utf8(this.defaultValidator.getClass().getName());
        cf.min_compaction_threshold = this.minCompactionThreshold;
        cf.max_compaction_threshold = this.maxCompactionThreshold;
        cf.row_cache_save_period_in_seconds = this.rowCacheSavePeriodInSeconds;
        cf.key_cache_save_period_in_seconds = this.keyCacheSavePeriodInSeconds;
        cf.memtable_flush_after_mins = this.memtableFlushAfterMins;
        cf.memtable_throughput_in_mb = this.memtableThroughputInMb;
        cf.memtable_operations_in_millions = this.memtableOperationsInMillions;
        cf.column_metadata = SerDeUtils.createArray(this.column_metadata.size(), ColumnDef.SCHEMA$);
        for (ColumnDefinition cd : this.column_metadata.values()) {
            cf.column_metadata.add(cd.deflate());
        }
        return cf;
    }

    public static CFMetaData inflate(CfDef cf) {
        BytesType validator;
        AbstractType comparator;
        AbstractType subcolumnComparator = null;
        try {
            comparator = DatabaseDescriptor.getComparator(((Object)cf.comparator_type).toString());
            if (cf.subcomparator_type != null) {
                subcolumnComparator = DatabaseDescriptor.getComparator(((Object)cf.subcomparator_type).toString());
            }
            validator = cf.default_validation_class == null ? BytesType.instance : DatabaseDescriptor.getComparator(((Object)cf.default_validation_class).toString());
        }
        catch (Exception ex) {
            throw new RuntimeException("Could not inflate CFMetaData for " + (Object)((Object)cf), ex);
        }
        TreeMap<ByteBuffer, ColumnDefinition> column_metadata = new TreeMap<ByteBuffer, ColumnDefinition>(BytesType.instance);
        for (ColumnDef aColumn_metadata : cf.column_metadata) {
            ColumnDefinition cd = ColumnDefinition.inflate(aColumn_metadata);
            column_metadata.put(cd.name, cd);
        }
        Integer minct = cf.min_compaction_threshold == null ? 4 : cf.min_compaction_threshold;
        Integer maxct = cf.max_compaction_threshold == null ? 32 : cf.max_compaction_threshold;
        Integer row_cache_save_period_in_seconds = cf.row_cache_save_period_in_seconds == null ? 0 : cf.row_cache_save_period_in_seconds;
        Integer key_cache_save_period_in_seconds = cf.key_cache_save_period_in_seconds == null ? 14400 : cf.key_cache_save_period_in_seconds;
        Integer memtable_flush_after_mins = cf.memtable_flush_after_mins == null ? 1440 : cf.memtable_flush_after_mins;
        Integer memtable_throughput_in_mb = cf.memtable_throughput_in_mb == null ? DEFAULT_MEMTABLE_THROUGHPUT_IN_MB : cf.memtable_throughput_in_mb;
        Double memtable_operations_in_millions = cf.memtable_operations_in_millions == null ? DEFAULT_MEMTABLE_OPERATIONS_IN_MILLIONS : cf.memtable_operations_in_millions;
        return new CFMetaData(((Object)cf.keyspace).toString(), ((Object)cf.name).toString(), ColumnFamilyType.create(((Object)cf.column_type).toString()), comparator, subcolumnComparator, ((Object)cf.comment).toString(), cf.row_cache_size, cf.key_cache_size, cf.read_repair_chance, cf.gc_grace_seconds, validator, minct, maxct, row_cache_save_period_in_seconds, key_cache_save_period_in_seconds, memtable_flush_after_mins, memtable_throughput_in_mb, memtable_operations_in_millions, cf.id, column_metadata);
    }

    public String getComment() {
        return this.comment;
    }

    public double getRowCacheSize() {
        return this.rowCacheSize;
    }

    public double getKeyCacheSize() {
        return this.keyCacheSize;
    }

    public double getReadRepairChance() {
        return this.readRepairChance;
    }

    public int getGcGraceSeconds() {
        return this.gcGraceSeconds;
    }

    public AbstractType getDefaultValidator() {
        return this.defaultValidator;
    }

    public Integer getMinCompactionThreshold() {
        return this.minCompactionThreshold;
    }

    public Integer getMaxCompactionThreshold() {
        return this.maxCompactionThreshold;
    }

    public int getRowCacheSavePeriodInSeconds() {
        return this.rowCacheSavePeriodInSeconds;
    }

    public int getKeyCacheSavePeriodInSeconds() {
        return this.keyCacheSavePeriodInSeconds;
    }

    public int getMemtableFlushAfterMins() {
        return this.memtableFlushAfterMins;
    }

    public int getMemtableThroughputInMb() {
        return this.memtableThroughputInMb;
    }

    public double getMemtableOperationsInMillions() {
        return this.memtableOperationsInMillions;
    }

    public Map<ByteBuffer, ColumnDefinition> getColumn_metadata() {
        return Collections.unmodifiableMap(this.column_metadata);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        CFMetaData rhs = (CFMetaData)obj;
        return new EqualsBuilder().append((Object)this.tableName, (Object)rhs.tableName).append((Object)this.cfName, (Object)rhs.cfName).append((Object)this.cfType, (Object)rhs.cfType).append((Object)this.comparator, (Object)rhs.comparator).append((Object)this.subcolumnComparator, (Object)rhs.subcolumnComparator).append((Object)this.comment, (Object)rhs.comment).append(this.rowCacheSize, rhs.rowCacheSize).append(this.keyCacheSize, rhs.keyCacheSize).append(this.readRepairChance, rhs.readRepairChance).append(this.gcGraceSeconds, rhs.gcGraceSeconds).append((Object)this.minCompactionThreshold, (Object)rhs.minCompactionThreshold).append((Object)this.maxCompactionThreshold, (Object)rhs.maxCompactionThreshold).append(this.cfId.intValue(), rhs.cfId.intValue()).append(this.column_metadata, rhs.column_metadata).append(this.rowCacheSavePeriodInSeconds, rhs.rowCacheSavePeriodInSeconds).append(this.keyCacheSavePeriodInSeconds, rhs.keyCacheSavePeriodInSeconds).append(this.memtableFlushAfterMins, rhs.memtableFlushAfterMins).append(this.memtableThroughputInMb, rhs.memtableThroughputInMb).append(this.memtableOperationsInMillions, rhs.memtableOperationsInMillions).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder(29, 1597).append((Object)this.tableName).append((Object)this.cfName).append((Object)this.cfType).append((Object)this.comparator).append((Object)this.subcolumnComparator).append((Object)this.comment).append(this.rowCacheSize).append(this.keyCacheSize).append(this.readRepairChance).append(this.gcGraceSeconds).append((Object)this.defaultValidator).append((Object)this.minCompactionThreshold).append((Object)this.maxCompactionThreshold).append((Object)this.cfId).append(this.column_metadata).append(this.rowCacheSavePeriodInSeconds).append(this.keyCacheSavePeriodInSeconds).append(this.memtableFlushAfterMins).append(this.memtableThroughputInMb).append(this.memtableOperationsInMillions).toHashCode();
    }

    private static int nextId() {
        return idGen.getAndIncrement();
    }

    public AbstractType getValueValidator(ByteBuffer column) {
        AbstractType validator = this.defaultValidator;
        ColumnDefinition columnDefinition = this.column_metadata.get(column);
        if (columnDefinition != null) {
            validator = columnDefinition.validator;
        }
        return validator;
    }

    public static void applyImplicitDefaults(CfDef cf_def) {
        if (cf_def.min_compaction_threshold == null) {
            cf_def.min_compaction_threshold = 4;
        }
        if (cf_def.max_compaction_threshold == null) {
            cf_def.max_compaction_threshold = 32;
        }
        if (cf_def.row_cache_save_period_in_seconds == null) {
            cf_def.row_cache_save_period_in_seconds = 0;
        }
        if (cf_def.key_cache_save_period_in_seconds == null) {
            cf_def.key_cache_save_period_in_seconds = 14400;
        }
        if (cf_def.memtable_flush_after_mins == null) {
            cf_def.memtable_flush_after_mins = 1440;
        }
        if (cf_def.memtable_throughput_in_mb == null) {
            cf_def.memtable_throughput_in_mb = DEFAULT_MEMTABLE_THROUGHPUT_IN_MB;
        }
        if (cf_def.memtable_operations_in_millions == null) {
            cf_def.memtable_operations_in_millions = DEFAULT_MEMTABLE_OPERATIONS_IN_MILLIONS;
        }
    }

    public static void applyImplicitDefaults(org.apache.cassandra.thrift.CfDef cf_def) {
        if (!cf_def.isSetMin_compaction_threshold()) {
            cf_def.setMin_compaction_threshold(4);
        }
        if (!cf_def.isSetMax_compaction_threshold()) {
            cf_def.setMax_compaction_threshold(32);
        }
        if (!cf_def.isSetRow_cache_save_period_in_seconds()) {
            cf_def.setRow_cache_save_period_in_seconds(0);
        }
        if (!cf_def.isSetKey_cache_save_period_in_seconds()) {
            cf_def.setKey_cache_save_period_in_seconds(14400);
        }
        if (!cf_def.isSetMemtable_flush_after_mins()) {
            cf_def.setMemtable_flush_after_mins(1440);
        }
        if (!cf_def.isSetMemtable_throughput_in_mb()) {
            cf_def.setMemtable_throughput_in_mb(DEFAULT_MEMTABLE_THROUGHPUT_IN_MB);
        }
        if (!cf_def.isSetMemtable_operations_in_millions()) {
            cf_def.setMemtable_operations_in_millions(DEFAULT_MEMTABLE_OPERATIONS_IN_MILLIONS);
        }
    }

    public void apply(CfDef cf_def) throws ConfigurationException {
        if (!cf_def.id.equals(this.cfId)) {
            throw new ConfigurationException("ids do not match.");
        }
        if (!((Object)cf_def.keyspace).toString().equals(this.tableName)) {
            throw new ConfigurationException("keyspaces do not match.");
        }
        if (!((Object)cf_def.name).toString().equals(this.cfName)) {
            throw new ConfigurationException("names do not match.");
        }
        if (!((Object)cf_def.column_type).toString().equals(this.cfType.name())) {
            throw new ConfigurationException("types do not match.");
        }
        if (this.comparator != DatabaseDescriptor.getComparator(cf_def.comparator_type)) {
            throw new ConfigurationException("comparators do not match.");
        }
        if (cf_def.subcomparator_type == null || cf_def.subcomparator_type.equals("") ? this.subcolumnComparator != null : this.subcolumnComparator != DatabaseDescriptor.getComparator(cf_def.subcomparator_type)) {
            throw new ConfigurationException("subcolumncomparators do not match.");
        }
        CFMetaData.validateMinMaxCompactionThresholds(cf_def);
        CFMetaData.validateMemtableSettings(cf_def);
        this.comment = cf_def.comment == null ? "" : ((Object)cf_def.comment).toString();
        this.rowCacheSize = cf_def.row_cache_size;
        this.keyCacheSize = cf_def.key_cache_size;
        this.readRepairChance = cf_def.read_repair_chance;
        this.gcGraceSeconds = cf_def.gc_grace_seconds;
        this.defaultValidator = DatabaseDescriptor.getComparator(cf_def.default_validation_class);
        this.minCompactionThreshold = cf_def.min_compaction_threshold;
        this.maxCompactionThreshold = cf_def.max_compaction_threshold;
        this.rowCacheSavePeriodInSeconds = cf_def.row_cache_save_period_in_seconds;
        this.keyCacheSavePeriodInSeconds = cf_def.key_cache_save_period_in_seconds;
        this.memtableFlushAfterMins = cf_def.memtable_flush_after_mins;
        this.memtableThroughputInMb = cf_def.memtable_throughput_in_mb;
        this.memtableOperationsInMillions = cf_def.memtable_operations_in_millions;
        HashSet<ByteBuffer> toRemove = new HashSet<ByteBuffer>();
        HashSet<ByteBuffer> newIndexNames = new HashSet<ByteBuffer>();
        HashSet<ColumnDef> toAdd = new HashSet<ColumnDef>();
        for (ColumnDef def : cf_def.column_metadata) {
            newIndexNames.add(def.name);
            if (this.column_metadata.containsKey(def.name)) continue;
            toAdd.add(def);
        }
        for (ByteBuffer indexName : this.column_metadata.keySet()) {
            if (newIndexNames.contains(indexName)) continue;
            toRemove.add(indexName);
        }
        for (ByteBuffer indexName : toRemove) {
            this.column_metadata.remove(indexName);
        }
        for (ColumnDef def : cf_def.column_metadata) {
            if (!this.column_metadata.containsKey(def.name)) continue;
            this.column_metadata.get(def.name).setIndexType(def.index_type == null ? null : IndexType.valueOf(def.index_type.name()));
            this.column_metadata.get(def.name).setIndexName(def.index_name == null ? null : ((Object)def.index_name).toString());
        }
        for (ColumnDef def : toAdd) {
            ColumnDefinition cd = new ColumnDefinition(def.name, ((Object)def.validation_class).toString(), def.index_type == null ? null : IndexType.valueOf(def.index_type.toString()), def.index_name == null ? null : ((Object)def.index_name).toString());
            this.column_metadata.put(cd.name, cd);
        }
    }

    public static org.apache.cassandra.thrift.CfDef convertToThrift(CFMetaData cfm) {
        org.apache.cassandra.thrift.CfDef def = new org.apache.cassandra.thrift.CfDef(cfm.tableName, cfm.cfName);
        def.setId(cfm.cfId);
        def.setColumn_type(cfm.cfType.name());
        def.setComparator_type(cfm.comparator.getClass().getName());
        if (cfm.subcolumnComparator != null) {
            def.setSubcomparator_type(cfm.subcolumnComparator.getClass().getName());
            def.setColumn_type("Super");
        }
        def.setComment(cfm.comment == null ? "" : cfm.comment);
        def.setRow_cache_size(cfm.rowCacheSize);
        def.setKey_cache_size(cfm.keyCacheSize);
        def.setRead_repair_chance(cfm.readRepairChance);
        def.setGc_grace_seconds(cfm.gcGraceSeconds);
        def.setDefault_validation_class(cfm.defaultValidator.getClass().getName());
        def.setMin_compaction_threshold(cfm.minCompactionThreshold);
        def.setMax_compaction_threshold(cfm.maxCompactionThreshold);
        def.setRow_cache_save_period_in_seconds(cfm.rowCacheSavePeriodInSeconds);
        def.setKey_cache_save_period_in_seconds(cfm.keyCacheSavePeriodInSeconds);
        def.setMemtable_flush_after_mins(cfm.memtableFlushAfterMins);
        def.setMemtable_throughput_in_mb(cfm.memtableThroughputInMb);
        def.setMemtable_operations_in_millions(cfm.memtableOperationsInMillions);
        ArrayList<org.apache.cassandra.thrift.ColumnDef> column_meta = new ArrayList<org.apache.cassandra.thrift.ColumnDef>(cfm.column_metadata.size());
        for (ColumnDefinition cd : cfm.column_metadata.values()) {
            org.apache.cassandra.thrift.ColumnDef tcd = new org.apache.cassandra.thrift.ColumnDef();
            tcd.setIndex_name(cd.getIndexName());
            tcd.setIndex_type(cd.getIndexType());
            tcd.setName(cd.name);
            tcd.setValidation_class(cd.validator.getClass().getName());
            column_meta.add(tcd);
        }
        def.setColumn_metadata(column_meta);
        return def;
    }

    public static CfDef convertToAvro(CFMetaData cfm) {
        CfDef def = new CfDef();
        def.name = cfm.cfName;
        def.keyspace = cfm.tableName;
        def.id = cfm.cfId;
        def.column_type = cfm.cfType.name();
        def.comparator_type = cfm.comparator.getClass().getName();
        if (cfm.subcolumnComparator != null) {
            def.subcomparator_type = cfm.subcolumnComparator.getClass().getName();
            def.column_type = "Super";
        }
        def.comment = cfm.comment == null ? "" : cfm.comment;
        def.row_cache_size = cfm.rowCacheSize;
        def.key_cache_size = cfm.keyCacheSize;
        def.read_repair_chance = cfm.readRepairChance;
        def.gc_grace_seconds = cfm.gcGraceSeconds;
        def.default_validation_class = cfm.defaultValidator == null ? null : cfm.defaultValidator.getClass().getName();
        def.min_compaction_threshold = cfm.minCompactionThreshold;
        def.max_compaction_threshold = cfm.maxCompactionThreshold;
        def.row_cache_save_period_in_seconds = cfm.rowCacheSavePeriodInSeconds;
        def.key_cache_save_period_in_seconds = cfm.keyCacheSavePeriodInSeconds;
        def.memtable_flush_after_mins = cfm.memtableFlushAfterMins;
        def.memtable_throughput_in_mb = cfm.memtableThroughputInMb;
        def.memtable_operations_in_millions = cfm.memtableOperationsInMillions;
        ArrayList<ColumnDef> column_meta = new ArrayList<ColumnDef>(cfm.column_metadata.size());
        for (ColumnDefinition cd : cfm.column_metadata.values()) {
            ColumnDef tcd = new ColumnDef();
            tcd.index_name = cd.getIndexName();
            tcd.index_type = cd.getIndexType() == null ? null : org.apache.cassandra.avro.IndexType.valueOf(cd.getIndexType().name());
            tcd.name = ByteBufferUtil.clone(cd.name);
            tcd.validation_class = cd.validator.getClass().getName();
            column_meta.add(tcd);
        }
        def.column_metadata = column_meta;
        return def;
    }

    public static CfDef convertToAvro(org.apache.cassandra.thrift.CfDef def) {
        CfDef newDef = new CfDef();
        newDef.keyspace = def.getKeyspace();
        newDef.name = def.getName();
        newDef.column_type = def.getColumn_type();
        newDef.comment = def.getComment();
        newDef.comparator_type = def.getComparator_type();
        newDef.default_validation_class = def.getDefault_validation_class();
        newDef.gc_grace_seconds = def.getGc_grace_seconds();
        newDef.id = def.getId();
        newDef.key_cache_save_period_in_seconds = def.getKey_cache_save_period_in_seconds();
        newDef.key_cache_size = def.getKey_cache_size();
        newDef.max_compaction_threshold = def.getMax_compaction_threshold();
        newDef.memtable_flush_after_mins = def.getMemtable_flush_after_mins();
        newDef.memtable_operations_in_millions = def.getMemtable_operations_in_millions();
        newDef.memtable_throughput_in_mb = def.getMemtable_throughput_in_mb();
        newDef.min_compaction_threshold = def.getMin_compaction_threshold();
        newDef.read_repair_chance = def.getRead_repair_chance();
        newDef.row_cache_save_period_in_seconds = def.getRow_cache_save_period_in_seconds();
        newDef.row_cache_size = def.getRow_cache_size();
        newDef.subcomparator_type = def.getSubcomparator_type();
        ArrayList<ColumnDef> columnMeta = new ArrayList<ColumnDef>();
        if (def.isSetColumn_metadata()) {
            for (org.apache.cassandra.thrift.ColumnDef cdef : def.getColumn_metadata()) {
                ColumnDef tdef = new ColumnDef();
                tdef.name = ByteBufferUtil.clone(cdef.BufferForName());
                tdef.validation_class = cdef.getValidation_class();
                tdef.index_name = cdef.getIndex_name();
                tdef.index_type = cdef.getIndex_type() == null ? null : org.apache.cassandra.avro.IndexType.valueOf(cdef.getIndex_type().name());
                columnMeta.add(tdef);
            }
        }
        newDef.column_metadata = columnMeta;
        return newDef;
    }

    public static void validateMinMaxCompactionThresholds(org.apache.cassandra.thrift.CfDef cf_def) throws ConfigurationException {
        if (cf_def.isSetMin_compaction_threshold() && cf_def.isSetMax_compaction_threshold()) {
            if (cf_def.min_compaction_threshold > cf_def.max_compaction_threshold && cf_def.max_compaction_threshold != 0) {
                throw new ConfigurationException("min_compaction_threshold cannot be greater than max_compaction_threshold");
            }
        } else if (cf_def.isSetMin_compaction_threshold()) {
            if (cf_def.min_compaction_threshold > 32) {
                throw new ConfigurationException("min_compaction_threshold cannot be greather than max_compaction_threshold (default 32)");
            }
        } else if (cf_def.isSetMax_compaction_threshold() && cf_def.max_compaction_threshold < 4 && cf_def.max_compaction_threshold != 0) {
            throw new ConfigurationException("max_compaction_threshold cannot be less than min_compaction_threshold");
        }
    }

    public static void validateMinMaxCompactionThresholds(CfDef cf_def) throws ConfigurationException {
        if (cf_def.min_compaction_threshold != null && cf_def.max_compaction_threshold != null) {
            if (cf_def.min_compaction_threshold > cf_def.max_compaction_threshold && cf_def.max_compaction_threshold != 0) {
                throw new ConfigurationException("min_compaction_threshold cannot be greater than max_compaction_threshold");
            }
        } else if (cf_def.min_compaction_threshold != null) {
            if (cf_def.min_compaction_threshold > 32) {
                throw new ConfigurationException("min_compaction_threshold cannot be greather than max_compaction_threshold (default 32)");
            }
        } else if (cf_def.max_compaction_threshold != null && cf_def.max_compaction_threshold < 4 && cf_def.max_compaction_threshold != 0) {
            throw new ConfigurationException("max_compaction_threshold cannot be less than min_compaction_threshold");
        }
    }

    public static void validateMemtableSettings(org.apache.cassandra.thrift.CfDef cf_def) throws ConfigurationException {
        if (cf_def.isSetMemtable_flush_after_mins()) {
            DatabaseDescriptor.validateMemtableFlushPeriod(cf_def.memtable_flush_after_mins);
        }
        if (cf_def.isSetMemtable_throughput_in_mb()) {
            DatabaseDescriptor.validateMemtableThroughput(cf_def.memtable_throughput_in_mb);
        }
        if (cf_def.isSetMemtable_operations_in_millions()) {
            DatabaseDescriptor.validateMemtableOperations(cf_def.memtable_operations_in_millions);
        }
    }

    public static void validateMemtableSettings(CfDef cf_def) throws ConfigurationException {
        if (cf_def.memtable_flush_after_mins != null) {
            DatabaseDescriptor.validateMemtableFlushPeriod(cf_def.memtable_flush_after_mins);
        }
        if (cf_def.memtable_throughput_in_mb != null) {
            DatabaseDescriptor.validateMemtableThroughput(cf_def.memtable_throughput_in_mb);
        }
        if (cf_def.memtable_operations_in_millions != null) {
            DatabaseDescriptor.validateMemtableOperations(cf_def.memtable_operations_in_millions);
        }
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("cfId", (Object)this.cfId).append("tableName", (Object)this.tableName).append("cfName", (Object)this.cfName).append("cfType", (Object)this.cfType).append("comparator", (Object)this.comparator).append("subcolumncomparator", (Object)this.subcolumnComparator).append("comment", (Object)this.comment).append("rowCacheSize", this.rowCacheSize).append("keyCacheSize", this.keyCacheSize).append("readRepairChance", this.readRepairChance).append("gcGraceSeconds", this.gcGraceSeconds).append("defaultValidator", (Object)this.defaultValidator).append("minCompactionThreshold", (Object)this.minCompactionThreshold).append("maxCompactionThreshold", (Object)this.maxCompactionThreshold).append("rowCacheSavePeriodInSeconds", this.rowCacheSavePeriodInSeconds).append("keyCacheSavePeriodInSeconds", this.keyCacheSavePeriodInSeconds).append("memtableFlushAfterMins", this.memtableFlushAfterMins).append("memtableThroughputInMb", this.memtableThroughputInMb).append("memtableOperationsInMillions", this.memtableOperationsInMillions).append("column_metadata", this.column_metadata).toString();
    }
}

