/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.service;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOError;
import java.io.IOException;
import java.net.InetAddress;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import org.apache.cassandra.db.ColumnFamily;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.ReadResponse;
import org.apache.cassandra.db.Row;
import org.apache.cassandra.db.RowMutation;
import org.apache.cassandra.net.Message;
import org.apache.cassandra.net.MessagingService;
import org.apache.cassandra.service.DigestMismatchException;
import org.apache.cassandra.service.IResponseResolver;
import org.apache.cassandra.service.StorageService;
import org.apache.cassandra.utils.FBUtilities;
import org.apache.commons.lang.ArrayUtils;
import org.cliffc.high_scale_lib.NonBlockingHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReadResponseResolver
implements IResponseResolver<Row> {
    private static Logger logger_ = LoggerFactory.getLogger(ReadResponseResolver.class);
    private final String table;
    private final ConcurrentMap<Message, ReadResponse> results = new NonBlockingHashMap();
    private DecoratedKey key;
    private ByteBuffer digest;
    private static final Message FAKE_MESSAGE = new Message(FBUtilities.getLocalAddress(), StorageService.Verb.INTERNAL_RESPONSE, ArrayUtils.EMPTY_BYTE_ARRAY);

    public ReadResponseResolver(String table, ByteBuffer key) {
        this.table = table;
        this.key = StorageService.getPartitioner().decorateKey(key);
    }

    @Override
    public Row getData() throws IOException {
        for (Map.Entry entry : this.results.entrySet()) {
            ReadResponse result = (ReadResponse)entry.getValue();
            if (result.isDigestQuery()) continue;
            return result.row();
        }
        throw new AssertionError((Object)"getData should not be invoked when no data is present");
    }

    @Override
    public Row resolve() throws DigestMismatchException, IOException {
        ColumnFamily resolved;
        if (logger_.isDebugEnabled()) {
            logger_.debug("resolving " + this.results.size() + " responses");
        }
        long startTime = System.currentTimeMillis();
        ArrayList<ColumnFamily> versions = new ArrayList<ColumnFamily>();
        ArrayList<InetAddress> endpoints = new ArrayList<InetAddress>();
        for (Map.Entry entry : this.results.entrySet()) {
            ReadResponse result = (ReadResponse)entry.getValue();
            Message message = (Message)entry.getKey();
            if (result.isDigestQuery()) {
                if (this.digest == null) {
                    this.digest = result.digest();
                } else {
                    ByteBuffer digest2 = result.digest();
                    if (!this.digest.equals(digest2)) {
                        throw new DigestMismatchException(this.key, this.digest, digest2);
                    }
                }
            } else {
                versions.add(result.row().cf);
                endpoints.add(message.getFrom());
            }
            this.results.remove(message);
        }
        if (this.digest != null) {
            for (ColumnFamily cf : versions) {
                ByteBuffer digest2 = ColumnFamily.digest(cf);
                if (this.digest.equals(digest2)) continue;
                throw new DigestMismatchException(this.key, this.digest, digest2);
            }
            if (logger_.isDebugEnabled()) {
                logger_.debug("digests verified");
            }
        }
        if (versions.size() > 1) {
            resolved = ReadResponseResolver.resolveSuperset(versions);
            if (logger_.isDebugEnabled()) {
                logger_.debug("versions merged");
            }
            ReadResponseResolver.maybeScheduleRepairs(resolved, this.table, this.key, versions, endpoints);
        } else {
            resolved = (ColumnFamily)versions.get(0);
        }
        if (logger_.isDebugEnabled()) {
            logger_.debug("resolve: " + (System.currentTimeMillis() - startTime) + " ms.");
        }
        return new Row(this.key, resolved);
    }

    public static void maybeScheduleRepairs(ColumnFamily resolved, String table, DecoratedKey key, List<ColumnFamily> versions, List<InetAddress> endpoints) {
        for (int i = 0; i < versions.size(); ++i) {
            Message repairMessage;
            ColumnFamily diffCf = ColumnFamily.diff(versions.get(i), resolved);
            if (diffCf == null) continue;
            RowMutation rowMutation = new RowMutation(table, key.key);
            rowMutation.add(diffCf);
            try {
                repairMessage = rowMutation.makeRowMutationMessage(StorageService.Verb.READ_REPAIR);
            }
            catch (IOException e) {
                throw new IOError(e);
            }
            MessagingService.instance().sendOneWay(repairMessage, endpoints.get(i));
        }
    }

    static ColumnFamily resolveSuperset(List<ColumnFamily> versions) {
        assert (versions.size() > 0);
        ColumnFamily resolved = null;
        for (ColumnFamily cf : versions) {
            if (cf == null) continue;
            resolved = cf.cloneMe();
            break;
        }
        if (resolved == null) {
            return null;
        }
        for (ColumnFamily cf : versions) {
            resolved.resolve(cf);
        }
        return resolved;
    }

    @Override
    public void preprocess(Message message) {
        byte[] body = message.getMessageBody();
        ByteArrayInputStream bufIn = new ByteArrayInputStream(body);
        try {
            ReadResponse result = ReadResponse.serializer().deserialize(new DataInputStream(bufIn));
            if (logger_.isDebugEnabled()) {
                logger_.debug("Preprocessed {} response", (Object)(result.isDigestQuery() ? "digest" : "data"));
            }
            this.results.put(message, result);
        }
        catch (IOException e) {
            throw new IOError(e);
        }
    }

    public void injectPreProcessed(ReadResponse result) {
        assert (this.results.get(FAKE_MESSAGE) == null);
        this.results.put(FAKE_MESSAGE, result);
    }

    @Override
    public boolean isDataPresent() {
        for (ReadResponse result : this.results.values()) {
            if (result.isDigestQuery()) continue;
            return true;
        }
        return false;
    }

    @Override
    public Iterable<Message> getMessages() {
        return this.results.keySet();
    }

    @Override
    public int getMessageCount() {
        return this.results.size();
    }
}

